/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.handle.HorizontChildCache;

public class OfferingHandle {
    public static final String BD_PRODUCT_SUMMARY = "bd_productsummary";

    public static List<Long> getOfferings(List<Long> productModelIds) {
        ArrayList<Long> offeringList = new ArrayList<Long>();
        QFilter qf = new QFilter("id", "in", productModelIds);
        Map offeringsMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_class", (String)"id,offering", (QFilter[])qf.toArray());
        if (!CollectionUtils.isEmpty((Map)offeringsMap)) {
            for (Map.Entry entry : offeringsMap.entrySet()) {
                Long offeringId = ((DynamicObject)entry.getValue()).getLong("offering.id");
                if (offeringId == null || offeringId == 0L || offeringList.contains(offeringId)) continue;
                offeringList.add(offeringId);
            }
        }
        return offeringList;
    }

    public static Long getFirstLevelById(Long offeringId) {
        List<List<Long>> listList = OfferingHandle.getTreeLists(offeringId);
        if (listList == null || listList.get(0).size() < 1) {
            return null;
        }
        return listList.get(0).get(listList.get(0).size() - 1);
    }

    public static Long getSecLevelById(Long offeringId) {
        List<List<Long>> listList = OfferingHandle.getTreeLists(offeringId);
        if (listList == null || listList.get(0).size() < 2) {
            return null;
        }
        return listList.get(0).get(listList.get(0).size() - 2);
    }

    private static List<List<Long>> getTreeLists(Long offeringId) {
        DynamicObject offering = BusinessDataServiceHelper.loadSingleFromCache((Object)offeringId, (String)BD_PRODUCT_SUMMARY);
        Long group = offering.getLong("group.id");
        if (group == null || group.equals(0L)) {
            return null;
        }
        List listList = HorizontChildCache.getInstance().getFromCache("bd_productgroup", group);
        if (CollectionUtils.isEmpty((Collection)listList)) {
            return null;
        }
        return listList;
    }
}

