/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.handle.HorizontChildCache;
import kd.occ.ocbase.common.status.Status;
import kd.occ.occpibc.business.handle.OfferingHandle;
import kd.occ.occpibc.common.model.BenefitCustomerQueryParamModel;
import kd.occ.occpibc.common.model.PreRelationEntityModel;
import kd.occ.occpibc.common.model.PreRelationModel;
import kd.occ.occpibc.common.model.PreRelationQueryParamModel;

public class PolicyGoalsTabHandle {
    private static final String POLICY_GOALS_SELECT_FIELDS = "id,policy,country,areadept,rptoffice,kpi.childtype,currency,signparty,starttime,endtime,salesattr,chlfirstclassid,chlsecclass,kpi.inspiretype,kpi.targetcaltype,settleperiod,benifitchl,benifitcustomer,isrealtime,kpi.laddertype,highestpercent,rebatetype";
    private static final String POLICY_GOALS_SELECT_CUSTOMER_FIELDS = "signcustentity,signcustentity.schannelfirstclass,signcustentity.schannelsecclass,signcustentity.signcustomer,signcustentity.signchannel";
    private static final String POLICY_GOALS_SELECT_PRODUCT_FIELDS = "itemclassentity,itemclassentity.productmodel,firstclass,secondclass,thirdclass,fourthclass,productmodel,itemclassentity.subentryentity,subentryentity.subproductmodel,subfourthclass,subthirdclass,subsecondclass,subfirstclass";
    private static final String POLICY_GOALS_SELECT_FORMULA = "formulaentity,formulaentity.rebatepercent,formulaentity.rebateamount";

    public List<DynamicObject> queryPolicyGoals() {
        QFilter qf = new QFilter("billstatus", "=", (Object)Status.AUDITED);
        String param = "id,policy,country,areadept,rptoffice,kpi.childtype,currency,signparty,starttime,endtime,salesattr,chlfirstclassid,chlsecclass,kpi.inspiretype,kpi.targetcaltype,settleperiod,benifitchl,benifitcustomer,isrealtime,kpi.laddertype,highestpercent,rebatetype,signcustentity,signcustentity.schannelfirstclass,signcustentity.schannelsecclass,signcustentity.signcustomer,signcustentity.signchannel,itemclassentity,itemclassentity.productmodel,firstclass,secondclass,thirdclass,fourthclass,productmodel,itemclassentity.subentryentity,subentryentity.subproductmodel,subfourthclass,subthirdclass,subsecondclass,subfirstclass,formulaentity,formulaentity.rebatepercent,formulaentity.rebateamount";
        DynamicObject[] policyGoalsCollection = BusinessDataServiceHelper.load((String)"occpic_rebatetarget", (String)param, (QFilter[])qf.toArray());
        return Arrays.asList(policyGoalsCollection);
    }

    public List<PreRelationModel> constructEntryModel(List<DynamicObject> policyGoals) {
        ArrayList<PreRelationModel> preRelations = new ArrayList<PreRelationModel>();
        for (DynamicObject policyGoal : policyGoals) {
            List<PreRelationModel> relationModels = this.constructEntry(policyGoal);
            preRelations.addAll(relationModels);
        }
        return preRelations;
    }

    public List<PreRelationQueryParamModel> constructParam(List<DynamicObject> policyGoals) {
        ArrayList<PreRelationQueryParamModel> preRelationQueryParamModels = new ArrayList<PreRelationQueryParamModel>();
        for (DynamicObject policyGoal : policyGoals) {
            Long policyGoalId = policyGoal.getLong("id");
            Long rebatepolicy = policyGoal.getLong("policy.id");
            Long benifitCustomer = policyGoal.getLong("benifitcustomer.id");
            Long benifitChl = policyGoal.getLong("benifitchl.id");
            DynamicObjectCollection signCustomers = policyGoal.getDynamicObjectCollection("signcustentity");
            for (DynamicObject signCustomer : signCustomers) {
                PreRelationQueryParamModel param = new PreRelationQueryParamModel();
                param.setPolicy(rebatepolicy);
                param.setPolicyGoalId(policyGoalId);
                param.setSignCustomerChannel(Long.valueOf(signCustomer.getLong("signchannel.id")));
                BenefitCustomerQueryParamModel benefitCustomerParam = new BenefitCustomerQueryParamModel();
                benefitCustomerParam.setBenefitCustomer(benifitCustomer);
                benefitCustomerParam.setBenefitChannelId(benifitChl);
                param.setBenefitCustomer(benefitCustomerParam);
                param = this.constructOtherParam(policyGoal, param);
                preRelationQueryParamModels.add(param);
            }
        }
        HorizontChildCache.getInstance().removeAllCacheData();
        return preRelationQueryParamModels;
    }

    private List<PreRelationModel> constructEntry(DynamicObject policyGoal) {
        ArrayList<PreRelationModel> relationModels = new ArrayList<PreRelationModel>();
        DynamicObjectCollection signCustomers = policyGoal.getDynamicObjectCollection("signcustentity");
        for (DynamicObject signCustomer : signCustomers) {
            DynamicObject signParty;
            DynamicObject chlSecClass;
            DynamicObject chlFirstClassId;
            DynamicObject signedCustomer;
            DynamicObject signChl;
            DynamicObject rptOffice;
            DynamicObject areaDept;
            PreRelationModel preRelationModel = new PreRelationModel();
            preRelationModel.setRebatePolicy(Long.valueOf(policyGoal.getLong("policy.id")));
            DynamicObject country = policyGoal.getDynamicObject("country");
            if (country != null) {
                preRelationModel.setCountryNumber(country.getString("number"));
                preRelationModel.setCountry(Long.valueOf(country.getLong("id")));
            }
            if ((areaDept = policyGoal.getDynamicObject("areadept")) != null) {
                preRelationModel.setAreaDept(Long.valueOf(areaDept.getLong("id")));
            }
            if ((rptOffice = policyGoal.getDynamicObject("rptoffice")) != null) {
                preRelationModel.setRptOffice(Long.valueOf(rptOffice.getLong("id")));
            }
            if ((signChl = signCustomer.getDynamicObject("signchannel")) != null) {
                preRelationModel.setSignCustomerChannel(Long.valueOf(signChl.getLong("id")));
            }
            if ((signedCustomer = signCustomer.getDynamicObject("signcustomer")) != null) {
                preRelationModel.setSignCustomerBG(Long.valueOf(signedCustomer.getLong("id")));
            }
            if ((chlFirstClassId = signCustomer.getDynamicObject("schannelfirstclass")) != null) {
                preRelationModel.setbChannelFirstClass(Long.valueOf(chlFirstClassId.getLong("id")));
            }
            if ((chlSecClass = signCustomer.getDynamicObject("schannelsecclass")) != null) {
                preRelationModel.setbChannelSecClass(Long.valueOf(chlSecClass.getLong("id")));
            }
            preRelationModel.setChildType(policyGoal.getString("kpi.childtype"));
            preRelationModel.setInspireType(policyGoal.getString("kpi.inspiretype"));
            preRelationModel.setTargetCalTypeId(policyGoal.getString("kpi.targetcaltype"));
            preRelationModel.setRebateType(policyGoal.getString("rebatetype"));
            preRelationModel.setSettPeriod(policyGoal.getString("settleperiod"));
            DynamicObject currency = policyGoal.getDynamicObject("currency");
            if (currency != null) {
                preRelationModel.setCurrency(Long.valueOf(currency.getLong("id")));
            }
            if ((signParty = policyGoal.getDynamicObject("signparty")) != null) {
                preRelationModel.setRpContractSubject(Long.valueOf(signParty.getLong("id")));
            }
            preRelationModel.setTargetStartTime(policyGoal.getDate("starttime"));
            preRelationModel.setTargetDndTime(policyGoal.getDate("endtime"));
            DynamicObject laddertype = policyGoal.getDynamicObject("kpi.laddertype");
            if (laddertype != null) {
                preRelationModel.setLadderType(laddertype.getString("number"));
            }
            preRelationModel.setHighEstPercent(policyGoal.getBigDecimal("highestpercent"));
            this.setSalesAttr(policyGoal, preRelationModel);
            this.setPerentAndAmount(policyGoal, preRelationModel);
            List<PreRelationEntityModel> preRelationEntityModels = this.constructBody(policyGoal);
            preRelationModel.setPretRelationEntityModels(preRelationEntityModels);
            relationModels.add(preRelationModel);
        }
        return relationModels;
    }

    private void setPerentAndAmount(DynamicObject policyGoal, PreRelationModel preRelationModel) {
        DynamicObjectCollection formulaEntitys = policyGoal.getDynamicObjectCollection("formulaentity");
        ArrayList<BigDecimal> rebatePercentList = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> rebateAmountList = new ArrayList<BigDecimal>();
        for (DynamicObject formulaEntity : formulaEntitys) {
            rebatePercentList.add(formulaEntity.getBigDecimal("rebatepercent"));
            rebateAmountList.add(formulaEntity.getBigDecimal("rebateamount"));
        }
        preRelationModel.setRebateAmounts(rebateAmountList);
        preRelationModel.setRebatePercents(rebatePercentList);
    }

    private void setSalesAttr(DynamicObject policyGoal, PreRelationModel preRelationModel) {
        DynamicObjectCollection salesattr = policyGoal.getDynamicObjectCollection("salesattr");
        ArrayList salesattrs = new ArrayList();
        salesattr.stream().forEach(item -> salesattrs.add(item.getDynamicObject(1).getLong("id")));
        preRelationModel.setSalesattrs(salesattrs);
        preRelationModel.setSalesattrsCollection(salesattr);
    }

    private List<PreRelationEntityModel> constructBody(DynamicObject policyGoal) {
        ArrayList<PreRelationEntityModel> preRelationEntityModels = new ArrayList<PreRelationEntityModel>();
        DynamicObjectCollection products = policyGoal.getDynamicObjectCollection("itemclassentity");
        boolean isrealtime = policyGoal.getBoolean("isrealtime");
        if (isrealtime) {
            this.setProductRealtime(products, policyGoal, preRelationEntityModels);
        } else {
            DynamicObjectCollection subentryentitys = null;
            for (DynamicObject product : products) {
                DynamicObjectCollection subs = product.getDynamicObjectCollection("subentryentity");
                if (subentryentitys == null) {
                    subentryentitys = subs;
                    continue;
                }
                subentryentitys.addAll((Collection)subs);
            }
            this.setsProduct(subentryentitys, policyGoal, preRelationEntityModels);
        }
        return preRelationEntityModels;
    }

    private List<List<Long>> getAllProductId(DynamicObjectCollection products) {
        ArrayList<Long> productIds = new ArrayList<Long>();
        for (DynamicObject product : products) {
            DynamicObject productModel = product.getDynamicObject("productmodel");
            if (productModel != null) {
                Long id = productModel.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject fourthclass = product.getDynamicObject("fourthclass");
            if (fourthclass != null) {
                Long id = fourthclass.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject thirdclass = product.getDynamicObject("thirdclass");
            if (thirdclass != null) {
                Long id = thirdclass.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject secondclass = product.getDynamicObject("secondclass");
            if (secondclass != null) {
                Long id = secondclass.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject firstclass = product.getDynamicObject("firstclass");
            if (firstclass == null) continue;
            Long id = firstclass.getLong("id");
            productIds.add(id);
        }
        ArrayList<List<Long>> resultList = new ArrayList<List<Long>>();
        if (!CollectionUtils.isEmpty(productIds)) {
            HorizontChildCache horizontChildCache = HorizontChildCache.getInstance();
            for (Long productId : productIds) {
                List idLists = horizontChildCache.getFromCache("mdr_item_class", productId);
                resultList.addAll(idLists);
            }
        }
        this.distinctProductIds(resultList);
        return resultList;
    }

    private void setProductRealtime(DynamicObjectCollection products, DynamicObject policyGoal, List<PreRelationEntityModel> preRelationEntityModels) {
        List<List<Long>> allProductId = this.getAllProductId(products);
        this.setProductModel(allProductId, policyGoal, preRelationEntityModels);
    }

    private List<Long> getAllLeafProductId(DynamicObjectCollection products) {
        List<List<Long>> listList = this.getAllProductId(products);
        ArrayList<Long> result = new ArrayList<Long>();
        for (List<Long> ids : listList) {
            if (CollectionUtils.isEmpty(ids)) continue;
            result.add(ids.get(0));
        }
        return result;
    }

    private void setProductModel(List<List<Long>> resultList, DynamicObject policyGoal, List<PreRelationEntityModel> preRelationEntityModels) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        ArrayList<Long> productIds = new ArrayList<Long>(resultList.size());
        for (List<Long> list : resultList) {
            if (list.size() < 5) continue;
            productIds.add(list.get(0));
        }
        List<Long> offerings = OfferingHandle.getOfferings(productIds);
        for (Long offering : offerings) {
            DynamicObject benefitCustomerId;
            PreRelationEntityModel preRelationEntityModel = new PreRelationEntityModel();
            preRelationEntityModel.setPolicygoal(Long.valueOf(policyGoal.getLong("id")));
            DynamicObject registerclientchannel = policyGoal.getDynamicObject("benifitchl");
            if (registerclientchannel != null) {
                preRelationEntityModel.setCustomerChanelId(Long.valueOf(registerclientchannel.getLong("id")));
            }
            if ((benefitCustomerId = (DynamicObject)policyGoal.get("benifitcustomer")) != null) {
                preRelationEntityModel.setCustomerBgId(Long.valueOf(benefitCustomerId.getLong("id")));
            }
            preRelationEntityModel.setProductNumberId(offering);
            preRelationEntityModel.setFirstLevelId(OfferingHandle.getFirstLevelById(offering));
            preRelationEntityModel.setSecLevelId(OfferingHandle.getSecLevelById(offering));
            preRelationEntityModels.add(preRelationEntityModel);
        }
    }

    private void distinctProductIds(List<List<Long>> listList) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        for (int i = 0; i < listList.size(); ++i) {
            List<Long> list = listList.get(i);
            if (CollectionUtils.isEmpty(list)) {
                if (i < 0) continue;
                listList.remove(i);
                --i;
                continue;
            }
            String key = list.get(0).toString();
            if (map.get(key) != null) {
                if (i < 0) continue;
                listList.remove(i);
                --i;
                continue;
            }
            map.put(key, list);
        }
    }

    private void setsProduct(DynamicObjectCollection products, DynamicObject policyGoal, List<PreRelationEntityModel> preRelationEntityModels) {
        if (CollectionUtils.isEmpty((Collection)products)) {
            return;
        }
        ArrayList<Long> productIds = new ArrayList<Long>();
        for (DynamicObject product : products) {
            DynamicObject productModel = product.getDynamicObject("subproductmodel");
            if (productModel == null) continue;
            productIds.add(productModel.getLong("id"));
        }
        if (CollectionUtils.isEmpty(productIds)) {
            return;
        }
        List<Long> offerings = OfferingHandle.getOfferings(productIds);
        if (CollectionUtils.isEmpty(offerings)) {
            return;
        }
        for (Long offering : offerings) {
            DynamicObject benefitCustomerId;
            PreRelationEntityModel preRelationEntityModel = new PreRelationEntityModel();
            preRelationEntityModel.setPolicygoal(Long.valueOf(policyGoal.getLong("id")));
            DynamicObject registerclientchannel = policyGoal.getDynamicObject("benifitchl");
            if (registerclientchannel != null) {
                preRelationEntityModel.setCustomerChanelId(Long.valueOf(registerclientchannel.getLong("id")));
            }
            if ((benefitCustomerId = (DynamicObject)policyGoal.get("benifitcustomer")) != null) {
                preRelationEntityModel.setCustomerBgId(Long.valueOf(benefitCustomerId.getLong("id")));
            }
            preRelationEntityModel.setProductNumberId(offering);
            preRelationEntityModel.setFirstLevelId(OfferingHandle.getFirstLevelById(offering));
            preRelationEntityModel.setSecLevelId(OfferingHandle.getSecLevelById(offering));
            preRelationEntityModels.add(preRelationEntityModel);
        }
    }

    private PreRelationQueryParamModel constructOtherParam(DynamicObject policyGoal, PreRelationQueryParamModel param) {
        DynamicObject contractSubject;
        DynamicObject policyCurrency;
        DynamicObject rptOffice;
        DynamicObject areaDept;
        DynamicObjectCollection products = policyGoal.getDynamicObjectCollection("itemclassentity");
        List<Object> productModels = new ArrayList();
        boolean isrealtime = policyGoal.getBoolean("isrealtime");
        if (isrealtime) {
            productModels = this.getAllLeafProductId(products);
        } else {
            DynamicObjectCollection subentryentitys = null;
            for (DynamicObject product : products) {
                DynamicObjectCollection subs = product.getDynamicObjectCollection("subentryentity");
                if (subentryentitys == null) {
                    subentryentitys = subs;
                    continue;
                }
                subentryentitys.addAll((Collection)subs);
            }
            if (!CollectionUtils.isEmpty(subentryentitys)) {
                for (DynamicObject subentryentity : subentryentitys) {
                    if (subentryentity.getDynamicObject("subproductmodel") == null) continue;
                    productModels.add(subentryentity.getDynamicObject("subproductmodel").getLong("id"));
                }
            }
        }
        param.setProductModels(productModels);
        DynamicObject country = policyGoal.getDynamicObject("country");
        if (country != null) {
            param.setCountryNumber(country.getString("number"));
            param.setCountry(Long.valueOf(country.getLong("id")));
        }
        if ((areaDept = policyGoal.getDynamicObject("areadept")) != null) {
            param.setRegion(Long.valueOf(areaDept.getLong("id")));
        }
        if ((rptOffice = policyGoal.getDynamicObject("rptoffice")) != null) {
            param.setRepOffice(Long.valueOf(rptOffice.getLong("id")));
        }
        Object childType = policyGoal.get("kpi.childtype");
        param.setChildType(childType.toString());
        DynamicObjectCollection packageOrders = policyGoal.getDynamicObjectCollection("salesattr");
        ArrayList packageOrderList = new ArrayList();
        packageOrders.stream().forEach(packageOrder -> packageOrderList.add(packageOrder.getDynamicObject(1).getLong("id")));
        if (!CollectionUtils.isEmpty(packageOrderList)) {
            param.setPackageOrder(packageOrderList);
        }
        if ((policyCurrency = policyGoal.getDynamicObject("currency")) != null) {
            param.setPolicyCurrency(Long.valueOf(policyCurrency.getLong("id")));
        }
        if ((contractSubject = policyGoal.getDynamicObject("signparty")) != null) {
            param.setContractSubject(Long.valueOf(contractSubject.getLong("id")));
        }
        Object dateStart = policyGoal.get("starttime");
        param.setDateStart((Date)dateStart);
        Object dateEnd = policyGoal.get("endtime");
        param.setDateEnd((Date)dateEnd);
        param.setProductModels(productModels);
        return param;
    }

    public void writeBackById(List<Long> ids) {
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"occpic_rebatetarget").getDynamicObjectType();
        DynamicObject[] entrys = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dynamicObjectType);
        if (entrys == null || entrys.length == 0) {
            return;
        }
        for (DynamicObject entry : entrys) {
            entry.set("presettle", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])entrys);
    }
}

