/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.handle.HorizontChildCache;
import kd.occ.ocbase.common.enums.occpic.CalculateStatus;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occpibc.business.handle.MaterialStandardHandle;
import kd.occ.occpibc.common.model.sd.BenefitCustomerQueryParamSDModel;
import kd.occ.occpibc.common.model.sd.PreRelationEntitySDModel;
import kd.occ.occpibc.common.model.sd.PreRelationQueryParamSDModel;
import kd.occ.occpibc.common.model.sd.PreRelationSDModel;
import kd.occ.occpibc.common.model.sd.RebateFormula;

public class PolicyGoalsTabStandardHandle {
    private static final String POLICY_GOALS_SELECT_FIELDS = "id,policy,country,areadept,rptoffice,kpi.childtype,currency,signparty,starttime,endtime,salesattr,chlfirstclassid,chlsecclass,kpi.inspiretype,kpi.targetcaltype,settleperiod,benifitchl,benifitcustomer,isrealtime,kpi.laddertype,highestpercent,rebatetype,baselineamount,baselineqty";
    private static final String POLICY_GOALS_SELECT_CUSTOMER_FIELDS = "signcustentity,signcustentity.schannelfirstclass,signcustentity.schannelsecclass,signcustentity.signcustomer,signcustentity.signchannel";
    private static final String POLICY_GOALS_SELECT_PRODUCT_FIELDS = "itemclassentity,itemclassentity.productmodel,itemclassentity.item,itemclassentity.material,firstclass,secondclass,thirdclass,fourthclass,productmodel,itemclassentity.subentryentity,subentryentity.subproductmodel,subfourthclass,subthirdclass,subsecondclass,subfirstclass";
    private static final String POLICY_GOALS_SELECT_FORMULA = "formulaentity.id,formulaentity.seq,formulaentity.minamount,formulaentity.maxamount,formulaentity.rebatepercent,formulaentity.level,formulaentity.rebateamount,formulaentity.minachive,formulaentity.maxachive,formulaentity.minqty,formulaentity.maxqty,formulaentity.fixedamount";

    public final void updateRebateTargetCalculateStatus() {
        Date now = KDDateUtils.now();
        QFilter qf = new QFilter("calculatestatus", "not in", (Object)new Object[]{CalculateStatus.XUYAOJISUAN.toString(), CalculateStatus.JISUANJIESHU.toString(), CalculateStatus.SHOUGONGJIESHU.toString()});
        qf.and("endtime", ">=", (Object)now);
        qf.and("starttime", "<=", (Object)now);
        DynamicObject[] rebateTargetArray = BusinessDataServiceHelper.load((String)"occpic_rebatetarget", (String)"calculatestatus", (QFilter[])qf.toArray());
        if (rebateTargetArray != null && rebateTargetArray.length > 0) {
            for (DynamicObject rebateTarget : rebateTargetArray) {
                rebateTarget.set("calculatestatus", (Object)CalculateStatus.XUYAOJISUAN.toString());
            }
            SaveServiceHelper.save((DynamicObject[])rebateTargetArray);
        }
    }

    public List<DynamicObject> queryPolicyGoals() {
        QFilter qf = new QFilter("billstatus", "=", (Object)Status.AUDITED);
        qf.and("calculatestatus", "=", (Object)CalculateStatus.XUYAOJISUAN.toString());
        String param = "id,policy,country,areadept,rptoffice,kpi.childtype,currency,signparty,starttime,endtime,salesattr,chlfirstclassid,chlsecclass,kpi.inspiretype,kpi.targetcaltype,settleperiod,benifitchl,benifitcustomer,isrealtime,kpi.laddertype,highestpercent,rebatetype,baselineamount,baselineqty,signcustentity,signcustentity.schannelfirstclass,signcustentity.schannelsecclass,signcustentity.signcustomer,signcustentity.signchannel,itemclassentity,itemclassentity.productmodel,itemclassentity.item,itemclassentity.material,firstclass,secondclass,thirdclass,fourthclass,productmodel,itemclassentity.subentryentity,subentryentity.subproductmodel,subfourthclass,subthirdclass,subsecondclass,subfirstclass,formulaentity.id,formulaentity.seq,formulaentity.minamount,formulaentity.maxamount,formulaentity.rebatepercent,formulaentity.level,formulaentity.rebateamount,formulaentity.minachive,formulaentity.maxachive,formulaentity.minqty,formulaentity.maxqty,formulaentity.fixedamount";
        DynamicObject[] policyGoalsCollection = BusinessDataServiceHelper.load((String)"occpic_rebatetarget", (String)param, (QFilter[])qf.toArray());
        return Arrays.asList(policyGoalsCollection);
    }

    public List<PreRelationSDModel> constructEntryModel(List<DynamicObject> policyGoals) {
        ArrayList<PreRelationSDModel> preRelations = new ArrayList<PreRelationSDModel>();
        for (DynamicObject policyGoal : policyGoals) {
            List<PreRelationSDModel> relationModels = this.constructEntry(policyGoal);
            preRelations.addAll(relationModels);
        }
        return preRelations;
    }

    public List<PreRelationQueryParamSDModel> constructParam(List<DynamicObject> policyGoals) {
        ArrayList<PreRelationQueryParamSDModel> PreRelationQueryParamSDModels = new ArrayList<PreRelationQueryParamSDModel>();
        for (DynamicObject policyGoal : policyGoals) {
            Long policyGoalId = policyGoal.getLong("id");
            Long rebatepolicy = policyGoal.getLong("policy.id");
            Long benifitCustomer = policyGoal.getLong("benifitcustomer.id");
            Long benifitChl = policyGoal.getLong("benifitchl.id");
            DynamicObjectCollection signCustomers = policyGoal.getDynamicObjectCollection("signcustentity");
            for (DynamicObject signCustomer : signCustomers) {
                PreRelationQueryParamSDModel param = new PreRelationQueryParamSDModel();
                param.setPolicy(rebatepolicy);
                param.setPolicyGoalId(policyGoalId);
                param.setSignCustomerChannel(Long.valueOf(signCustomer.getLong("signchannel.id")));
                BenefitCustomerQueryParamSDModel benefitCustomerParam = new BenefitCustomerQueryParamSDModel();
                benefitCustomerParam.setBenefitCustomer(benifitCustomer);
                benefitCustomerParam.setBenefitChannelId(benifitChl);
                param.setBenefitCustomer(benefitCustomerParam);
                param = this.constructOtherParam(policyGoal, param);
                PreRelationQueryParamSDModels.add(param);
            }
        }
        HorizontChildCache.getInstance().removeAllCacheData();
        return PreRelationQueryParamSDModels;
    }

    private List<PreRelationSDModel> constructEntry(DynamicObject policyGoal) {
        ArrayList<PreRelationSDModel> relationModels = new ArrayList<PreRelationSDModel>();
        DynamicObjectCollection signCustomers = policyGoal.getDynamicObjectCollection("signcustentity");
        for (DynamicObject signCustomer : signCustomers) {
            DynamicObject signParty;
            DynamicObject chlSecClass;
            DynamicObject chlFirstClassId;
            DynamicObject signedCustomer;
            DynamicObject signChl;
            DynamicObject rptOffice;
            DynamicObject areaDept;
            PreRelationSDModel PreRelationSDModel2 = new PreRelationSDModel();
            PreRelationSDModel2.setRebatePolicy(Long.valueOf(policyGoal.getLong("policy.id")));
            DynamicObject country = policyGoal.getDynamicObject("country");
            if (country != null) {
                PreRelationSDModel2.setCountryNumber(country.getString("number"));
                PreRelationSDModel2.setCountry(Long.valueOf(country.getLong("id")));
            }
            if ((areaDept = policyGoal.getDynamicObject("areadept")) != null) {
                PreRelationSDModel2.setAreaDept(Long.valueOf(areaDept.getLong("id")));
            }
            if ((rptOffice = policyGoal.getDynamicObject("rptoffice")) != null) {
                PreRelationSDModel2.setRptOffice(Long.valueOf(rptOffice.getLong("id")));
            }
            if ((signChl = signCustomer.getDynamicObject("signchannel")) != null) {
                PreRelationSDModel2.setSignCustomerChannel(Long.valueOf(signChl.getLong("id")));
            }
            if ((signedCustomer = signCustomer.getDynamicObject("signcustomer")) != null) {
                PreRelationSDModel2.setSignCustomerBG(Long.valueOf(signedCustomer.getLong("id")));
            }
            if ((chlFirstClassId = signCustomer.getDynamicObject("schannelfirstclass")) != null) {
                PreRelationSDModel2.setbChannelFirstClass(Long.valueOf(chlFirstClassId.getLong("id")));
            }
            if ((chlSecClass = signCustomer.getDynamicObject("schannelsecclass")) != null) {
                PreRelationSDModel2.setbChannelSecClass(Long.valueOf(chlSecClass.getLong("id")));
            }
            PreRelationSDModel2.setChildType(policyGoal.getString("kpi.childtype"));
            PreRelationSDModel2.setInspireType(policyGoal.getString("kpi.inspiretype"));
            PreRelationSDModel2.setTargetCalTypeId(policyGoal.getString("kpi.targetcaltype"));
            PreRelationSDModel2.setRebateType(policyGoal.getString("rebatetype"));
            PreRelationSDModel2.setSettPeriod(policyGoal.getString("settleperiod"));
            DynamicObject currency = policyGoal.getDynamicObject("currency");
            if (currency != null) {
                PreRelationSDModel2.setCurrency(Long.valueOf(currency.getLong("id")));
            }
            if ((signParty = policyGoal.getDynamicObject("signparty")) != null) {
                PreRelationSDModel2.setRpContractSubject(Long.valueOf(signParty.getLong("id")));
            }
            PreRelationSDModel2.setTargetStartTime(policyGoal.getDate("starttime"));
            PreRelationSDModel2.setTargetDndTime(policyGoal.getDate("endtime"));
            DynamicObject laddertype = policyGoal.getDynamicObject("kpi.laddertype");
            if (laddertype != null) {
                PreRelationSDModel2.setLadderType(laddertype.getString("number"));
                PreRelationSDModel2.setLadderTypeId(DynamicObjectUtils.getPkValue((DynamicObject)laddertype));
            }
            PreRelationSDModel2.setHighEstPercent(policyGoal.getBigDecimal("highestpercent"));
            PreRelationSDModel2.setBaselineAmount(policyGoal.getBigDecimal("baselineamount"));
            PreRelationSDModel2.setBaselineQty(policyGoal.getBigDecimal("baselineqty"));
            this.setSalesAttr(policyGoal, PreRelationSDModel2);
            this.setPerentAndAmount(policyGoal, PreRelationSDModel2);
            List<PreRelationEntitySDModel> preRelationEntitySDModels = this.constructBody(policyGoal);
            PreRelationSDModel2.setPretRelationEntityModels(preRelationEntitySDModels);
            relationModels.add(PreRelationSDModel2);
        }
        return relationModels;
    }

    private void setPerentAndAmount(DynamicObject policyGoal, PreRelationSDModel PreRelationSDModel2) {
        DynamicObjectCollection formulaEntitys = policyGoal.getDynamicObjectCollection("formulaentity");
        ArrayList<RebateFormula> formulaList = new ArrayList<RebateFormula>(formulaEntitys.size());
        for (DynamicObject formulaEntity : formulaEntitys) {
            RebateFormula formula = new RebateFormula();
            formula.setMaxAchive(formulaEntity.getBigDecimal("maxachive"));
            formula.setMinAchive(formulaEntity.getBigDecimal("minachive"));
            formula.setMaxAmount(formulaEntity.getBigDecimal("maxamount"));
            formula.setMinAmount(formulaEntity.getBigDecimal("minamount"));
            formula.setMaxQty(formulaEntity.getBigDecimal("maxqty"));
            formula.setMinQty(formulaEntity.getBigDecimal("minqty"));
            formula.setRebateAmount(formulaEntity.getBigDecimal("rebateamount"));
            formula.setRebatePercent(formulaEntity.getBigDecimal("rebatepercent"));
            formula.setFixedAmount(formulaEntity.getBigDecimal("fixedamount"));
            formulaList.add(formula);
        }
        PreRelationSDModel2.setFormulaList(formulaList);
    }

    private void setSalesAttr(DynamicObject policyGoal, PreRelationSDModel PreRelationSDModel2) {
        DynamicObjectCollection salesattr = policyGoal.getDynamicObjectCollection("salesattr");
        ArrayList salesattrs = new ArrayList();
        salesattr.stream().forEach(item -> salesattrs.add(item.getDynamicObject(1).getLong("id")));
        PreRelationSDModel2.setSalesattrs(salesattrs);
        PreRelationSDModel2.setSalesattrsCollection(salesattr);
    }

    private List<PreRelationEntitySDModel> constructBody(DynamicObject policyGoal) {
        ArrayList<PreRelationEntitySDModel> preRelationEntitySDModels = new ArrayList<PreRelationEntitySDModel>();
        DynamicObjectCollection products = policyGoal.getDynamicObjectCollection("itemclassentity");
        boolean isrealtime = policyGoal.getBoolean("isrealtime");
        if (isrealtime) {
            this.setProductRealtime(products, policyGoal, preRelationEntitySDModels);
        } else {
            DynamicObjectCollection subentryentitys = null;
            for (DynamicObject product : products) {
                DynamicObjectCollection subs = product.getDynamicObjectCollection("subentryentity");
                if (subentryentitys == null) {
                    subentryentitys = subs;
                    continue;
                }
                subentryentitys.addAll((Collection)subs);
            }
            this.setsProduct(subentryentitys, policyGoal, preRelationEntitySDModels);
        }
        Map<Long, List<PreRelationEntitySDModel>> groupByMaterialPreRelationEntitySDModelMap = preRelationEntitySDModels.stream().collect(Collectors.groupingBy(PreRelationEntitySDModel::getMaterial));
        return groupByMaterialPreRelationEntitySDModelMap.values().stream().map(r -> (PreRelationEntitySDModel)r.get(0)).collect(Collectors.toList());
    }

    private List<List<Long>> getAllProductId(DynamicObjectCollection products) {
        ArrayList<Long> productIds = new ArrayList<Long>();
        for (DynamicObject product : products) {
            DynamicObject productModel = product.getDynamicObject("productmodel");
            if (productModel != null) {
                Long id = productModel.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject fourthclass = product.getDynamicObject("fourthclass");
            if (fourthclass != null) {
                Long id = fourthclass.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject thirdclass = product.getDynamicObject("thirdclass");
            if (thirdclass != null) {
                Long id = thirdclass.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject secondclass = product.getDynamicObject("secondclass");
            if (secondclass != null) {
                Long id = secondclass.getLong("id");
                productIds.add(id);
                continue;
            }
            DynamicObject firstclass = product.getDynamicObject("firstclass");
            if (firstclass == null) continue;
            Long id = firstclass.getLong("id");
            productIds.add(id);
        }
        ArrayList<List<Long>> resultList = new ArrayList<List<Long>>();
        if (!CollectionUtils.isEmpty(productIds)) {
            HorizontChildCache horizontChildCache = HorizontChildCache.getInstance();
            for (Long productId : productIds) {
                List idLists = horizontChildCache.getFromCache("mdr_item_class", productId);
                resultList.addAll(idLists);
            }
        }
        this.distinctProductIds(resultList);
        return resultList;
    }

    private void setProductRealtime(DynamicObjectCollection products, DynamicObject policyGoal, List<PreRelationEntitySDModel> preRelationEntitySDModels) {
        List<List<Long>> allProductId = this.getAllProductId(products);
        this.setProductModel(allProductId, policyGoal, preRelationEntitySDModels);
    }

    private List<Long> getAllLeafProductId(DynamicObjectCollection products) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<List<Long>> listList = this.getAllProductId(products);
        if (!CollectionUtils.isEmpty(listList)) {
            for (List<Long> ids : listList) {
                result.add(ids.get(0));
            }
        }
        return result;
    }

    private void setProductModel(List<List<Long>> resultList, DynamicObject policyGoal, List<PreRelationEntitySDModel> preRelationEntitySDModels) {
        ArrayList<Long> productIds = new ArrayList<Long>(resultList.size());
        for (List<Long> list : resultList) {
            if (list.size() < 1) continue;
            productIds.add(list.get(0));
        }
        List<Long> materials = MaterialStandardHandle.getMaterials(productIds);
        HashSet<Long> materialIdSet = new HashSet<Long>(policyGoal.getDynamicObjectCollection("itemclassentity").size());
        for (DynamicObject entry : policyGoal.getDynamicObjectCollection("itemclassentity")) {
            long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"item");
            long materialId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"material");
            if (itemId <= 0L || materialId <= 0L) continue;
            PreRelationEntitySDModel preRelationEntitySDModel = new PreRelationEntitySDModel();
            preRelationEntitySDModel.setPolicygoal(Long.valueOf(policyGoal.getLong("id")));
            preRelationEntitySDModel.setCustomerChanelId(Long.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policyGoal, (String)"benifitchl")));
            preRelationEntitySDModel.setCustomerBgId(Long.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policyGoal, (String)"benifitcustomer")));
            preRelationEntitySDModel.setMaterial(Long.valueOf(materialId));
            preRelationEntitySDModel.setIteminfo(Long.valueOf(itemId));
            preRelationEntitySDModels.add(preRelationEntitySDModel);
            materialIdSet.add(materialId);
        }
        materials.removeAll(materialIdSet);
        for (Long material : materials) {
            DynamicObject benefitCustomerId;
            PreRelationEntitySDModel preRelationEntitySDModel = new PreRelationEntitySDModel();
            preRelationEntitySDModel.setPolicygoal(Long.valueOf(policyGoal.getLong("id")));
            DynamicObject registerclientchannel = policyGoal.getDynamicObject("benifitchl");
            if (registerclientchannel != null) {
                preRelationEntitySDModel.setCustomerChanelId(Long.valueOf(registerclientchannel.getLong("id")));
            }
            if ((benefitCustomerId = (DynamicObject)policyGoal.get("benifitcustomer")) != null) {
                preRelationEntitySDModel.setCustomerBgId(Long.valueOf(benefitCustomerId.getLong("id")));
            }
            preRelationEntitySDModel.setMaterial(material);
            Long itemInfoId = MaterialStandardHandle.getItemByMaterialId(material);
            preRelationEntitySDModel.setIteminfo(itemInfoId);
            preRelationEntitySDModels.add(preRelationEntitySDModel);
        }
    }

    private void distinctProductIds(List<List<Long>> listList) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        for (int i = 0; i < listList.size(); ++i) {
            List<Long> list = listList.get(i);
            if (CollectionUtils.isEmpty(list)) {
                if (i < 0) continue;
                listList.remove(i);
                --i;
                continue;
            }
            String key = list.get(0).toString();
            if (map.get(key) != null) {
                if (i < 0) continue;
                listList.remove(i);
                --i;
                continue;
            }
            map.put(key, list);
        }
    }

    private void setsProduct(DynamicObjectCollection products, DynamicObject policyGoal, List<PreRelationEntitySDModel> preRelationEntitySDModels) {
        if (CollectionUtils.isEmpty((Collection)products)) {
            return;
        }
        ArrayList<Long> productIds = new ArrayList<Long>();
        for (DynamicObject product : products) {
            DynamicObject productModel = product.getDynamicObject("subproductmodel");
            if (productModel == null) continue;
            productIds.add(productModel.getLong("id"));
        }
        List<Long> materials = MaterialStandardHandle.getMaterials(productIds);
        HashSet<Long> materialIdSet = new HashSet<Long>(policyGoal.getDynamicObjectCollection("itemclassentity").size());
        for (DynamicObject entry : policyGoal.getDynamicObjectCollection("itemclassentity")) {
            long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"item");
            long materialId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"material");
            if (itemId <= 0L || materialId <= 0L) continue;
            PreRelationEntitySDModel preRelationEntitySDModel = new PreRelationEntitySDModel();
            preRelationEntitySDModel.setPolicygoal(Long.valueOf(policyGoal.getLong("id")));
            preRelationEntitySDModel.setCustomerChanelId(Long.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policyGoal, (String)"benifitchl")));
            preRelationEntitySDModel.setCustomerBgId(Long.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policyGoal, (String)"benifitcustomer")));
            preRelationEntitySDModel.setMaterial(Long.valueOf(materialId));
            preRelationEntitySDModel.setIteminfo(Long.valueOf(itemId));
            preRelationEntitySDModels.add(preRelationEntitySDModel);
            materialIdSet.add(materialId);
        }
        materials.removeAll(materialIdSet);
        for (Long material : materials) {
            DynamicObject benefitCustomerId;
            PreRelationEntitySDModel preRelationEntitySDModel = new PreRelationEntitySDModel();
            preRelationEntitySDModel.setPolicygoal(Long.valueOf(policyGoal.getLong("id")));
            DynamicObject registerclientchannel = policyGoal.getDynamicObject("benifitchl");
            if (registerclientchannel != null) {
                preRelationEntitySDModel.setCustomerChanelId(Long.valueOf(registerclientchannel.getLong("id")));
            }
            if ((benefitCustomerId = (DynamicObject)policyGoal.get("benifitcustomer")) != null) {
                preRelationEntitySDModel.setCustomerBgId(Long.valueOf(benefitCustomerId.getLong("id")));
            }
            preRelationEntitySDModel.setMaterial(material);
            Long itemInfoId = MaterialStandardHandle.getItemByMaterialId(material);
            preRelationEntitySDModel.setIteminfo(itemInfoId);
            preRelationEntitySDModels.add(preRelationEntitySDModel);
        }
    }

    private PreRelationQueryParamSDModel constructOtherParam(DynamicObject policyGoal, PreRelationQueryParamSDModel param) {
        DynamicObject contractSubject;
        DynamicObject policyCurrency;
        DynamicObject rptOffice;
        DynamicObject areaDept;
        DynamicObjectCollection products = policyGoal.getDynamicObjectCollection("itemclassentity");
        List<Object> productModels = new ArrayList();
        boolean isrealtime = policyGoal.getBoolean("isrealtime");
        if (isrealtime) {
            productModels = this.getAllLeafProductId(products);
        } else {
            DynamicObjectCollection subentryentitys = null;
            for (DynamicObject product : products) {
                DynamicObjectCollection subs = product.getDynamicObjectCollection("subentryentity");
                if (subentryentitys == null) {
                    subentryentitys = subs;
                    continue;
                }
                subentryentitys.addAll((Collection)subs);
            }
            if (!CollectionUtils.isEmpty(subentryentitys)) {
                for (DynamicObject subentryentity : subentryentitys) {
                    if (subentryentity.getDynamicObject("subproductmodel") == null) continue;
                    productModels.add(subentryentity.getDynamicObject("subproductmodel").getLong("id"));
                }
            }
        }
        param.setProductModels(productModels);
        Set materialIdSet = products.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"material")).filter(r -> r > 0L).collect(Collectors.toSet());
        param.setMaterialIdSet(materialIdSet);
        DynamicObject country = policyGoal.getDynamicObject("country");
        if (country != null) {
            param.setCountryNumber(country.getString("number"));
            param.setCountry(Long.valueOf(country.getLong("id")));
        }
        if ((areaDept = policyGoal.getDynamicObject("areadept")) != null) {
            param.setRegion(Long.valueOf(areaDept.getLong("id")));
        }
        if ((rptOffice = policyGoal.getDynamicObject("rptoffice")) != null) {
            param.setRepOffice(Long.valueOf(rptOffice.getLong("id")));
        }
        Object childType = policyGoal.get("kpi.childtype");
        param.setChildType(childType.toString());
        DynamicObjectCollection packageOrders = policyGoal.getDynamicObjectCollection("salesattr");
        ArrayList packageOrderList = new ArrayList();
        packageOrders.stream().forEach(packageOrder -> packageOrderList.add(packageOrder.getDynamicObject(1).getLong("id")));
        if (!CollectionUtils.isEmpty(packageOrderList)) {
            param.setPackageOrder(packageOrderList);
        }
        if ((policyCurrency = policyGoal.getDynamicObject("currency")) != null) {
            param.setPolicyCurrency(Long.valueOf(policyCurrency.getLong("id")));
        }
        if ((contractSubject = policyGoal.getDynamicObject("signparty")) != null) {
            param.setContractSubject(Long.valueOf(contractSubject.getLong("id")));
        }
        Object dateStart = policyGoal.get("starttime");
        param.setDateStart((Date)dateStart);
        Object dateEnd = policyGoal.get("endtime");
        param.setDateEnd((Date)dateEnd);
        param.setProductModels(productModels);
        return param;
    }

    public void writeBackById(List<Long> ids) {
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"occpic_rebatetarget").getDynamicObjectType();
        DynamicObject[] entrys = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dynamicObjectType);
        if (entrys == null || entrys.length == 0) {
            return;
        }
        for (DynamicObject entry : entrys) {
            entry.set("presettle", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])entrys);
    }
}

