/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occpibc.common.model.PreRelationEntityModel;
import kd.occ.occpibc.common.model.PreRelationModel;

public class PretRelationTabHandle {
    private static final String PRET_RELATION_SELECT_FIELDS = "id,rebatepolicy,country,areadept,rptoffice,signcustomerchannel,signcustomerbg,signcustomerbg.name,bchannelfirstclass,bchannelsecclass,childtype,inspiretype,targetcaltype,settperiod,currency,rpcontractsubject,rpbegindate,rpenddate,salesattrs,modifytime";
    private static final String PRET_RELATION_SELECT_FIELDS_ENTITY = "entryentity,entryentity.policygoal,entryentity.customerchanelid,entryentity.customerbg,entryentity.firstclass,entryentity.secondclass,entryentity.productnumber,entryentity.podmax,entryentity.atamax,entryentity.ordernumsum,entryentity.signnumsum,entryentity.deliveryamount,entryentity.maxamount,entryentity.percentmax,entryentity.rebateamount,entryentity.contractno,entryentity.updatetime,entryentity.unit";

    public DynamicObject[] searchByPolicy(List<Long> policyIds) {
        QFilter qf = new QFilter("rebatepolicy", "in", policyIds);
        String param = "id,rebatepolicy,country,areadept,rptoffice,signcustomerchannel,signcustomerbg,signcustomerbg.name,bchannelfirstclass,bchannelsecclass,childtype,inspiretype,targetcaltype,settperiod,currency,rpcontractsubject,rpbegindate,rpenddate,salesattrs,modifytime,entryentity,entryentity.policygoal,entryentity.customerchanelid,entryentity.customerbg,entryentity.firstclass,entryentity.secondclass,entryentity.productnumber,entryentity.podmax,entryentity.atamax,entryentity.ordernumsum,entryentity.signnumsum,entryentity.deliveryamount,entryentity.maxamount,entryentity.percentmax,entryentity.rebateamount,entryentity.contractno,entryentity.updatetime,entryentity.unit";
        DynamicObject[] pretRelations = BusinessDataServiceHelper.load((String)"occpibc_pretrelation", (String)param, (QFilter[])qf.toArray());
        return pretRelations;
    }

    public DynamicObject[] getTodayData() {
        Date todayWee = DateUtil.getTodayWee();
        QFilter qf = new QFilter("modifytime", ">=", (Object)todayWee);
        String param = "id,rebatepolicy,country,areadept,rptoffice,signcustomerchannel,signcustomerbg,signcustomerbg.name,bchannelfirstclass,bchannelsecclass,childtype,inspiretype,targetcaltype,settperiod,currency,rpcontractsubject,rpbegindate,rpenddate,salesattrs,modifytime,entryentity,entryentity.policygoal,entryentity.customerchanelid,entryentity.customerbg,entryentity.firstclass,entryentity.secondclass,entryentity.productnumber,entryentity.podmax,entryentity.atamax,entryentity.ordernumsum,entryentity.signnumsum,entryentity.deliveryamount,entryentity.maxamount,entryentity.percentmax,entryentity.rebateamount,entryentity.contractno,entryentity.updatetime,entryentity.unit";
        DynamicObject[] pretRelations = BusinessDataServiceHelper.load((String)"occpibc_pretrelation", (String)param, (QFilter[])qf.toArray());
        return pretRelations;
    }

    public void conversionToModel(DynamicObject[] pretRelations, List<PreRelationModel> preRelationModels) {
        for (DynamicObject pretRelation : pretRelations) {
            for (PreRelationModel preRelationModel : preRelationModels) {
                Long policyId = pretRelation.getLong("rebatepolicy.id");
                Long signcustomerChl = pretRelation.getLong("signcustomerchannel.id");
                Date rpbegindate = pretRelation.getDate("rpbegindate");
                Date rpenddate = pretRelation.getDate("rpenddate");
                if (preRelationModel.getRebatePolicy() == null || preRelationModel.getSignCustomerChannel() == null || preRelationModel.getTargetStartTime() == null || preRelationModel.getTargetDndTime() == null || !preRelationModel.getRebatePolicy().equals(policyId) || !preRelationModel.getSignCustomerChannel().equals(signcustomerChl) || preRelationModel.getTargetStartTime().compareTo(rpbegindate) != 0 || preRelationModel.getTargetDndTime().compareTo(rpenddate) != 0) continue;
                long id = pretRelation.getLong("id");
                preRelationModel.setId(Long.valueOf(id));
                DynamicObjectCollection entryEntitys = pretRelation.getDynamicObjectCollection("entryentity");
                List pretRelationEntityModels = preRelationModel.getPretRelationEntityModels();
                this.fuse(id, entryEntitys, pretRelationEntityModels);
            }
        }
    }

    private void fuse(Long id, DynamicObjectCollection entryEntitys, List<PreRelationEntityModel> pretRelationEntityModels) {
        for (DynamicObject entryEntity : entryEntitys) {
            for (PreRelationEntityModel pretRelationEntityModel : pretRelationEntityModels) {
                long policygoalid = entryEntity.getLong("policygoal.id");
                Long policygoal = pretRelationEntityModel.getPolicygoal();
                Long customerChanel = entryEntity.getLong("customerchanelid.id");
                Long customerChanelId = pretRelationEntityModel.getCustomerChanelId();
                Long productNumber = entryEntity.getLong("productnumber.id");
                Long productNumberId = pretRelationEntityModel.getProductNumberId();
                String contractNo = pretRelationEntityModel.getContractNo();
                String contractno = entryEntity.getString("contractno");
                if (productNumberId == null || policygoal == null || contractNo == null || !customerChanelId.equals(customerChanel) || !productNumberId.equals(productNumber) || !policygoal.equals(policygoalid) || !contractNo.equals(contractno)) continue;
                pretRelationEntityModel.setId(id);
                pretRelationEntityModel.setEntryId((Long)entryEntity.getPkValue());
                pretRelationEntityModel.setAtaMax(entryEntity.getDate("atamax"));
                pretRelationEntityModel.setPodMax(entryEntity.getDate("podmax"));
                pretRelationEntityModel.setOrderNumSum(entryEntity.getBigDecimal("ordernumsum"));
                pretRelationEntityModel.setSignNumSum(entryEntity.getBigDecimal("signnumsum"));
                pretRelationEntityModel.setDeliveryAmount(entryEntity.getBigDecimal("deliveryamount"));
                pretRelationEntityModel.setMaxAmount(entryEntity.getBigDecimal("maxamount"));
                pretRelationEntityModel.setMaxPercent(entryEntity.getBigDecimal("percentmax"));
                pretRelationEntityModel.setRebateAmount(entryEntity.getBigDecimal("rebateamount"));
                pretRelationEntityModel.setUpdateTime(entryEntity.getDate("updatetime"));
            }
        }
    }

    public List<DynamicObject> saveByModel(List<PreRelationModel> preRelationModels, DynamicObject[] oldPreRelations) {
        ArrayList<DynamicObject> preRelations = new ArrayList<DynamicObject>();
        for (PreRelationModel preRelationModel : preRelationModels) {
            Date targetDndTime;
            Date targetStartTime;
            Long signCustomerChannel;
            List pretRelationEntityModels = preRelationModel.getPretRelationEntityModels();
            if (CollectionUtils.isEmpty((Collection)pretRelationEntityModels)) continue;
            if (preRelationModel.getId() == null) {
                DynamicObject preRelation = BusinessDataServiceHelper.newDynamicObject((String)"occpibc_pretrelation");
                this.setHeader(preRelation, preRelationModel);
                DynamicObjectCollection entry = preRelation.getDynamicObjectCollection("entryentity");
                for (PreRelationEntityModel pretRelationEntityModel : pretRelationEntityModels) {
                    DynamicObject entryObject = entry.addNew();
                    this.setEntry(pretRelationEntityModel, entryObject);
                }
                preRelations.add(preRelation);
                continue;
            }
            Long policy = preRelationModel.getRebatePolicy();
            DynamicObject oldPreRelation = this.getDynamicObjectById(oldPreRelations, policy, signCustomerChannel = preRelationModel.getSignCustomerChannel(), targetStartTime = preRelationModel.getTargetStartTime(), targetDndTime = preRelationModel.getTargetDndTime());
            if (oldPreRelation == null) continue;
            this.setHeader(oldPreRelation, preRelationModel);
            DynamicObjectCollection entrys = oldPreRelation.getDynamicObjectCollection("entryentity");
            for (PreRelationEntityModel pretRelationEntityModel : pretRelationEntityModels) {
                if (pretRelationEntityModel.getEntryId() != null) {
                    for (DynamicObject entry : entrys) {
                        if (!entry.getPkValue().equals(pretRelationEntityModel.getEntryId())) continue;
                        this.setEntry(pretRelationEntityModel, entry);
                    }
                    continue;
                }
                DynamicObject entryObject = entrys.addNew();
                this.setEntry(pretRelationEntityModel, entryObject);
            }
            preRelations.add(oldPreRelation);
        }
        for (DynamicObject preRelation : preRelations) {
            DynamicObject[] preRelationentry = new DynamicObject[]{preRelation};
            SaveServiceHelper.save((DynamicObject[])preRelationentry);
        }
        return preRelations;
    }

    private DynamicObject getDynamicObjectById(DynamicObject[] oldPreRelations, Long id, Long signCustomerChannel, Date targetStartTime, Date targetDndTime) {
        for (DynamicObject oldPreRelation : oldPreRelations) {
            Long policyId = oldPreRelation.getLong("rebatepolicy.id");
            Long signcustomerChl = oldPreRelation.getLong("signcustomerchannel.id");
            Date rpbegindate = oldPreRelation.getDate("rpbegindate");
            Date rpenddate = oldPreRelation.getDate("rpenddate");
            if (!id.equals(policyId) || !signCustomerChannel.equals(signcustomerChl) || targetStartTime.compareTo(rpbegindate) != 0 || targetDndTime.compareTo(rpenddate) != 0) continue;
            return oldPreRelation;
        }
        return null;
    }

    private void setHeader(DynamicObject preRelation, PreRelationModel preRelationModel) {
        preRelation.set("rebatepolicy", (Object)preRelationModel.getRebatePolicy());
        preRelation.set("country", (Object)preRelationModel.getCountry());
        preRelation.set("areadept", (Object)preRelationModel.getAreaDept());
        preRelation.set("rptoffice", (Object)preRelationModel.getRptOffice());
        preRelation.set("signcustomerchannel", (Object)preRelationModel.getSignCustomerChannel());
        preRelation.set("signcustomerbg", (Object)preRelationModel.getSignCustomerBG());
        preRelation.set("bchannelfirstclass", (Object)preRelationModel.getbChannelFirstClass());
        preRelation.set("bchannelsecclass", (Object)preRelationModel.getbChannelSecClass());
        preRelation.set("childtype", (Object)preRelationModel.getChildType());
        preRelation.set("inspiretype", (Object)preRelationModel.getInspireType());
        preRelation.set("targetcaltype", (Object)preRelationModel.getTargetCalTypeId());
        preRelation.set("settperiod", (Object)preRelationModel.getSettPeriod());
        preRelation.set("currency", (Object)preRelationModel.getCurrency());
        preRelation.set("rpcontractsubject", (Object)preRelationModel.getRpContractSubject());
        preRelation.set("rpbegindate", (Object)preRelationModel.getTargetStartTime());
        preRelation.set("rpenddate", (Object)preRelationModel.getTargetDndTime());
        preRelation.set("modifytime", (Object)new Date());
        List salesAttrs = preRelationModel.getSalesattrs();
        if (!CollectionUtils.isEmpty((Collection)salesAttrs)) {
            DynamicObjectUtils.setMultiF7Value((DynamicObject)preRelation, (String)"salesattrs", (String)"ocdbd_item_saleattr", (Object[])salesAttrs.toArray());
        }
    }

    private void setEntry(PreRelationEntityModel pretRelationEntityModel, DynamicObject entryObject) {
        entryObject.set("policygoal", (Object)pretRelationEntityModel.getPolicygoal());
        entryObject.set("customerchanelid", (Object)pretRelationEntityModel.getCustomerChanelId());
        entryObject.set("customerbg", (Object)pretRelationEntityModel.getCustomerBgId());
        entryObject.set("firstclass", (Object)pretRelationEntityModel.getFirstLevelId());
        entryObject.set("secondclass", (Object)pretRelationEntityModel.getSecLevelId());
        entryObject.set("productnumber", (Object)pretRelationEntityModel.getProductNumberId());
        entryObject.set("contractno", (Object)pretRelationEntityModel.getContractNo());
        entryObject.set("podmax", (Object)pretRelationEntityModel.getPodMax());
        entryObject.set("atamax", (Object)pretRelationEntityModel.getAtaMax());
        entryObject.set("ordernumsum", (Object)pretRelationEntityModel.getOrderNumSum());
        entryObject.set("signnumsum", (Object)pretRelationEntityModel.getSignNumSum());
        entryObject.set("deliveryamount", (Object)pretRelationEntityModel.getDeliveryAmount());
        entryObject.set("maxamount", (Object)pretRelationEntityModel.getMaxAmount());
        entryObject.set("percentmax", (Object)pretRelationEntityModel.getMaxPercent());
        entryObject.set("rebateamount", (Object)pretRelationEntityModel.getRebateAmount());
        entryObject.set("unit", (Object)pretRelationEntityModel.getUnit());
        entryObject.set("updatetime", (Object)new Date());
    }
}

