/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.LadderTypeEnums;
import kd.occ.ocbase.common.enums.RebateTypeEnum;
import kd.occ.ocbase.common.enums.TargetCalTypeEnum;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.occpibc.business.handle.RebateCalcStandardHandle;
import kd.occ.occpibc.common.model.sd.PreRelationEntitySDModel;
import kd.occ.occpibc.common.model.sd.PreRelationSDModel;

public class PretRelationTabStandardHandle {
    private static final String PRET_RELATION_SELECT_FIELDS = "id,rebatepolicy,country,areadept,rptoffice,signcustomerchannel,signcustomerbg,signcustomerbg.name,bchannelfirstclass,bchannelsecclass,childtype,inspiretype,targetcaltype,settperiod,currency,rpcontractsubject,rpbegindate,rpenddate,salesattrs,modifytime";
    private static final String PRET_RELATION_SELECT_FIELDS_ENTITY = "entryentity,entryentity.policygoal,entryentity.customerchanelid,entryentity.customerbg,entryentity.firstclass,entryentity.secondclass,entryentity.productnumber,entryentity.podmax,entryentity.atamax,entryentity.ordernumsum,entryentity.signnumsum,entryentity.deliveryamount,entryentity.maxamount,entryentity.percentmax,entryentity.rebateamount,entryentity.contractno,entryentity.updatetime,entryentity.unit,entryentity.material,entryentity.iteminfo,entryentity.fixedamount";

    public DynamicObject[] searchByPolicy(List<Long> policyIds) {
        QFilter qf = new QFilter("rebatepolicy", "in", policyIds);
        return QueryUtil.load((String)"occpibc_pretrelation", (QFilter[])qf.toArray(), (String[])new String[0]);
    }

    public DynamicObject[] getTodayData() {
        Date todayWee = DateUtil.getTodayWee();
        QFilter qf = new QFilter("modifytime", ">=", (Object)todayWee);
        String param = "id,rebatepolicy,country,areadept,rptoffice,signcustomerchannel,signcustomerbg,signcustomerbg.name,bchannelfirstclass,bchannelsecclass,childtype,inspiretype,targetcaltype,settperiod,currency,rpcontractsubject,rpbegindate,rpenddate,salesattrs,modifytime,entryentity,entryentity.policygoal,entryentity.customerchanelid,entryentity.customerbg,entryentity.firstclass,entryentity.secondclass,entryentity.productnumber,entryentity.podmax,entryentity.atamax,entryentity.ordernumsum,entryentity.signnumsum,entryentity.deliveryamount,entryentity.maxamount,entryentity.percentmax,entryentity.rebateamount,entryentity.contractno,entryentity.updatetime,entryentity.unit,entryentity.material,entryentity.iteminfo,entryentity.fixedamount";
        DynamicObject[] pretRelations = BusinessDataServiceHelper.load((String)"occpibc_pretrelation", (String)param, (QFilter[])qf.toArray());
        return pretRelations;
    }

    public void conversionToModel(DynamicObject[] pretRelations, List<PreRelationSDModel> preRelationSDModels) {
        for (DynamicObject pretRelation : pretRelations) {
            for (PreRelationSDModel preRelationSDModel : preRelationSDModels) {
                Long policyId = pretRelation.getLong("rebatepolicy.id");
                Long signcustomerChl = pretRelation.getLong("signcustomerchannel.id");
                Date rpbegindate = pretRelation.getDate("rpbegindate");
                Date rpenddate = pretRelation.getDate("rpenddate");
                if (preRelationSDModel.getRebatePolicy() == null || preRelationSDModel.getSignCustomerChannel() == null || preRelationSDModel.getTargetStartTime() == null || preRelationSDModel.getTargetDndTime() == null || !preRelationSDModel.getRebatePolicy().equals(policyId) || !preRelationSDModel.getSignCustomerChannel().equals(signcustomerChl) || preRelationSDModel.getTargetStartTime().compareTo(rpbegindate) != 0 || preRelationSDModel.getTargetDndTime().compareTo(rpenddate) != 0) continue;
                long id = pretRelation.getLong("id");
                preRelationSDModel.setId(Long.valueOf(id));
                DynamicObjectCollection entryEntitys = pretRelation.getDynamicObjectCollection("entryentity");
                List pretRelationEntityModels = preRelationSDModel.getPretRelationEntityModels();
                this.fuse(id, entryEntitys, pretRelationEntityModels);
            }
        }
    }

    private void fuse(Long id, DynamicObjectCollection entryEntitys, List<PreRelationEntitySDModel> pretRelationEntityModels) {
        for (DynamicObject entryEntity : entryEntitys) {
            for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                long policygoalid = entryEntity.getLong("policygoal.id");
                Long policygoal = pretRelationEntityModel.getPolicygoal();
                Long customerChanel = entryEntity.getLong("customerchanelid.id");
                Long customerChanelId = pretRelationEntityModel.getCustomerChanelId();
                Long material = entryEntity.getLong("material.id");
                Long materialId = pretRelationEntityModel.getMaterial();
                String contractNo = pretRelationEntityModel.getContractNo();
                String contractno = entryEntity.getString("contractno");
                if (materialId == null || policygoal == null || contractNo == null || !customerChanelId.equals(customerChanel) || !materialId.equals(material) || !policygoal.equals(policygoalid) || !contractNo.equals(contractno)) continue;
                pretRelationEntityModel.setId(id);
                pretRelationEntityModel.setEntryId((Long)entryEntity.getPkValue());
                pretRelationEntityModel.setAtaMax(entryEntity.getDate("atamax"));
                pretRelationEntityModel.setPodMax(entryEntity.getDate("podmax"));
                pretRelationEntityModel.setOrderNumSum(entryEntity.getBigDecimal("ordernumsum"));
                pretRelationEntityModel.setSignNumSum(entryEntity.getBigDecimal("signnumsum"));
                pretRelationEntityModel.setDeliveryAmount(entryEntity.getBigDecimal("deliveryamount"));
                pretRelationEntityModel.setMaxAmount(entryEntity.getBigDecimal("maxamount"));
                pretRelationEntityModel.setMaxPercent(entryEntity.getBigDecimal("percentmax"));
                pretRelationEntityModel.setRebateAmount(entryEntity.getBigDecimal("rebateamount"));
                pretRelationEntityModel.setUpdateTime(entryEntity.getDate("updatetime"));
            }
        }
    }

    public List<DynamicObject> saveByModel(List<PreRelationSDModel> preRelationSDModels, DynamicObject[] oldPreRelations) {
        ArrayList<DynamicObject> preRelations = new ArrayList<DynamicObject>();
        for (PreRelationSDModel preRelationSDModel : preRelationSDModels) {
            Date targetDndTime;
            Date targetStartTime;
            Long signCustomerChannel;
            List pretRelationEntityModels = preRelationSDModel.getPretRelationEntityModels();
            if (CollectionUtils.isEmpty((Collection)pretRelationEntityModels)) continue;
            if (preRelationSDModel.getId() == null) {
                DynamicObject preRelation = BusinessDataServiceHelper.newDynamicObject((String)"occpibc_pretrelation");
                this.setHeader(preRelation, preRelationSDModel);
                DynamicObjectCollection entry = preRelation.getDynamicObjectCollection("entryentity");
                for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                    DynamicObject entryObject = entry.addNew();
                    this.setEntry(pretRelationEntityModel, entryObject);
                }
                preRelations.add(preRelation);
                continue;
            }
            Long policy = preRelationSDModel.getRebatePolicy();
            DynamicObject oldPreRelation = PretRelationTabStandardHandle.getDynamicObjectById(oldPreRelations, policy, signCustomerChannel = preRelationSDModel.getSignCustomerChannel(), targetStartTime = preRelationSDModel.getTargetStartTime(), targetDndTime = preRelationSDModel.getTargetDndTime());
            if (oldPreRelation == null) continue;
            this.setHeader(oldPreRelation, preRelationSDModel);
            DynamicObjectCollection entrys = oldPreRelation.getDynamicObjectCollection("entryentity");
            boolean isFixAmount = RebateTypeEnum.fixedamount.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType());
            BigDecimal sumQty = BigDecimal.ZERO;
            BigDecimal sumAmount = BigDecimal.ZERO;
            List linkedIdList = pretRelationEntityModels.stream().map(PreRelationEntitySDModel::getEntryId).collect(Collectors.toList());
            for (DynamicObject entry : entrys) {
                if (linkedIdList.contains(DynamicObjectUtils.getPkValue((DynamicObject)entry))) continue;
                sumQty = sumQty.add(entry.getBigDecimal("signnumsum"));
                if (isFixAmount) {
                    sumAmount = sumAmount.add(BigDecimal.ZERO.compareTo(entry.getBigDecimal("deliveryamount")) > 0 ? BigDecimal.ZERO : entry.getBigDecimal("deliveryamount"));
                    continue;
                }
                sumAmount = sumAmount.add(entry.getBigDecimal("deliveryamount"));
            }
            sumQty = sumQty.add(preRelationSDModel.getTotalQty());
            sumAmount = sumAmount.add(preRelationSDModel.getTotalAmount());
            RebateCalcStandardHandle rebateCalcStandardHandle = new RebateCalcStandardHandle();
            rebateCalcStandardHandle.reCalculateTotal(sumQty, sumAmount, preRelationSDModel, pretRelationEntityModels);
            ArrayList<Long> updateEntryIdList = new ArrayList<Long>(4);
            for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                if (pretRelationEntityModel.getEntryId() != null) {
                    for (DynamicObject entry : entrys) {
                        if (!entry.getPkValue().equals(pretRelationEntityModel.getEntryId())) continue;
                        this.setEntry(pretRelationEntityModel, entry);
                        updateEntryIdList.add(pretRelationEntityModel.getEntryId());
                    }
                    continue;
                }
                DynamicObject entryObject = entrys.addNew();
                this.setEntry(pretRelationEntityModel, entryObject);
            }
            for (DynamicObject entry : entrys) {
                if (updateEntryIdList.contains(DynamicObjectUtils.getPkValue((DynamicObject)entry))) continue;
                this.getReCalculateRebateAmount(preRelationSDModel, entry);
                entry.set("updatetime", (Object)new Date());
            }
            preRelations.add(oldPreRelation);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])preRelations.stream().toArray(DynamicObject[]::new)));
        return preRelations;
    }

    private void getReCalculateRebateAmount(PreRelationSDModel preRelationSDModel, DynamicObject entry) {
        if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.MBO.getTypeId()) {
            BigDecimal highestPercent = preRelationSDModel.getHighEstPercent();
            entry.set("percentmax", (Object)highestPercent);
            BigDecimal rebateAmount = entry.getBigDecimal("deliveryamount").multiply(highestPercent).divide(new BigDecimal("100"));
            entry.set("rebateamount", (Object)rebateAmount);
        } else if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.UNCONDITION.getTypeId()) {
            if (RebateTypeEnum.amount.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType())) {
                BigDecimal totalRebateAmount = preRelationSDModel.getRebackAmount().multiply(entry.getBigDecimal("signnumsum"));
                entry.set("maxamount", (Object)preRelationSDModel.getRebackAmount());
                entry.set("rebateamount", (Object)totalRebateAmount);
            } else if (RebateTypeEnum.percentage.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType())) {
                BigDecimal totalRebateAmount = preRelationSDModel.getRebackPercent().multiply(entry.getBigDecimal("deliveryamount")).divide(new BigDecimal("100"));
                entry.set("percentmax", (Object)preRelationSDModel.getRebackPercent());
                entry.set("rebateamount", (Object)totalRebateAmount);
            } else if (RebateTypeEnum.fixedamount.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType())) {
                // empty if block
            }
        } else if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.NORMAL.getTypeId()) {
            if (TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(preRelationSDModel.getTargetCalTypeId()) && RebateTypeEnum.amount.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType())) {
                BigDecimal totalRebateAmount = preRelationSDModel.getRebackAmount().multiply(entry.getBigDecimal("signnumsum"));
                entry.set("maxamount", (Object)preRelationSDModel.getRebackAmount());
                entry.set("rebateamount", (Object)totalRebateAmount);
            } else if (TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(preRelationSDModel.getTargetCalTypeId()) && RebateTypeEnum.percentage.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType()) || TargetCalTypeEnum.AMOUNT.getValue().equalsIgnoreCase(preRelationSDModel.getTargetCalTypeId()) && RebateTypeEnum.percentage.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType())) {
                BigDecimal totalRebateAmount = preRelationSDModel.getRebackPercent().multiply(entry.getBigDecimal("deliveryamount")).divide(new BigDecimal("100"));
                entry.set("percentmax", (Object)preRelationSDModel.getRebackPercent());
                entry.set("rebateamount", (Object)totalRebateAmount);
            }
        } else if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.ACHIEVEMENT.getTypeId()) {
            if (RebateTypeEnum.amount.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType()) && TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType())) {
                BigDecimal totalRebateAmount = preRelationSDModel.getRebackAmount().multiply(entry.getBigDecimal("signnumsum")).multiply(preRelationSDModel.getBaseRate());
                entry.set("maxamount", (Object)preRelationSDModel.getRebackAmount());
                entry.set("rebateamount", (Object)totalRebateAmount);
            } else if (RebateTypeEnum.percentage.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType())) {
                entry.set("percentmax", (Object)preRelationSDModel.getRebackPercent());
                BigDecimal totalRebateAmount = preRelationSDModel.getRebackPercent().multiply(entry.getBigDecimal("deliveryamount")).divide(new BigDecimal("100")).multiply(preRelationSDModel.getBaseRate());
                entry.set("rebateamount", (Object)totalRebateAmount);
            }
        }
    }

    public static final DynamicObject getDynamicObjectById(DynamicObject[] oldPreRelations, Long id, Long signCustomerChannel, Date targetStartTime, Date targetDndTime) {
        for (DynamicObject oldPreRelation : oldPreRelations) {
            Long policyId = oldPreRelation.getLong("rebatepolicy.id");
            Long signcustomerChl = oldPreRelation.getLong("signcustomerchannel.id");
            Date rpbegindate = oldPreRelation.getDate("rpbegindate");
            Date rpenddate = oldPreRelation.getDate("rpenddate");
            if (!id.equals(policyId) || !signCustomerChannel.equals(signcustomerChl) || targetStartTime.compareTo(rpbegindate) != 0 || targetDndTime.compareTo(rpenddate) != 0) continue;
            return oldPreRelation;
        }
        return null;
    }

    private void setHeader(DynamicObject preRelation, PreRelationSDModel preRelationSDModel) {
        preRelation.set("rebatepolicy", (Object)preRelationSDModel.getRebatePolicy());
        preRelation.set("country", (Object)preRelationSDModel.getCountry());
        preRelation.set("areadept", (Object)preRelationSDModel.getAreaDept());
        preRelation.set("rptoffice", (Object)preRelationSDModel.getRptOffice());
        preRelation.set("signcustomerchannel", (Object)preRelationSDModel.getSignCustomerChannel());
        preRelation.set("signcustomerbg", (Object)preRelationSDModel.getSignCustomerBG());
        preRelation.set("bchannelfirstclass", (Object)preRelationSDModel.getbChannelFirstClass());
        preRelation.set("bchannelsecclass", (Object)preRelationSDModel.getbChannelSecClass());
        preRelation.set("childtype", (Object)preRelationSDModel.getChildType());
        preRelation.set("inspiretype", (Object)preRelationSDModel.getInspireType());
        preRelation.set("targetcaltype", (Object)preRelationSDModel.getTargetCalTypeId());
        preRelation.set("settperiod", (Object)preRelationSDModel.getSettPeriod());
        preRelation.set("currency", (Object)preRelationSDModel.getCurrency());
        preRelation.set("rpcontractsubject", (Object)preRelationSDModel.getRpContractSubject());
        preRelation.set("rpbegindate", (Object)preRelationSDModel.getTargetStartTime());
        preRelation.set("rpenddate", (Object)preRelationSDModel.getTargetDndTime());
        preRelation.set("modifytime", (Object)new Date());
        List salesAttrs = preRelationSDModel.getSalesattrs();
        if (!CollectionUtils.isEmpty((Collection)salesAttrs)) {
            DynamicObjectUtils.setMultiF7Value((DynamicObject)preRelation, (String)"salesattrs", (String)"ocdbd_item_saleattr", (Object[])salesAttrs.toArray());
        }
    }

    private void setEntry(PreRelationEntitySDModel pretRelationEntityModel, DynamicObject entryObject) {
        entryObject.set("policygoal", (Object)pretRelationEntityModel.getPolicygoal());
        entryObject.set("customerchanelid", (Object)pretRelationEntityModel.getCustomerChanelId());
        entryObject.set("customerbg", (Object)pretRelationEntityModel.getCustomerBgId());
        entryObject.set("material", (Object)pretRelationEntityModel.getMaterial());
        entryObject.set("iteminfo", (Object)pretRelationEntityModel.getIteminfo());
        entryObject.set("contractno", (Object)pretRelationEntityModel.getContractNo());
        entryObject.set("podmax", (Object)pretRelationEntityModel.getPodMax());
        entryObject.set("atamax", (Object)pretRelationEntityModel.getAtaMax());
        entryObject.set("ordernumsum", (Object)pretRelationEntityModel.getOrderNumSum());
        entryObject.set("signnumsum", (Object)pretRelationEntityModel.getSignNumSum());
        entryObject.set("deliveryamount", (Object)pretRelationEntityModel.getDeliveryAmount());
        entryObject.set("maxamount", (Object)pretRelationEntityModel.getMaxAmount());
        entryObject.set("percentmax", (Object)pretRelationEntityModel.getMaxPercent());
        entryObject.set("rebateamount", (Object)pretRelationEntityModel.getRebateAmount());
        entryObject.set("fixedamount", (Object)pretRelationEntityModel.getFixedAmount());
        entryObject.set("unit", (Object)pretRelationEntityModel.getUnit());
        entryObject.set("updatetime", (Object)new Date());
    }
}

