/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.occpibc.business.handle.MaterialStandardHandle;
import kd.occ.occpibc.business.handle.PretCorresStandardHandle;
import kd.occ.occpibc.common.model.sd.BenefitCustomerQueryParamSDModel;
import kd.occ.occpibc.common.model.sd.PreRelationEntitySDModel;
import kd.occ.occpibc.common.model.sd.PreRelationQueryParamSDModel;
import kd.occ.occpibc.common.model.sd.PreRelationSDModel;

public class RebateBaseTabSearchStandardHandle {
    private static final String REBATE_BASE_DATA_SELECT_FIELDS = "id,country,region,repoffice,channel,customer,linetype,currency,signentity,contractno,productno,price,orderqty,signqty,unit,qtytype,ata,pod,deliveryamount,createtime,enable,operator,unit.id,material";
    private static final PretCorresStandardHandle pretCorresHandle = new PretCorresStandardHandle();

    public DynamicObjectCollection queryRebateBaseData(List<PreRelationQueryParamSDModel> PreRelationQueryParamSDModels, List<PreRelationSDModel> preRelations) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        for (PreRelationQueryParamSDModel param : PreRelationQueryParamSDModels) {
            BenefitCustomerQueryParamSDModel benefitCustomer = param.getBenefitCustomer();
            QFilter qf = this.getqFilter(param, benefitCustomer);
            DynamicObjectCollection rebateBaseDatas = QueryServiceHelper.query((String)"occpibc_rebatebasetab", (String)REBATE_BASE_DATA_SELECT_FIELDS, (QFilter[])qf.toArray());
            this.fuseData(param, rebateBaseDatas, preRelations);
            result.addAll((Collection)rebateBaseDatas);
        }
        return result;
    }

    private QFilter getqFilter(PreRelationQueryParamSDModel param, BenefitCustomerQueryParamSDModel benefitCustomer) {
        QFilter qf = new QFilter("country", "=", (Object)param.getCountry());
        Long policyGoal = param.getPolicyGoalId();
        Long maxRowId = pretCorresHandle.getMaxRowId(policyGoal);
        if (maxRowId > 0L) {
            qf.and("id", ">", (Object)maxRowId);
        }
        qf.and("region", "=", (Object)param.getRegion());
        qf.and("repoffice", "=", (Object)param.getRepOffice());
        qf.and("channel", "=", (Object)benefitCustomer.getBenefitChannelId());
        qf.and("customer", "=", (Object)benefitCustomer.getBenefitCustomer());
        List productModelIds = param.getProductModels();
        Set materialIdSet = param.getMaterialIdSet();
        materialIdSet.addAll(MaterialStandardHandle.getMaterials(productModelIds));
        qf.and("material", "in", (Object)materialIdSet);
        qf.and("qtytype", "=", (Object)param.getChildType());
        qf.and("linetype", "in", (Object)param.getPackageOrder());
        qf.and("currency", "=", (Object)param.getPolicyCurrency());
        qf.and("signentity", "=", (Object)param.getContractSubject());
        if (param.getCountry() != null && param.getCountryNumber().equals("CN")) {
            qf.and("pod", ">=", (Object)param.getDateStart());
            qf.and("pod", "<=", (Object)param.getDateEnd());
        } else {
            qf.and("ata", ">=", (Object)param.getDateStart());
            qf.and("ata", "<=", (Object)param.getDateEnd());
        }
        qf.and("enable", "=", (Object)"1");
        return qf;
    }

    private void fuseData(PreRelationQueryParamSDModel param, DynamicObjectCollection rebateBaseDatas, List<PreRelationSDModel> preRelations) {
        BenefitCustomerQueryParamSDModel benefitCustomer = param.getBenefitCustomer();
        Long benefitChannelId = benefitCustomer.getBenefitChannelId();
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            Long material = rebateBaseData.getLong("material");
            List<PreRelationSDModel> preRelationByPolicyGoals = this.getPreRelationByParam(param, preRelations);
            if (CollectionUtils.isEmpty(preRelationByPolicyGoals)) continue;
            for (PreRelationSDModel preRelationByPolicyGoal : preRelationByPolicyGoals) {
                List pretRelationEntityModels = preRelationByPolicyGoal.getPretRelationEntityModels();
                for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                    if (!benefitChannelId.equals(pretRelationEntityModel.getCustomerChanelId()) || !material.equals(pretRelationEntityModel.getMaterial())) continue;
                    pretRelationEntityModel.getRebateBaseDatas().add(rebateBaseData);
                }
            }
        }
    }

    private List<PreRelationSDModel> getPreRelationByParam(PreRelationQueryParamSDModel param, List<PreRelationSDModel> preRelations) {
        ArrayList<PreRelationSDModel> result = new ArrayList<PreRelationSDModel>();
        Long policy = param.getPolicy();
        Long signCustomerChannel = param.getSignCustomerChannel();
        Date dateEnd = param.getDateEnd();
        Date dateStart = param.getDateStart();
        for (PreRelationSDModel preRelation : preRelations) {
            Long rebatePolicy = preRelation.getRebatePolicy();
            Long signCustomer = preRelation.getSignCustomerChannel();
            Date targetStartTime = preRelation.getTargetStartTime();
            Date targetDndTime = preRelation.getTargetDndTime();
            if (rebatePolicy == null || !rebatePolicy.equals(policy) || signCustomer == null || !signCustomer.equals(signCustomerChannel) || targetStartTime == null || targetStartTime.compareTo(dateStart) != 0 || targetDndTime == null || targetDndTime.compareTo(dateEnd) != 0) continue;
            result.add(preRelation);
        }
        return result;
    }

    public void splitByPo(List<PreRelationSDModel> preRelations) {
        for (PreRelationSDModel preRelation : preRelations) {
            List pretRelationEntityModels = preRelation.getPretRelationEntityModels();
            ArrayList<PreRelationEntitySDModel> tempList = new ArrayList<PreRelationEntitySDModel>();
            for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                List rebateBaseDatas = pretRelationEntityModel.getRebateBaseDatas();
                if (CollectionUtils.isEmpty((Collection)rebateBaseDatas)) continue;
                Map<String, List<DynamicObject>> map = this.groupByContractNo(rebateBaseDatas);
                List<PreRelationEntitySDModel> entryModels = this.createEntryModel(map, pretRelationEntityModel);
                tempList.addAll(entryModels);
            }
            pretRelationEntityModels.addAll(tempList);
        }
    }

    private List<PreRelationEntitySDModel> createEntryModel(Map<String, List<DynamicObject>> rebateBaseDataMap, PreRelationEntitySDModel pretRelationEntityModel) {
        ArrayList<PreRelationEntitySDModel> list = new ArrayList<PreRelationEntitySDModel>();
        ArrayList<String> listKey = new ArrayList<String>(rebateBaseDataMap.keySet());
        for (int i = 0; i < listKey.size(); ++i) {
            if (i == 0) {
                pretRelationEntityModel.setRebateBaseDatas(rebateBaseDataMap.get(listKey.get(i)));
                pretRelationEntityModel.setContractNo((String)listKey.get(i));
                continue;
            }
            try {
                PreRelationEntitySDModel model = pretRelationEntityModel.clone();
                model.setContractNo((String)listKey.get(i));
                model.setRebateBaseDatas(rebateBaseDataMap.get(listKey.get(i)));
                list.add(model);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return list;
    }

    private Map<String, List<DynamicObject>> groupByContractNo(List<DynamicObject> rebateBaseDatas) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            String contractno = rebateBaseData.getString("contractno");
            if (map.get(contractno) == null) {
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(rebateBaseData);
                map.put(contractno, list);
                continue;
            }
            List dynamicObjects = (List)map.get(contractno);
            dynamicObjects.add(rebateBaseData);
        }
        return map;
    }
}

