/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.occpibc.common.model.PreRelationEntityModel;
import kd.occ.occpibc.common.model.PreRelationModel;

public class RebateCalcHandle {
    public void rebateAutomatic(List<PreRelationModel> preRelationModels) {
        if (CollectionUtils.isEmpty(preRelationModels)) {
            return;
        }
        for (PreRelationModel preRelationModel : preRelationModels) {
            List pretRelationEntityModels = preRelationModel.getPretRelationEntityModels();
            for (PreRelationEntityModel pretRelationEntityModel : pretRelationEntityModels) {
                List rebateBaseDatas = pretRelationEntityModel.getRebateBaseDatas();
                if (CollectionUtils.isEmpty((Collection)rebateBaseDatas)) continue;
                this.setEntryModel(pretRelationEntityModel, rebateBaseDatas, preRelationModel);
            }
        }
    }

    private void setEntryModel(PreRelationEntityModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas, PreRelationModel preRelationModel) {
        List rebateAmounts = preRelationModel.getRebateAmounts();
        List rebatePercents = preRelationModel.getRebatePercents();
        pretRelationEntityModel.setContractNo(rebateBaseDatas.get(0).getString("contractno"));
        pretRelationEntityModel.setProductNumberId(Long.valueOf(rebateBaseDatas.get(0).getLong("productno")));
        pretRelationEntityModel.setUnit(Long.valueOf(rebateBaseDatas.get(0).getLong("unit")));
        Date ata = this.getMaxAta(rebateBaseDatas);
        Date ataMax = pretRelationEntityModel.getAtaMax();
        if (ataMax == null || ataMax.compareTo(ata) < 0) {
            pretRelationEntityModel.setAtaMax(ata);
        }
        Date pod = this.getMaxPod(rebateBaseDatas);
        Date podMax = pretRelationEntityModel.getPodMax();
        if (podMax == null || podMax.compareTo(pod) < 0) {
            pretRelationEntityModel.setPodMax(pod);
        }
        BigDecimal orderNumSum = this.sumOrderNum(pretRelationEntityModel, rebateBaseDatas);
        pretRelationEntityModel.setOrderNumSum(orderNumSum);
        BigDecimal sumSignNum = this.sumSignNum(pretRelationEntityModel, rebateBaseDatas);
        pretRelationEntityModel.setSignNumSum(sumSignNum);
        BigDecimal deliveryAmountSum = this.deliveryAmountSum(pretRelationEntityModel, rebateBaseDatas);
        pretRelationEntityModel.setDeliveryAmount(deliveryAmountSum);
        BigDecimal maxAmount = this.getMaxAmount(rebateAmounts);
        pretRelationEntityModel.setMaxAmount(maxAmount);
        BigDecimal maxPercents = this.getMaxPercents(rebatePercents);
        if ("laddertype5".equals(preRelationModel.getLadderType())) {
            maxPercents = this.nullToZero(preRelationModel.getHighEstPercent());
        }
        pretRelationEntityModel.setMaxPercent(maxPercents);
        String rebateType = preRelationModel.getRebateType();
        BigDecimal rebateAmount = this.calcRebate(rebateType, maxAmount, maxPercents, sumSignNum, deliveryAmountSum);
        pretRelationEntityModel.setRebateAmount(rebateAmount);
    }

    private BigDecimal calcRebate(String rebateType, BigDecimal maxAmount, BigDecimal maxPercents, BigDecimal sumSignNum, BigDecimal deliveryAmountSum) {
        BigDecimal rebateMoney = BigDecimal.ZERO;
        if ("A".equals(rebateType)) {
            rebateMoney = deliveryAmountSum.multiply(maxPercents.divide(new BigDecimal("100.00")));
        } else if ("B".equals(rebateType)) {
            rebateMoney = maxAmount.multiply(sumSignNum);
        }
        return rebateMoney;
    }

    private BigDecimal nullToZero(BigDecimal num) {
        if (num == null) {
            return BigDecimal.ZERO;
        }
        return num;
    }

    private BigDecimal deliveryAmountSum(PreRelationEntityModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas) {
        BigDecimal deliveryAmount = this.nullToZero(pretRelationEntityModel.getDeliveryAmount());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            BigDecimal delivery = this.nullToZero(rebateBaseData.getBigDecimal("deliveryamount"));
            deliveryAmount = deliveryAmount.add(delivery);
        }
        return deliveryAmount;
    }

    private BigDecimal sumOrderNum(PreRelationEntityModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas) {
        BigDecimal orderNumSum = this.nullToZero(pretRelationEntityModel.getOrderNumSum());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            BigDecimal orderqty = this.nullToZero(rebateBaseData.getBigDecimal("orderqty"));
            orderNumSum = orderNumSum.add(orderqty);
        }
        return orderNumSum;
    }

    private BigDecimal sumSignNum(PreRelationEntityModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas) {
        BigDecimal signNumSum = this.nullToZero(pretRelationEntityModel.getSignNumSum());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            BigDecimal signQty = this.nullToZero(rebateBaseData.getBigDecimal("signqty"));
            signNumSum = signNumSum.add(signQty);
        }
        return signNumSum;
    }

    private BigDecimal getMaxAmount(List<BigDecimal> rebateAmounts) {
        if (CollectionUtils.isEmpty(rebateAmounts)) {
            return BigDecimal.ZERO;
        }
        BigDecimal maxAmount = Collections.max(rebateAmounts, new Comparator<BigDecimal>(){

            @Override
            public int compare(BigDecimal o1, BigDecimal o2) {
                return o1.compareTo(o2);
            }
        });
        return maxAmount;
    }

    private BigDecimal getMaxPercents(List<BigDecimal> rebatePercents) {
        if (CollectionUtils.isEmpty(rebatePercents)) {
            return BigDecimal.ZERO;
        }
        BigDecimal maxPercent = Collections.max(rebatePercents, new Comparator<BigDecimal>(){

            @Override
            public int compare(BigDecimal o1, BigDecimal o2) {
                return o1.compareTo(o2);
            }
        });
        return maxPercent;
    }

    private Date getMaxAta(List<DynamicObject> rebateBaseDatas) {
        ArrayList<Date> ataDates = new ArrayList<Date>(rebateBaseDatas.size());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            ataDates.add(rebateBaseData.getDate("ata"));
        }
        if (CollectionUtils.isEmpty(ataDates)) {
            return null;
        }
        Date date = Collections.max(ataDates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        return date;
    }

    private Date getMaxPod(List<DynamicObject> rebateBaseDatas) {
        ArrayList<Date> podDates = new ArrayList<Date>(rebateBaseDatas.size());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            podDates.add(rebateBaseData.getDate("pod"));
        }
        if (CollectionUtils.isEmpty(podDates)) {
            return null;
        }
        Date date = Collections.max(podDates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        return date;
    }
}

