/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.handle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.enums.LadderTypeEnums;
import kd.occ.ocbase.common.enums.RebateTypeEnum;
import kd.occ.ocbase.common.enums.TargetCalTypeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occpibc.business.handle.PretRelationTabStandardHandle;
import kd.occ.occpibc.common.model.sd.PreRelationEntitySDModel;
import kd.occ.occpibc.common.model.sd.PreRelationSDModel;
import kd.occ.occpibc.common.model.sd.RebateFormula;

public class RebateCalcStandardHandle {
    public void rebateAutomatic(List<PreRelationSDModel> preRelationSDModels, DynamicObject[] oldPreRelations) {
        if (CollectionUtils.isEmpty(preRelationSDModels)) {
            return;
        }
        for (PreRelationSDModel preRelationSDModel : preRelationSDModels) {
            List pretRelationEntityModels = preRelationSDModel.getPretRelationEntityModels();
            for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                List rebateBaseDatas = pretRelationEntityModel.getRebateBaseDatas();
                if (CollectionUtils.isEmpty((Collection)rebateBaseDatas)) continue;
                this.setEntryModel(pretRelationEntityModel, rebateBaseDatas, preRelationSDModel);
            }
            Long policy = preRelationSDModel.getRebatePolicy();
            Long signCustomerChannel = preRelationSDModel.getSignCustomerChannel();
            Date targetStartTime = preRelationSDModel.getTargetStartTime();
            Date targetDndTime = preRelationSDModel.getTargetDndTime();
            DynamicObject oldPreRelation = PretRelationTabStandardHandle.getDynamicObjectById(oldPreRelations, policy, signCustomerChannel, targetStartTime, targetDndTime);
            this.calculateSumAmountAndQty(preRelationSDModel, pretRelationEntityModels, oldPreRelation);
        }
    }

    private void calculateSumAmountAndQty(PreRelationSDModel preRelationSDModel, List<PreRelationEntitySDModel> pretRelationEntityModels, DynamicObject oldPreRelation) {
        if (CollectionUtils.isEmpty(pretRelationEntityModels)) {
            return;
        }
        boolean isFixAmount = RebateTypeEnum.fixedamount.getValue().equalsIgnoreCase(preRelationSDModel.getRebateType());
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumQty = BigDecimal.ZERO;
        for (PreRelationEntitySDModel entry : pretRelationEntityModels) {
            sumAmount = isFixAmount ? sumAmount.add(BigDecimal.ZERO.compareTo(entry.getDeliveryAmount()) > 0 ? BigDecimal.ZERO : entry.getDeliveryAmount()) : entry.getDeliveryAmount().add(sumAmount);
            sumQty = entry.getSignNumSum().add(sumQty);
        }
        preRelationSDModel.setTotalAmount(sumAmount);
        preRelationSDModel.setTotalQty(sumQty);
        if (oldPreRelation != null) {
            List linkedIdList = pretRelationEntityModels.stream().map(PreRelationEntitySDModel::getEntryId).collect(Collectors.toList());
            for (DynamicObject entry : oldPreRelation.getDynamicObjectCollection("entryentity")) {
                if (linkedIdList.contains(DynamicObjectUtils.getPkValue((DynamicObject)entry))) continue;
                sumQty = sumQty.add(entry.getBigDecimal("signnumsum"));
                if (isFixAmount) {
                    sumAmount = sumAmount.add(BigDecimal.ZERO.compareTo(entry.getBigDecimal("deliveryamount")) > 0 ? BigDecimal.ZERO : entry.getBigDecimal("deliveryamount"));
                    continue;
                }
                sumAmount = sumAmount.add(entry.getBigDecimal("deliveryamount"));
            }
        }
        this.reCalculateTotal(sumQty, sumAmount, preRelationSDModel, pretRelationEntityModels);
    }

    public void reCalculateTotal(BigDecimal sumQty, BigDecimal sumAmount, PreRelationSDModel preRelationSDModel, List<PreRelationEntitySDModel> pretRelationEntityModels) {
        if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.MBO.getTypeId()) {
            for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                this.calculateForMbo(preRelationSDModel, pretRelationEntityModel, pretRelationEntityModel.getDeliveryAmount());
            }
        } else if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.UNCONDITION.getTypeId()) {
            for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                this.calculateForUncondition(preRelationSDModel, pretRelationEntityModel, pretRelationEntityModel.getSignNumSum(), pretRelationEntityModel.getDeliveryAmount());
            }
        } else if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.NORMAL.getTypeId()) {
            this.calculateForNormal(preRelationSDModel, pretRelationEntityModels, sumQty, sumAmount);
        } else if (preRelationSDModel.getLadderTypeId() == LadderTypeEnums.ACHIEVEMENT.getTypeId()) {
            this.calculateForAchievement(preRelationSDModel, pretRelationEntityModels, sumQty, sumAmount);
        }
    }

    private void setEntryModel(PreRelationEntitySDModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas, PreRelationSDModel preRelationSDModel) {
        pretRelationEntityModel.setContractNo(rebateBaseDatas.get(0).getString("contractno"));
        pretRelationEntityModel.setMaterial(Long.valueOf(rebateBaseDatas.get(0).getLong("material")));
        pretRelationEntityModel.setUnit(Long.valueOf(rebateBaseDatas.get(0).getLong("unit")));
        Date ata = this.getMaxAta(rebateBaseDatas);
        Date ataMax = pretRelationEntityModel.getAtaMax();
        if (ataMax == null || ataMax.compareTo(ata) < 0) {
            pretRelationEntityModel.setAtaMax(ata);
        }
        Date pod = this.getMaxPod(rebateBaseDatas);
        Date podMax = pretRelationEntityModel.getPodMax();
        if (podMax == null || podMax.compareTo(pod) < 0) {
            pretRelationEntityModel.setPodMax(pod);
        }
        BigDecimal orderNumSum = this.sumOrderNum(pretRelationEntityModel, rebateBaseDatas);
        pretRelationEntityModel.setOrderNumSum(orderNumSum);
        BigDecimal sumSignNum = this.sumSignNum(pretRelationEntityModel, rebateBaseDatas);
        pretRelationEntityModel.setSignNumSum(sumSignNum);
        BigDecimal deliveryAmountSum = this.deliveryAmountSum(pretRelationEntityModel, rebateBaseDatas);
        pretRelationEntityModel.setDeliveryAmount(deliveryAmountSum);
    }

    private void calculateForNormal(PreRelationSDModel preRelationSDModel, List<PreRelationEntitySDModel> pretRelationEntityModels, BigDecimal sumQty, BigDecimal sumAmount) {
        block6: {
            List formulaList;
            String targetcCalType;
            String rebateType;
            block8: {
                block7: {
                    rebateType = preRelationSDModel.getRebateType();
                    targetcCalType = preRelationSDModel.getTargetCalTypeId();
                    formulaList = preRelationSDModel.getFormulaList();
                    if (!TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(targetcCalType) || !RebateTypeEnum.amount.getValue().equalsIgnoreCase(rebateType)) break block7;
                    for (RebateFormula formula : formulaList) {
                        boolean isSatisfied = this.checkNormalCondition(formula.getMinQty(), formula.getMaxQty(), sumQty);
                        if (!isSatisfied) continue;
                        preRelationSDModel.setRebackAmount(formula.getRebateAmount());
                        for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                            this.setTotalRebateAmountByRebackAmount(formula.getRebateAmount(), pretRelationEntityModel.getSignNumSum(), pretRelationEntityModel);
                        }
                        break block6;
                    }
                    break block6;
                }
                if (!TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(targetcCalType) || !RebateTypeEnum.percentage.getValue().equalsIgnoreCase(rebateType)) break block8;
                for (RebateFormula formula : formulaList) {
                    boolean isSatisfied = this.checkNormalCondition(formula.getMinQty(), formula.getMaxQty(), sumQty);
                    if (!isSatisfied) continue;
                    preRelationSDModel.setRebackPercent(formula.getRebatePercent());
                    for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                        this.setTotalRebateAmountByRebackPercentage(formula.getRebatePercent(), pretRelationEntityModel.getDeliveryAmount(), pretRelationEntityModel);
                    }
                    break block6;
                }
                break block6;
            }
            if (!TargetCalTypeEnum.AMOUNT.getValue().equalsIgnoreCase(targetcCalType) || !RebateTypeEnum.percentage.getValue().equalsIgnoreCase(rebateType)) break block6;
            for (RebateFormula formula : formulaList) {
                boolean isSatisfied = this.checkNormalCondition(formula.getMinAmount(), formula.getMaxAmount(), sumAmount);
                if (!isSatisfied) continue;
                preRelationSDModel.setRebackPercent(formula.getRebatePercent());
                for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                    this.setTotalRebateAmountByRebackPercentage(formula.getRebatePercent(), pretRelationEntityModel.getDeliveryAmount(), pretRelationEntityModel);
                }
                break;
            }
        }
    }

    private void setTotalRebateAmountByRebackAmount(BigDecimal rebateAmount, BigDecimal qty, PreRelationEntitySDModel pretRelationEntityModel) {
        BigDecimal totalRebateAmount = rebateAmount.multiply(qty);
        pretRelationEntityModel.setMaxAmount(rebateAmount);
        pretRelationEntityModel.setRebateAmount(totalRebateAmount);
    }

    private void setTotalRebateAmountByRebackPercentage(BigDecimal rebatePercent, BigDecimal amount, PreRelationEntitySDModel pretRelationEntityModel) {
        BigDecimal totalRebateAmount = rebatePercent.multiply(amount).divide(new BigDecimal("100"));
        pretRelationEntityModel.setMaxPercent(rebatePercent);
        pretRelationEntityModel.setRebateAmount(totalRebateAmount);
    }

    private boolean checkNormalCondition(BigDecimal minDecimal, BigDecimal maxDecimal, BigDecimal compareDecimal) {
        return minDecimal.compareTo(compareDecimal) <= 0 && (maxDecimal.compareTo(BigDecimal.ZERO) == 0 || maxDecimal.compareTo(compareDecimal) > 0);
    }

    private void calculateForUncondition(PreRelationSDModel preRelationSDModel, PreRelationEntitySDModel pretRelationEntityModel, BigDecimal sumQty, BigDecimal sumAmount) {
        String rebateType = preRelationSDModel.getRebateType();
        List formulaList = preRelationSDModel.getFormulaList();
        if (!CollectionUtils.isEmpty((Collection)formulaList)) {
            if (RebateTypeEnum.amount.getValue().equalsIgnoreCase(rebateType)) {
                BigDecimal rebackAmount = ((RebateFormula)formulaList.get(0)).getRebateAmount();
                preRelationSDModel.setRebackAmount(rebackAmount);
                BigDecimal totalRebateAmount = rebackAmount.multiply(sumQty);
                pretRelationEntityModel.setMaxAmount(rebackAmount);
                pretRelationEntityModel.setRebateAmount(totalRebateAmount);
            } else if (RebateTypeEnum.percentage.getValue().equalsIgnoreCase(rebateType)) {
                BigDecimal rebatePercent = ((RebateFormula)formulaList.get(0)).getRebatePercent();
                preRelationSDModel.setRebackPercent(rebatePercent);
                BigDecimal totalRebateAmount = rebatePercent.multiply(sumAmount).divide(new BigDecimal("100"));
                pretRelationEntityModel.setMaxPercent(rebatePercent);
                pretRelationEntityModel.setRebateAmount(totalRebateAmount);
            } else if (RebateTypeEnum.fixedamount.getValue().equalsIgnoreCase(rebateType)) {
                BigDecimal fixedAmount = ((RebateFormula)formulaList.get(0)).getFixedAmount();
                BigDecimal amount = pretRelationEntityModel.getDeliveryAmount();
                BigDecimal rebateAmount = BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(sumAmount) != 0 && BigDecimal.ZERO.compareTo(amount) < 0) {
                    rebateAmount = fixedAmount.multiply(amount).divide(sumAmount, 10, RoundingMode.HALF_UP);
                }
                pretRelationEntityModel.setFixedAmount(fixedAmount);
                pretRelationEntityModel.setRebateAmount(rebateAmount);
            }
        }
    }

    private void calculateForMbo(PreRelationSDModel preRelationSDModel, PreRelationEntitySDModel pretRelationEntityModel, BigDecimal sumAmount) {
        BigDecimal highestPercent = preRelationSDModel.getHighEstPercent();
        pretRelationEntityModel.setMaxPercent(highestPercent);
        BigDecimal rebateAmount = sumAmount.multiply(highestPercent).divide(new BigDecimal("100"));
        pretRelationEntityModel.setRebateAmount(rebateAmount);
    }

    private void calculateForAchievement(PreRelationSDModel preRelationSDModel, List<PreRelationEntitySDModel> pretRelationEntityModels, BigDecimal sumQty, BigDecimal sumAmount) {
        List formulaList = preRelationSDModel.getFormulaList();
        String targetcCalType = preRelationSDModel.getTargetCalTypeId();
        String rebateType = preRelationSDModel.getRebateType();
        BigDecimal rate = this.getAchievementBaseRate(targetcCalType, sumQty, sumAmount, preRelationSDModel);
        preRelationSDModel.setBaseRate(rate);
        for (RebateFormula formula : formulaList) {
            if (!this.checkAchievementEntry(formula, rate)) continue;
            if (RebateTypeEnum.amount.getValue().equalsIgnoreCase(rebateType) && TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(targetcCalType)) {
                preRelationSDModel.setRebackAmount(formula.getRebateAmount());
                for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                    this.setAchievementByQty(formula.getRebateAmount(), pretRelationEntityModel.getSignNumSum(), rate, pretRelationEntityModel);
                }
            } else {
                if (!RebateTypeEnum.percentage.getValue().equalsIgnoreCase(rebateType)) continue;
                preRelationSDModel.setRebackPercent(formula.getRebatePercent());
                for (PreRelationEntitySDModel pretRelationEntityModel : pretRelationEntityModels) {
                    this.setAchievementByPercentage(formula.getRebatePercent(), pretRelationEntityModel.getDeliveryAmount(), rate, pretRelationEntityModel);
                }
            }
            break;
        }
    }

    private void setAchievementByPercentage(BigDecimal rebatePercent, BigDecimal amount, BigDecimal rate, PreRelationEntitySDModel pretRelationEntityModel) {
        pretRelationEntityModel.setMaxPercent(rebatePercent);
        BigDecimal totalRebateAmount = rebatePercent.multiply(amount).divide(new BigDecimal("100")).multiply(rate);
        pretRelationEntityModel.setRebateAmount(totalRebateAmount);
    }

    private void setAchievementByQty(BigDecimal rebateAmount, BigDecimal qty, BigDecimal rate, PreRelationEntitySDModel pretRelationEntityModel) {
        BigDecimal totalRebateAmount = rebateAmount.multiply(qty).multiply(rate);
        pretRelationEntityModel.setRebateAmount(totalRebateAmount);
    }

    private boolean checkAchievementEntry(RebateFormula formula, BigDecimal compareDecimal) {
        if (formula == null || compareDecimal == null) {
            return false;
        }
        BigDecimal compareRate = compareDecimal.multiply(new BigDecimal("100"));
        return formula.getMinAchive().compareTo(compareRate) <= 0 && (formula.getMaxAchive().compareTo(BigDecimal.ZERO) == 0 || formula.getMaxAchive().compareTo(compareRate) > 0);
    }

    private BigDecimal getAchievementBaseRate(String targetcCalType, BigDecimal sumQty, BigDecimal sumAmount, PreRelationSDModel preRelationSDModel) {
        BigDecimal rate = BigDecimal.ZERO;
        if (TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(targetcCalType)) {
            rate = this.getDivideResult(sumQty, preRelationSDModel.getBaselineQty());
        } else if (TargetCalTypeEnum.AMOUNT.getValue().equalsIgnoreCase(targetcCalType)) {
            rate = this.getDivideResult(sumAmount, preRelationSDModel.getBaselineAmount());
        }
        return rate;
    }

    private BigDecimal getDivideResult(BigDecimal divisor, BigDecimal dividend) {
        if (dividend.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return divisor.divide(dividend, 10, RoundingMode.HALF_UP);
    }

    private BigDecimal nullToZero(BigDecimal num) {
        if (num == null) {
            return BigDecimal.ZERO;
        }
        return num;
    }

    private BigDecimal deliveryAmountSum(PreRelationEntitySDModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas) {
        BigDecimal deliveryAmount = this.nullToZero(pretRelationEntityModel.getDeliveryAmount());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            BigDecimal delivery = this.nullToZero(rebateBaseData.getBigDecimal("deliveryamount"));
            deliveryAmount = deliveryAmount.add(delivery);
        }
        return deliveryAmount;
    }

    private BigDecimal sumOrderNum(PreRelationEntitySDModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas) {
        BigDecimal orderNumSum = this.nullToZero(pretRelationEntityModel.getOrderNumSum());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            BigDecimal orderqty = this.nullToZero(rebateBaseData.getBigDecimal("orderqty"));
            orderNumSum = orderNumSum.add(orderqty);
        }
        return orderNumSum;
    }

    private BigDecimal sumSignNum(PreRelationEntitySDModel pretRelationEntityModel, List<DynamicObject> rebateBaseDatas) {
        BigDecimal signNumSum = this.nullToZero(pretRelationEntityModel.getSignNumSum());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            BigDecimal signQty = this.nullToZero(rebateBaseData.getBigDecimal("signqty"));
            signNumSum = signNumSum.add(signQty);
        }
        return signNumSum;
    }

    private Date getMaxAta(List<DynamicObject> rebateBaseDatas) {
        ArrayList<Date> ataDates = new ArrayList<Date>(rebateBaseDatas.size());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            ataDates.add(rebateBaseData.getDate("ata"));
        }
        if (CollectionUtils.isEmpty(ataDates)) {
            return null;
        }
        Date date = Collections.max(ataDates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        return date;
    }

    private Date getMaxPod(List<DynamicObject> rebateBaseDatas) {
        ArrayList<Date> podDates = new ArrayList<Date>(rebateBaseDatas.size());
        for (DynamicObject rebateBaseData : rebateBaseDatas) {
            podDates.add(rebateBaseData.getDate("pod"));
        }
        if (CollectionUtils.isEmpty(podDates)) {
            return null;
        }
        Date date = Collections.max(podDates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        return date;
    }
}

