/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.occpibc.business.handle.PolicyGoalsTabHandle;
import kd.occ.occpibc.business.handle.PretRelationTabHandle;

public class PretRelationPushHelper {
    private static final PretRelationTabHandle pretRelationTabHandle = new PretRelationTabHandle();
    private static final PolicyGoalsTabHandle policyGoalsTabHandle = new PolicyGoalsTabHandle();
    private static final String REBATE_POLICY_SELECT_FIELDS = "kpi.laddertype,rebatetype,formula,settperiod,kpi.targetcaltype,kpi.name,name";

    public boolean push() {
        DynamicObject[] pretRelations = pretRelationTabHandle.getTodayData();
        ArrayList<DynamicObject> saveEntry = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> logEntrys = new ArrayList<DynamicObject>();
        for (DynamicObject pretRelation : pretRelations) {
            Long signCustomerChannel = pretRelation.getLong("signcustomerchannel.id");
            Long rebatePolicy = pretRelation.getLong("rebatepolicy.id");
            Date beginDate = pretRelation.getDate("rpbegindate");
            Date endDate = pretRelation.getDate("rpenddate");
            DynamicObject rebatePolicyEntry = BusinessDataServiceHelper.loadSingle((Object)rebatePolicy, (String)"occpic_rebatepolicy", (String)REBATE_POLICY_SELECT_FIELDS);
            DynamicObject rebatePreData = this.findRebatePreData(signCustomerChannel, rebatePolicy, beginDate, endDate);
            if (rebatePreData == null) {
                DynamicObject rebatePrebudget = BusinessDataServiceHelper.newDynamicObject((String)"occpic_rebateprebudget");
                this.setEntry(rebatePrebudget, pretRelation, rebatePolicyEntry, logEntrys);
                saveEntry.add(rebatePrebudget);
                this.sumEntitys(rebatePrebudget);
                continue;
            }
            boolean isFinish = rebatePreData.getBoolean("isbudgetfinish");
            if (isFinish) continue;
            this.updateEntry(rebatePreData, pretRelation, logEntrys);
            saveEntry.add(rebatePreData);
            this.sumEntitys(rebatePreData);
        }
        this.txSave(saveEntry, logEntrys);
        return true;
    }

    private void sumEntitys(DynamicObject rebatePrebudget) {
        DynamicObjectCollection entryEntitys = rebatePrebudget.getDynamicObjectCollection("entryentity");
        BigDecimal totalproconsignqty = BigDecimal.ZERO;
        BigDecimal totalrebateamount = BigDecimal.ZERO;
        for (DynamicObject entryEntity : entryEntitys) {
            BigDecimal proconsignqty = entryEntity.getBigDecimal("proconsignqty");
            totalproconsignqty = totalproconsignqty.add(proconsignqty);
            BigDecimal rebateamount = entryEntity.getBigDecimal("rebateamount");
            totalrebateamount = totalrebateamount.add(rebateamount);
        }
        rebatePrebudget.set("totalproconsignqty", (Object)totalproconsignqty);
        rebatePrebudget.set("totalrebateamount", (Object)totalrebateamount);
    }

    private void txSave(List<DynamicObject> saveEntry, List<DynamicObject> logEntrys) {
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])saveEntry.toArray(new DynamicObject[saveEntry.size()]));
                SaveServiceHelper.save((DynamicObject[])logEntrys.toArray(new DynamicObject[logEntrys.size()]));
                this.writeBackPolicyGoals(saveEntry);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void writeBackPolicyGoals(List<DynamicObject> saveEntrys) {
        ArrayList<Long> policyGoalIds = new ArrayList<Long>();
        for (DynamicObject saveEntry : saveEntrys) {
            DynamicObjectCollection entryentitys = saveEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                long goalId = entryentity.getLong("repolicytarget.id");
                policyGoalIds.add(goalId);
            }
        }
        if (CollectionUtils.isEmpty(policyGoalIds)) {
            return;
        }
        List<Long> listWithoutDuplicates = policyGoalIds.stream().distinct().collect(Collectors.toList());
        policyGoalsTabHandle.writeBackById(listWithoutDuplicates);
    }

    private void updateEntry(DynamicObject rebatePreData, DynamicObject pretRelation, List<DynamicObject> logEntrys) {
        rebatePreData.set("prebudgetdate", (Object)new Date());
        rebatePreData.set("modifytime", (Object)new Date());
        DynamicObjectCollection pretRelationEntrys = pretRelation.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entryEntitys = rebatePreData.getDynamicObjectCollection("entryentity");
        for (DynamicObject pretRelationEntry : pretRelationEntrys) {
            DynamicObject log;
            DynamicObject sameEntry = this.getSameEntry(entryEntitys, pretRelationEntry);
            if (sameEntry != null) {
                this.updateEntryEntity(sameEntry, pretRelationEntry, pretRelation);
                log = this.addLog(rebatePreData, pretRelationEntry, pretRelation, "B");
                logEntrys.add(log);
                continue;
            }
            this.addEntryEntity(entryEntitys, pretRelationEntry, pretRelation);
            log = this.addLog(rebatePreData, pretRelationEntry, pretRelation, "A");
            logEntrys.add(log);
        }
    }

    private DynamicObject addLog(DynamicObject rebatePreData, DynamicObject pretRelationEntry, DynamicObject pretRelation, String updateType) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"occpibc_pretrelationlog");
        log.set("rebatepolicy", pretRelation.get("rebatepolicy"));
        log.set("policygoal", pretRelationEntry.get("policygoal"));
        log.set("pretrelation", pretRelation.get("id"));
        log.set("pretrelationentry", pretRelationEntry.get("id"));
        log.set("podmax", pretRelationEntry.get("podmax"));
        log.set("atamax", pretRelationEntry.get("atamax"));
        log.set("ordernumsum", pretRelationEntry.get("ordernumsum"));
        log.set("signnumsum", pretRelationEntry.get("signnumsum"));
        log.set("deliveryamount", pretRelationEntry.get("deliveryamount"));
        log.set("maxamount", pretRelationEntry.get("maxamount"));
        log.set("percentmax", pretRelationEntry.get("percentmax"));
        log.set("rebateamount", pretRelationEntry.get("rebateamount"));
        log.set("prebudgetbillno", rebatePreData.get("billno"));
        log.set("updatetype", (Object)updateType);
        log.set("modifytime", pretRelationEntry.get("updatetime"));
        return log;
    }

    private DynamicObject getSameEntry(DynamicObjectCollection entryEntitys, DynamicObject pretRelationEntry) {
        if (CollectionUtils.isEmpty((Collection)entryEntitys)) {
            return null;
        }
        Long policyGoalId = pretRelationEntry.getLong("policygoal.id");
        Long customerChanelId = pretRelationEntry.getLong("customerchanelid.id");
        String contractNo = pretRelationEntry.getString("contractno");
        Long productNumber = pretRelationEntry.getLong("productnumber.id");
        for (DynamicObject entryEntity : entryEntitys) {
            Long repolicytarget = entryEntity.getLong("repolicytarget.id");
            Long product = entryEntity.getLong("product.id");
            String framecontractnumber = entryEntity.getString("framecontractnumber");
            Long benefitcustomer = entryEntity.getLong("benefitcustomer.id");
            if (policyGoalId == null || customerChanelId == null || contractNo == null || productNumber == null || !policyGoalId.equals(repolicytarget) || !customerChanelId.equals(benefitcustomer) || !productNumber.equals(product) || !contractNo.equals(framecontractnumber)) continue;
            return entryEntity;
        }
        return null;
    }

    public void setEntry(DynamicObject rebatePreData, DynamicObject pretRelation, DynamicObject rebatePolicyEntry, List<DynamicObject> logEntrys) {
        this.setEntryProperty(rebatePreData, pretRelation, rebatePolicyEntry);
        this.setEntryBody(rebatePreData, pretRelation, logEntrys);
    }

    public void setEntryProperty(DynamicObject rebatePreData, DynamicObject pretRelation, DynamicObject rebatePolicyEntry) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)rebatePreData.getDataEntityType().getName(), (DynamicObject)rebatePreData, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)rebatePreData);
        String name = this.getName(pretRelation, rebatePolicyEntry);
        rebatePreData.set("name", (Object)name);
        rebatePreData.set("version", (Object)1);
        rebatePreData.set("createtime", (Object)new Date());
        rebatePreData.set("billno", (Object)number);
        rebatePreData.set("billtype", (Object)1039841962997446656L);
        rebatePreData.set("rebatepolicy", pretRelation.get("rebatepolicy"));
        rebatePreData.set("channel", pretRelation.get("signcustomerchannel"));
        rebatePreData.set("customer", pretRelation.get("signcustomerbg"));
        rebatePreData.set("prebudgetdate", (Object)new Date());
        rebatePreData.set("org", pretRelation.get("rpcontractsubject.frepresentativeorg"));
        rebatePreData.set("rpprecurrency", pretRelation.get("currency"));
        rebatePreData.set("billstatus", (Object)"C");
        rebatePreData.set("isbudgetfinish", (Object)Boolean.FALSE);
        rebatePreData.set("rpbegindate", pretRelation.get("rpbegindate"));
        rebatePreData.set("rpenddate", pretRelation.get("rpenddate"));
        rebatePreData.set("rpareadep", pretRelation.get("areadept"));
        rebatePreData.set("rprepresentoffice", pretRelation.get("rptoffice"));
        rebatePreData.set("rparea", pretRelation.get("country"));
        rebatePreData.set("rpcontractsubject", pretRelation.get("rpcontractsubject"));
        rebatePreData.set("rpchannelfirstgroup", pretRelation.get("bchannelfirstclass"));
        rebatePreData.set("rpchannelsecondgroup", pretRelation.get("bchannelsecclass"));
        DynamicObjectCollection salesattr = pretRelation.getDynamicObjectCollection("salesattrs");
        ArrayList salesattrs = new ArrayList();
        salesattr.stream().forEach(item -> salesattrs.add(item.getDynamicObject(1).getLong("id")));
        if (!CollectionUtils.isEmpty(salesattrs)) {
            DynamicObjectUtils.setMultiF7Value((DynamicObject)rebatePreData, (String)"rpgoodsalepropertys", (String)"ocdbd_item_saleattr", (Object[])salesattrs.toArray());
        }
        rebatePreData.set("rpincentivetype", pretRelation.get("inspiretype"));
        rebatePreData.set("rpincentivesubtyp", pretRelation.get("childtype"));
        rebatePreData.set("rpdestcaculatetype", pretRelation.get("targetcaltype"));
        rebatePreData.set("rpbudgetcycle", pretRelation.get("settperiod"));
        rebatePreData.set("laddertype", rebatePolicyEntry.get("kpi.laddertype"));
        rebatePreData.set("rebatetype", rebatePolicyEntry.get("rebatetype"));
        rebatePreData.set("rppdestformula", rebatePolicyEntry.get("formula"));
    }

    public void setEntryBody(DynamicObject rebatePreData, DynamicObject pretRelation, List<DynamicObject> logEntrys) {
        DynamicObjectCollection pretRelationEntrys = pretRelation.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entryEntitys = rebatePreData.getDynamicObjectCollection("entryentity");
        for (DynamicObject pretRelationEntry : pretRelationEntrys) {
            this.addEntryEntity(entryEntitys, pretRelationEntry, pretRelation);
            DynamicObject log = this.addLog(rebatePreData, pretRelationEntry, pretRelation, "A");
            logEntrys.add(log);
        }
    }

    public void updateEntryEntity(DynamicObject entryEntity, DynamicObject pretRelationEntry, DynamicObject pretRelation) {
        entryEntity.set("saleorderqty", pretRelationEntry.get("ordernumsum"));
        BigDecimal signNumSum = pretRelationEntry.getBigDecimal("signnumsum");
        entryEntity.set("consignqty", (Object)signNumSum);
        BigDecimal adjustconsignqty = entryEntity.getBigDecimal("adjustconsignqty");
        if (signNumSum != null && adjustconsignqty != null) {
            BigDecimal result = signNumSum.add(adjustconsignqty);
            entryEntity.set("proconsignqty", (Object)result);
        } else {
            entryEntity.set("proconsignqty", pretRelationEntry.get("signnumsum"));
        }
        BigDecimal deliveryamount = pretRelationEntry.getBigDecimal("deliveryamount");
        entryEntity.set("saleamount", (Object)deliveryamount);
        BigDecimal adjustsaleamount = entryEntity.getBigDecimal("adjustsaleamount");
        if (deliveryamount != null && adjustsaleamount != null) {
            BigDecimal result = deliveryamount.add(adjustsaleamount);
            entryEntity.set("prosaleamount", (Object)result);
        } else {
            entryEntity.set("prosaleamount", pretRelationEntry.get("deliveryamount"));
        }
        entryEntity.set("perunitrebateamount", pretRelationEntry.get("maxamount"));
        entryEntity.set("profitrate", pretRelationEntry.get("percentmax"));
        entryEntity.set("rebateamount", pretRelationEntry.get("rebateamount"));
        entryEntity.set("unitid", pretRelationEntry.get("unit"));
        entryEntity.set("deliveytime", pretRelationEntry.get("podmax"));
        entryEntity.set("arrivaltime", pretRelationEntry.get("atamax"));
        entryEntity.set("benefitcustomer", pretRelationEntry.get("customerchanelid"));
        BigDecimal signnumsum = pretRelationEntry.getBigDecimal("signnumsum");
        if (deliveryamount != null && signnumsum != null && signnumsum.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal price = deliveryamount.divide(signnumsum, 10, 4);
            entryEntity.set("price", (Object)price);
        }
    }

    public void addEntryEntity(DynamicObjectCollection entryEntitys, DynamicObject pretRelationEntry, DynamicObject pretRelation) {
        DynamicObject rebatePreEntryEntitys = entryEntitys.addNew();
        this.setEntryEntityProperty(pretRelationEntry, pretRelation, rebatePreEntryEntitys);
    }

    public void setEntryEntityProperty(DynamicObject pretRelationEntry, DynamicObject pretRelation, DynamicObject rebatePreEntryEntitys) {
        DynamicObject country;
        rebatePreEntryEntitys.set("repolicytarget", pretRelationEntry.get("policygoal"));
        rebatePreEntryEntitys.set("product", pretRelationEntry.get("productnumber"));
        rebatePreEntryEntitys.set("unitid", pretRelationEntry.get("unit"));
        rebatePreEntryEntitys.set("saleordernumber", pretRelationEntry.get("contractno"));
        rebatePreEntryEntitys.set("saleorderqty", pretRelationEntry.get("ordernumsum"));
        rebatePreEntryEntitys.set("framecontractnumber", pretRelationEntry.get("contractno"));
        rebatePreEntryEntitys.set("consignqty", pretRelationEntry.get("signnumsum"));
        rebatePreEntryEntitys.set("proconsignqty", pretRelationEntry.get("signnumsum"));
        rebatePreEntryEntitys.set("saleamount", pretRelationEntry.get("deliveryamount"));
        rebatePreEntryEntitys.set("prosaleamount", pretRelationEntry.get("deliveryamount"));
        rebatePreEntryEntitys.set("perunitrebateamount", pretRelationEntry.get("maxamount"));
        rebatePreEntryEntitys.set("profitrate", pretRelationEntry.get("percentmax"));
        rebatePreEntryEntitys.set("rebateamount", pretRelationEntry.get("rebateamount"));
        rebatePreEntryEntitys.set("deliveytime", pretRelationEntry.get("podmax"));
        rebatePreEntryEntitys.set("arrivaltime", pretRelationEntry.get("atamax"));
        rebatePreEntryEntitys.set("benefitcustomer", pretRelationEntry.get("customerchanelid"));
        BigDecimal deliveryamount = pretRelationEntry.getBigDecimal("deliveryamount");
        BigDecimal signnumsum = pretRelationEntry.getBigDecimal("signnumsum");
        if (deliveryamount != null && signnumsum != null && signnumsum.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal price = deliveryamount.divide(signnumsum, 2, 4);
            rebatePreEntryEntitys.set("price", (Object)price);
        }
        if ((country = pretRelation.getDynamicObject("country")) != null) {
            String number = country.getString("number");
            if (number.equals("CN")) {
                rebatePreEntryEntitys.set("istax", (Object)Boolean.TRUE);
            } else {
                rebatePreEntryEntitys.set("istax", (Object)Boolean.FALSE);
            }
        }
    }

    private DynamicObject findRebatePreData(Long signCustomerChannel, Long rebatePolicy, Date beginDate, Date endDate) {
        QFilter qf = new QFilter("channel", "=", (Object)signCustomerChannel);
        qf.and("rebatepolicy", "=", (Object)rebatePolicy);
        qf.and("rpbegindate", "=", (Object)beginDate);
        qf.and("rpenddate", "=", (Object)endDate);
        String param = "id";
        DynamicObject pkid = QueryServiceHelper.queryOne((String)"occpic_rebateprebudget", (String)param, (QFilter[])qf.toArray());
        if (pkid != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkid.getLong("id"), (String)"occpic_rebateprebudget");
            return dynamicObject;
        }
        return null;
    }

    private String getName(DynamicObject pretRelation, DynamicObject rebatePolicyEntry) {
        String customerName = pretRelation.getString("signcustomerbg.name");
        String policyName = rebatePolicyEntry.getString("name");
        String begindateStr = "";
        Date begindate = pretRelation.getDate("rpbegindate");
        if (begindate != null) {
            begindateStr = DateUtil.getDateFormat((Date)begindate, (String)"yyyy-MM-dd");
        }
        return customerName + "+" + policyName + "+" + begindateStr;
    }
}

