/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.occpibc.business.handle.PolicyGoalsTabHandle;
import kd.occ.occpibc.business.handle.PretCorresHandle;
import kd.occ.occpibc.business.handle.PretRelationTabHandle;
import kd.occ.occpibc.business.handle.RebateBaseTabSearchHandle;
import kd.occ.occpibc.business.handle.RebateCalcHandle;
import kd.occ.occpibc.common.model.PreRelationEntityModel;
import kd.occ.occpibc.common.model.PreRelationModel;
import kd.occ.occpibc.common.model.PreRelationQueryParamModel;

public class RebatePreSettlementHelper {
    private static final RebateBaseTabSearchHandle rebateBaseTabSearchHandle = new RebateBaseTabSearchHandle();
    private static final PretRelationTabHandle pretRelationTabHandle = new PretRelationTabHandle();
    private static final RebateCalcHandle rebateCalcHandle = new RebateCalcHandle();
    private static final PolicyGoalsTabHandle policyGoalsTabHandle = new PolicyGoalsTabHandle();
    private static final PretCorresHandle pretCorresHandle = new PretCorresHandle();

    public boolean rebatePreProcess() {
        boolean result = false;
        List<DynamicObject> policys = policyGoalsTabHandle.queryPolicyGoals();
        if (CollectionUtils.isEmpty(policys)) {
            return true;
        }
        List<PreRelationModel> preRelations = policyGoalsTabHandle.constructEntryModel(policys);
        List<PreRelationQueryParamModel> preRelationQueryParamModels = policyGoalsTabHandle.constructParam(policys);
        DynamicObjectCollection rebateBaseData = rebateBaseTabSearchHandle.queryRebateBaseData(preRelationQueryParamModels, preRelations);
        if (CollectionUtils.isEmpty((Collection)rebateBaseData)) {
            return true;
        }
        rebateBaseTabSearchHandle.splitByPo(preRelations);
        List<Long> policyIds = preRelations.stream().map(PreRelationModel::getRebatePolicy).collect(Collectors.toList());
        DynamicObject[] oldPreRelations = pretRelationTabHandle.searchByPolicy(policyIds);
        pretRelationTabHandle.conversionToModel(oldPreRelations, preRelations);
        this.removeUselessData(preRelations);
        if (CollectionUtils.isEmpty(preRelations)) {
            return true;
        }
        preRelations = this.summaryHeader(preRelations);
        rebateCalcHandle.rebateAutomatic(preRelations);
        result = this.txSave(preRelations, oldPreRelations);
        return result;
    }

    private boolean txSave(List<PreRelationModel> preRelations, DynamicObject[] oldPreRelations) {
        boolean result;
        try (TXHandle h = TX.required();){
            try {
                pretRelationTabHandle.saveByModel(preRelations, oldPreRelations);
                pretCorresHandle.savePretCorres(preRelations);
                result = true;
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return result;
    }

    private List<PreRelationModel> summaryHeader(List<PreRelationModel> preRelations) {
        HashMap keyMap = new HashMap();
        for (PreRelationModel preRelation : preRelations) {
            Long rebatePolicy = preRelation.getRebatePolicy();
            Long signCustomer = preRelation.getSignCustomerChannel();
            Date targetStartTime = preRelation.getTargetStartTime();
            Date targetDndTime = preRelation.getTargetDndTime();
            if (rebatePolicy == null || signCustomer == null || targetStartTime == null || targetDndTime == null) continue;
            String key = rebatePolicy.toString().concat(signCustomer.toString()).concat(targetStartTime.toString()).concat(targetDndTime.toString());
            if (keyMap.get(key) == null) {
                ArrayList<PreRelationModel> tempList = new ArrayList<PreRelationModel>();
                tempList.add(preRelation);
                keyMap.put(key, tempList);
                continue;
            }
            ((List)keyMap.get(key)).add(preRelation);
        }
        if (CollectionUtils.isEmpty(keyMap)) {
            return null;
        }
        ArrayList<PreRelationModel> resultList = new ArrayList<PreRelationModel>();
        for (Map.Entry entry : keyMap.entrySet()) {
            PreRelationModel resultRelationModel;
            List relationModels = (List)entry.getValue();
            if (!CollectionUtils.isEmpty((Collection)relationModels) && relationModels.size() > 1) {
                resultRelationModel = (PreRelationModel)relationModels.get(0);
                ArrayList resultPretRelationEntityModels = new ArrayList();
                for (PreRelationModel relationModel : relationModels) {
                    List pretRelationEntityModels = relationModel.getPretRelationEntityModels();
                    resultPretRelationEntityModels.addAll(pretRelationEntityModels);
                }
                resultRelationModel.setPretRelationEntityModels(resultPretRelationEntityModels);
                resultList.add(resultRelationModel);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)relationModels)) continue;
            resultRelationModel = (PreRelationModel)relationModels.get(0);
            resultList.add(resultRelationModel);
        }
        return resultList;
    }

    private void removeUselessData(List<PreRelationModel> preRelations) {
        for (int i = 0; i < preRelations.size(); ++i) {
            int useNum = 0;
            List pretRelationEntityModels = preRelations.get(i).getPretRelationEntityModels();
            if (CollectionUtils.isEmpty((Collection)pretRelationEntityModels)) {
                if (i >= 0) {
                    preRelations.remove(i);
                    --i;
                }
            } else {
                for (int j = 0; j < pretRelationEntityModels.size(); ++j) {
                    List rebateBaseDatas = ((PreRelationEntityModel)pretRelationEntityModels.get(j)).getRebateBaseDatas();
                    if (CollectionUtils.isEmpty((Collection)rebateBaseDatas)) {
                        pretRelationEntityModels.remove(j);
                        --j;
                        continue;
                    }
                    ++useNum;
                }
            }
            if (i < 0 || useNum != 0) continue;
            preRelations.remove(i);
            --i;
        }
    }
}

