/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.helper.conditionmatch.ConditionMatchHelper;
import kd.occ.ocbase.common.enums.LadderTypeEnums;
import kd.occ.ocbase.common.enums.occpic.CalScopeType;
import kd.occ.ocbase.common.enums.occpic.CalculateStatus;
import kd.occ.ocbase.common.enums.occpic.RebateObject;
import kd.occ.ocbase.common.enums.occpic.TargetCalType;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.occpibc.business.handle.PolicyGoalsTabStandardHandle;
import kd.occ.occpibc.engine.RebateEngine;
import kd.occ.occpibc.engine.common.RebateCalcTaskInfo;
import kd.occ.occpibc.engine.common.kpi.Kpi;
import kd.occ.occpibc.engine.common.kpi.ladder.AbstractLadder;
import kd.occ.occpibc.engine.common.kpi.ladder.AmountLadder;
import kd.occ.occpibc.engine.common.kpi.ladder.AmountRateLadder;
import kd.occ.occpibc.engine.common.kpi.ladder.ManagementLadder;
import kd.occ.occpibc.engine.common.kpi.ladder.QtyLadder;
import kd.occ.occpibc.engine.common.kpi.ladder.QtyRateLadder;
import kd.occ.occpibc.engine.common.kpi.ladder.UnConditionalLadder;

public class RebatePreSettlementStandardHelper {
    private static final PolicyGoalsTabStandardHandle policyGoalsTabHandle = new PolicyGoalsTabStandardHandle();

    public static final void rebateCalulate() {
        RebateCalcTaskInfo[] rebateCalcTaskArray;
        policyGoalsTabHandle.updateRebateTargetCalculateStatus();
        QFilter qf = new QFilter("billstatus", "=", (Object)Status.AUDITED);
        qf.and("calculatestatus", "=", (Object)CalculateStatus.XUYAOJISUAN.toString());
        DynamicObject[] targetArray = QueryUtil.load((String)"occpic_rebatetarget", (QFilter[])qf.toArray(), (String[])new String[0]);
        for (RebateCalcTaskInfo rebateCalcTaskInfo : rebateCalcTaskArray = RebatePreSettlementStandardHelper.buildRebateCalcTaskInfo(targetArray)) {
            RebateEngine.execute((RebateCalcTaskInfo)rebateCalcTaskInfo);
        }
    }

    public static final RebateCalcTaskInfo buildRebateCalcTaskInfo(DynamicObject rebateTarget) {
        return rebateTarget == null ? null : RebatePreSettlementStandardHelper.buildRebateCalcTaskInfo(new DynamicObject[]{rebateTarget})[0];
    }

    public static final RebateCalcTaskInfo[] buildRebateCalcTaskInfo(DynamicObject[] rebateTargetArray) {
        Map<String, List<DynamicObject>> targetMap = RebatePreSettlementStandardHelper.getCalculateTargetMap(rebateTargetArray);
        ArrayList<RebateCalcTaskInfo> rebateCalcTaskList = new ArrayList<RebateCalcTaskInfo>(targetMap.size() * 10);
        for (List<DynamicObject> targetList : targetMap.values()) {
            RebateCalcTaskInfo rebateCalcTaskInfo = new RebateCalcTaskInfo();
            for (DynamicObject target : targetList) {
                DynamicObject rebateClass = target.getDynamicObject("rebateclass");
                if (rebateClass == null) continue;
                if (rebateCalcTaskInfo.getRebateModelId() == null) {
                    rebateCalcTaskInfo.setRebateModelId(Long.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rebateClass, (String)"rebatemodel")));
                }
                String rebateObject = rebateClass.getString("rebateobject");
                if (rebateCalcTaskInfo.getRebateObjectField() == null) {
                    rebateCalcTaskInfo.setRebateObjectField(rebateObject);
                }
                if (rebateCalcTaskInfo.getKpiList() == null) {
                    rebateCalcTaskInfo.setKpiList(RebatePreSettlementStandardHelper.buildKpiList(target));
                }
                if (rebateCalcTaskInfo.getQueryFilter() == null) {
                    QFilter qFilter = ConditionMatchHelper.buildConditionMatchHeaderFilter((DynamicObject)target);
                    rebateCalcTaskInfo.setQueryFilter(qFilter);
                }
                if (RebateObject.CHANNEL.toString().equals(rebateObject)) {
                    rebateCalcTaskInfo.getSrcTargets().put(String.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"benifitchl")), target.getLong("id"));
                    continue;
                }
                if (!RebateObject.CUSTOMER.toString().equals(rebateObject)) continue;
                rebateCalcTaskInfo.getSrcTargets().put(String.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"benifitcustomer")), target.getLong("id"));
            }
            rebateCalcTaskList.add(rebateCalcTaskInfo);
        }
        return (RebateCalcTaskInfo[])rebateCalcTaskList.stream().toArray(RebateCalcTaskInfo[]::new);
    }

    private static final List<Kpi> buildKpiList(DynamicObject target) {
        String calScopeType = target.getString("calscopetype");
        List<Object> kpiList = new ArrayList(0);
        if (CalScopeType.ALL.toString().equals(calScopeType)) {
            kpiList = RebatePreSettlementStandardHelper.buildCalAllTargetKpiList(target);
        } else if (CalScopeType.GROUP.toString().equals(calScopeType)) {
            kpiList = RebatePreSettlementStandardHelper.buildCalGroupTargetKpiList(target);
        }
        return kpiList;
    }

    private static final List<Kpi> buildCalGroupTargetKpiList(DynamicObject target) {
        ArrayList<Kpi> kpiList = new ArrayList<Kpi>();
        String targetCalType = target.getString("targetcaltype");
        long ladderTypeId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"laddertype");
        DynamicObjectCollection entries = target.getDynamicObjectCollection("itemformulaentity");
        if (StringUtils.isNotEmpty((String)targetCalType) && ladderTypeId > 0L && !CollectionUtils.isEmpty((Collection)entries)) {
            Map<Object, List<DynamicObject>> map = entries.stream().collect(Collectors.groupingBy(r -> r.get("group")));
            Object[] conditonGroupIdArray = entries.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"conditongroup")).distinct().toArray();
            Map conditonGroupMap = QueryUtil.loadMap((Object[])conditonGroupIdArray, (String)"ocdbd_conditongroup", (String[])new String[0]);
            for (Map.Entry<Object, List<DynamicObject>> entry : map.entrySet()) {
                Kpi kpi = new Kpi();
                QFilter qFilter = ConditionMatchHelper.buildConditionMatchConditionGroupFilter((DynamicObject)((DynamicObject)conditonGroupMap.get(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry.getValue().get(0), (String)"conditongroup"))));
                kpi.setCondition(qFilter);
                kpi.setField(targetCalType);
                if (ladderTypeId == LadderTypeEnums.UNCONDITION.getTypeId()) {
                    RebatePreSettlementStandardHelper.addUnConditionalLadder2Kpi(kpi, entry.getValue(), "group", "itemrebateamount", "itemrebatepercent", "itemfixedamount");
                } else if (ladderTypeId == LadderTypeEnums.MBO.getTypeId()) {
                    RebatePreSettlementStandardHelper.addManagementLadder2Kpi(kpi, entry.getValue(), "group", "itemrebateamount", "itemrebatepercent", "itemfixedamount");
                } else if (ladderTypeId == LadderTypeEnums.ACHIEVEMENT.getTypeId()) {
                    if (TargetCalType.BYAMOUNT.toString().equals(targetCalType)) {
                        RebatePreSettlementStandardHelper.addAmountRateLadder2Kpi(kpi, target, entry.getValue(), "itemmaxachive", "itemminachive", "itemblamount", "group", "itemrebateamount", "itemrebatepercent", "itemfixedamount");
                    } else if (TargetCalType.BYQTY.toString().equals(targetCalType)) {
                        RebatePreSettlementStandardHelper.addQtyRateLadder2Kpi(kpi, target, entry.getValue(), "itemmaxachive", "itemminachive", "itemblqty", "group", "itemrebateamount", "itemrebatepercent", "itemfixedamount");
                    }
                } else if (ladderTypeId == LadderTypeEnums.NORMAL.getTypeId()) {
                    if (TargetCalType.BYAMOUNT.toString().equals(targetCalType)) {
                        RebatePreSettlementStandardHelper.addAmountLadder2Kpi(kpi, entry.getValue(), "itemmaxamount", "itemminamount", "group", "itemrebateamount", "itemrebatepercent", "itemfixedamount");
                    } else if (TargetCalType.BYQTY.toString().equals(targetCalType)) {
                        RebatePreSettlementStandardHelper.addQtyLadder2Kpi(kpi, entry.getValue(), "itemmaxqty", "itemminqty", "group", "itemrebateamount", "itemrebatepercent", "itemfixedamount");
                    }
                }
                kpiList.add(kpi);
            }
        }
        return kpiList;
    }

    private static final List<Kpi> buildCalAllTargetKpiList(DynamicObject target) {
        ArrayList<Kpi> kpiList = new ArrayList<Kpi>(1);
        String targetCalType = target.getString("targetcaltype");
        long ladderTypeId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"laddertype");
        if (StringUtils.isNotEmpty((String)targetCalType) && ladderTypeId > 0L) {
            List<DynamicObject> entryList = target.getDynamicObjectCollection("formulaentity").stream().collect(Collectors.toList());
            Kpi kpi = new Kpi();
            QFilter qFilter = ConditionMatchHelper.buildConditionMatchItemRangeEntryFilter((DynamicObject)target);
            kpi.setCondition(qFilter);
            kpi.setField(targetCalType);
            if (ladderTypeId == LadderTypeEnums.UNCONDITION.getTypeId()) {
                RebatePreSettlementStandardHelper.addUnConditionalLadder2Kpi(kpi, entryList, null, "rebateamount", "rebatepercent", "fixedamount");
            } else if (ladderTypeId == LadderTypeEnums.MBO.getTypeId()) {
                RebatePreSettlementStandardHelper.addManagementLadder2Kpi(kpi, entryList, null, "rebateamount", "rebatepercent", "fixedamount");
            } else if (ladderTypeId == LadderTypeEnums.ACHIEVEMENT.getTypeId()) {
                if (TargetCalType.BYAMOUNT.toString().equals(targetCalType)) {
                    RebatePreSettlementStandardHelper.addAmountRateLadder2Kpi(kpi, target, entryList, "maxachive", "minachive", "baselineamount", null, "rebateamount", "rebatepercent", "fixedamount");
                } else if (TargetCalType.BYQTY.toString().equals(targetCalType)) {
                    RebatePreSettlementStandardHelper.addQtyRateLadder2Kpi(kpi, target, entryList, "maxachive", "minachive", "baselineqty", null, "rebateamount", "rebatepercent", "fixedamount");
                }
            } else if (ladderTypeId == LadderTypeEnums.NORMAL.getTypeId()) {
                if (TargetCalType.BYAMOUNT.toString().equals(targetCalType)) {
                    RebatePreSettlementStandardHelper.addAmountLadder2Kpi(kpi, entryList, "maxamount", "minamount", null, "rebateamount", "rebatepercent", "fixedamount");
                } else if (TargetCalType.BYQTY.toString().equals(targetCalType)) {
                    RebatePreSettlementStandardHelper.addQtyLadder2Kpi(kpi, entryList, "maxqty", "minqty", null, "rebateamount", "rebatepercent", "fixedamount");
                }
            }
            kpiList.add(kpi);
        }
        return kpiList;
    }

    private static final void addUnConditionalLadder2Kpi(Kpi kpi, List<DynamicObject> entryList, String groupKey, String rebateAmountKey, String rebatePercentKey, String fixedAmountKey) {
        for (DynamicObject entry : entryList) {
            UnConditionalLadder ladder = new UnConditionalLadder();
            RebatePreSettlementStandardHelper.setBaseLadder((AbstractLadder)ladder, entry, groupKey, rebateAmountKey, rebatePercentKey, fixedAmountKey);
            kpi.addLadder((AbstractLadder)ladder);
        }
    }

    private static final void addManagementLadder2Kpi(Kpi kpi, List<DynamicObject> entryList, String groupKey, String rebateAmountKey, String rebatePercentKey, String fixedAmountKey) {
        for (DynamicObject entry : entryList) {
            ManagementLadder ladder = new ManagementLadder();
            RebatePreSettlementStandardHelper.setBaseLadder((AbstractLadder)ladder, entry, groupKey, rebateAmountKey, rebatePercentKey, fixedAmountKey);
            kpi.addLadder((AbstractLadder)ladder);
        }
    }

    private static final void addQtyLadder2Kpi(Kpi kpi, List<DynamicObject> entryList, String maxKey, String minKey, String groupKey, String rebateAmountKey, String rebatePercentKey, String fixedAmountKey) {
        for (DynamicObject entry : entryList) {
            QtyLadder qtyLadder = new QtyLadder(entry.getBigDecimal(minKey), entry.getBigDecimal(maxKey));
            RebatePreSettlementStandardHelper.setBaseLadder((AbstractLadder)qtyLadder, entry, groupKey, rebateAmountKey, rebatePercentKey, fixedAmountKey);
            kpi.addLadder((AbstractLadder)qtyLadder);
        }
    }

    private static final void addAmountLadder2Kpi(Kpi kpi, List<DynamicObject> entryList, String maxKey, String minKey, String groupKey, String rebateAmountKey, String rebatePercentKey, String fixedAmountKey) {
        for (DynamicObject entry : entryList) {
            AmountLadder amountLadder = new AmountLadder(entry.getBigDecimal(minKey), entry.getBigDecimal(maxKey));
            RebatePreSettlementStandardHelper.setBaseLadder((AbstractLadder)amountLadder, entry, groupKey, rebateAmountKey, rebatePercentKey, fixedAmountKey);
            kpi.addLadder((AbstractLadder)amountLadder);
        }
    }

    private static final void addQtyRateLadder2Kpi(Kpi kpi, DynamicObject target, List<DynamicObject> entryList, String maxKey, String minKey, String baselineKey, String groupKey, String rebateAmountKey, String rebatePercentKey, String fixedAmountKey) {
        for (DynamicObject entry : entryList) {
            QtyRateLadder qtyRateLadder = new QtyRateLadder("baselineqty".equals(baselineKey) ? target.getBigDecimal(baselineKey) : entry.getBigDecimal(baselineKey), entry.getBigDecimal(minKey), entry.getBigDecimal(maxKey));
            RebatePreSettlementStandardHelper.setBaseLadder((AbstractLadder)qtyRateLadder, entry, groupKey, rebateAmountKey, rebatePercentKey, fixedAmountKey);
            kpi.addLadder((AbstractLadder)qtyRateLadder);
        }
    }

    private static final void addAmountRateLadder2Kpi(Kpi kpi, DynamicObject target, List<DynamicObject> entryList, String maxKey, String minKey, String baselineKey, String groupKey, String rebateAmountKey, String rebatePercentKey, String fixedAmountKey) {
        for (DynamicObject entry : entryList) {
            AmountRateLadder amountRateLadder = new AmountRateLadder("baselineamount".equals(baselineKey) ? target.getBigDecimal(baselineKey) : entry.getBigDecimal(baselineKey), entry.getBigDecimal(minKey), entry.getBigDecimal(maxKey));
            RebatePreSettlementStandardHelper.setBaseLadder((AbstractLadder)amountRateLadder, entry, groupKey, rebateAmountKey, rebatePercentKey, fixedAmountKey);
            kpi.addLadder((AbstractLadder)amountRateLadder);
        }
    }

    private static final void setBaseLadder(AbstractLadder ladder, DynamicObject entry, String groupKey, String rebateAmountKey, String rebatePercentKey, String fixedAmountKey) {
        if (ladder != null && entry != null) {
            if (StringUtils.isNotEmpty((String)groupKey)) {
                ladder.setGroupNo(Integer.valueOf(entry.getInt(groupKey)));
            }
            if (StringUtils.isNotEmpty((String)rebateAmountKey)) {
                ladder.setUnitrebate(entry.getBigDecimal(rebateAmountKey));
            }
            if (StringUtils.isNotEmpty((String)rebatePercentKey)) {
                ladder.setRebatepoint(entry.getBigDecimal(rebatePercentKey));
            }
            if (StringUtils.isNotEmpty((String)fixedAmountKey)) {
                ladder.setFixedamount(entry.getBigDecimal(fixedAmountKey));
            }
        }
    }

    private static final Map<String, List<DynamicObject>> getCalculateTargetMap(DynamicObject[] targetArray) {
        if (targetArray != null && targetArray.length > 0) {
            return Arrays.stream(targetArray).collect(Collectors.groupingBy(r -> String.valueOf(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"policy")) + DateUtil.getDateTimeFormat((Date)r.getDate("modifytime"))));
        }
        return new HashMap<String, List<DynamicObject>>(0);
    }
}

