/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.opplugin.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.Enable;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;

public class RebateModelOutputUniqeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntityArray = this.getDataEntities();
        String operateKey = this.getOperateKey();
        this.checkUniqe(extendedDataEntityArray, operateKey);
    }

    private void checkUniqe(ExtendedDataEntity[] extendedDataEntityArray, String operateKey) {
        Map<Long, List<ExtendedDataEntity>> map;
        if (extendedDataEntityArray != null && extendedDataEntityArray.length > 0 && !CollectionUtils.isEmpty(map = this.groupByEnableRebateModel(extendedDataEntityArray, operateKey))) {
            HashMap<Long, ExtendedDataEntity> rebateModel2OutputMap = new HashMap<Long, ExtendedDataEntity>();
            for (List<ExtendedDataEntity> extendedDataEntityList : map.values()) {
                if (extendedDataEntityList.size() > 1) {
                    for (ExtendedDataEntity extendedDataEntity : extendedDataEntityList) {
                        this.addErrorMessage(extendedDataEntity, this.buildErrorMessage(operateKey));
                    }
                    continue;
                }
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntityList) {
                    rebateModel2OutputMap.put(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)extendedDataEntity.getDataEntity(), (String)"rebatemodel"), extendedDataEntity);
                }
            }
            if (!CollectionUtils.isEmpty(rebateModel2OutputMap)) {
                QFilter qFilter = F7Utils.getEnableFilter();
                qFilter.and("rebatemodel", "in", rebateModel2OutputMap.keySet());
                DynamicObjectCollection rebateModelOutputCol = QueryServiceHelper.query((String)"occpibc_irebateoutput", (String)F7Utils.getSelectCols((String[])new String[]{"id", "rebatemodel"}), (QFilter[])qFilter.toArray());
                for (DynamicObject rebateModelOutput : rebateModelOutputCol) {
                    ExtendedDataEntity extendedDataEntity;
                    long rebatemodelId = rebateModelOutput.getLong("rebatemodel");
                    long id = rebateModelOutput.getLong("id");
                    if (id == (extendedDataEntity = (ExtendedDataEntity)rebateModel2OutputMap.get(rebatemodelId)).getDataEntity().getLong("id")) continue;
                    this.addErrorMessage(extendedDataEntity, this.buildErrorMessage(operateKey));
                }
            }
        }
    }

    private Map<Long, List<ExtendedDataEntity>> groupByEnableRebateModel(ExtendedDataEntity[] extendedDataEntityArray, String operateKey) {
        HashMap<Long, List<ExtendedDataEntity>> map = new HashMap<Long, List<ExtendedDataEntity>>(extendedDataEntityArray.length);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String enable = dataEntity.getString("enable");
            if ("enable".equals(this.getOperateKey())) {
                if (!Enable.DISABLE.toString().equals(enable)) continue;
                this.buildMap(map, extendedDataEntity, dataEntity);
                continue;
            }
            if (!Enable.ENABLE.toString().equals(enable)) continue;
            this.buildMap(map, extendedDataEntity, dataEntity);
        }
        return map;
    }

    private void buildMap(Map<Long, List<ExtendedDataEntity>> map, ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        long rebatemodelId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)dataEntity, (String)"rebatemodel");
        List<ExtendedDataEntity> extendedDataEntityList = map.get(rebatemodelId);
        if (extendedDataEntityList == null) {
            extendedDataEntityList = new ArrayList<ExtendedDataEntity>();
            extendedDataEntityList.add(extendedDataEntity);
            map.put(rebatemodelId, extendedDataEntityList);
        } else {
            extendedDataEntityList.add(extendedDataEntity);
        }
    }

    private String buildErrorMessage(String operateKey) {
        String message = "\u5df2\u5b58\u5728\u76f8\u540c\u8fd4\u5229\u8ba1\u7b97\u6a21\u578b \u542f\u7528\u72b6\u6001\u7684\u8f93\u51fa\u89c4\u5219";
        message = "enable".equals(operateKey) ? message + "\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u3002" : message + "\uff0c\u8bf7\u4fee\u6539\u3002";
        return message;
    }
}

