/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.formplugin.engine;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.occ.occpibc.engine.common.rebate.RebateModelUtil;

public class IRebateModelEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "metadataid": {
                this.loadMetadataProperties();
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.reLoadMetadataProperties();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "submit": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.reLoadMetadataProperties();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null) {
            // empty if block
        }
    }

    private void loadMetadataProperties() {
        DynamicObject sourceMetadata = RebateModelUtil.getModelMetadata((DynamicObject)this.getModel().getDataEntity());
        DynamicObjectCollection properties = this.getModel().getDataEntity(true).getDynamicObjectCollection("propertyentry");
        properties.clear();
        if (sourceMetadata == null) {
            return;
        }
        List sourceProperties = RebateModelUtil.getModelMetadatasProperties((DynamicObject)this.getModel().getDataEntity());
        for (IDataEntityProperty sourceProperty : sourceProperties) {
            DynamicObject propertyRowData = properties.addNew();
            propertyRowData.set("propname", (Object)sourceProperty.getDisplayName().getLocaleValue());
            propertyRowData.set("propid", (Object)sourceProperty.getName());
        }
        this.getView().updateView("propertyentry");
    }

    private void reLoadMetadataProperties() {
        DynamicObjectCollection properties = this.getModel().getDataEntity(true).getDynamicObjectCollection("propertyentry");
        List metadataProperties = RebateModelUtil.getModelMetadatasProperties((DynamicObject)this.getModel().getDataEntity());
        Map<String, String> metadataPropertiesMap = metadataProperties.stream().collect(Collectors.toMap(v -> v.getName(), v -> v.getDisplayName().getLocaleValue()));
        for (DynamicObject property : properties) {
            String propid = property.getString("propid");
            if (metadataPropertiesMap.get(propid) == null) continue;
            property.set("propname", (Object)metadataPropertiesMap.get(propid));
        }
    }

    private void callBack4CpropidFieldCol(String field) {
    }
}

