/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.formplugin.engine;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.message.service.pa.util.StringUtil;
import kd.occ.ocbase.common.util.EntityUtil;
import kd.occ.occpibc.engine.common.rebate.RebateModelUtil;

public class IRebateSourceEdit
extends AbstractBillPlugIn {
    private static final String F_SourceFieldname = "sourcefieldname";
    private static final String F_SourceBill = "sourcebill";
    private static final String F_SourceFieldid = "sourcefieldid";
    private static final String F_RebateModel = "irebatemodel";
    private static final String F_PropertisEntity = "propertisentity";
    private static final String F_RebatePropName = "rebatepropname";
    private static final String F_RebatePropid = "irebatepropid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{F_SourceFieldname});
    }

    public void afterLoadData(EventObject e) {
        this.reSetPropertiesName();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "sourcefieldname": {
                EntityUtil.showSelectEntityFieldForm((IFormView)this.getView(), (String)EntityUtil.getFormIdByField((IDataModel)this.getModel(), (String)F_SourceBill), null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, F_SourceFieldname));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "irebatemodel": {
                this.loadRebateModel();
                break;
            }
            case "sourcefieldname": {
                if (e.getChangeSet()[0].getNewValue() != null && !e.getChangeSet()[0].getNewValue().toString().equals("")) break;
                this.getModel().setValue(F_SourceFieldid, (Object)"", e.getChangeSet()[0].getRowIndex());
            }
        }
    }

    private void loadRebateModel() {
        DynamicObject dataObject = this.getModel().getDataEntity(true);
        dataObject.getDynamicObjectCollection(F_PropertisEntity).clear();
        DynamicObject rebateObject = dataObject.getDynamicObject(F_RebateModel);
        if (this.rebateModelIsEmpty(rebateObject)) {
            this.getView().updateView(F_PropertisEntity);
            return;
        }
        List rebateProperties = RebateModelUtil.getModelMetadatasProperties((DynamicObject)rebateObject);
        DynamicObjectCollection propertiesCollection = this.getModel().getEntryEntity(F_PropertisEntity);
        for (IDataEntityProperty rebatePropertie : rebateProperties) {
            DynamicObject rowData = propertiesCollection.addNew();
            rowData.set(F_RebatePropName, (Object)rebatePropertie.getDisplayName());
            rowData.set(F_RebatePropid, (Object)rebatePropertie.getName());
        }
        this.getView().updateView(F_PropertisEntity);
    }

    private void reSetPropertiesName() {
        DynamicObject rebateModelObject = this.getModel().getDataEntity().getDynamicObject(F_RebateModel);
        if (this.rebateModelIsEmpty(rebateModelObject)) {
            return;
        }
        Map rebateModelPropertiesMap = EntityUtil.getEntityAllFields((String)RebateModelUtil.getModelEntityId((DynamicObject)rebateModelObject));
        DynamicObjectCollection propertiesCollection = this.getModel().getEntryEntity(F_PropertisEntity);
        MainEntityType billEntity = EntityUtil.getMainEntityType((String)EntityUtil.getFormIdByField((IDataModel)this.getModel(), (String)F_SourceBill));
        Iterator iterator = propertiesCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject dataObject;
            IDataEntityProperty rebateModelProperty = (IDataEntityProperty)rebateModelPropertiesMap.get((dataObject = (DynamicObject)iterator.next()).get(F_RebatePropid));
            dataObject.set(F_RebatePropName, (Object)(rebateModelProperty == null ? "" : rebateModelProperty.getDisplayName()));
            dataObject.set(F_SourceFieldname, (Object)EntityUtil.getColFullName((MainEntityType)billEntity, (String)dataObject.getString(F_SourceFieldid)));
        }
    }

    private boolean rebateModelIsEmpty(DynamicObject rebateModelObject) {
        return rebateModelObject == null || RebateModelUtil.getModelEntityId((DynamicObject)rebateModelObject) == null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null) {
            switch (e.getActionId()) {
                case "sourcefieldname": {
                    this.callBack4SourceFieldCol((String)returnData);
                }
            }
        }
    }

    private void callBack4SourceFieldCol(String field) {
        if (!StringUtil.isEmpty((String)field)) {
            IDataModel model = this.getModel();
            MainEntityType billEntity = EntityUtil.getMainEntityType((String)EntityUtil.getFormIdByField((IDataModel)this.getModel(), (String)F_SourceBill));
            int row = model.getEntryCurrentRowIndex(F_PropertisEntity);
            model.setValue(F_SourceFieldid, (Object)field, row);
            model.setValue(F_SourceFieldname, (Object)EntityUtil.getColFullName((MainEntityType)billEntity, (String)field), row);
        }
    }
}

