/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.formplugin.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.message.service.pa.util.StringUtil;
import kd.occ.ocbase.common.util.EntityUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occpibc.engine.common.rebate.RebateOutputUtil;

public class RebateModelOutputEdit
extends AbstractBillPlugIn {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String RebateTarget = "occpic_rebatetarget";
    private static List<String> IngoreKeys = Arrays.stream("billno,creator,modifier,auditor,auditdate,modifytime,createtime,changer,version,name".split(",")).collect(Collectors.toList());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"rid", "stid", "sid"});
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.updateRequestFilterCols(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGridCtrl = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterCondition filterCondition = this.loadFilter("filterscheme");
        if (filterCondition != null) {
            filterGridCtrl.SetValue(filterCondition);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void afterLoadData(EventObject e) {
        this.checkMoreProperties();
        this.reSetTargetName();
        this.reSetSourceFieldName();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "target": {
                this.reSetTargetProperties();
                this.updateRequestFilterCols(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (control.getKey().equalsIgnoreCase("sid")) {
            int row = this.getCurrentRow();
            String sourceFieldType = (String)this.getModel().getValue("sourcefieldtype", row);
            if (StringUtils.isEmpty((String)sourceFieldType)) {
                return;
            }
            if (sourceFieldType.equalsIgnoreCase("a")) {
                EntityUtil.showSelectEntityFieldForm((IFormView)this.getView(), (String)RebateOutputUtil.getRebateModelFormId((DynamicObject)this.getModel().getDataEntity()), null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "rid"));
            } else if (sourceFieldType.equalsIgnoreCase("b")) {
                EntityUtil.showSelectEntityFieldForm((IFormView)this.getView(), (String)RebateTarget, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "stid"));
            } else {
                EntityUtil.showSelectEntityFieldForm((IFormView)this.getView(), (String)RebateOutputUtil.getTargetFormId((DynamicObject)this.getModel().getDataEntity()), null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "tid"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData != null) {
            switch (e.getActionId()) {
                case "stid": {
                    this.callBack4Stid((String)returnData);
                    break;
                }
                case "rid": {
                    this.callBack4Rid((String)returnData);
                    break;
                }
                case "tid": {
                    this.callBack4Tid((String)returnData);
                }
            }
        }
    }

    private final void reSetTargetProperties() {
        List properties = RebateOutputUtil.getTargetProperties((DynamicObject)this.getModel().getDataEntity());
        DynamicObjectCollection botpEntryData = this.getModel().getDataEntity(true).getDynamicObjectCollection("botpentry");
        botpEntryData.clear();
        if (properties == null) {
            return;
        }
        for (IDataEntityProperty property : properties) {
            if (IngoreKeys.contains(property.getName())) continue;
            DynamicObject botpRowData = botpEntryData.addNew();
            botpRowData.set("tname", (Object)property.getDisplayName().getLocaleValue());
            botpRowData.set("tid", (Object)property.getName());
        }
        this.getView().updateView("botpentry");
    }

    private void callBack4Stid(String field) {
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("botpentry");
        this.setStid(field, row);
    }

    private void callBack4Rid(String field) {
        if (!StringUtil.isEmpty((String)field)) {
            this.setSoureFieldName(field, RebateOutputUtil.getRebateModelFormId((DynamicObject)this.getModel().getDataEntity()));
        }
    }

    private void setStid(String field, int row) {
        if (!StringUtil.isEmpty((String)field)) {
            this.setSoureFieldName(field, RebateTarget);
        }
    }

    private void setSoureFieldName(String field, String sourceFieldFormId) {
        IDataModel model = this.getModel();
        MainEntityType billEntity = EntityUtil.getMainEntityType((String)sourceFieldFormId);
        int row = model.getEntryCurrentRowIndex("botpentry");
        model.setValue("sid", (Object)field, row);
        model.setValue("sname", (Object)EntityUtil.getColFullName((MainEntityType)billEntity, (String)field), row);
    }

    private void callBack4Tid(String field) {
        if (!StringUtil.isEmpty((String)field)) {
            this.setSoureFieldName(field, RebateOutputUtil.getTargetFormId((DynamicObject)this.getModel().getDataEntity()));
        }
    }

    private void reSetTargetName() {
        DynamicObjectCollection botpEntryDataCollection = this.getModel().getEntryEntity("botpentry");
        String formId = RebateOutputUtil.getTargetFormId((DynamicObject)this.getModel().getDataEntity());
        MainEntityType billEntity = EntityUtil.getMainEntityType((String)formId);
        for (DynamicObject entryData : botpEntryDataCollection) {
            String tid = entryData.getString("tid");
            entryData.set("tname", (Object)EntityUtil.getColFullName((MainEntityType)billEntity, (String)tid));
        }
    }

    private void reSetSourceFieldName() {
        DynamicObjectCollection botpEntryDataCollection = this.getModel().getEntryEntity("botpentry");
        String formId = RebateOutputUtil.getRebateModelFormId((DynamicObject)this.getModel().getDataEntity());
        MainEntityType billEntity = EntityUtil.getMainEntityType((String)formId);
        MainEntityType rebateTargetEntity = EntityUtil.getMainEntityType((String)RebateTarget);
        MainEntityType targetEntity = EntityUtil.getMainEntityType((String)RebateOutputUtil.getTargetFormId((DynamicObject)this.getModel().getDataEntity()));
        MainEntityType mainEntity = null;
        for (DynamicObject entryData : botpEntryDataCollection) {
            String sid;
            String sourceFieldType = entryData.getString("sourcefieldtype");
            if (StringUtils.isNotEmpty((String)sourceFieldType)) {
                mainEntity = "a".equalsIgnoreCase(sourceFieldType) ? billEntity : ("b".equalsIgnoreCase(sourceFieldType) ? rebateTargetEntity : targetEntity);
            }
            if (!StringUtil.isNotEmpty((String)(sid = entryData.getString("sid")))) continue;
            entryData.set("sname", (Object)EntityUtil.getColFullName((MainEntityType)mainEntity, (String)sid));
        }
    }

    private void checkMoreProperties() {
        DynamicObjectCollection botpEntryDataCollection = this.getModel().getEntryEntity("botpentry");
        Set map = botpEntryDataCollection.stream().map(v -> v.getString("tid")).collect(Collectors.toSet());
        MainEntityType billEntity = EntityUtil.getMainEntityType((String)RebateOutputUtil.getTargetFormId((DynamicObject)this.getModel().getDataEntity()));
        Map allFields = billEntity.getAllFields();
        for (Map.Entry property : allFields.entrySet()) {
            if (property instanceof EntryProp || ((IDataEntityProperty)property.getValue()).getDisplayName() == null || IngoreKeys.contains(((IDataEntityProperty)property.getValue()).getName()) || map.contains(((IDataEntityProperty)property.getValue()).getName())) continue;
            DynamicObject rowData = botpEntryDataCollection.addNew();
            rowData.set("tid", (Object)((IDataEntityProperty)property.getValue()).getName());
        }
    }

    private int getCurrentRow() {
        IDataModel model = this.getModel();
        return model.getEntryCurrentRowIndex("botpentry");
    }

    private FilterCondition loadFilter(String ctrlName) {
        Object filter = this.getModel().getValue(ctrlName);
        if (StringUtils.isEmpty((Object)filter)) {
            return null;
        }
        return (FilterCondition)SerializationUtils.fromJsonString((String)filter.toString(), FilterCondition.class);
    }

    private void updateRequestFilterCols(boolean changed) {
        MainEntityType entityType = this.getRequireBillMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList(0));
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            filterGrid.setEntityNumber(entityType.getName());
        }
        this.getView().updateView(FILTERGRIDAP);
    }

    private MainEntityType getRequireBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("target");
        if (requireBill == null) {
            return null;
        }
        String metaDataNo = requireBill.getString("number");
        return EntityMetadataCache.getDataEntityType((String)metaDataNo);
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        String requestFilter = this.getRequestFilterStr();
        model.setValue("filterscheme", (Object)requestFilter);
    }

    private String getRequestFilterStr() {
        FilterGrid grid = (FilterGrid)this.getControl(FILTERGRIDAP);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        return SerializationUtils.toJsonString((Object)condition);
    }
}

