/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.util.EntityUtil;
import kd.occ.ocbase.common.util.FilterConditionUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.botp.AbstractConvertPlugin;
import kd.occ.ocbase.formplugin.botp.ConvertArgs;
import kd.occ.occpibc.engine.botp.ExpressionHelper;
import kd.occ.occpibc.engine.botp.ext.DefaultConvertPlugin;
import kd.occ.occpibc.engine.botp.obj.Continue;
import kd.occ.occpibc.engine.botp.obj.GroupMap;
import kd.occ.occpibc.engine.botp.obj.Grouper;
import kd.occ.occpibc.engine.botp.obj.TargetQueryResult;
import kd.occ.occpibc.engine.common.RebateCalcTaskInfo;
import kd.occ.occpibc.engine.common.rebate.RebateOutputUtil;
import kd.occ.occpibc.engine.handler.algox.common.FixedField;

public class BotpConverter {
    private static Log logger = LogFactory.getLog(BotpConverter.class);
    private RowMeta rowMeta;
    private RebateCalcTaskInfo taskInfo;
    private DynamicObject rebateModelObject;
    private Object rebateObjectId;
    private List<Object[]> calcResultObjects;
    private DynamicObject outputTargetModelObject;
    private String rebateTargetBillno;
    private DynamicObject mainDataObject;
    private DynamicObject srcRebateTargetObject;

    public BotpConverter(RowMeta rowMeta, RebateCalcTaskInfo taskInfo, DynamicObject rebateModelObject, Object rebateObjectId) {
        this.rowMeta = rowMeta;
        this.taskInfo = taskInfo;
        this.rebateModelObject = rebateModelObject;
        this.rebateObjectId = rebateObjectId;
        this.init();
    }

    private void init() {
        if (this.rebateObjectId == null) {
            return;
        }
        Long rebateTargetId = this.taskInfo.getSrcTargets().get(this.rebateObjectId.toString());
        if (rebateTargetId == null) {
            return;
        }
        this.srcRebateTargetObject = BusinessDataServiceHelper.loadSingle((Object)rebateTargetId, (String)"occpic_rebatetarget");
        this.rebateTargetBillno = this.srcRebateTargetObject != null ? this.srcRebateTargetObject.getString("billno") : "";
        logger.info(String.format("rebateConvert: rebateObjectId: %s, rebateTarget:%s, result:%s", this.rebateObjectId, this.rebateTargetBillno, this.getCalcResultObjects() != null ? this.getCalcResultObjects().size() : 0));
        this.outputTargetModelObject = RebateOutputUtil.getTargetInfo(this.rebateModelObject.getPkValue());
    }

    public final OperationResult out() {
        if (this.rebateObjectId == null) {
            return null;
        }
        logger.info("rebateConvert: rebateObjectId:" + this.rebateObjectId);
        if (this.srcRebateTargetObject == null) {
            return null;
        }
        AbstractConvertPlugin pluginProxy = this.getPlugin();
        Continue isContinue = new Continue();
        this.mainDataObject = this.getOrCreateBillInfo(isContinue);
        if (!isContinue.isContinue()) {
            return null;
        }
        this.handNodata(isContinue);
        if (!isContinue.isContinue()) {
            return null;
        }
        this.convertBillHead();
        this.convertBillEntry();
        pluginProxy.afterConvert(this.mainDataObject);
        DynamicObject existDataObject = this.getExistBill();
        ConvertArgs convertArgs = new ConvertArgs();
        pluginProxy.compareBill(this.mainDataObject, existDataObject, convertArgs);
        if (convertArgs.isCancel()) {
            return null;
        }
        pluginProxy.beforeSave(this.mainDataObject);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getOutputObjectFormId(), (DynamicObject[])new DynamicObject[]{this.mainDataObject}, (OperateOption)OperateOption.create());
        this.logResult(operationResult, this.rebateTargetBillno, this.rebateObjectId);
        return null;
    }

    private DynamicObject getOrCreateBillInfo(Continue isContinue) {
        TargetQueryResult targetQueryResult = this.getTargetQueryResult();
        if (targetQueryResult.isExist()) {
            DynamicObject dataObject = targetQueryResult.getResult();
            if (dataObject != null) {
                return dataObject;
            }
            isContinue.setContinue(false);
            return null;
        }
        return this.buildDynamicObject();
    }

    private TargetQueryResult getTargetQueryResult() {
        boolean isExistBill;
        List<QFilter> isExistQfitler = this.getQueryExistBillQfilter();
        String entityName = this.getOutputObjectFormId();
        if (!CollectionUtils.isEmpty(isExistQfitler) && (isExistBill = QueryServiceHelper.exists((String)entityName, (QFilter[])((QFilter[])isExistQfitler.stream().toArray(QFilter[]::new))))) {
            QFilter extendQFilter = this.getRebateModelOutputFilterScheme();
            if (extendQFilter != null) {
                isExistQfitler.add(extendQFilter);
            }
            DynamicObject result = QueryUtil.loadSingle((String)entityName, (QFilter[])((QFilter[])isExistQfitler.stream().toArray(QFilter[]::new)), (String[])new String[0]);
            return new TargetQueryResult(isExistBill, result);
        }
        return new TargetQueryResult(false, null);
    }

    private QFilter getRebateModelOutputFilterScheme() {
        QFilter qFilter = null;
        if (this.outputTargetModelObject != null) {
            String dataEntityType = this.getOutputObjectFormId();
            String filter = this.outputTargetModelObject.getString("filterscheme");
            if (StringUtils.isNotEmpty((String)dataEntityType) && StringUtils.isNotEmpty((String)filter)) {
                qFilter = FilterConditionUtil.translateInfoSqlFilter((String)dataEntityType, (String)filter);
            }
        }
        return qFilter;
    }

    private List<QFilter> getQueryExistBillQfilter() {
        List<DynamicObject> uniqueFieldBotpProperties = RebateOutputUtil.getBillUniqueBotpProperties(this.outputTargetModelObject);
        if (!CollectionUtils.isEmpty(uniqueFieldBotpProperties)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(uniqueFieldBotpProperties.size());
            Continue isContinue = new Continue();
            for (DynamicObject uniqueFieldBotpProperty : uniqueFieldBotpProperties) {
                String f = uniqueFieldBotpProperty.getString("tid");
                Object value = this.getHeadValue(uniqueFieldBotpProperty, isContinue);
                qFilterList.add(new QFilter(f, "=", value));
            }
            return qFilterList;
        }
        return new ArrayList<QFilter>(0);
    }

    private DynamicObject getExistBill() {
        List<QFilter> isExistQfitler = this.getQueryExistBillQfilter();
        if (!CollectionUtils.isEmpty(isExistQfitler)) {
            String entityName = this.getOutputObjectFormId();
            return QueryUtil.loadSingle((String)entityName, (QFilter[])((QFilter[])isExistQfitler.stream().toArray(QFilter[]::new)), (String[])new String[0]);
        }
        return null;
    }

    private AbstractConvertPlugin getPlugin() {
        String plugin = this.outputTargetModelObject.getString("plugin");
        Object pluginProxy = null;
        pluginProxy = StringUtil.isNotEmpty((String)plugin) ? (AbstractConvertPlugin)TypesContainer.createInstance((String)plugin) : new DefaultConvertPlugin();
        return pluginProxy;
    }

    private DynamicObject buildDynamicObject() {
        String targetFormId = this.getOutputObjectFormId();
        return BusinessDataServiceHelper.newDynamicObject((String)targetFormId);
    }

    private void handNodata(Continue isContinue) {
        boolean hasNoData;
        String noDataType = this.getNoDataType();
        boolean bl = hasNoData = this.getCalcResultObjects().size() == 0;
        if (noDataType.equalsIgnoreCase("a") && hasNoData) {
            isContinue.setContinue(false);
            if ((Long)this.mainDataObject.getPkValue() > 0L) {
                OperationServiceHelper.executeOperate((String)"delete", (String)this.getOutputObjectFormId(), (DynamicObject[])new DynamicObject[]{this.mainDataObject}, (OperateOption)OperateOption.create());
            }
        }
    }

    private void convertBillHead() {
        if (this.mainDataObject != null) {
            MainEntityType billEntity = EntityUtil.getMainEntityType((String)this.getOutputObjectFormId());
            Map allOutputTargetFields = billEntity.getAllFields();
            DynamicObjectCollection botpProperties = this.outputTargetModelObject.getDynamicObjectCollection("botpentry");
            for (DynamicObject botpProperty : botpProperties) {
                String tid;
                if (botpProperty == null || !this.isCanUpdate(botpProperty, this.mainDataObject) || allOutputTargetFields.get(tid = botpProperty.getString("tid")) == null || ((IDataEntityProperty)allOutputTargetFields.get(tid)).getParent() instanceof EntryType) continue;
                DynamicProperty dynamicProperty = this.mainDataObject.getDynamicObjectType().getProperty(tid);
                String valueType = botpProperty.getString("valuetype");
                if (dynamicProperty == null || StringUtil.isEmpty((String)valueType)) continue;
                Continue isContinue = new Continue();
                Object value = this.getHeadValue(botpProperty, isContinue);
                if (!isContinue.isContinue()) continue;
                if (dynamicProperty instanceof BasedataProp && !(value instanceof DynamicObject)) {
                    this.mainDataObject.set(tid + "_id", value);
                    continue;
                }
                this.mainDataObject.set(tid, value);
            }
            if (this.mainDataObject.getDataEntityType().getProperties().get((Object)"creator") != null) {
                this.mainDataObject.set("creator_Id", (Object)RequestContext.get().getCurrUserId());
            }
        }
    }

    private boolean isCanUpdate(DynamicObject botpProperty, DynamicObject dyObj) {
        String updateType;
        boolean result = true;
        if (botpProperty != null && dyObj != null && StringUtils.isNotEmpty((String)(updateType = botpProperty.getString("updatetype"))) && "B".equals(updateType)) {
            result = dyObj.getPkValue() == null || dyObj.getLong("id") == 0L;
        }
        return result;
    }

    private Object getHeadValue(DynamicObject botpProperty, Continue isContinue) {
        String valueType = botpProperty.getString("valuetype");
        if (StringUtil.isEmpty((String)valueType)) {
            isContinue.setContinue(false);
            return null;
        }
        String sourceFieldType = botpProperty.getString("sourcefieldtype");
        Object value = null;
        if (valueType.equalsIgnoreCase("A")) {
            String sid = botpProperty.getString("sid");
            if (StringUtil.isEmpty((String)sid)) {
                isContinue.setContinue(false);
                return null;
            }
            if (sourceFieldType.equalsIgnoreCase("B")) {
                value = this.getSrcRebateTargetValue(sid);
            }
        } else {
            if (StringUtil.isEmpty((String)botpProperty.getString("conststr"))) {
                isContinue.setContinue(false);
                return null;
            }
            value = ExpressionHelper.getExpValue(botpProperty.getString("conststr"), this.srcRebateTargetObject);
        }
        return value;
    }

    private void convertBillEntry() {
        GroupMap groupMap = this.groupAndSum();
        Map<String, List<DynamicObject>> entrypBotpPropertiesMap = this.getEntryBotpProperties();
        List<DynamicObject> rowUniqueFields = RebateOutputUtil.getRowUniqueField(this.outputTargetModelObject);
        List<DynamicObject> rowUniqueSumFields = RebateOutputUtil.getRowUniqueSumField(this.outputTargetModelObject);
        for (Map.Entry<String, List<DynamicObject>> entryBotpProperty : entrypBotpPropertiesMap.entrySet()) {
            String entrykey = entryBotpProperty.getKey();
            DynamicObjectCollection historyRowCollection = this.mainDataObject.getDynamicObjectCollection(entrykey);
            List<Object> noExistRowIds = new ArrayList();
            DynamicObjectType historyRowDynamicObjectType = historyRowCollection.getDynamicObjectType();
            for (int i = 0; i < historyRowCollection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)historyRowCollection.get(i);
                String groupKey = this.getOutputTargetRowUniqueKey(dynamicObject, rowUniqueFields);
                Grouper group = groupMap.getGrouper(groupKey);
                if (group != null) {
                    this.setRowData(dynamicObject, historyRowDynamicObjectType, this.calcResultObjects.get(group.getRowDataIndex().get(0)), entryBotpProperty.getValue());
                    this.setSumData(dynamicObject, group, rowUniqueSumFields);
                    groupMap.addExistHistoryKey(groupKey);
                    continue;
                }
                noExistRowIds.add(i);
            }
            noExistRowIds = noExistRowIds.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (Integer n : noExistRowIds) {
                historyRowCollection.remove(n.intValue());
            }
            Map<String, Grouper> newRowsGrouper = groupMap.getNewRows();
            for (Map.Entry<String, Grouper> newRowGrouper : newRowsGrouper.entrySet()) {
                DynamicObject newRowData = historyRowCollection.addNew();
                this.setRowData(newRowData, historyRowDynamicObjectType, this.calcResultObjects.get(newRowGrouper.getValue().getRowDataIndex().get(0)), entryBotpProperty.getValue());
                this.setSumData(newRowData, newRowGrouper.getValue(), rowUniqueSumFields);
            }
            BusinessDataServiceHelper.loadRefence((Object[])historyRowCollection.toArray((Object[])new DynamicObject[historyRowCollection.size()]), (IDataEntityType)historyRowDynamicObjectType);
            this.convertSelfField();
        }
    }

    private void setRowData(DynamicObject targetRowData, DynamicObjectType targetRowDataType, Object[] srcCalcResult, List<DynamicObject> rowBotpProperties) {
        for (DynamicObject botpRowData : rowBotpProperties) {
            if (botpRowData == null || targetRowData == null || !this.isCanUpdate(botpRowData, targetRowData)) continue;
            Continue isContinue = new Continue();
            Object value = this.getResultRowValue(botpRowData, srcCalcResult, isContinue);
            if (!isContinue.isContinue()) continue;
            String tid = botpRowData.getString("tid");
            DynamicProperty dynamicProperty = targetRowDataType.getProperty(tid);
            if (dynamicProperty instanceof BasedataProp) {
                targetRowData.set(tid + "_id", value);
                continue;
            }
            targetRowData.set(tid, value);
        }
    }

    private Object getResultRowValue(DynamicObject botpRowData, Object[] srcCalcResult, Continue isContinue) {
        String valueType = botpRowData.getString("valuetype");
        if (StringUtil.isEmpty((String)valueType)) {
            isContinue.setContinue(false);
            return null;
        }
        Object value = null;
        if (valueType.equalsIgnoreCase("A")) {
            String sid = botpRowData.getString("sid");
            if (StringUtil.isNotEmpty((String)sid)) {
                int fieldIndex = this.rowMeta.getFieldIndex(sid);
                value = srcCalcResult[fieldIndex];
            }
        } else {
            String conststr = botpRowData.getString("conststr");
            String sid = FixedField.getFieldByExp(conststr);
            if (StringUtil.isNotEmpty((String)sid)) {
                int fieldIndex = this.rowMeta.getFieldIndex(sid);
                value = srcCalcResult[fieldIndex];
            } else if (StringUtil.isNotEmpty((String)conststr)) {
                value = ExpressionHelper.getExpValue(conststr, this.srcRebateTargetObject);
            }
        }
        return value;
    }

    private void convertSelfField() {
        Map<String, List<DynamicObject>> groupSelfFieldByFieldTypes = this.groupSelfFieldByFieldType();
        for (Map.Entry<String, List<DynamicObject>> selfConvertProperties : groupSelfFieldByFieldTypes.entrySet()) {
            for (DynamicObject selfConvertPropertie : selfConvertProperties.getValue()) {
                if (selfConvertProperties.getKey().equals("._billhead")) continue;
                DynamicObjectCollection entryDataObjectCollection = this.mainDataObject.getDynamicObjectCollection(selfConvertProperties.getKey());
                for (DynamicObject entryDataObject : entryDataObjectCollection) {
                    if (selfConvertPropertie == null || entryDataObject == null || !this.isCanUpdate(selfConvertPropertie, entryDataObject)) continue;
                    entryDataObject.set(selfConvertPropertie.getString("tid"), entryDataObject.get(selfConvertPropertie.getString("sid")));
                }
            }
        }
    }

    private Map<String, List<DynamicObject>> groupSelfFieldByFieldType() {
        DynamicObjectCollection botpProperties = this.outputTargetModelObject.getDynamicObjectCollection("botpentry");
        Map<String, IDataEntityProperty> allOutputObjectFields = this.getOutputObjectFields();
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        List selfConvertProperties = botpProperties.stream().filter(v -> v.getString("sourcefieldtype").equalsIgnoreCase("C")).collect(Collectors.toList());
        for (DynamicObject botpProperty : selfConvertProperties) {
            ArrayList<DynamicObject> listObjs;
            String groupKey = "._billhead";
            String tid = botpProperty.getString("tid");
            if (allOutputObjectFields.get(tid).getParent() instanceof EntryType) {
                groupKey = allOutputObjectFields.get(tid).getParent().getName();
            }
            if ((listObjs = (ArrayList<DynamicObject>)result.get(groupKey)) == null) {
                listObjs = new ArrayList<DynamicObject>();
                result.put(groupKey, listObjs);
            }
            listObjs.add(botpProperty);
        }
        return result;
    }

    private Map<String, List<DynamicObject>> getEntryBotpProperties() {
        Map<String, IDataEntityProperty> allTargetObjectFields = this.getOutputObjectFields();
        DynamicObjectCollection botpProperties = this.outputTargetModelObject.getDynamicObjectCollection("botpentry");
        HashMap<String, List<DynamicObject>> entryMap = new HashMap<String, List<DynamicObject>>(2);
        for (DynamicObject botpRowProperty : botpProperties) {
            IDataEntityProperty tidProperty;
            boolean isConststr;
            String valueType = botpRowProperty.getString("valuetype");
            String sourceFieldType = botpRowProperty.getString("sourcefieldtype");
            if (StringUtil.isEmpty((String)valueType)) continue;
            boolean isResultField = "A".equalsIgnoreCase(valueType) && sourceFieldType.equalsIgnoreCase("A");
            boolean bl = isConststr = ("C".equalsIgnoreCase(valueType) || "B".equalsIgnoreCase(valueType)) && StringUtil.isNotEmpty((String)botpRowProperty.getString("conststr"));
            if (!isResultField && !isConststr || !((tidProperty = allTargetObjectFields.get(botpRowProperty.get("tid"))).getParent() instanceof EntryType)) continue;
            ArrayList<DynamicObject> entryFieldList = (ArrayList<DynamicObject>)entryMap.get(tidProperty.getParent().getName());
            if (entryFieldList == null) {
                entryFieldList = new ArrayList<DynamicObject>(10);
                entryMap.put(tidProperty.getParent().getName(), entryFieldList);
            }
            entryFieldList.add(botpRowProperty);
        }
        return entryMap;
    }

    private String getOutputTargetRowUniqueKey(DynamicObject row, List<DynamicObject> rowUniqueFields) {
        StringBuilder key = new StringBuilder(10);
        for (DynamicObject rowUniqueField : rowUniqueFields) {
            String fieldId = rowUniqueField.getString("tid");
            Object obj = row.get(fieldId);
            String value = obj == null ? "" : (obj instanceof DynamicObject ? ((DynamicObject)obj).getPkValue().toString() : obj.toString());
            key.append(value).append("_");
        }
        return key.toString();
    }

    private String getResultRowUniqueKey(Object[] rowData, List<DynamicObject> rowUniqueFields) {
        StringBuilder key = new StringBuilder(10);
        Continue isContinue = new Continue();
        for (DynamicObject rowUniqueField : rowUniqueFields) {
            Object value = this.getResultRowValue(rowUniqueField, rowData, isContinue);
            key.append(value != null ? value : "").append("_");
        }
        return key.toString();
    }

    private GroupMap groupAndSum() {
        List<DynamicObject> rowUniqueFields = RebateOutputUtil.getRowUniqueField(this.outputTargetModelObject);
        List<DynamicObject> rowUniqueSumFields = RebateOutputUtil.getRowUniqueSumField(this.outputTargetModelObject);
        GroupMap groupMap = new GroupMap();
        List<Object[]> resultObjects = this.getCalcResultObjects();
        Continue isContinue = new Continue();
        for (int i = 0; i < resultObjects.size(); ++i) {
            Object[] rowData = resultObjects.get(i);
            String groupKey = this.getResultRowUniqueKey(rowData, rowUniqueFields);
            groupMap.add(groupKey, i);
            for (DynamicObject rowUniqueSumField : rowUniqueSumFields) {
                Object value = this.getResultRowValue(rowUniqueSumField, rowData, isContinue);
                String field = rowUniqueSumField.getString("tid");
                groupMap.addSumData(groupKey, field, (BigDecimal)value);
            }
        }
        return groupMap;
    }

    private void setSumData(DynamicObject rowData, Grouper grouper, List<DynamicObject> rowUniqueSumFields) {
        for (DynamicObject rowUniqueSumField : rowUniqueSumFields) {
            if (rowUniqueSumField == null || rowData == null || !this.isCanUpdate(rowUniqueSumField, rowData)) continue;
            String field = rowUniqueSumField.getString("tid");
            rowData.set(field, (Object)grouper.getSumData().get(field));
        }
    }

    private String getOutputObjectFormId() {
        return RebateOutputUtil.getTargetFormId(this.outputTargetModelObject);
    }

    private Map<String, IDataEntityProperty> getOutputObjectFields() {
        return EntityMetadataCache.getDataEntityType((String)this.getOutputObjectFormId()).getAllFields();
    }

    public List<Object[]> getCalcResultObjects() {
        return this.calcResultObjects;
    }

    public void setCalcResultObjects(List<Object[]> calcResultObjects) {
        this.calcResultObjects = calcResultObjects;
    }

    public DynamicObject getMainDataObject() {
        return this.mainDataObject;
    }

    public void setMainDataObject(DynamicObject mainDataObject) {
        this.mainDataObject = mainDataObject;
    }

    public String getRebateTargetBillno() {
        return this.rebateTargetBillno;
    }

    private Object getSrcRebateTargetValue(String fieldName) {
        return this.srcRebateTargetObject.get(fieldName);
    }

    private void logResult(OperationResult operationResult, String rebateTargetNumber, Object rebateObjectId) {
        if (operationResult.isSuccess()) {
            logger.info(String.format("rebateConvert:RebateObjectId: %s, %s Convert success ,preObj:%s", rebateObjectId, rebateTargetNumber, operationResult.getBillNos().get("0")));
        } else {
            logger.info(String.format("rebateConvert:RebateObjectId: %s, %s Convert fail: %s", rebateObjectId, rebateTargetNumber, this.getErrorInfo(operationResult)));
        }
    }

    private String getErrorInfo(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            List errorInfos = operationResult.getAllErrorOrValidateInfo();
            StringBuilder result = new StringBuilder();
            for (IOperateInfo errorInfo : errorInfos) {
                result.append(errorInfo.getMessage()).append("\n");
            }
            return result.toString();
        }
        return "";
    }

    private String getNoDataType() {
        String nodatamodel = this.outputTargetModelObject.getString("nodatamodel");
        return (StringUtils.isEmpty((String)nodatamodel) ? "A" : nodatamodel).toLowerCase();
    }
}

