/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.common.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.occpibc.engine.common.RebateCalcTaskInfo;
import kd.occ.occpibc.engine.common.rebate.RebateOutputUtil;

public class BotpConverter {
    private RowMeta rowMeta;
    private RebateCalcTaskInfo taskInfo;
    private DynamicObject rebateModelObject;
    private Object rebateObjectId;
    private List<Object[]> calcResultObjects;
    private DynamicObject modelTargetObject;
    private DynamicObject targetMainDataObject;

    public BotpConverter(RowMeta rowMeta, RebateCalcTaskInfo taskInfo, DynamicObject rebateModelObject, Object rebateObjectId) {
        this.rowMeta = rowMeta;
        this.taskInfo = taskInfo;
        this.rebateModelObject = rebateModelObject;
        this.rebateObjectId = rebateObjectId;
    }

    public final void out() {
        Long srcTargetId = this.taskInfo.getSrcTargets().get(this.rebateObjectId.toString());
        if (srcTargetId == null) {
            return;
        }
        DynamicObject srcRebateTargetObject = BusinessDataServiceHelper.loadSingle((Object)srcTargetId, (String)"occpic_rebatetarget");
        this.modelTargetObject = RebateOutputUtil.getTargetInfo(this.rebateModelObject.getPkValue());
        this.targetMainDataObject = this.convertBillInfo(srcRebateTargetObject);
        this.convetResult();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)RebateOutputUtil.getTargetFormId(this.modelTargetObject), (DynamicObject[])new DynamicObject[]{this.targetMainDataObject}, (OperateOption)OperateOption.create());
        this.throwErrorIfHas(operationResult);
    }

    private DynamicObject buildDynamicObject(DynamicObject modelTargetObject) {
        String targetFormId = RebateOutputUtil.getTargetFormId(modelTargetObject);
        return BusinessDataServiceHelper.newDynamicObject((String)targetFormId);
    }

    private DynamicObject convertBillInfo(DynamicObject srcRebateTargetObject) {
        DynamicObject dataOjbect = this.buildDynamicObject(this.modelTargetObject);
        Map allFields = EntityMetadataCache.getDataEntityType((String)"occpic_rebatetarget").getAllFields();
        DynamicObjectCollection botpProperties = this.modelTargetObject.getDynamicObjectCollection("botpentry");
        for (DynamicObject botpProperty : botpProperties) {
            String tid = botpProperty.getString("tid");
            String stid = botpProperty.getString("stid");
            Object value = null;
            if (!StringUtil.isEmpty((String)stid)) {
                if (((IDataEntityProperty)allFields.get(stid)).getParent() instanceof EntryType) continue;
                value = srcRebateTargetObject.get(stid);
            } else {
                if (!StringUtil.isNotEmpty((String)botpProperty.getString("conststr"))) continue;
                value = botpProperty.getString("conststr");
                if (value.equals("currentdate()")) {
                    value = TimeServiceHelper.now();
                }
            }
            DynamicProperty dynamicProperty = dataOjbect.getDynamicObjectType().getProperty(tid);
            if (dynamicProperty instanceof BasedataProp && !(value instanceof DynamicObject)) {
                dataOjbect.set(tid + "_id", value);
                continue;
            }
            dataOjbect.set(tid, value);
        }
        return dataOjbect;
    }

    private void convetResult() {
        Map<String, List<DynamicObject>> entryMap = this.getEntryWithResultMap();
        for (Map.Entry<String, List<DynamicObject>> entry : entryMap.entrySet()) {
            String entrykey = entry.getKey();
            DynamicObjectCollection entryRowCollection = this.targetMainDataObject.getDynamicObjectCollection(entrykey);
            DynamicObjectType entryDynamicObjectType = entryRowCollection.getDynamicObjectType();
            for (Object[] data : this.getCalcResultObjects()) {
                DynamicObject rowData = entryRowCollection.addNew();
                for (DynamicObject botpRowData : entry.getValue()) {
                    String rid = botpRowData.getString("rid");
                    int fieldIndex = this.rowMeta.getFieldIndex(rid);
                    String tid = botpRowData.getString("tid");
                    DynamicProperty dynamicProperty = entryDynamicObjectType.getProperty(tid);
                    if (dynamicProperty instanceof BasedataProp) {
                        rowData.set(tid + "_id", data[fieldIndex]);
                        continue;
                    }
                    rowData.set(tid, data[fieldIndex]);
                }
            }
            BusinessDataServiceHelper.loadRefence((Object[])entryRowCollection.toArray((Object[])new DynamicObject[entryRowCollection.size()]), (IDataEntityType)entryRowCollection.getDynamicObjectType());
        }
    }

    private Map<String, List<DynamicObject>> getEntryWithResultMap() {
        Map allTargetObjectFields = EntityMetadataCache.getDataEntityType((String)RebateOutputUtil.getTargetFormId(this.modelTargetObject)).getAllFields();
        DynamicObjectCollection botpProperties = this.modelTargetObject.getDynamicObjectCollection("botpentry");
        HashMap<String, List<DynamicObject>> entryMap = new HashMap<String, List<DynamicObject>>(2);
        for (DynamicObject botpProperty : botpProperties) {
            IDataEntityProperty tidProperty;
            if (!StringUtil.isNotEmpty((String)botpProperty.getString("rid")) || !((tidProperty = (IDataEntityProperty)allTargetObjectFields.get(botpProperty.get("tid"))).getParent() instanceof EntryType)) continue;
            ArrayList<DynamicObject> entryFieldList = (ArrayList<DynamicObject>)entryMap.get(tidProperty.getParent().getName());
            if (entryFieldList == null) {
                entryFieldList = new ArrayList<DynamicObject>(10);
                entryMap.put(tidProperty.getParent().getName(), entryFieldList);
            }
            entryFieldList.add(botpProperty);
        }
        return entryMap;
    }

    private void throwErrorIfHas(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            List errorInfos = operationResult.getAllErrorOrValidateInfo();
            StringBuilder result = new StringBuilder();
            for (IOperateInfo errorInfo : errorInfos) {
                result.append(errorInfo.getMessage()).append("\n");
            }
            throw new KDBizException(result.toString());
        }
    }

    public List<Object[]> getCalcResultObjects() {
        return this.calcResultObjects;
    }

    public void setCalcResultObjects(List<Object[]> calcResultObjects) {
        this.calcResultObjects = calcResultObjects;
    }
}

