/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.common.kpi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occpibc.engine.common.GroupCalcResult;
import kd.occ.occpibc.engine.common.kpi.filter.AbstractLadderFilter;
import kd.occ.occpibc.engine.common.kpi.filter.LadderDefaultFilter;
import kd.occ.occpibc.engine.common.kpi.ladder.AbstractLadder;

public class Kpi
implements Serializable {
    private static final long serialVersionUID = -2160027217459363500L;
    private String field;
    private QFilter condition;
    private List<AbstractLadder> ladderList;
    private AbstractLadderFilter ladderFilter;
    private String calcType;

    public QFilter getCondition() {
        return this.condition;
    }

    public void setCondition(QFilter condition) {
        this.condition = condition;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
        List<AbstractLadder> ladderList = this.getLadderList();
        if (ladderList == null || ladderList.size() == 0) {
            return;
        }
        for (AbstractLadder ladder : ladderList) {
            ladder.setField(field);
        }
    }

    public String[] getConditionVariables() {
        if (StringUtils.isNotEmpty((Object)this.condition)) {
            return FormulaEngine.extractVariables((String)this.condition.toString());
        }
        return new String[0];
    }

    public String[] getAllVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(this.field);
        String[] conditionVars = this.getConditionVariables();
        if (conditionVars != null && conditionVars.length > 0) {
            variables.addAll(Arrays.asList(conditionVars));
        }
        return variables.toArray(new String[variables.size()]);
    }

    public List<AbstractLadder> getLadderList() {
        return this.ladderList;
    }

    public void addLadder(AbstractLadder ladder) {
        if (this.ladderList == null) {
            this.ladderList = new ArrayList<AbstractLadder>(6);
        }
        ladder.setField(this.getField());
        this.ladderList.add(ladder);
    }

    public AbstractLadderFilter getLadderFilter() {
        if (this.ladderFilter == null) {
            this.ladderFilter = new LadderDefaultFilter();
            this.ladderFilter.setKpi(this);
        }
        return this.ladderFilter;
    }

    public void setLadderFilter(AbstractLadderFilter ladderFilter) {
        this.ladderFilter = ladderFilter;
        this.ladderFilter.setKpi(this);
    }

    public AbstractLadder compareLadder(GroupCalcResult groupCalcResult) {
        for (AbstractLadder ladder : this.ladderList) {
            if (!ladder.compare(groupCalcResult)) continue;
            return ladder;
        }
        return null;
    }

    public String getCalcType() {
        return this.calcType;
    }

    public void setCalcType(String calcType) {
        this.calcType = calcType;
    }
}

