/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.common.kpi.ladder;

import java.math.BigDecimal;
import kd.occ.occpibc.engine.common.GroupCalcResult;
import kd.occ.occpibc.engine.common.kpi.ladder.AbstractLadder;

public class QtyRateLadder
extends AbstractLadder {
    private BigDecimal baseLineQty;
    private BigDecimal minQtyRate;
    private BigDecimal maxQtyRate;

    public QtyRateLadder(BigDecimal baseLineQty, BigDecimal minQtyRate, BigDecimal maxQtyRate) {
        this.baseLineQty = baseLineQty;
        this.minQtyRate = minQtyRate;
        this.maxQtyRate = maxQtyRate;
    }

    public BigDecimal getBaseLineQty() {
        return this.baseLineQty;
    }

    public void setBaseLineQty(BigDecimal baseLineQty) {
        this.baseLineQty = baseLineQty;
    }

    public BigDecimal getMinQtyRate() {
        return this.minQtyRate;
    }

    public void setMinQtyRate(BigDecimal minQtyRate) {
        this.minQtyRate = minQtyRate;
    }

    public BigDecimal getMaxQtyRate() {
        return this.maxQtyRate;
    }

    public void setMaxQtyRate(BigDecimal maxQtyRate) {
        this.maxQtyRate = maxQtyRate;
    }

    @Override
    public boolean compare(GroupCalcResult row) {
        boolean isGreater;
        BigDecimal totalQty = row.get(this.getField());
        boolean bl = this.minQtyRate == null ? true : (isGreater = totalQty.compareTo(this.baseLineQty.multiply(this.minQtyRate.divide(BigDecimal.valueOf(100L)))) >= 0);
        boolean isLess = this.maxQtyRate == null || this.maxQtyRate.compareTo(BigDecimal.ZERO) == 0 ? true : totalQty.compareTo(this.baseLineQty.multiply(this.maxQtyRate.divide(BigDecimal.valueOf(100L)))) < 0;
        return totalQty != null && isGreater && isLess;
    }
}

