/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.common.rebate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.occ.ocbase.common.util.EntityUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occpibc.engine.common.rebate.CalFieldInfo;
import kd.occ.occpibc.engine.common.util.EngineUtil;

public class RebateModelUtil {
    public static final DynamicObject getModelMetadata(DynamicObject rebateModel) {
        return rebateModel.getDynamicObject("metadataid");
    }

    public static final String getModelEntityId(DynamicObject rebateModel) {
        DynamicObject metadata = RebateModelUtil.getModelMetadata(rebateModel);
        if (metadata != null) {
            return (String)metadata.getPkValue();
        }
        return "";
    }

    public static final List<IDataEntityProperty> getModelMetadatasProperties(DynamicObject rebateModel) {
        String formId = RebateModelUtil.getModelEntityId(rebateModel);
        if (StringUtils.isEmpty((String)formId)) {
            return new ArrayList<IDataEntityProperty>(1);
        }
        return EngineUtil.getEntityAllDefinedField(formId);
    }

    public static final DynamicObjectCollection getBotpPropertis(DynamicObject sourceBill) {
        RebateModelUtil.checkSourceBill(sourceBill);
        return sourceBill.getDynamicObjectCollection("propertisentity");
    }

    public static final String getSourceBillEntityId(DynamicObject sourceBill) {
        RebateModelUtil.checkSourceBill(sourceBill);
        return (String)sourceBill.getDynamicObject("sourcebill").getPkValue();
    }

    public static final String getBotpRebateModelPropertyId(DynamicObject botpObject) {
        return botpObject.getString("irebatepropid");
    }

    public static final String getBotpSourceBillPropertyId(DynamicObject botpObject) {
        return botpObject.getString("sourcefieldid");
    }

    private static final void checkSourceBill(DynamicObject sourceBill) {
        if (sourceBill == null) {
            throw new KDBizException("rebate source is null");
        }
    }

    public static final List<IDataEntityProperty> getCalcModelFieldList(DynamicObject rebateModel) {
        String formId = RebateModelUtil.getModelEntityId(rebateModel);
        if (StringUtils.isNotEmpty((String)formId)) {
            return EngineUtil.getEntityAllDefinedField(formId);
        }
        return new ArrayList<IDataEntityProperty>(0);
    }

    public static final Map<String, CalFieldInfo> getCalcFields(DynamicObject rebateModel) {
        HashMap<String, CalFieldInfo> ret = new HashMap<String, CalFieldInfo>(6);
        if (rebateModel == null) {
            return ret;
        }
        return rebateModel.getDynamicObjectCollection("calcpropentry").stream().map(v -> new CalFieldInfo(v.getString("calcpropid"), v.getString("linkpropid"), v.getString("calmodeltype"), v.getString("specdimfield"))).collect(Collectors.toMap(v -> v.getKey(), v -> v));
    }

    public static final Map<String, CalFieldInfo> getCalcFields(DynamicObject rebateModel, String[] expVariables) {
        if (expVariables == null || expVariables.length == 0) {
            return new HashMap<String, CalFieldInfo>(1);
        }
        Map<String, CalFieldInfo> allCalcFields = RebateModelUtil.getCalcFields(rebateModel);
        List<String> expVariableList = Arrays.asList(expVariables);
        return allCalcFields.entrySet().stream().filter(v -> expVariableList.contains(v.getKey())).collect(Collectors.toMap(v -> (String)v.getKey(), v -> (CalFieldInfo)v.getValue()));
    }

    public static final Map<String, List<String>> getCalFieldsByDimension(DynamicObject rebateModel, String defaultDimension) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        if (rebateModel == null) {
            return ret;
        }
        DynamicObjectCollection calPropentyCollection = rebateModel.getDynamicObjectCollection("calcpropentry");
        for (DynamicObject calProperty : calPropentyCollection) {
            String dim = calProperty.getString("specdimfield") == null ? defaultDimension : calProperty.getString("specdimfield");
            ArrayList<String> fields = (ArrayList<String>)ret.get(dim);
            if (fields == null) {
                fields = new ArrayList<String>(2);
                ret.put(dim, fields);
            }
            fields.add(calProperty.getString("calcpropid"));
        }
        return ret;
    }

    public static final List<String> getDimension(DynamicObject rebateModel) {
        Map<String, String> calcModelPropertiesMap = RebateModelUtil.getCalcModelFieldList(rebateModel).stream().collect(Collectors.toMap(v -> v.getName(), v -> v.getDisplayName().getLocaleValue()));
        return rebateModel.getDynamicObjectCollection("propertyentry").stream().filter(v -> v.getString("propertytype").equalsIgnoreCase("a") && calcModelPropertiesMap.containsKey(v.getString("propid"))).map(x -> x.getString("propid")).collect(Collectors.toList());
    }

    public static final Map<String, DynamicObject> getRebateModelProperties(DynamicObject rebateModel) {
        return rebateModel.getDynamicObjectCollection("propertyentry").stream().collect(Collectors.toMap(v -> v.getString("propid"), v -> v));
    }

    public static final Map<String, String> getBotpProperties(DynamicObject sourceBill) {
        DynamicObjectCollection properties = RebateModelUtil.getBotpPropertis(sourceBill);
        String sourceEntityId = RebateModelUtil.getSourceBillEntityId(sourceBill);
        MainEntityType sourceEntityType = EntityUtil.getMainEntityType((String)sourceEntityId);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (DynamicObject property : properties) {
            String sourcePropertyId = EntityUtil.getColFullId((MainEntityType)sourceEntityType, (String)RebateModelUtil.getBotpSourceBillPropertyId(property));
            String rebateModelPropertyId = RebateModelUtil.getBotpRebateModelPropertyId(property);
            propertiesMap.put(rebateModelPropertyId, sourcePropertyId);
        }
        return propertiesMap;
    }
}

