/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.handler.algox;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.occpibc.engine.IRebateEngineHandler;
import kd.occ.occpibc.engine.common.RebateCalcTaskInfo;
import kd.occ.occpibc.engine.common.kpi.Kpi;
import kd.occ.occpibc.engine.common.rebate.RebateModelHelper;
import kd.occ.occpibc.engine.handler.algox.common.DataServiceHandleInfo;
import kd.occ.occpibc.engine.handler.algox.common.RebateCalCtx;
import kd.occ.occpibc.engine.handler.algox.metadata.OutputHelper;
import kd.occ.occpibc.engine.handler.algox.service.AbstractDataService;
import kd.occ.occpibc.engine.handler.algox.service.AbstractInputService;
import kd.occ.occpibc.engine.handler.algox.service.DataServiceHelper;

public class RebateEngineAlgoxHandler
implements IRebateEngineHandler {
    private static Log logger = LogFactory.getLog(RebateEngineAlgoxHandler.class);
    private RebateCalcTaskInfo rebateCalcTaskInfo;
    private DynamicObject[] sourceBills;
    private DynamicObject rebateModel;
    private JobSession session;

    public static final RebateEngineAlgoxHandler get() {
        return new RebateEngineAlgoxHandler();
    }

    @Override
    public final DataSet execute(RebateCalcTaskInfo rebateCalcTaskInfo) {
        this.init(rebateCalcTaskInfo);
        return this.run();
    }

    private void init(RebateCalcTaskInfo rebateCalcTaskInfo) {
        this.rebateCalcTaskInfo = rebateCalcTaskInfo;
        this.rebateModel = RebateModelHelper.getRebateModel(rebateCalcTaskInfo.getRebateModelId());
        if (this.rebateModel == null) {
            throw new KDBizException(String.format("No %s's  RebateModel", rebateCalcTaskInfo.getRebateModelId()));
        }
        this.sourceBills = RebateModelHelper.getSourceBills((Long)this.rebateModel.getPkValue());
    }

    private DataSet run() {
        this.session = AlgoX.createSession((String)"occ_rebateengine", (String)"\u8fd4\u5229\u8ba1\u7b97");
        logger.info("rebateRunner:" + String.join((CharSequence)",", this.rebateCalcTaskInfo.getSrcTargets().entrySet().stream().map(v -> ((Long)v.getValue()).toString()).collect(Collectors.toList())) + ", Qfilter:" + this.rebateCalcTaskInfo.getQueryFilter().toString());
        ArrayList<DataSetX> resultDataSetX = new ArrayList<DataSetX>(2);
        for (Kpi kpi : this.rebateCalcTaskInfo.getKpiList()) {
            RebateCalCtx rebateCalCtx = new RebateCalCtx(this.rebateModel, this.sourceBills, this.rebateCalcTaskInfo, kpi);
            DataSetX dataSetX = this.createSourceDataSetx(rebateCalCtx);
            dataSetX = this.doCalc(rebateCalCtx, dataSetX);
            resultDataSetX.add(dataSetX);
        }
        DataSetX retDataSetx = this.merge(resultDataSetX);
        if (retDataSetx == null) {
            return null;
        }
        retDataSetx = retDataSetx.orderBy(new String[]{this.rebateCalcTaskInfo.getRebateObjectField()});
        logger.info("RebateEngine.algox 8output");
        Output output = OutputHelper.createOutput(this.rebateCalcTaskInfo, retDataSetx.getRowMeta(), this.rebateModel);
        retDataSetx.output(output);
        this.session.commit(7200, TimeUnit.SECONDS);
        return this.rebateCalcTaskInfo.isTest() ? this.session.readDataSet(((DataSetOutput)output).getId()) : null;
    }

    private DataSetX createSourceDataSetx(RebateCalCtx rebateCalCtx) {
        List<AbstractInputService> datsServiceList = DataServiceHelper.getInputService(rebateCalCtx);
        DataSetX resultDataSetX = null;
        for (AbstractInputService inputService : datsServiceList) {
            inputService.init(rebateCalCtx);
            Input[] inputs = inputService.createInputs();
            DataSetX inputDataSetX = this.session.fromInput(inputs);
            resultDataSetX = resultDataSetX == null ? inputDataSetX : resultDataSetX.union(inputDataSetX);
        }
        return resultDataSetX;
    }

    private DataSetX merge(List<DataSetX> sourceDataSetXList) {
        DataSetX retDataSet = null;
        for (DataSetX dataSetX : sourceDataSetXList) {
            if (retDataSet == null) {
                retDataSet = dataSetX;
                continue;
            }
            retDataSet = retDataSet.union(dataSetX);
        }
        return retDataSet;
    }

    private DataSetX doCalc(RebateCalCtx rebateCalCtx, DataSetX sourceDataSetX) {
        AbstractDataService dataService = DataServiceHelper.getDataService();
        dataService.init(rebateCalCtx);
        DataServiceHandleInfo dataServiceHandleInfo = new DataServiceHandleInfo();
        dataServiceHandleInfo.setExpVar(DataServiceHelper.getDefaultExtVar(rebateCalCtx));
        rebateCalCtx.setDataServiceExecInfo(dataServiceHandleInfo);
        return dataService.handData(sourceDataSetX);
    }

    private DataSetX doFilter(RebateCalCtx rebateCalCtx, DataSetX sourceDataSetX) {
        return rebateCalCtx.getKpi().getLadderFilter().doFilter(sourceDataSetX);
    }
}

