/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.handler.algox.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.util.StringUtils;
import kd.occ.occpibc.engine.common.RebateCalcTaskInfo;
import kd.occ.occpibc.engine.common.kpi.Kpi;
import kd.occ.occpibc.engine.common.rebate.CalFieldInfo;
import kd.occ.occpibc.engine.common.rebate.RebateModelUtil;
import kd.occ.occpibc.engine.handler.algox.common.DataServiceHandleInfo;

public class RebateCalCtx {
    private DynamicObject rebateModel;
    private DynamicObject[] sourceBills;
    private RebateCalcTaskInfo rebateCalcTaskInfo;
    private Kpi kpi;
    private RowMeta rowMeta;
    private DataServiceHandleInfo dataServiceExecInfo;
    private Map<String, CalFieldInfo> calFieldInfos;
    private String qtyField;
    private String amountField;
    private String jobId;

    public RebateCalCtx(DynamicObject rebateModel, DynamicObject[] sourceBills, RebateCalcTaskInfo rebateCalcTaskInfo, Kpi kpi) {
        this.rebateModel = rebateModel;
        this.sourceBills = sourceBills;
        this.rebateCalcTaskInfo = rebateCalcTaskInfo;
        this.kpi = kpi;
        this.initQtyAmountField();
        this.jobId = DB.genStringId((String)"rebate");
    }

    public DynamicObject getRebateModel() {
        return this.rebateModel;
    }

    public void setRebateModel(DynamicObject rebateModel) {
        this.rebateModel = rebateModel;
    }

    public DynamicObject[] getSourceBills() {
        return this.sourceBills;
    }

    public void setSourceBills(DynamicObject[] sourceBills) {
        this.sourceBills = sourceBills;
    }

    public RebateCalcTaskInfo getRebateCalcTaskInfo() {
        return this.rebateCalcTaskInfo;
    }

    public void setRebateCalcTaskInfo(RebateCalcTaskInfo rebateCalcTaskInfo) {
        this.rebateCalcTaskInfo = rebateCalcTaskInfo;
    }

    public Kpi getKpi() {
        return this.kpi;
    }

    public void setKpi(Kpi kpi) {
        this.kpi = kpi;
    }

    public String[] getDimensions() {
        String[] fields = this.kpi.getAllVariables();
        Map<String, CalFieldInfo> calFields = RebateModelUtil.getCalcFields(this.rebateModel);
        ArrayList<String> dims = new ArrayList<String>();
        dims.add(this.rebateCalcTaskInfo.getRebateObjectField());
        for (String field : fields) {
            if (calFields.containsKey(field)) continue;
            dims.add(field);
        }
        return dims.toArray(new String[dims.size()]);
    }

    public String[] getGroupKey() {
        ArrayList<String> dims = new ArrayList<String>();
        dims.add(this.rebateCalcTaskInfo.getRebateObjectField());
        return dims.toArray(new String[dims.size()]);
    }

    public List<String> getAllVariables() {
        String[] fields = this.kpi.getAllVariables();
        List<String> fieldList = Arrays.stream(fields).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((String)this.rebateCalcTaskInfo.getRebateObjectField())) {
            fieldList.add(this.rebateCalcTaskInfo.getRebateObjectField());
        }
        return fieldList;
    }

    public Map<String, CalFieldInfo> getCalFieldInfos() {
        if (this.calFieldInfos == null) {
            this.calFieldInfos = RebateModelUtil.getCalcFields(this.rebateModel);
        }
        return this.calFieldInfos;
    }

    private void initQtyAmountField() {
        DynamicObjectCollection propertyCollection = this.rebateModel.getDynamicObjectCollection("propertyentry");
        for (DynamicObject propertyObject : propertyCollection) {
            String propertyType = propertyObject.getString("propertytype");
            if (propertyType == null) continue;
            if (propertyType.equalsIgnoreCase("a")) {
                this.amountField = propertyObject.getString("propid");
                continue;
            }
            if (!propertyType.equalsIgnoreCase("b")) continue;
            this.qtyField = propertyObject.getString("propid");
        }
    }

    public String getDimension() {
        CharSequence[] dims = this.getDimensions();
        return String.join((CharSequence)",", dims);
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public DataServiceHandleInfo getDataServiceExecInfo() {
        return this.dataServiceExecInfo;
    }

    public void setDataServiceExecInfo(DataServiceHandleInfo dataServiceExecInfo) {
        this.dataServiceExecInfo = dataServiceExecInfo;
    }

    public String getQtyField() {
        return this.qtyField;
    }

    public String getAmountField() {
        return this.amountField;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }
}

