/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.handler.algox.func;

import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.occpibc.engine.common.GroupCalcResult;
import kd.occ.occpibc.engine.common.kpi.Kpi;
import kd.occ.occpibc.engine.common.kpi.ladder.AbstractLadder;
import kd.occ.occpibc.engine.common.rebate.CalFieldInfo;
import kd.occ.occpibc.engine.handler.algox.common.GroupSumResultStorage;

public class FilterLadderFunc
extends GroupReduceFunction {
    private static Log logger = LogFactory.getLog(FilterLadderFunc.class);
    private static final long serialVersionUID = -4503267073992488423L;
    private List<String> keys;
    private Map<String, CalFieldInfo> calFieldInfoMap;
    private RowMeta rowMeta;
    private Kpi kpi;
    private static final String SUM = "a";
    private static final String AVG = "b";
    private int qtyFieldIndex;
    private int amountFieldIndex;
    private String jobId;
    private String[] groupFields;

    public FilterLadderFunc(List<String> keys, Map<String, CalFieldInfo> calFieldInfoMap, RowMeta rowMeta, Kpi kpi) {
        this.keys = keys;
        this.calFieldInfoMap = calFieldInfoMap;
        this.rowMeta = rowMeta;
        this.kpi = kpi;
    }

    public void initQtyAmountField(String qtyField, String amountField) {
        this.qtyFieldIndex = this.rowMeta.getFieldIndex(qtyField);
        this.amountFieldIndex = this.rowMeta.getFieldIndex(amountField);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        logger.info("RebateEngine.algox docalc: begin");
        GroupCalcResult groupCalcResult = new GroupCalcResult();
        StringBuilder groupKey = new StringBuilder();
        AbstractLadder ladder = null;
        for (RowX rowx : iterable) {
            if (groupKey.length() == 0) {
                for (String key : this.groupFields) {
                    groupKey.append(rowx.get(this.rowMeta.getFieldIndex(key))).append(".");
                }
                ladder = GroupSumResultStorage.getMatchedLadder(this.getJobId(), groupKey.toString());
            }
            if (ladder == null) continue;
            this.setDefaultValue(rowx, ladder);
            collector.collect(rowx);
        }
    }

    private void setDefaultValue(RowX rowx, AbstractLadder ladder) {
        this.setCustomValue(rowx, "irebatepoint", ladder.getRebatepoint());
        this.setCustomValue(rowx, "iunitrebate", ladder.getUnitrebate());
        this.setCustomValue(rowx, "ifixedamount", ladder.getFixedamount());
        this.setCustomValue(rowx, "igroupno", ladder.getGroupNo());
    }

    private void setCustomValue(RowX rowx, String field, Object value) {
        int fieldIndex = this.getResultRowMeta().getFieldIndex(field);
        rowx.set(fieldIndex, value);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String[] getGroupFields() {
        return this.groupFields;
    }

    public void setGroupFields(String[] groupFields) {
        this.groupFields = groupFields;
    }
}

