/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.handler.algox.func;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.occ.occpibc.engine.common.GroupCalcResult;
import kd.occ.occpibc.engine.common.kpi.Kpi;
import kd.occ.occpibc.engine.common.kpi.ladder.AbstractLadder;
import kd.occ.occpibc.engine.common.rebate.CalFieldInfo;

public class LadderReduceGroupFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = -4503267073992488423L;
    private Map<String, CalFieldInfo> calFieldInfoMap;
    private RowMeta rowMeta;
    private Kpi kpi;
    private static final String SUM = "a";
    private static final String AVG = "b";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("RebateEngine");

    public LadderReduceGroupFunc(List<String> keys, Map<String, CalFieldInfo> calFieldInfoMap, RowMeta rowMeta, Kpi kpi) {
        this.calFieldInfoMap = calFieldInfoMap;
        this.rowMeta = rowMeta;
        this.kpi = kpi;
    }

    public void initQtyAmountField(String qtyField, String amountField) {
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        GroupCalcResult groupCalcResult = new GroupCalcResult();
        ArrayList<RowX> copy = new ArrayList<RowX>();
        StringBuilder ids = new StringBuilder();
        for (RowX rowx : iterable) {
            for (Map.Entry<String, CalFieldInfo> calFieldInfos : this.calFieldInfoMap.entrySet()) {
                CalFieldInfo calFieldInfo = calFieldInfos.getValue();
                switch (calFieldInfo.getModelType().toLowerCase(Locale.ENGLISH)) {
                    case "a": {
                        groupCalcResult.add(calFieldInfo.getKey(), rowx.getBigDecimal(this.rowMeta.getFieldIndex(calFieldInfo.getField())));
                        break;
                    }
                }
            }
            ids.append(rowx.getLong(this.rowMeta.getFieldIndex("material"))).append(",");
            copy.add(rowx);
        }
        AbstractLadder ladder = this.kpi.compareLadder(groupCalcResult);
        if (ladder != null) {
            int maxSize = copy.size();
            for (int i = 0; i < maxSize; ++i) {
                RowX rowx = (RowX)copy.get(i);
                this.setDefaultValue(rowx, ladder);
                collector.collect(rowx);
            }
        }
    }

    private void setDefaultValue(RowX rowx, AbstractLadder ladder) {
        this.setCustomValue(rowx, "irebatepoint", ladder.getRebatepoint());
        this.setCustomValue(rowx, "iunitrebate", ladder.getUnitrebate());
        this.setCustomValue(rowx, "ifixedamount", ladder.getFixedamount());
        this.setCustomValue(rowx, "igroupno", ladder.getGroupNo());
    }

    private void setCustomValue(RowX rowx, String field, Object value) {
        int fieldIndex = this.getResultRowMeta().getFieldIndex(field);
        rowx.set(fieldIndex, value);
    }
}

