/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.handler.algox.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occpibc.engine.common.ExpVariable;
import kd.occ.occpibc.engine.common.rebate.CalFieldInfo;
import kd.occ.occpibc.engine.common.rebate.RebateModelUtil;
import kd.occ.occpibc.engine.handler.algox.common.RebateCalCtx;
import kd.occ.occpibc.engine.handler.algox.service.AbstractDataService;
import kd.occ.occpibc.engine.handler.algox.service.AbstractInputService;
import kd.occ.occpibc.engine.handler.algox.service.impl.DefaultDataService;
import kd.occ.occpibc.engine.handler.algox.service.impl.DefaultInputService;

public class DataServiceHelper {
    public static final List<AbstractInputService> getInputService(RebateCalCtx rebateCalCtx) {
        Map<String, ExpVariable> expVariableMap = DataServiceHelper.groupVariable(rebateCalCtx);
        ArrayList<AbstractInputService> dataServiceList = new ArrayList<AbstractInputService>(2);
        dataServiceList.add(DataServiceHelper.getDefaultInputService(expVariableMap));
        List<AbstractInputService> customDataService = DataServiceHelper.getCustomDataService(expVariableMap);
        if (customDataService != null) {
            dataServiceList.addAll(customDataService);
        }
        return dataServiceList;
    }

    public static final AbstractDataService getDataService() {
        DefaultDataService service = new DefaultDataService();
        return service;
    }

    private static final AbstractInputService getDefaultInputService(Map<String, ExpVariable> expVariableMap) {
        ExpVariable expVar = expVariableMap.entrySet().stream().filter(v -> ((ExpVariable)v.getValue()).isDefault()).map(v -> (ExpVariable)v.getValue()).findFirst().get();
        DefaultInputService defaultService = new DefaultInputService();
        defaultService.setExpVar(expVar);
        return defaultService;
    }

    private static final List<AbstractInputService> getCustomDataService(Map<String, ExpVariable> expVariableMap) {
        List customerDimExpList = expVariableMap.entrySet().stream().filter(v -> !((ExpVariable)v.getValue()).isDefault()).map(v -> (ExpVariable)v.getValue()).collect(Collectors.toList());
        for (ExpVariable expVariable : customerDimExpList) {
        }
        return null;
    }

    public static ExpVariable getDefaultExtVar(RebateCalCtx rebateCalCtx) {
        Map<String, ExpVariable> expVariableMap = DataServiceHelper.groupVariable(rebateCalCtx);
        ExpVariable expVar = expVariableMap.entrySet().stream().filter(v -> ((ExpVariable)v.getValue()).isDefault()).map(v -> (ExpVariable)v.getValue()).findFirst().get();
        return expVar;
    }

    protected static Map<String, ExpVariable> groupVariable(RebateCalCtx rebateCalCtx) {
        String[] expVariables;
        Map<String, CalFieldInfo> allCalFields = RebateModelUtil.getCalcFields(rebateCalCtx.getRebateModel());
        HashMap<String, ExpVariable> groupedVariables = new HashMap<String, ExpVariable>(2);
        for (String expVar : expVariables = rebateCalCtx.getKpi().getAllVariables()) {
            ExpVariable expVariable;
            CalFieldInfo calFieldInfo = allCalFields.get(expVar);
            if (calFieldInfo == null) continue;
            if (StringUtils.isNotEmpty((String)calFieldInfo.getPlugin())) {
                expVariable = new ExpVariable();
                expVariable.setDefault(false);
                expVariable.setDim(calFieldInfo.getSpecDim());
                expVariable.setPlugin(calFieldInfo.getPlugin());
                groupedVariables.put(calFieldInfo.getPlugin(), expVariable);
            } else {
                String dim = rebateCalCtx.getDimension();
                expVariable = (ExpVariable)groupedVariables.get(dim);
                if (expVariable == null) {
                    expVariable = new ExpVariable();
                }
                expVariable.setDim(dim);
                groupedVariables.put(expVariable.getDim(), expVariable);
            }
            expVariable.getKeys().add(expVar);
        }
        return groupedVariables;
    }
}

