/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.handler.algox.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.util.EntityUtil;
import kd.occ.occpibc.engine.common.rebate.RebateModelUtil;
import kd.occ.occpibc.engine.handler.algox.service.AbstractInputService;

public class DefaultInputService
extends AbstractInputService {
    private static Log logger = LogFactory.getLog(DefaultInputService.class);

    @Override
    public Input[] createInputs() {
        if (this.getCtx().getSourceBills() == null || this.getCtx().getSourceBills().length == 0) {
            throw new KDBizException("\u6ca1\u6709\u8bbe\u7f6e\u6e90\u5355\u4fe1\u606f");
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>();
        for (DynamicObject sourceBill : this.getCtx().getSourceBills()) {
            DynamicObjectCollection properties = RebateModelUtil.getBotpPropertis(sourceBill);
            if (properties == null || properties.isEmpty()) continue;
            String sourceEntityId = RebateModelUtil.getSourceBillEntityId(sourceBill);
            MainEntityType sourceEntityType = EntityUtil.getMainEntityType((String)sourceEntityId);
            StringBuilder selectFields = new StringBuilder(50);
            for (DynamicObject property : properties) {
                String sourcePropertyId = EntityUtil.getColFullId((MainEntityType)sourceEntityType, (String)RebateModelUtil.getBotpSourceBillPropertyId(property));
                if (sourcePropertyId == null) continue;
                String rebateModelPropertyId = RebateModelUtil.getBotpRebateModelPropertyId(property);
                selectFields.append(sourcePropertyId).append(" as ").append(rebateModelPropertyId).append(",");
            }
            selectFields.deleteCharAt(selectFields.length() - 1);
            RowMeta rowMeta = this.createRowMeta(sourceEntityId, selectFields);
            OrmInput ormInput = new OrmInput("occ_rebate_input" + sourceEntityId, sourceEntityId, this.addMoreFields(selectFields), this.getQfilter(sourceBill), rowMeta);
            inputs.add(ormInput);
        }
        return inputs.toArray(new Input[inputs.size()]);
    }

    private RowMeta createRowMeta(String sourceEntityId, StringBuilder selectFields) {
        RowMeta oldRowMeta = ORM.create().createRowMeta(sourceEntityId, selectFields.toString());
        List<Field> fieldList = Arrays.stream(oldRowMeta.getFields()).collect(Collectors.toList());
        fieldList.add(new Field("iunitrebate", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("irebatepoint", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("ifixedamount", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("irebateamount", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("igroupno", (DataType)DataType.IntegerType));
        return new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
    }

    private String addMoreFields(StringBuilder selectFields) {
        selectFields.append(", 0 as ").append("iunitrebate");
        selectFields.append(", 0 as ").append("irebatepoint");
        selectFields.append(", 0 as ").append("ifixedamount");
        selectFields.append(", 0 as ").append("irebateamount");
        selectFields.append(", 0 as ").append("igroupno");
        return selectFields.toString();
    }

    private QFilter[] getQfilter(DynamicObject sourceBill) {
        QFilter mainFilter;
        String rebateObjectField = this.getCtx().getRebateCalcTaskInfo().getRebateObjectField();
        Map<String, String> botpPropertiesMap = RebateModelUtil.getBotpProperties(sourceBill);
        List rebateObjectIds = this.getCtx().getRebateCalcTaskInfo().getSrcTargets().entrySet().stream().map(v -> Long.parseLong((String)v.getKey())).collect(Collectors.toList());
        QFilter qfilter = new QFilter(botpPropertiesMap.get(rebateObjectField), "in", rebateObjectIds);
        QFilter qFilter = mainFilter = this.getCtx().getRebateCalcTaskInfo().getQueryFilter() != null ? this.getCtx().getRebateCalcTaskInfo().getQueryFilter().copy() : null;
        if (mainFilter != null) {
            this.replaceAllQfilter(mainFilter, botpPropertiesMap);
            qfilter.and(mainFilter);
        }
        logger.info("rebate,input pre qfilter:" + this.getCtx().getKpi().getCondition() != null ? this.getCtx().getKpi().getCondition().toString() : "");
        if (this.getCtx().getKpi().getCondition() != null) {
            QFilter groupNoFilter = this.getCtx().getKpi().getCondition().copy();
            this.replaceAllQfilter(groupNoFilter, botpPropertiesMap);
            qfilter.and(groupNoFilter);
        }
        logger.info("rebate,input qfilter:" + qfilter.toString());
        return qfilter.toArray();
    }

    private void replaceAllQfilter(QFilter qfilter, Map<String, String> botpPropertiesMap) {
        String destProperty = botpPropertiesMap.get(qfilter.getProperty());
        if (StringUtil.isNotEmpty((String)destProperty)) {
            qfilter.__setProperty(destProperty);
        }
        Iterator iterator = qfilter.getNests(false).iterator();
        while (iterator.hasNext()) {
            this.replaceAllQfilter(((QFilter.QFilterNest)iterator.next()).getFilter(), botpPropertiesMap);
        }
    }
}

