/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpibc.engine.handler.algox.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.occpibc.engine.botp.BotpConverter;
import kd.occ.occpibc.engine.common.RebateCalcTaskInfo;
import kd.occ.occpibc.engine.handler.algox.service.AbstractOutputService;

public class DefaultOutputService
extends AbstractOutputService
implements CustomizedOutput {
    private static Log logger = LogFactory.getLog(DefaultOutputService.class);
    private RowMeta rowMeta;
    private DynamicObject rebateModel;
    private Object currentGroupObject = null;
    private List<Object[]> groupObjects = new ArrayList<Object[]>(10);
    private int groupObjectIndex = -1;
    private RebateCalcTaskInfo calcTaskInfo;
    private Set<String> hasDataGroupObject = new HashSet<String>();
    private StringBuffer errorInfo = new StringBuffer(100);

    public DefaultOutputService(RowMeta rowMeta, RebateCalcTaskInfo calcTaskInfo, DynamicObject rebateModel) {
        this.rowMeta = rowMeta;
        this.calcTaskInfo = calcTaskInfo;
        this.rebateModel = rebateModel;
    }

    public void open() {
        logger.info("OutputOpen");
        this.groupObjectIndex = this.rowMeta.getFieldIndex(this.calcTaskInfo.getRebateObjectField());
    }

    public void write(Object[] objects) {
        if (objects == null || this.groupObjectIndex == -1) {
            return;
        }
        logger.info("OutputWriteReady");
        Object nextData = objects[this.groupObjectIndex];
        if (this.currentGroupObject == null) {
            this.currentGroupObject = nextData;
            this.hasDataGroupObject.add(nextData.toString());
        }
        if (this.currentGroupObject.equals(nextData)) {
            this.groupObjects.add(objects);
        } else {
            this.out();
            this.groupObjects.clear();
            this.groupObjects.add(objects);
            this.currentGroupObject = nextData;
            this.hasDataGroupObject.add(nextData.toString());
        }
    }

    public void close() {
        this.out();
        this.outNoData();
        this.throwErrorIfHas();
    }

    private void out() {
        this.out(this.currentGroupObject, this.groupObjects);
    }

    private void out(Object currentGroupObject, List<Object[]> groupObjects) {
        logger.info("OutputWrite:" + groupObjects.size());
        BotpConverter botpConverter = new BotpConverter(this.rowMeta, this.calcTaskInfo, this.rebateModel, currentGroupObject);
        botpConverter.setCalcResultObjects(groupObjects);
        OperationResult operationResult = botpConverter.out();
        if (operationResult != null && !operationResult.isSuccess()) {
            this.errorInfo.append("targetN:").append(botpConverter.getRebateTargetBillno());
            this.appdneResult(operationResult, this.errorInfo);
            this.errorInfo.append("\n");
        }
    }

    private void outNoData() {
        for (Map.Entry<String, Long> srcTargets : this.calcTaskInfo.getSrcTargets().entrySet()) {
            if (this.hasDataGroupObject.contains(srcTargets.getKey())) continue;
            this.out(srcTargets.getKey(), new ArrayList<Object[]>());
        }
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public boolean isSingleParallel() {
        return false;
    }

    private void throwErrorIfHas() {
        if (this.errorInfo.length() == 0) {
            return;
        }
        throw new KDBizException(this.errorInfo.toString());
    }

    private void appdneResult(OperationResult operationResult, StringBuffer result) {
        if (!operationResult.isSuccess()) {
            List errorInfos = operationResult.getAllErrorOrValidateInfo();
            result.append((String)operationResult.getBillNos().get("0")).append(":\n");
            for (IOperateInfo errorInfo : errorInfos) {
                result.append(errorInfo.getMessage()).append("\n");
            }
        }
    }
}

