/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.opplugin.rebate.rebateprebudget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class RbPrebudgetSave
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("rebatepolicytarget");
        e.getFieldKeys().add("rpprecurrency");
        e.getFieldKeys().add("totalproconsignqty");
        e.getFieldKeys().add("totalsaleamount");
        e.getFieldKeys().add("totalrebateamount");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.repolicytarget");
        e.getFieldKeys().add("entryentity.consignqty");
        e.getFieldKeys().add("entryentity.saleamount");
        e.getFieldKeys().add("entryentity.rebateamount");
        e.getFieldKeys().add("entryentity.actualunitrebate");
        e.getFieldKeys().add("entryentity.taxrateid");
        e.getFieldKeys().add("entryentity.taxrate");
        e.getFieldKeys().add("entryentity.tax");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length <= 0) {
            return;
        }
        int priceprecision = 2;
        int amtprecision = 2;
        HashSet<Long> repolicyTargetIdSet = new HashSet<Long>(0);
        DynamicObject repolicytarget = null;
        for (DynamicObject data : datas) {
            DynamicObjectCollection entryEntity;
            DynamicObject rpprecurrency;
            repolicytarget = data.getDynamicObject("rebatepolicytarget");
            if (repolicytarget != null) {
                long repolicyTargetId = data.getLong("rebatepolicytarget_id");
                repolicyTargetIdSet.add(repolicyTargetId);
            }
            if ((rpprecurrency = data.getDynamicObject("rpprecurrency")) != null) {
                priceprecision = rpprecurrency.getInt("priceprecision");
                amtprecision = rpprecurrency.getInt("amtprecision");
            }
            if (CollectionUtils.isEmpty((Collection)(entryEntity = data.getDynamicObjectCollection("entryentity")))) continue;
            BigDecimal sumconsignqty = BigDecimal.ZERO;
            BigDecimal sumsaleamount = BigDecimal.ZERO;
            BigDecimal sumrebateamount = BigDecimal.ZERO;
            HashMap<Long, BigDecimal> taxRateMap = new HashMap<Long, BigDecimal>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                BigDecimal consignqty = entry.getBigDecimal("consignqty");
                BigDecimal saleamount = entry.getBigDecimal("saleamount");
                BigDecimal rebateamount = entry.getBigDecimal("rebateamount");
                sumconsignqty = sumconsignqty.add(consignqty);
                sumsaleamount = sumsaleamount.add(saleamount);
                sumrebateamount = sumrebateamount.add(rebateamount);
                repolicytarget = entry.getDynamicObject("repolicytarget");
                if (repolicytarget != null) {
                    long repolicyTargetId = entry.getLong("repolicytarget_id");
                    repolicyTargetIdSet.add(repolicyTargetId);
                }
                if (consignqty.compareTo(BigDecimal.ZERO) != 0) {
                    entry.set("actualunitrebate", (Object)rebateamount.divide(consignqty, priceprecision, RoundingMode.HALF_UP));
                }
                DynamicObject entrytaxrate = entry.getDynamicObject("taxrateid");
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || entrytaxrate != null) continue;
                DynamicObject materialtaxrate = material.getDynamicObject("taxrate");
                entry.set("taxrateid", (Object)materialtaxrate);
                if (materialtaxrate == null) continue;
                long taxrateid = DynamicObjectUtils.getPkValue((DynamicObject)materialtaxrate);
                BigDecimal taxrate = (BigDecimal)taxRateMap.get(taxrateid);
                if (taxrate == null) {
                    taxrate = this.queryTaxrate(taxrateid);
                    taxRateMap.put(taxrateid, taxrate);
                }
                BigDecimal taxamount = rebateamount.multiply(taxrate).divide(taxrate.add(BigDecimal.valueOf(100L)), amtprecision, RoundingMode.HALF_UP);
                entry.set("taxrate", (Object)taxrate);
                entry.set("tax", (Object)taxamount);
            }
            data.set("totalproconsignqty", (Object)sumconsignqty);
            data.set("totalsaleamount", (Object)sumsaleamount);
            data.set("totalrebateamount", (Object)sumrebateamount);
        }
        SaveServiceHelper.update((DynamicObject[])datas);
        this.updateRebateTarget(repolicyTargetIdSet);
    }

    private void updateRebateTarget(Set<Long> repolicyTargetIdSet) {
        if (repolicyTargetIdSet == null || repolicyTargetIdSet.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "in", repolicyTargetIdSet);
        filter.and("presettle", "=", (Object)Boolean.FALSE);
        DynamicObject[] rebateTargets = BusinessDataServiceHelper.load((String)"occpic_rebatetarget", (String)"presettle", (QFilter[])filter.toArray());
        if (rebateTargets != null && rebateTargets.length > 0) {
            for (DynamicObject rebateTarget : rebateTargets) {
                rebateTarget.set("presettle", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.update((DynamicObject[])rebateTargets);
        }
    }

    private BigDecimal queryTaxrate(long taxrateid) {
        BigDecimal taxrate = BigDecimal.ZERO;
        QFilter filter = new QFilter("id", "=", (Object)taxrateid);
        DynamicObject taxrateDo = QueryServiceHelper.queryOne((String)"bd_taxrate", (String)"taxrate", (QFilter[])filter.toArray());
        if (taxrateDo != null) {
            taxrate = taxrateDo.getBigDecimal("taxrate");
        }
        return taxrate;
    }
}

