/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.opplugin.rebate.validators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.handle.RebateHandle;
import kd.occ.ocbase.common.enums.occpic.CalScopeType;
import kd.occ.ocbase.common.enums.occpic.CalculateStatus;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.validator.BatchFastValidator;

public class RebatePolicyValidator
extends BatchFastValidator {
    public void otherOP(String opKey, ExtendedDataEntity[] datas) {
        if ("disablepolicy".equalsIgnoreCase(opKey)) {
            for (ExtendedDataEntity data : datas) {
                DynamicObject dataEntity = data.getDataEntity();
                if ("A".equalsIgnoreCase(dataEntity.getString("billstatus")) || "B".equalsIgnoreCase(dataEntity.getString("billstatus"))) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5ba1\u6838\u201d\uff0c\u4e0d\u5141\u8bb8\u5931\u6548\u3002", (String)"UnableRebatePolicyValidator_0", (String)"occ-occpic-opplugin", (Object[])new Object[0]), dataEntity.getString("billno")), ErrorLevel.Error);
                    continue;
                }
                if (!"D".equalsIgnoreCase(dataEntity.getString("billstatus"))) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\u7684\u5355\u636e\u72b6\u6001\u5df2\u4e3a\u201c\u5931\u6548\u201d\u3002", (String)"UnableRebatePolicyValidator_1", (String)"occ-occpic-opplugin", (Object[])new Object[0]), dataEntity.getString("billno")), ErrorLevel.Error);
            }
        }
    }

    public void submit(ExtendedDataEntity[] datas) {
        this.checkBeforeSave(datas);
    }

    public void save(ExtendedDataEntity[] datas) {
        this.checkBeforeSave(datas);
    }

    public void unaudit(ExtendedDataEntity[] datas) {
        if (datas != null && datas.length > 0) {
            List policyIdList = Arrays.stream(datas).map(r -> r.getDataEntity().getPkValue()).collect(Collectors.toList());
            QFilter qFilter = new QFilter("policy", "in", policyIdList);
            DynamicObject[] targetArray = BusinessDataServiceHelper.load((String)"occpic_rebatetarget", (String)F7Utils.getSelectCols((String[])new String[]{"id", "policy", "presettle", "billstatus", "calculatestatus"}), (QFilter[])qFilter.toArray());
            Map<Object, List<DynamicObject>> policy2TargetMap = Arrays.stream(targetArray).collect(Collectors.groupingBy(r -> r.getDynamicObject("policy").getPkValue()));
            ArrayList targetIdList = new ArrayList(200);
            for (ExtendedDataEntity data : datas) {
                DynamicObject policy = data.getDataEntity();
                Object policyId = policy.getPkValue();
                List<DynamicObject> targetList = policy2TargetMap.get(policyId);
                if (CollectionUtils.isEmpty(targetList)) continue;
                boolean isCanUnaudit = true;
                for (DynamicObject target : targetList) {
                    if (Status.AUDITED.toString().equals(target.getString("billstatus")) && !target.getBoolean("presettle") && CalculateStatus.WEIKAISHIJISUAN.toString().equals(target.getString("calculatestatus"))) continue;
                    isCanUnaudit = false;
                    break;
                }
                if (isCanUnaudit) {
                    targetIdList.addAll(targetList.stream().map(r -> r.getPkValue()).collect(Collectors.toList()));
                    continue;
                }
                this.addFatalErrorMessage(data, "\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002");
            }
            if (!CollectionUtils.isEmpty(targetIdList)) {
                OperateOption option = CommonUtils.getOperateOption();
                OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"occpic_rebatetarget", (Object[])targetIdList.stream().toArray(), (OperateOption)option);
                if (!CollectionUtils.isEmpty((Collection)unauditResult.getSuccessPkIds())) {
                    OperationServiceHelper.executeOperate((String)"delete", (String)"occpic_rebatetarget", (Object[])unauditResult.getSuccessPkIds().stream().toArray(), (OperateOption)option);
                }
            }
        }
    }

    private void checkBeforeSave(ExtendedDataEntity[] datas) {
        if (datas != null && datas.length > 0) {
            block4: for (ExtendedDataEntity data : datas) {
                DynamicObject policy = data.getDataEntity();
                String calScopeType = policy.getString("calscopetype");
                if (!StringUtils.isNotEmpty((String)calScopeType)) continue;
                switch (CalScopeType.parse((String)calScopeType)) {
                    case ALL: {
                        this.checkEntityNonEmpty(data, "entryentity");
                        this.checkMustInputForBaseline(data, "incomecusentity");
                        this.checkMinMax(data, "entryentity");
                        continue block4;
                    }
                    case GROUP: {
                        this.checkEntityNonEmpty(data, "itemformulaentity");
                        this.checkMustInputForBaseline(data, "itemformulaentity");
                        this.checkMinMax(data, "itemformulaentity");
                    }
                }
            }
        }
    }

    private void checkMustInputForBaseline(ExtendedDataEntity data, String entity) {
        DynamicObject policy = data.getDataEntity();
        long ladderTypeId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policy, (String)"nladdertype");
        if (RebateHandle.isJinEDaChengLv((long)ladderTypeId)) {
            String message = "\u8fd4\u5229\u5224\u65ad\u6807\u51c6\u4e3a\u91d1\u989d\u8fbe\u6210\u7387 \uff0c\u57fa\u7ebf\u91d1\u989d\u5fc5\u586b.";
            if ("incomecusentity".equals(entity)) {
                this.checkEntryFieldMustInput(data, entity, "blamount", message);
            } else if ("itemformulaentity".equals(entity)) {
                this.checkEntryFieldMustInput(data, entity, "itemblamount", message);
            }
        } else if (RebateHandle.isShuLiangDaChengLv((long)ladderTypeId)) {
            String message = "\u8fd4\u5229\u5224\u65ad\u6807\u51c6\u4e3a\u6570\u91cf\u8fbe\u6210\u7387\uff0c\u57fa\u7ebf\u6570\u91cf\u5fc5\u586b.";
            if ("incomecusentity".equals(entity)) {
                this.checkEntryFieldMustInput(data, entity, "blqty", message);
            } else if ("itemformulaentity".equals(entity)) {
                this.checkEntryFieldMustInput(data, entity, "itemblqty", message);
            }
        }
    }

    private void checkMinMax(ExtendedDataEntity data, String entity) {
        DynamicObjectCollection entryCol = data.getDataEntity().getDynamicObjectCollection(entity);
        if ("entryentity".equals(entity)) {
            this.checkMinMax(data, entryCol.stream().collect(Collectors.toList()), entity);
        } else if ("itemformulaentity".equals(entity)) {
            Map<Object, List<DynamicObject>> entryMap = entryCol.stream().collect(Collectors.groupingBy(r -> r.get("group")));
            for (Map.Entry<Object, List<DynamicObject>> entryList : entryMap.entrySet()) {
                this.checkMinMax(data, entryList.getValue(), entity);
            }
        }
    }

    private void checkMinMax(ExtendedDataEntity data, List<DynamicObject> entryList, String entity) {
        DynamicObject policy = data.getDataEntity();
        long ladderTypeId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policy, (String)"nladdertype");
        if (RebateHandle.isDaChengLv((long)ladderTypeId)) {
            if ("entryentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "minachive", "maxachive");
            } else if ("itemformulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "itemminachive", "itemmaxachive");
            }
        } else if (RebateHandle.isJinEJieTi((long)ladderTypeId)) {
            if ("entryentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "minamount", "maxamount");
            } else if ("itemformulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "itemminamount", "itemmaxamount");
            }
        } else if (RebateHandle.isShuLiangJieTi((long)ladderTypeId)) {
            if ("entryentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "minqty", "maxqty");
            } else if ("itemformulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "itemminqty", "itemmaxqty");
            }
        }
    }

    private void checkMinMax(ExtendedDataEntity data, List<DynamicObject> entryList, String entity, String minKey, String maxKey) {
        if (!CollectionUtils.isEmpty(entryList)) {
            int maxi = entryList.size() - 1;
            for (int i = 0; i <= maxi; ++i) {
                DynamicObject entry = entryList.get(i);
                if (maxi != 0) {
                    if (i == 0) {
                        this.checkMinMaxMustInput(data, entry, entity, maxKey);
                    } else if (i == maxi) {
                        this.checkMinMaxMustInput(data, entry, entity, minKey);
                        this.checkNextMinLargeLastMax(data, entryList.get(i - 1), entry, entity, minKey, maxKey);
                    } else {
                        this.checkMinMaxMustInput(data, entry, entity, minKey);
                        this.checkMinMaxMustInput(data, entry, entity, maxKey);
                        this.checkNextMinLargeLastMax(data, entryList.get(i - 1), entry, entity, minKey, maxKey);
                    }
                }
                this.checkMaxLargeMin(data, entry, entity, minKey, maxKey);
            }
        }
    }

    private void checkNextMinLargeLastMax(ExtendedDataEntity data, DynamicObject lastEntry, DynamicObject nextEntry, String entity, String minKey, String maxKey) {
        BigDecimal lastMax = lastEntry.getBigDecimal(maxKey);
        BigDecimal nextMin = nextEntry.getBigDecimal(minKey);
        if (lastMax != null && nextMin != null && BigDecimal.ZERO.compareTo(lastMax) != 0 && BigDecimal.ZERO.compareTo(nextMin) != 0 && nextMin.compareTo(lastMax) < 0) {
            this.addErrorMessage(data, this.buildCheckNextMinLargeLastMaxMessage(entity, minKey, maxKey, lastEntry.getInt("seq"), nextEntry.getInt("seq")));
        }
    }

    private void checkMaxLargeMin(ExtendedDataEntity data, DynamicObject entry, String entity, String minKey, String maxKey) {
        BigDecimal max = entry.getBigDecimal(maxKey);
        BigDecimal min = entry.getBigDecimal(minKey);
        if (max != null && min != null && BigDecimal.ZERO.compareTo(max) != 0 && BigDecimal.ZERO.compareTo(min) != 0 && min.compareTo(max) >= 0) {
            this.addErrorMessage(data, this.buildCheckMaxLargeMinMessage(entity, minKey, maxKey, entry.getInt("seq")));
        }
    }

    private String buildCheckMaxLargeMinMessage(String entity, String minKey, String maxKey, int seq) {
        return String.format("%1$s\u7b2c%2$s\u884c%3$s\u5fc5\u987b\u5c0f\u4e8e%4$s\u3002", this.getNameByKey(entity), seq, this.getNameByKey(minKey), this.getNameByKey(maxKey));
    }

    private String buildCheckNextMinLargeLastMaxMessage(String entity, String minKey, String maxKey, int lastSeq, int nextSeq) {
        return String.format("%1$s\u7b2c%2$s\u884c%3$s\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u7b2c%4$s\u884c%5$s\u3002", this.getNameByKey(entity), nextSeq, this.getNameByKey(minKey), lastSeq, this.getNameByKey(maxKey));
    }

    private void checkMinMaxMustInput(ExtendedDataEntity data, DynamicObject entry, String entity, String filedKey) {
        if (entry.getBigDecimal(filedKey) == null || BigDecimal.ZERO.compareTo(entry.getBigDecimal(filedKey)) == 0) {
            this.addErrorMessage(data, this.buildCheckMinMustInputMaxMessage(entity, filedKey, entry.getInt("seq")));
        }
    }

    private String buildCheckMinMustInputMaxMessage(String entity, String fieldKey, int seq) {
        return String.format("%1$s\u7b2c%2$s\u884c%3$s\u5fc5\u586b\u3002", this.getNameByKey(entity), seq, this.getNameByKey(fieldKey));
    }

    private String getNameByKey(String key) {
        String name = "";
        switch (key) {
            case "incomecusentity": {
                name = "\u8fd4\u5229\u5bf9\u8c61";
                break;
            }
            case "itemclassentity": {
                name = "\u8fd4\u5229\u5546\u54c1";
                break;
            }
            case "entryentity": {
                name = "\u8fd4\u5229\u6807\u51c6";
                break;
            }
            case "itemformulaentity": {
                name = "\u5546\u54c1\u8fd4\u5229\u6807\u51c6";
                break;
            }
            case "minachive": 
            case "itemminachive": {
                name = "\u8fbe\u6210\u7387\u6700\u5c0f\u503c";
                break;
            }
            case "maxachive": 
            case "itemmaxachive": {
                name = "\u8fbe\u6210\u7387\u6700\u5927\u503c";
                break;
            }
            case "minamount": 
            case "itemminamount": {
                name = "\u91d1\u989d\u6700\u5c0f\u503c";
                break;
            }
            case "maxamount": 
            case "itemmaxamount": {
                name = "\u91d1\u989d\u6700\u5927\u503c";
                break;
            }
            case "minqty": 
            case "itemminqty": {
                name = "\u6570\u91cf\u6700\u5c0f\u503c";
                break;
            }
            case "maxqty": 
            case "itemmaxqty": {
                name = "\u6570\u91cf\u6700\u5927\u503c";
                break;
            }
        }
        return name;
    }

    private void checkEntryFieldMustInput(ExtendedDataEntity data, String entity, String fieldKey, String message) {
        DynamicObject policy = data.getDataEntity();
        for (DynamicObject entry : policy.getDynamicObjectCollection(entity)) {
            if (entry.getBigDecimal(fieldKey) != null && BigDecimal.ZERO.compareTo(entry.getBigDecimal(fieldKey)) != 0) continue;
            this.addErrorMessage(data, message);
            break;
        }
    }

    private void checkEntityNonEmpty(ExtendedDataEntity data, String entity) {
        if (CollectionUtils.isEmpty((Collection)data.getDataEntity().getDynamicObjectCollection(entity))) {
            this.addErrorMessage(data, String.format("\u8fd4\u5229\u653f\u7b56\u5206\u5f55-%1$s\u5fc5\u586b(\u4e0d\u5141\u8bb8\u4e3a\u7a7a).", this.getNameByKey(entity)));
        }
    }
}

