/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.opplugin.rebate.validators;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.handle.RebateHandle;
import kd.occ.ocbase.common.enums.occpic.CalScopeType;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.validator.BatchFastValidator;

public class RebateTargetValidator
extends BatchFastValidator {
    public void submit(ExtendedDataEntity[] datas) {
        this.checkBeforeSave(datas);
    }

    public void save(ExtendedDataEntity[] datas) {
        this.checkBeforeSave(datas);
    }

    private void checkBeforeSave(ExtendedDataEntity[] datas) {
        if (datas != null && datas.length > 0) {
            block4: for (ExtendedDataEntity data : datas) {
                DynamicObject policy = data.getDataEntity();
                String calScopeType = policy.getString("calscopetype");
                if (!StringUtils.isNotEmpty((String)calScopeType)) continue;
                switch (CalScopeType.parse((String)calScopeType)) {
                    case ALL: {
                        this.checkEntityNonEmpty(data, "formulaentity");
                        this.checkMustInputForBaseline(data, null);
                        this.checkMinMax(data, "formulaentity");
                        continue block4;
                    }
                    case GROUP: {
                        this.checkEntityNonEmpty(data, "itemformulaentity");
                        this.checkMustInputForBaseline(data, "itemformulaentity");
                        this.checkMinMax(data, "itemformulaentity");
                    }
                }
            }
        }
    }

    private void checkMustInputForBaseline(ExtendedDataEntity data, String entity) {
        DynamicObject policy = data.getDataEntity();
        long ladderTypeId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policy, (String)"nladdertype");
        if (RebateHandle.isJinEDaChengLv((long)ladderTypeId)) {
            String message = "\u8fd4\u5229\u5224\u65ad\u6807\u51c6\u4e3a\u91d1\u989d\u8fbe\u6210\u7387 \uff0c\u57fa\u7ebf\u91d1\u989d\u5fc5\u586b.";
            if (entity == null) {
                this.checkFieldMustInput(data, "baselineamount", message);
            } else if ("itemformulaentity".equals(entity)) {
                this.checkEntryFieldMustInput(data, entity, "itemblamount", message);
            }
        } else if (RebateHandle.isShuLiangDaChengLv((long)ladderTypeId)) {
            String message = "\u8fd4\u5229\u5224\u65ad\u6807\u51c6\u4e3a\u6570\u91cf\u8fbe\u6210\u7387\uff0c\u57fa\u7ebf\u6570\u91cf\u5fc5\u586b.";
            if (entity == null) {
                this.checkFieldMustInput(data, "baselineqty", message);
            } else if ("itemformulaentity".equals(entity)) {
                this.checkEntryFieldMustInput(data, entity, "itemblqty", message);
            }
        }
    }

    private void checkMinMax(ExtendedDataEntity data, String entity) {
        DynamicObjectCollection entryCol = data.getDataEntity().getDynamicObjectCollection(entity);
        if ("formulaentity".equals(entity)) {
            this.checkMinMax(data, entryCol.stream().collect(Collectors.toList()), entity);
        } else if ("itemformulaentity".equals(entity)) {
            Map<Object, List<DynamicObject>> entryMap = entryCol.stream().collect(Collectors.groupingBy(r -> r.get("group")));
            for (Map.Entry<Object, List<DynamicObject>> entryList : entryMap.entrySet()) {
                this.checkMinMax(data, entryList.getValue(), entity);
            }
        }
    }

    private void checkMinMax(ExtendedDataEntity data, List<DynamicObject> entryList, String entity) {
        DynamicObject policy = data.getDataEntity();
        long ladderTypeId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policy, (String)"nladdertype");
        if (RebateHandle.isDaChengLv((long)ladderTypeId)) {
            if ("formulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "minachive", "maxachive");
            } else if ("itemformulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "itemminachive", "itemmaxachive");
            }
        } else if (RebateHandle.isJinEJieTi((long)ladderTypeId)) {
            if ("formulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "minamount", "maxamount");
            } else if ("itemformulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "itemminamount", "itemmaxamount");
            }
        } else if (RebateHandle.isShuLiangJieTi((long)ladderTypeId)) {
            if ("formulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "minqty", "maxqty");
            } else if ("itemformulaentity".equals(entity)) {
                this.checkMinMax(data, entryList, entity, "itemminqty", "itemmaxqty");
            }
        }
    }

    private void checkMinMax(ExtendedDataEntity data, List<DynamicObject> entryList, String entity, String minKey, String maxKey) {
        if (!CollectionUtils.isEmpty(entryList)) {
            int maxi = entryList.size() - 1;
            for (int i = 0; i <= maxi; ++i) {
                DynamicObject entry = entryList.get(i);
                if (maxi != 0) {
                    if (i == 0) {
                        this.checkMinMaxMustInput(data, entry, entity, maxKey);
                    } else if (i == maxi) {
                        this.checkMinMaxMustInput(data, entry, entity, minKey);
                        this.checkNextMinLargeLastMax(data, entryList.get(i - 1), entry, entity, minKey, maxKey);
                    } else {
                        this.checkMinMaxMustInput(data, entry, entity, minKey);
                        this.checkMinMaxMustInput(data, entry, entity, maxKey);
                        this.checkNextMinLargeLastMax(data, entryList.get(i - 1), entry, entity, minKey, maxKey);
                    }
                }
                this.checkMaxLargeMin(data, entry, entity, minKey, maxKey);
            }
        }
    }

    private void checkNextMinLargeLastMax(ExtendedDataEntity data, DynamicObject lastEntry, DynamicObject nextEntry, String entity, String minKey, String maxKey) {
        BigDecimal lastMax = lastEntry.getBigDecimal(maxKey);
        BigDecimal nextMin = nextEntry.getBigDecimal(minKey);
        if (lastMax != null && nextMin != null && BigDecimal.ZERO.compareTo(lastMax) != 0 && BigDecimal.ZERO.compareTo(nextMin) != 0 && nextMin.compareTo(lastMax) < 0) {
            this.addErrorMessage(data, this.buildCheckNextMinLargeLastMaxMessage(entity, minKey, maxKey, lastEntry.getInt("seq"), nextEntry.getInt("seq")));
        }
    }

    private void checkMaxLargeMin(ExtendedDataEntity data, DynamicObject entry, String entity, String minKey, String maxKey) {
        BigDecimal max = entry.getBigDecimal(maxKey);
        BigDecimal min = entry.getBigDecimal(minKey);
        if (max != null && min != null && BigDecimal.ZERO.compareTo(max) != 0 && BigDecimal.ZERO.compareTo(min) != 0 && min.compareTo(max) >= 0) {
            this.addErrorMessage(data, this.buildCheckMaxLargeMinMessage(entity, minKey, maxKey, entry.getInt("seq")));
        }
    }

    private String buildCheckMaxLargeMinMessage(String entity, String minKey, String maxKey, int seq) {
        return String.format("%1$s\u7b2c%2$s\u884c%3$s\u5fc5\u987b\u5c0f\u4e8e%4$s\u3002", this.getNameByKey(entity), seq, this.getNameByKey(minKey), this.getNameByKey(maxKey));
    }

    private String buildCheckNextMinLargeLastMaxMessage(String entity, String minKey, String maxKey, int lastSeq, int nextSeq) {
        return String.format("%1$s\u7b2c%2$s\u884c%3$s\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u7b2c%4$s\u884c%5$s\u3002", this.getNameByKey(entity), nextSeq, this.getNameByKey(minKey), lastSeq, this.getNameByKey(maxKey));
    }

    private void checkMinMaxMustInput(ExtendedDataEntity data, DynamicObject entry, String entity, String filedKey) {
        if (entry.getBigDecimal(filedKey) == null || BigDecimal.ZERO.compareTo(entry.getBigDecimal(filedKey)) == 0) {
            this.addErrorMessage(data, this.buildCheckMinMustInputMaxMessage(entity, filedKey, entry.getInt("seq")));
        }
    }

    private String buildCheckMinMustInputMaxMessage(String entity, String fieldKey, int seq) {
        return String.format("%1$s\u7b2c%2$s\u884c%3$s\u5fc5\u586b\u3002", this.getNameByKey(entity), seq, this.getNameByKey(fieldKey));
    }

    private String getNameByKey(String key) {
        String name = "";
        switch (key) {
            case "itemclassentity": {
                name = "\u8fd4\u5229\u5546\u54c1";
                break;
            }
            case "formulaentity": {
                name = "\u8fd4\u5229\u6807\u51c6";
                break;
            }
            case "itemformulaentity": {
                name = "\u5546\u54c1\u8fd4\u5229\u6807\u51c6";
                break;
            }
            case "minachive": 
            case "itemminachive": {
                name = "\u8fbe\u6210\u7387\u6700\u5c0f\u503c";
                break;
            }
            case "maxachive": 
            case "itemmaxachive": {
                name = "\u8fbe\u6210\u7387\u6700\u5927\u503c";
                break;
            }
            case "minamount": 
            case "itemminamount": {
                name = "\u91d1\u989d\u6700\u5c0f\u503c";
                break;
            }
            case "maxamount": 
            case "itemmaxamount": {
                name = "\u91d1\u989d\u6700\u5927\u503c";
                break;
            }
            case "minqty": 
            case "itemminqty": {
                name = "\u6570\u91cf\u6700\u5c0f\u503c";
                break;
            }
            case "maxqty": 
            case "itemmaxqty": {
                name = "\u6570\u91cf\u6700\u5927\u503c";
                break;
            }
        }
        return name;
    }

    private void checkFieldMustInput(ExtendedDataEntity data, String fieldKey, String message) {
        DynamicObject policy = data.getDataEntity();
        if (policy.getBigDecimal(fieldKey) == null || BigDecimal.ZERO.compareTo(policy.getBigDecimal(fieldKey)) == 0) {
            this.addErrorMessage(data, message);
        }
    }

    private void checkEntryFieldMustInput(ExtendedDataEntity data, String entity, String fieldKey, String message) {
        DynamicObject policy = data.getDataEntity();
        for (DynamicObject entry : policy.getDynamicObjectCollection(entity)) {
            if (entry.getBigDecimal(fieldKey) != null && BigDecimal.ZERO.compareTo(entry.getBigDecimal(fieldKey)) != 0) continue;
            this.addErrorMessage(data, message);
            break;
        }
    }

    private void checkEntityNonEmpty(ExtendedDataEntity data, String entity) {
        if (CollectionUtils.isEmpty((Collection)data.getDataEntity().getDynamicObjectCollection(entity))) {
            this.addErrorMessage(data, String.format("\u653f\u7b56\u76ee\u6807\u5206\u5f55-%1$s\u5fc5\u586b(\u4e0d\u5141\u8bb8\u4e3a\u7a7a).", this.getNameByKey(entity)));
        }
    }
}

