/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebate.rebatepolicy;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.occpic.business.rebate.RebateHelper;
import kd.occ.occpic.common.pojo.SettlePeriod;

public class CustomPushTargetPlugin
extends OcbaseFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String settperiod = CommonUtils.getStringCustomParamValue((IFormView)this.getView(), (String)"settperiod");
        dataEntity.set("policyidsformatestring", (Object)CommonUtils.getStringCustomParamValue((IFormView)this.getView(), (String)"policyidsformatestring"));
        dataEntity.set("settperiod", (Object)settperiod);
        Date startTime = DateUtil.getDateFormat((String)CommonUtils.getStringCustomParamValue((IFormView)this.getView(), (String)"starttime"));
        dataEntity.set("starttime", (Object)startTime);
        Date endTime = DateUtil.getDateFormat((String)CommonUtils.getStringCustomParamValue((IFormView)this.getView(), (String)"endtime"));
        dataEntity.set("endtime", (Object)endTime);
        dataEntity.set("generatetype", (Object)"D");
        Map settlePeriodMap = RebateHelper.getSettlePeriodMap((String)settperiod, (Date)startTime, (Date)endTime, null);
        if (!CollectionUtils.isEmpty((Map)settlePeriodMap)) {
            DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entry");
            for (Map.Entry settlePeriodEntry : settlePeriodMap.entrySet()) {
                SettlePeriod settlePeriod = (SettlePeriod)settlePeriodEntry.getValue();
                DynamicObject row = entryCol.addNew();
                row.set("splitsettperiod", (Object)settlePeriod.getName());
                row.set("begindate", (Object)settlePeriod.getBeginDate());
                row.set("enddate", (Object)settlePeriod.getEndDate());
                row.set("key", settlePeriodEntry.getKey());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "generatetype": {
                this.setValue("generatesize", 0);
                this.getModel().deleteEntryData("entry");
            }
            case "generatesize": {
                this.generateSettlePeriod(e);
            }
        }
    }

    private void generateSettlePeriod(PropertyChangedArgs e) {
        String settperiod = this.getStringValue("settperiod");
        String generateType = this.getStringValue("generatetype");
        int generateSize = (Integer)this.getValue("generatesize");
        if (generateSize == 0 && "D".equals(generateType) || generateSize > 0 && !"D".equals(generateType)) {
            Date startTime = null;
            Date endTime = null;
            switch (generateType) {
                case "D": {
                    startTime = (Date)this.getValue("starttime");
                    endTime = (Date)this.getValue("endtime");
                    break;
                }
                case "C": {
                    endTime = (Date)this.getValue("endtime");
                    startTime = this.calStartTime(endTime, settperiod, --generateSize);
                    break;
                }
                case "B": {
                    startTime = (Date)this.getValue("starttime");
                    endTime = this.calEndTime(startTime, settperiod, --generateSize);
                    break;
                }
                case "A": {
                    Date now = DateUtil.getNowDate();
                    startTime = this.calStartTime(now, settperiod, generateSize);
                    endTime = this.calEndTime(now, settperiod, generateSize);
                }
            }
            if (startTime == null || endTime == null) {
                this.setValue(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
                this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5468\u671f\u4e0d\u5728\u6709\u6548\u671f\u5185\uff0c\u8bf7\u8c03\u6574\u5468\u671f\u751f\u6210\u65b9\u5f0f\uff0c\u5468\u671f\u751f\u6210\u6570\u91cf\u518d\u8bd5\u3002", (String)"CustomPushTargetPlugin_4", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
            } else {
                Map settlePeriodMap = RebateHelper.getSettlePeriodMap((String)settperiod, (Date)startTime, (Date)endTime, null);
                if (!CollectionUtils.isEmpty((Map)settlePeriodMap)) {
                    DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entry");
                    entryCol.clear();
                    for (Map.Entry settlePeriodEntry : settlePeriodMap.entrySet()) {
                        SettlePeriod settlePeriod = (SettlePeriod)settlePeriodEntry.getValue();
                        DynamicObject row = entryCol.addNew();
                        row.set("splitsettperiod", (Object)settlePeriod.getName());
                        row.set("begindate", (Object)settlePeriod.getBeginDate());
                        row.set("enddate", (Object)settlePeriod.getEndDate());
                        row.set("key", settlePeriodEntry.getKey());
                    }
                    this.getView().updateView("entry");
                }
            }
        }
    }

    private Date calStartTime(Date date, String settperiod, int generateSize) {
        Date startTime = RebateHelper.calAddDateForSettlePeriod((String)settperiod, (Date)date, (int)(0 - generateSize));
        if (DateUtil.dayDiff((Date)(startTime = RebateHelper.calFistDayForSettlePeriod((String)settperiod, (Date)startTime)), (Date)((Date)this.getValue("starttime"))) >= 0) {
            return startTime;
        }
        return null;
    }

    private Date calEndTime(Date date, String settperiod, int generateSize) {
        Date endTime = RebateHelper.calAddDateForSettlePeriod((String)settperiod, (Date)date, (int)generateSize);
        if (DateUtil.dayDiff((Date)(endTime = RebateHelper.calLastDayForSettlePeriod((String)settperiod, (Date)endTime)), (Date)((Date)this.getValue("endtime"))) <= 0) {
            return endTime;
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "dook": {
                this.doOk();
                break;
            }
        }
    }

    private void doOk() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        int[] selectRowArray = entryGrid.getEntryState().getSelectedRows();
        if (selectRowArray != null && selectRowArray.length > 0) {
            ArrayList<String> keyList = new ArrayList<String>(selectRowArray.length);
            for (int selectRow : selectRowArray) {
                keyList.add(this.getModel().getEntryRowEntity("entry", selectRow).getString("key"));
            }
            String customDateRange = RebateHelper.formateCusomDateRange((String[])((String[])keyList.stream().toArray(String[]::new)));
            Object[] policyIdArray = RebateHelper.parsePolicyIdArray((String)this.getStringValue("policyidsformatestring"));
            RebateHelper.updateRebatePolicy((Object[])policyIdArray, (String)customDateRange);
            OperationServiceHelper.executeOperate((String)"pushandsave", (String)"occpic_rebatepolicy", (Object[])policyIdArray, (OperateOption)CommonUtils.getOperateOption());
            this.getView().showMessage(ResManager.loadKDString((String)"\u6307\u5b9a\u5468\u671f\u751f\u6210\u76ee\u6807\u64cd\u4f5c\u5b8c\u6210\uff0c\u8bf7\u901a\u8fc7\u4e0b\u67e5\u64cd\u4f5c\u67e5\u770b\u751f\u6210\u7684\u76ee\u6807\u3002", (String)"CustomPushTargetPlugin_5", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
            this.getView().close();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u6210\u5468\u671f\u3002", (String)"CustomPushTargetPlugin_6", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
        }
    }
}

