/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebate.rebatepolicy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.helper.CustomerHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occpic.business.rebate.RebateHelper;
import kd.occ.occpic.common.pojo.SettlePeriod;

public class RebatePolicy2TargetConvert
extends AbstractConvertPlugIn {
    private static final int FLOWNUM_LENGTH = 3;
    private static final String FLOWNUM_PREFIX = "00000";

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet targetEntitySet = e.getTargetExtDataEntitySet();
        if (targetEntitySet == null) {
            return;
        }
        String targetMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] targetExtendedDataEntityArray = targetEntitySet.FindByEntityKey(targetMainType);
        int batchSize = targetExtendedDataEntityArray.length * 10;
        HashSet<Long> channelClassIdSet = new HashSet<Long>(batchSize);
        HashSet<Long> customerGroupIdSet = new HashSet<Long>(batchSize);
        this.batchGetCCIdSet(targetExtendedDataEntityArray, customerGroupIdSet, channelClassIdSet);
        Map channelClassId2ChannelIdSetMap = ChannelHelper.queryChannelIdByClassId(channelClassIdSet, (boolean)true);
        Map customerGroupId2CustomerIdSetMap = CustomerHelper.queryCustomerIdByCustomerGroupId(customerGroupIdSet, (boolean)true);
        LinkedHashMap<String, DynamicObject> pccid2TargetMap = new LinkedHashMap<String, DynamicObject>(targetExtendedDataEntityArray.length);
        for (ExtendedDataEntity targetExtendedDataEntity : targetExtendedDataEntityArray) {
            Object[] target = targetExtendedDataEntity.getDataEntity();
            this.splitTargetByClass((DynamicObject)target, pccid2TargetMap, channelClassId2ChannelIdSetMap, customerGroupId2CustomerIdSetMap);
        }
        List<DynamicObject> targetList = new ArrayList<DynamicObject>(pccid2TargetMap.size() * 10);
        Object[] targetArray = (DynamicObject[])pccid2TargetMap.values().stream().toArray(DynamicObject[]::new);
        BusinessDataServiceHelper.loadRefence((Object[])targetArray, (IDataEntityType)this.getTgtMainType());
        HashMap<String, Map<String, SettlePeriod>> settlePeriodCache = new HashMap<String, Map<String, SettlePeriod>>(batchSize);
        Date now = TimeServiceHelper.now();
        for (Object object : targetArray) {
            targetList.addAll(this.splitTargetByEffDate((DynamicObject)object, now, settlePeriodCache));
        }
        for (DynamicObject target : targetList) {
            long rebateClassId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"nrebateclass");
            if (!this.isChannel(rebateClassId)) continue;
            DynamicObjectUtils.copyDynamicObjectLPkValue((DynamicObject)target.getDynamicObject("benifitchl"), (String)"customer", (DynamicObject)target, (String)"benifitcustomer");
        }
        targetList = this.removeExistTarget(targetList);
        targetEntitySet.getExtDataEntityMap().remove(targetMainType);
        ArrayList<ExtendedDataEntity> newExtendedDataEntities = new ArrayList<ExtendedDataEntity>(targetList.size());
        int dataIndex = 0;
        for (DynamicObject dynamicObject : targetList) {
            newExtendedDataEntities.add(new ExtendedDataEntity(dynamicObject, dataIndex++, 0));
        }
        targetEntitySet.AddExtendedDataEntities(targetMainType, newExtendedDataEntities);
    }

    private List<DynamicObject> removeExistTarget(List<DynamicObject> targetList) {
        if (!CollectionUtils.isEmpty(targetList)) {
            int batchSize = targetList.size();
            LinkedHashMap<String, DynamicObject> targetMap = new LinkedHashMap<String, DynamicObject>(batchSize);
            HashSet<Long> policyIdSet = new HashSet<Long>(batchSize);
            for (DynamicObject target : targetList) {
                targetMap.put(this.buildKeyForTarget(target), target);
                policyIdSet.add(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"policy"));
            }
            QFilter qFilter = new QFilter("policy", "in", policyIdSet);
            String selectProperties = F7Utils.getSelectCols((String[])new String[]{"policy", "nrebateclass", "benifitcustomer", "benifitchl", "starttime", "endtime"});
            DynamicObject[] targetArray = BusinessDataServiceHelper.load((String)"occpic_rebatetarget", (String)selectProperties, (QFilter[])qFilter.toArray());
            if (targetArray != null && targetArray.length > 0) {
                for (DynamicObject target : targetArray) {
                    targetMap.remove(this.buildKeyForTarget(target));
                }
                targetList = targetMap.values().stream().collect(Collectors.toList());
            }
        }
        return targetList;
    }

    private String buildKeyForTarget(DynamicObject target) {
        long policyId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"policy");
        long rebateClassId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"nrebateclass");
        String ccKey = null;
        if (this.isCustomer(rebateClassId)) {
            ccKey = "benifitcustomer";
        } else if (this.isChannel(rebateClassId)) {
            ccKey = "benifitchl";
        }
        long ccId = StringUtils.isNotEmpty((String)ccKey) ? DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)ccKey) : 0L;
        Date startTime = target.getDate("starttime");
        Date endTime = target.getDate("endtime");
        return String.join((CharSequence)"#", String.valueOf(policyId), String.valueOf(ccId), startTime == null ? "" : DateUtil.getDateFormat((Date)startTime), endTime == null ? "" : DateUtil.getDateFormat((Date)endTime));
    }

    private void batchGetCCIdSet(ExtendedDataEntity[] targetExtendedDataEntityArray, Set<Long> customerClassIdSet, Set<Long> channelClassIdSet) {
        for (ExtendedDataEntity targetExtendedDataEntity : targetExtendedDataEntityArray) {
            long ccClassId;
            DynamicObject target = targetExtendedDataEntity.getDataEntity();
            long policyId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"policy");
            long rebateClassId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"nrebateclass");
            if (policyId <= 0L || rebateClassId <= 0L) continue;
            String ccClassKey = null;
            Set<Long> ccIdSet = null;
            if (this.isCustomer(rebateClassId)) {
                ccClassKey = "benifitcustomerclass";
                ccIdSet = customerClassIdSet;
            } else if (this.isChannel(rebateClassId)) {
                ccClassKey = "benifitchlclass";
                ccIdSet = channelClassIdSet;
            }
            if (!StringUtils.isNotEmpty((String)ccClassKey) || ccIdSet == null || (ccClassId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)ccClassKey)) <= 0L) continue;
            ccIdSet.add(ccClassId);
        }
    }

    private void splitTargetByClass(DynamicObject target, Map<String, DynamicObject> pccid2TargetMap, Map<Long, Set<Long>> channelClassId2ChannelIdSetMap, Map<Long, Set<Long>> customerGroupId2CustomerIdSetMap) {
        long policyId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"policy");
        long rebateClassId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"nrebateclass");
        if (policyId > 0L && rebateClassId > 0L) {
            String ccKey = null;
            String ccClassKey = null;
            Map<Long, Set<Long>> ccClassId2ccIdSetMap = null;
            if (this.isCustomer(rebateClassId)) {
                ccKey = "benifitcustomer";
                ccClassKey = "benifitcustomerclass";
                ccClassId2ccIdSetMap = customerGroupId2CustomerIdSetMap;
            } else if (this.isChannel(rebateClassId)) {
                ccKey = "benifitchl";
                ccClassKey = "benifitchlclass";
                ccClassId2ccIdSetMap = channelClassId2ChannelIdSetMap;
            }
            if (StringUtils.isNotEmpty((String)ccKey) && StringUtils.isNotEmpty((String)ccClassKey)) {
                Set<Long> ccIdSet;
                long ccid = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)ccKey);
                long ccClassId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)ccClassKey);
                if (ccid > 0L) {
                    String key = this.buildCCid2TargetMapKey(policyId, ccid);
                    if (!pccid2TargetMap.containsKey(key)) {
                        pccid2TargetMap.put(key, target);
                    }
                } else if (ccClassId > 0L && ccClassId2ccIdSetMap != null && !ccClassId2ccIdSetMap.isEmpty() && !CollectionUtils.isEmpty(ccIdSet = ccClassId2ccIdSetMap.get(ccClassId))) {
                    Long ccId;
                    String key;
                    Iterator<Long> iterator = ccIdSet.iterator();
                    while (iterator.hasNext() && !pccid2TargetMap.containsKey(key = this.buildCCid2TargetMapKey(policyId, ccId = iterator.next()))) {
                        DynamicObject cloneTarget = (DynamicObject)OrmUtils.clone((IDataEntityBase)target, (boolean)false, (boolean)true);
                        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)cloneTarget, (String)ccKey, (long)ccId);
                        pccid2TargetMap.put(key, cloneTarget);
                    }
                }
            }
        }
    }

    private boolean isChannel(long rebateClassId) {
        return rebateClassId == 1695535217797783552L;
    }

    private boolean isCustomer(long rebateClassId) {
        return rebateClassId == 1695535399184650240L;
    }

    private String buildCCid2TargetMapKey(long policyId, long ccid) {
        return policyId + "#" + ccid;
    }

    private List<DynamicObject> splitTargetByEffDate(DynamicObject target, Date now, Map<String, Map<String, SettlePeriod>> settlePeriodCache) {
        ArrayList<Object> splitedTargetList = new ArrayList<DynamicObject>(0);
        List settlePeriodList = RebateHelper.getSplitSettlePeriodList((DynamicObject)target, (Date)now, settlePeriodCache);
        if (!CollectionUtils.isEmpty((Collection)settlePeriodList)) {
            int batchSize = settlePeriodList.size();
            splitedTargetList = new ArrayList(batchSize);
            Map settlePeriodMap = RebateHelper.getSettlePeriodMap((DynamicObject)target, settlePeriodCache);
            for (int i = 0; i < batchSize; ++i) {
                SettlePeriod settlePeriod = (SettlePeriod)settlePeriodList.get(i);
                if (i == 0) {
                    splitedTargetList.add(this.resetSplitTartget(settlePeriodMap, target, settlePeriod));
                    continue;
                }
                splitedTargetList.add(this.resetSplitTartget(settlePeriodMap, (DynamicObject)OrmUtils.clone((IDataEntityBase)target, (boolean)false, (boolean)true), settlePeriod));
            }
        }
        return splitedTargetList;
    }

    private DynamicObject resetSplitTartget(Map<String, SettlePeriod> settlePeriodMap, DynamicObject splitTarget, SettlePeriod settlePeriod) {
        String name = this.buildTargetNameWithoutFlownum(splitTarget);
        if (!CollectionUtils.isEmpty(settlePeriodMap) && settlePeriodMap.size() > 1) {
            name = name + RebatePolicy2TargetConvert.flowNum(settlePeriod.getIndex());
        }
        splitTarget.set("starttime", (Object)settlePeriod.getBeginDate());
        splitTarget.set("endtime", (Object)settlePeriod.getEndDate());
        splitTarget.set("name", (Object)name);
        return splitTarget;
    }

    private String buildTargetNameWithoutFlownum(DynamicObject target) {
        String policyNumber = target.getDynamicObject("policy").getString("number");
        long rebateClassId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)target, (String)"nrebateclass");
        String ccKey = null;
        if (this.isCustomer(rebateClassId)) {
            ccKey = "benifitcustomer";
        } else if (this.isChannel(rebateClassId)) {
            ccKey = "benifitchl";
        }
        if (StringUtils.isNotEmpty((String)ccKey) && target.getDynamicObject(ccKey) != null) {
            return policyNumber + target.getDynamicObject(ccKey).getString("name");
        }
        return policyNumber;
    }

    public static String flowNum(int idx) {
        String flowNum = FLOWNUM_PREFIX + idx;
        return "-" + flowNum.substring(flowNum.length() - 3, flowNum.length());
    }
}

