/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebate.rebatepolicy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.handle.HorizontChildHelper;
import kd.occ.ocbase.business.handle.RebateHandle;
import kd.occ.ocbase.business.helper.ComboItemHelper;
import kd.occ.ocbase.common.enums.LadderTypeEnums;
import kd.occ.ocbase.common.enums.RebateTypeEnum;
import kd.occ.ocbase.common.enums.TargetCalTypeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class RebatePolicyBaseEdit
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    public static final String customergroup = "customergroup";
    public static final String secitemgroup = "secitemgroup";
    public static final String additemclass = "additemclass";
    protected static final String ADDITEM = "additem";
    public static final String pkValue = "id";
    protected static final String[] f7FieldKeys = new String[]{"rptoffice", "areadept", "country", "kpi", "reducetype", "rebateformula", "benefitchannel", "signchannel"};
    protected static final String[] entryFieldKeys = new String[]{"benefitchannel", "signchannel", "productmodel"};
    public static final long basicClassId = 836014120472951808L;
    public static final int maxItemClassLevel = 5;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1", "advcontoolbarap2"});
        this.addF7Listeners(f7FieldKeys);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        QFilter qFilter = null;
        switch (key) {
            case "rptoffice": {
                DynamicObject modelValue = (DynamicObject)this.getModel().getValue("areadept");
                if (null == modelValue) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5730\u533a\u90e8\u3002", (String)"RebatePolicyBaseEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                long parentId = Long.parseLong(modelValue.getPkValue().toString());
                qFilter = new QFilter("parent", "=", (Object)parentId);
                break;
            }
            case "country": {
                DynamicObject modelValue = (DynamicObject)this.getModel().getValue("areadept");
                if (modelValue == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5730\u533a\u90e8\u3002", (String)"RebatePolicyBaseEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                ArrayList<Object> countryIds = new ArrayList<Object>(1);
                DynamicObject country = modelValue.getDynamicObject("countryarea");
                if (country != null) {
                    countryIds.add(country.getPkValue());
                }
                if ((modelValue = (DynamicObject)this.getModel().getValue("rptoffice")) == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ee3\u8868\u5904\u3002", (String)"RebatePolicyBaseEdit_1", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                country = modelValue.getDynamicObject("countryarea");
                if (country != null) {
                    countryIds.add(country.getPkValue());
                }
                qFilter = new QFilter(pkValue, "in", countryIds);
                break;
            }
            case "rebateformula": {
                DynamicObject modelValue = (DynamicObject)this.getModel().getValue("reducetype");
                if (modelValue == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6fc0\u52b1\u6263\u51cf\u7c7b\u578b\u3002", (String)"RebatePolicyBaseEdit_2", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                qFilter = this.setRebateFormulaFilter(Long.parseLong(modelValue.getPkValue().toString()));
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter setRebateFormulaFilter(long reducetypeId) {
        ArrayList<Long> ids = new ArrayList<Long>(0);
        if (reducetypeId == 1031886754971754496L) {
            ids.add(1032492724106017792L);
            ids.add(1032492815130927104L);
            ids.add(1032492923276861440L);
        } else if (reducetypeId == 1031886228645198848L) {
            ids.add(1032491749744156672L);
            ids.add(1032491954367347712L);
            ids.add(1032492030284250112L);
        } else if (reducetypeId == 1031886917450578944L) {
            ids.add(1032493019611635712L);
            ids.add(1032493121071849472L);
        } else if (reducetypeId == 1032491385636502528L) {
            ids.add(1032493202684616704L);
            ids.add(1032493298306359296L);
            ids.add(1032493431324516352L);
        } else if (reducetypeId == 1032491513646784512L) {
            ids.add(1032493553739472896L);
            ids.add(1032493655350681600L);
        }
        return new QFilter(pkValue, "in", ids);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateValuesByKpiChange();
        this.setFormulaEntryEnable(this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "addincomecus": 
            case "addsigncus": 
            case "customergroup": 
            case "secitemgroup": 
            case "additemclass": 
            case "additem": {
                String checkMsg = this.checkValuesBeforeAddEntry();
                if (!StringUtils.isNotEmpty((CharSequence)checkMsg)) break;
                e.setCancel(true);
                this.getView().showMessage(checkMsg);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "deleteincomecus": {
                DynamicObject kpi = (DynamicObject)this.getModel().getValue("kpi");
                if (kpi == null || !"B".equalsIgnoreCase(kpi.getString("childtype"))) break;
                DynamicObjectCollection signEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity1");
                signEntity.clear();
                DynamicObjectCollection cusEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity");
                int srowIndex = 0;
                for (DynamicObject cus : cusEntity) {
                    signEntity.addNew();
                    this.getModel().setValue("signcustomer", (Object)DynamicObjectUtils.getPkValue((DynamicObject)cus, (String)"benefitcustomer"), srowIndex);
                    this.getModel().setValue("schannelfirstclass", (Object)DynamicObjectUtils.getPkValue((DynamicObject)cus, (String)"bchannelfirstclass"), srowIndex);
                    this.getModel().setValue("schannelsecclass", (Object)DynamicObjectUtils.getPkValue((DynamicObject)cus, (String)"bchannelsecclass"), srowIndex);
                    this.getModel().setValue("signchannel", (Object)DynamicObjectUtils.getPkValue((DynamicObject)cus, (String)"benefitchannel"), srowIndex);
                    ++srowIndex;
                }
                this.getView().updateView("incomecusentity1");
                break;
            }
            case "customergroup": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"ocdbd_customgroup", (boolean)true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, customergroup));
                showParameter.setCustomParam("enable", (Object)"1");
                DynamicObject office = (DynamicObject)this.getModel().getValue("rptoffice");
                showParameter.setCustomParam("rptoffice", (Object)DynamicObjectUtils.getPkValue((DynamicObject)office));
                DynamicObject country = (DynamicObject)this.getModel().getValue("country");
                showParameter.setCustomParam("country", (Object)DynamicObjectUtils.getPkValue((DynamicObject)country));
                DynamicObject areadept = (DynamicObject)this.getModel().getValue("areadept");
                showParameter.setCustomParam("areadept", (Object)DynamicObjectUtils.getPkValue((DynamicObject)areadept));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "secitemgroup": {
                ListShowParameter itemParameter = ShowFormHelper.createShowListForm((String)"ocdbd_productgroup", (boolean)true);
                itemParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, secitemgroup));
                itemParameter.setCustomParam("enable", (Object)"1");
                DynamicObject rptoffice = (DynamicObject)this.getModel().getValue("rptoffice");
                itemParameter.setCustomParam("office", (Object)DynamicObjectUtils.getPkValue((DynamicObject)rptoffice));
                DynamicObject itemcountry = (DynamicObject)this.getModel().getValue("country");
                itemParameter.setCustomParam("country", (Object)DynamicObjectUtils.getPkValue((DynamicObject)itemcountry));
                DynamicObject areaDept = (DynamicObject)this.getModel().getValue("areadept");
                itemParameter.setCustomParam("area", (Object)DynamicObjectUtils.getPkValue((DynamicObject)areaDept));
                this.getView().showForm((FormShowParameter)itemParameter);
                break;
            }
            case "additemclass": {
                RebateHandle.showItemClassF7((IFormView)this.getView(), (IFormPlugin)this, (String)additemclass);
                break;
            }
            case "additem": {
                RebateHandle.showItemF7((IFormView)this.getView(), (IFormPlugin)this, (String)ADDITEM);
                break;
            }
        }
    }

    private String checkValuesBeforeAddEntry() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("areadept");
        if (value == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5730\u533a\u90e8\u3002", (String)"RebatePolicyBaseEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]);
        }
        value = (DynamicObject)this.getModel().getValue("rptoffice");
        if (value == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ee3\u8868\u5904\u3002", (String)"RebatePolicyBaseEdit_1", (String)"occ-occpic-formplugin", (Object[])new Object[0]);
        }
        value = (DynamicObject)this.getModel().getValue("country");
        if (value == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6\u3002", (String)"RebatePolicyBaseEdit_3", (String)"occ-occpic-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnIdList = (ListSelectedRowCollection)e.getReturnData();
        List ids = returnIdList.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)returnIdList)) {
            return;
        }
        switch (e.getActionId()) {
            case "customergroup": {
                DynamicObjectCollection incomeCusEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity");
                QFilter filter = new QFilter(pkValue, "in", ids);
                DynamicObjectCollection customerGroupList = ORM.create().query("ocdbd_customgroup", filter.toArray());
                if (CollectionUtils.isEmpty((Collection)customerGroupList)) {
                    return;
                }
                List<String> entryKeyList = this.getChannelEntryCollectionKeyList("incomecusentity", "benefitcustomer", "bchannelfirstclass", "bchannelsecclass", "benefitchannel");
                ArrayList<Long> existCIdList = new ArrayList<Long>(0);
                for (DynamicObject customerGroup : customerGroupList) {
                    DynamicObjectCollection customerDetailList = customerGroup.getDynamicObjectCollection("commentryentity");
                    for (Object detail : customerDetailList) {
                        DynamicObject channelObject;
                        long id;
                        String key = String.format("%s_%s_%s_%s", DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"customerid"), DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"channelclass1"), DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"channelclass2"), DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"channelid"));
                        if (entryKeyList.contains(key) || (id = (channelObject = detail.getDynamicObject("channelid")) == null ? 0L : Long.parseLong(channelObject.getPkValue().toString())) <= 0L || existCIdList.contains(id)) continue;
                        DynamicObject incomeCus = incomeCusEntity.addNew();
                        incomeCus.set("bchannelfirstclass", (Object)detail.getDynamicObject("channelclass1"));
                        incomeCus.set("bchannelsecclass", (Object)detail.getDynamicObject("channelclass2"));
                        incomeCus.set("benefitcustomer", (Object)detail.getDynamicObject("customerid"));
                        incomeCus.set("benefitchannel", (Object)detail.getDynamicObject("channelid"));
                        existCIdList.add(id);
                    }
                }
                this.getView().updateView("incomecusentity");
                DynamicObject kpi = this.getF7Value("kpi");
                if (kpi == null || !"B".equalsIgnoreCase(kpi.getString("childtype"))) break;
                DynamicObjectCollection signEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity1");
                signEntity.clear();
                DynamicObjectCollection cusEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity");
                for (DynamicObject cus : cusEntity) {
                    DynamicObject addSignObj = signEntity.addNew();
                    addSignObj.set("signcustomer", (Object)cus.getDynamicObject("benefitcustomer"));
                    addSignObj.set("schannelfirstclass", (Object)cus.getDynamicObject("bchannelfirstclass"));
                    addSignObj.set("schannelsecclass", (Object)cus.getDynamicObject("bchannelsecclass"));
                    addSignObj.set("signchannel", (Object)cus.getDynamicObject("benefitchannel"));
                }
                this.getView().updateView("incomecusentity1");
                break;
            }
            case "secitemgroup": {
                DynamicObjectCollection itemClassEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itemclassentity");
                QFilter classFilter = new QFilter(pkValue, "in", ids);
                DynamicObjectCollection itemGroupCol = ORM.create().query("ocdbd_productgroup", classFilter.toArray());
                if (CollectionUtils.isEmpty((Collection)itemGroupCol)) {
                    return;
                }
                Set itemKeySet = RebateHandle.getEntryKeySet((String)"itemclassentity", (DynamicObjectCollection)itemClassEntity);
                for (DynamicObject itemGroup : itemGroupCol) {
                    DynamicObjectCollection classDetailCol = itemGroup.getDynamicObjectCollection("entryentity");
                    for (DynamicObject detail : classDetailCol) {
                        String reverseKey = RebateHandle.getEntryKey((String)"entryentity", (DynamicObject)detail);
                        if (itemKeySet.contains(reverseKey)) continue;
                        DynamicObject itemClass = itemClassEntity.addNew();
                        itemClass.set("firstclass", (Object)detail.getDynamicObject("plv1"));
                        itemClass.set("secondclass", (Object)detail.getDynamicObject("plv2"));
                        itemClass.set("thirdclass", (Object)detail.getDynamicObject("plv3"));
                        itemClass.set("fourthclass", (Object)detail.getDynamicObject("plv4"));
                        itemClass.set("productmodel", (Object)detail.getDynamicObject("plv5"));
                        itemClass.set("item", (Object)detail.getDynamicObject("item"));
                        itemClass.set("material", (Object)detail.getDynamicObject("material"));
                        DynamicObjectCollection subEntity = itemClass.getDynamicObjectCollection("subentryentity");
                        DynamicObjectCollection sourceSubEntity = detail.getDynamicObjectCollection("subentryentity");
                        for (DynamicObject sourceSub : sourceSubEntity) {
                            DynamicObject subObject = subEntity.addNew();
                            subObject.set("subfirstclass", (Object)sourceSub.getDynamicObject("lv1"));
                            subObject.set("subsecondclass", (Object)sourceSub.getDynamicObject("lv2"));
                            subObject.set("subthirdclass", (Object)sourceSub.getDynamicObject("lv3"));
                            subObject.set("subfourthclass", (Object)sourceSub.getDynamicObject("lv4"));
                            subObject.set("subproductmodel", (Object)sourceSub.getDynamicObject("itemclassid"));
                        }
                        itemClass.set("subentryentity", (Object)subEntity);
                    }
                }
                this.getModel().setValue("itemclassentity", (Object)itemClassEntity);
                this.getView().updateView("itemclassentity");
                break;
            }
            case "additemclass": {
                QFilter addClassFilter = new QFilter(pkValue, "in", ids);
                DynamicObjectCollection itemClassList = ORM.create().query("mdr_item_class", addClassFilter.toArray());
                this.updateItemClassEntityValues(itemClassList);
                break;
            }
            case "additem": {
                RebateHandle.addPItem((IFormView)this.getView(), (String)"itemclassentity", ids);
                break;
            }
        }
    }

    private void updateItemClassEntityValues(DynamicObjectCollection itemClassList) {
        DynamicObjectCollection itemClassEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itemclassentity");
        List<String> itemKeyList = this.getItemClassKeyList(itemClassEntity);
        Map<Integer, String> classMap = this.itemClassLevelMap();
        for (DynamicObject itemClass : itemClassList) {
            int maxLevel;
            String reverseKey;
            List<Object> ics = new ArrayList<DynamicObject>();
            long pid = itemClass.getLong("parent.id");
            ics.add(itemClass);
            if (pid != 0L) {
                this.getItemClassByParent(pid, ics);
            }
            if (ics.size() > 5) {
                ics = ics.subList(ics.size() - 5, ics.size());
            }
            if (itemKeyList.contains(reverseKey = this.reverseItemClassIdsKey(ics))) continue;
            Collections.reverse(ics);
            DynamicObject newClass = itemClassEntity.addNew();
            int defalutSize = maxLevel = ics.size() > 5 ? 5 : ics.size();
            for (int i = 0; i < maxLevel; ++i) {
                newClass.set(classMap.get(defalutSize), ics.get(i));
                --defalutSize;
            }
            long itemClassId = DynamicObjectUtils.getPkValue((DynamicObject)itemClass);
            this.updateProductModelDetialValues(itemClassId, newClass, "firstclass", "secondclass", "thirdclass", "fourthclass");
        }
        this.getModel().setValue("itemclassentity", (Object)itemClassEntity);
        this.getView().updateView("itemclassentity");
        this.getView().updateView("subentryentity");
    }

    private String reverseItemClassIdsKey(List<DynamicObject> itemClassList) {
        if (CollectionUtils.isEmpty(itemClassList)) {
            return null;
        }
        Collections.reverse(itemClassList);
        ArrayList<Long> ids = new ArrayList<Long>(itemClassList.size());
        for (DynamicObject itemClass : itemClassList) {
            ids.add(DynamicObjectUtils.getPkValue((DynamicObject)itemClass));
        }
        return StringUtils.join((Object[])ids.toArray(), (String)",");
    }

    private List<String> getItemClassKeyList(DynamicObjectCollection itemClassEntity) {
        ArrayList<String> itemKeyList = new ArrayList<String>(itemClassEntity.size());
        for (DynamicObject itemClass : itemClassEntity) {
            String key;
            long productModelId;
            long fourthClassId;
            long thirdClassId;
            long secondClassId;
            ArrayList<Long> keyIds = new ArrayList<Long>(5);
            long firstClassId = DynamicObjectUtils.getPkValue((DynamicObject)itemClass, (String)"firstclass");
            if (firstClassId > 0L) {
                keyIds.add(firstClassId);
            }
            if ((secondClassId = DynamicObjectUtils.getPkValue((DynamicObject)itemClass, (String)"secondclass")) > 0L) {
                keyIds.add(secondClassId);
            }
            if ((thirdClassId = DynamicObjectUtils.getPkValue((DynamicObject)itemClass, (String)"thirdclass")) > 0L) {
                keyIds.add(thirdClassId);
            }
            if ((fourthClassId = DynamicObjectUtils.getPkValue((DynamicObject)itemClass, (String)"fourthclass")) > 0L) {
                keyIds.add(fourthClassId);
            }
            if ((productModelId = DynamicObjectUtils.getPkValue((DynamicObject)itemClass, (String)"productmodel")) > 0L) {
                keyIds.add(productModelId);
            }
            if (itemKeyList.contains(key = StringUtils.join((Object[])keyIds.toArray(), (String)","))) continue;
            itemKeyList.add(key);
        }
        return itemKeyList;
    }

    private void updateProductModelDetialValues(long classId, DynamicObject parentItemClass, String efFirstclass, String efSecondclass, String efThirdclass, String efFourthclass) {
        HorizontChildHelper horizontChildHelper = new HorizontChildHelper();
        List childLevelList = horizontChildHelper.ShowHighLevels("mdr_item_class", Long.valueOf(classId));
        DynamicObjectCollection itemClassSubEntity = parentItemClass.getDynamicObjectCollection("subentryentity");
        itemClassSubEntity.clear();
        if (!CollectionUtils.isEmpty((Collection)childLevelList)) {
            Map<Integer, String> subClassMap = this.parentItemClassLevelMap();
            for (List levelDetail : childLevelList) {
                DynamicObject addValue = itemClassSubEntity.addNew();
                int maxLevel = levelDetail.size() > 5 ? 5 : levelDetail.size();
                int defalutSize = 5;
                for (int i = 0; i < maxLevel; ++i) {
                    addValue.set(subClassMap.get(defalutSize) + "_id", levelDetail.get(i));
                    --defalutSize;
                }
            }
        }
    }

    private void getItemClassByParent(long pid, List<DynamicObject> ics) {
        QFilter filters = new QFilter(pkValue, "=", (Object)pid);
        DynamicObject[] itemClass = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id,parent", (QFilter[])filters.toArray());
        if (itemClass != null && itemClass.length > 0) {
            DynamicObject ic = itemClass[0];
            long nextPid = ic.getLong("parent_id");
            ics.add(ic);
            this.getItemClassByParent(nextPid, ics);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateValuesByKpiChange();
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        this.triggerChangeEvent = true;
        ChangeData[] changeData = e.getChangeSet();
        switch (key) {
            case "formulalevel": {
                String formulaLevel = (String)this.getModel().getValue("formulalevel");
                if (StringUtils.isEmpty((CharSequence)formulaLevel)) {
                    return;
                }
                int formulalevel = Integer.parseInt(formulaLevel);
                this.createNewFormulaEntry(formulalevel);
                break;
            }
            case "kpi": {
                this.updateValuesByKpiChange();
                this.clearAllDetailEntry();
                String formulaLevel1 = (String)this.getModel().getValue("formulalevel");
                if (StringUtils.isEmpty((CharSequence)formulaLevel1)) {
                    return;
                }
                int formulalevel1 = Integer.parseInt(formulaLevel1);
                this.createNewFormulaEntry(formulalevel1);
                break;
            }
            case "rebatetype": {
                this.updateValuesByKpiChange();
                break;
            }
            case "areadept": {
                this.getModel().setValue("rptoffice", null);
                this.getModel().setValue("country", null);
                break;
            }
            case "target": {
                this.setFormulasValues();
                break;
            }
            case "maxamount": 
            case "maxachive": 
            case "maxqty": {
                this.handleMaxEntryKeyChanged(e, key);
                break;
            }
            case "benefitchannel": {
                this.updateChannelEntryValues(changeData, "benefitcustomer", "bchannelfirstclass", "bchannelsecclass", "benefitchannel", "incomecusentity");
                break;
            }
            case "signchannel": {
                this.updateChannelEntryValues(changeData, "signcustomer", "schannelfirstclass", "schannelsecclass", "signchannel", "incomecusentity1");
                break;
            }
            case "productmodel": {
                DynamicObject productModel = (DynamicObject)changeData[0].getNewValue();
                if (productModel == null) {
                    return;
                }
                int rowIndex = changeData[0].getRowIndex();
                this.updateProductModelEntryValues(productModel, "firstclass", "secondclass", "thirdclass", "fourthclass", rowIndex);
                break;
            }
        }
        this.setFormulaEntryEnable(this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
    }

    private void clearAllDetailEntry() {
        DynamicObjectCollection detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity");
        detailEntry.clear();
        this.getView().updateView("incomecusentity");
        detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity1");
        detailEntry.clear();
        this.getView().updateView("incomecusentity1");
        detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        detailEntry.clear();
        this.getView().updateView("entryentity");
        detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itemclassentity");
        detailEntry.clear();
        this.getView().updateView("itemclassentity");
    }

    private void setFormulasValues() {
        DynamicObjectCollection formulasList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)formulasList)) {
            return;
        }
        int formulasLevel = formulasList.size();
        for (int rowIndex = 0; rowIndex < formulasLevel; ++rowIndex) {
            this.getModel().setValue("minachive", null, rowIndex);
            this.getModel().setValue("maxachive", null, rowIndex);
            this.getModel().setValue("minamount", null, rowIndex);
            this.getModel().setValue("maxamount", null, rowIndex);
            this.getModel().setValue("minqty", null, rowIndex);
            this.getModel().setValue("maxqty", null, rowIndex);
        }
    }

    private void updateValuesByKpiChange() {
        DynamicObject kpi = (DynamicObject)this.getModel().getValue("kpi");
        if (kpi == null) {
            return;
        }
        long ladderTypeId = DynamicObjectUtils.getPkValue((DynamicObject)kpi, (String)"laddertype");
        FieldEdit formulaLevelControl = (FieldEdit)this.getControl("formulalevel");
        formulaLevelControl.setMustInput(LadderTypeEnums.NORMAL.getTypeId() == ladderTypeId);
        String targetcaltype = DynamicObjectUtils.getString((DynamicObject)kpi, (String)"targetcaltype");
        if (LadderTypeEnums.ACHIEVEMENT.getTypeId() == ladderTypeId) {
            if (TargetCalTypeEnum.AMOUNT.getValue().equalsIgnoreCase(targetcaltype)) {
                FieldEdit baselineAmount = (FieldEdit)this.getControl("baselineamount");
                baselineAmount.setMustInput(true);
                this.getModel().setValue("rebatetype", (Object)"A");
                this.getView().setEnable(Boolean.FALSE, new String[]{"rebatetype"});
            } else if (TargetCalTypeEnum.QTY.getValue().equalsIgnoreCase(targetcaltype)) {
                FieldEdit baselineQty = (FieldEdit)this.getControl("baselineqty");
                baselineQty.setMustInput(true);
                this.getView().setEnable(Boolean.TRUE, new String[]{"rebatetype"});
            }
        } else if (LadderTypeEnums.MBO.getTypeId() == ladderTypeId) {
            FieldEdit highestRebate = (FieldEdit)this.getControl("highestrebate");
            highestRebate.setMustInput(true);
            this.getModel().setValue("formulalevel", (Object)"");
            this.getModel().setValue("rebatetype", (Object)"A");
            this.getView().setEnable(Boolean.FALSE, new String[]{"rebatetype"});
        } else if (LadderTypeEnums.UNCONDITION.getTypeId() == ladderTypeId) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"rebatetype"});
        } else if (LadderTypeEnums.NORMAL.getTypeId() == ladderTypeId) {
            if (TargetCalTypeEnum.AMOUNT.getValue().equalsIgnoreCase(targetcaltype)) {
                this.getModel().setValue("rebatetype", (Object)RebateTypeEnum.percentage.getValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"rebatetype"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"rebatetype"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"rebatetype"});
        }
        ComboEdit rebateTypeControl = (ComboEdit)this.getView().getControl("rebatetype");
        HashSet<String> valueSet = new HashSet<String>(1);
        valueSet.add(RebateTypeEnum.fixedamount.getValue());
        if (LadderTypeEnums.UNCONDITION.getTypeId() == ladderTypeId) {
            ComboItemHelper.setItemVisible((ComboEdit)rebateTypeControl, valueSet, (boolean)true);
        } else {
            ComboItemHelper.setItemVisible((ComboEdit)rebateTypeControl, valueSet, (boolean)false);
        }
        if ("B".equalsIgnoreCase(kpi.getString("childtype"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"addsigncus"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"deletesigncus"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"addsigncus"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"deletesigncus"});
        }
        this.updateFormulaByKpi();
    }

    private void handleMaxEntryKeyChanged(PropertyChangedArgs e, String maxKey) {
        int row = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String minKey = maxKey.replace("max", "min");
        BigDecimal maxValue = (BigDecimal)newValue;
        if (maxValue != null && BigDecimal.ZERO.compareTo(maxValue) != 0) {
            BigDecimal minValue = (BigDecimal)this.getValue(minKey, row);
            if (maxValue.compareTo(minValue) > 0) {
                this.setNextLevelMinByMax(minKey, maxKey, maxValue, oldValue, row);
            } else {
                this.setValue(maxKey, oldValue, row);
            }
        }
    }

    private void setNextLevelMinByMax(String minKey, String maxKey, BigDecimal maxValue, Object oldValue, int row) {
        int nextRow = row + 1;
        if (this.getModel().getEntryRowCount("entryentity") > nextRow) {
            BigDecimal nextMaxValue = (BigDecimal)this.getValue(maxKey, nextRow);
            if (nextMaxValue != null && BigDecimal.ZERO.compareTo(nextMaxValue) != 0 && maxValue.compareTo(nextMaxValue) >= 0) {
                this.setValue(maxKey, null, row);
                this.setValue(minKey, null, nextRow);
            } else {
                this.setValue(minKey, maxValue, nextRow);
            }
        }
    }

    private void updateProductModelEntryValues(DynamicObject productModel, String firstClass, String secondClass, String thirdClass, String fourthClass, int rowIndex) {
        List childLevelList;
        DynamicObject parentItemClass;
        int i;
        Map<Integer, String> classMap = this.itemClassLevelMap();
        HorizontChildHelper horizontChildHelper = new HorizontChildHelper();
        DynamicObjectCollection itemClassEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itemclassentity");
        long classId = DynamicObjectUtils.getPkValue((DynamicObject)productModel);
        List levelList = horizontChildHelper.ShowHighLevels("mdr_item_class", Long.valueOf(classId));
        if (CollectionUtils.isEmpty((Collection)levelList)) {
            return;
        }
        DynamicObject itemClassInfo = this.getItemClass(classId);
        if (itemClassInfo == null) {
            return;
        }
        int level = itemClassInfo.getInt("level");
        long parentId = classId;
        for (i = 0; i < level && (parentItemClass = this.getItemClass(parentId)) != null; ++i) {
            DynamicObject parent;
            int parentLevelId = parentItemClass.getInt("level");
            if (parentLevelId > 5) {
                parent = parentItemClass.getDynamicObject("parent");
                if (parent == null) continue;
                parentId = Long.parseLong(parent.getPkValue().toString());
                continue;
            }
            this.getModel().setValue(classMap.get(parentLevelId), (Object)parentId, rowIndex);
            parent = parentItemClass.getDynamicObject("parent");
            if (parent == null) continue;
            parentId = Long.parseLong(parent.getPkValue().toString());
        }
        if (level < 5) {
            for (i = level + 1; i <= 5; ++i) {
                String value = classMap.get(i);
                if (value == null) continue;
                this.getModel().setValue(value, null, rowIndex);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(childLevelList = horizontChildHelper.ShowHighLevels("mdr_item_class", Long.valueOf(classId))))) {
            Map<Integer, String> subClassMap = this.parentItemClassLevelMap();
            DynamicObject itemClassValue = (DynamicObject)itemClassEntity.get(rowIndex);
            DynamicObjectCollection itemClassSubEntity = itemClassValue.getDynamicObjectCollection("subentryentity");
            itemClassSubEntity.clear();
            for (List levelDetail : childLevelList) {
                DynamicObject addValue = itemClassSubEntity.addNew();
                int maxLevel = levelDetail.size() > 5 ? 5 : levelDetail.size();
                int defalutSize = levelDetail.size();
                for (int i2 = 0; i2 < maxLevel; ++i2) {
                    addValue.set(subClassMap.get(defalutSize) + "_id", levelDetail.get(i2));
                    --defalutSize;
                }
            }
            itemClassValue.set("subentryentity", (Object)itemClassSubEntity);
        }
        this.getModel().setValue("itemclassentity", (Object)itemClassEntity, rowIndex);
        this.getView().updateView("itemclassentity", rowIndex);
    }

    private DynamicObject getItemClass(long classId) {
        QFilter filter = new QFilter(pkValue, "=", (Object)classId);
        return ORM.create().queryOne("mdr_item_class", filter.toArray());
    }

    private Map<Integer, String> parentItemClassLevelMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>(5);
        map.put(1, "subfirstclass");
        map.put(2, "subsecondclass");
        map.put(3, "subthirdclass");
        map.put(4, "subfourthclass");
        map.put(5, "subproductmodel");
        return map;
    }

    private Map<Integer, String> itemClassLevelMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>(5);
        map.put(1, "firstclass");
        map.put(2, "secondclass");
        map.put(3, "thirdclass");
        map.put(4, "fourthclass");
        map.put(5, "productmodel");
        return map;
    }

    public long getParentItemClassId(long itemClassId) {
        DynamicObject parent;
        long parentId = 0L;
        QFilter filter = new QFilter(pkValue, "=", (Object)itemClassId);
        DynamicObject itemClass = ORM.create().queryOne("mdr_item_class", filter.toArray());
        if (itemClass != null && itemClass.getInt("level") <= 5 && (parent = itemClass.getDynamicObject("parent")) != null) {
            parentId = Long.parseLong(parent.getPkValue().toString());
        }
        return parentId;
    }

    private void updateChannelEntryValues(ChangeData[] changeData, String ef_customer, String ef_firstclass, String ef_secclass, String ef_channel, String channelEntry) {
        if (changeData == null || changeData.length == 0) {
            return;
        }
        List<String> entryKeyList = this.getChannelEntryCollectionKeyList(channelEntry, ef_customer, ef_firstclass, ef_secclass, ef_channel);
        for (ChangeData changeItem : changeData) {
            int rowIndex = changeItem.getRowIndex();
            DynamicObject value = (DynamicObject)changeItem.getNewValue();
            if (value == null) continue;
            DynamicObjectCollection channelClassEntity = value.getDynamicObjectCollection("channelclassentity");
            DynamicObject secclass = null;
            long classifyId = 0L;
            for (DynamicObject channelClass : channelClassEntity) {
                DynamicObject classify = channelClass.getDynamicObject("classstandard");
                if (classify == null || (classifyId = Long.parseLong(classify.getPkValue().toString())) != 836014120472951808L) continue;
                secclass = channelClass.getDynamicObject("channelclass");
                break;
            }
            Object secPkValue = secclass == null ? Long.valueOf(0L) : secclass.getPkValue();
            long secClassId = secPkValue == null ? 0L : Long.parseLong(secPkValue.toString());
            long parentId = this.getParentChannelClass(secClassId);
            String key = String.format("%s_%s_%s_%s", value.getPkValue(), parentId, secClassId, DynamicObjectUtils.getPkValue((DynamicObject)value));
            if (entryKeyList.contains(key)) continue;
            entryKeyList.add(key);
            this.getModel().setValue(ef_customer, value.getPkValue(), rowIndex);
            this.getModel().setValue(ef_secclass, (Object)secClassId, rowIndex);
            this.getModel().setValue(ef_firstclass, (Object)parentId, rowIndex);
            this.getView().updateView("entryentity", rowIndex);
            DynamicObject kpi = (DynamicObject)this.getModel().getValue("kpi");
            if (kpi == null || !"incomecusentity".equals(channelEntry) || !"B".equalsIgnoreCase(kpi.getString("childtype"))) continue;
            DynamicObjectCollection signEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity1");
            signEntity.clear();
            DynamicObjectCollection cusEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("incomecusentity");
            for (DynamicObject cus : cusEntity) {
                DynamicObject addSignObj = signEntity.addNew();
                addSignObj.set("signcustomer", (Object)cus.getDynamicObject("benefitcustomer"));
                addSignObj.set("schannelfirstclass", (Object)cus.getDynamicObject("bchannelfirstclass"));
                addSignObj.set("schannelsecclass", (Object)cus.getDynamicObject("bchannelsecclass"));
                addSignObj.set("signchannel", (Object)cus.getDynamicObject("benefitchannel"));
            }
            this.getView().updateView("incomecusentity1");
        }
    }

    private List<String> getChannelEntryCollectionKeyList(String channelEntry, String ef_customer, String ef_firstclass, String ef_secclass, String ef_channel) {
        DynamicObjectCollection channelEntryCollection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection(channelEntry);
        ArrayList<String> entryKeyList = new ArrayList<String>(channelEntryCollection.size());
        for (DynamicObject entry : channelEntryCollection) {
            String key = String.format("%s_%s_%s_%s", DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_customer), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_firstclass), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_secclass), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_channel));
            if (entryKeyList.contains(key)) continue;
            entryKeyList.add(key);
        }
        return entryKeyList;
    }

    public long getParentChannelClass(long id) {
        DynamicObject parent;
        long parentId = 0L;
        QFilter filter = new QFilter(pkValue, "=", (Object)id);
        DynamicObject channelClass = ORM.create().queryOne("ocdbd_channel_class", filter.toArray());
        if (channelClass != null && (parent = channelClass.getDynamicObject("parent")) != null) {
            parentId = Long.parseLong(parent.getPkValue().toString());
        }
        return parentId;
    }

    private void updateFormulaByKpi() {
        DynamicObject kpi = (DynamicObject)this.getModel().getValue("kpi");
        if (kpi == null) {
            return;
        }
        String rebateType = (String)this.getModel().getValue("rebatetype");
        DynamicObject ladderType = kpi.getDynamicObject("laddertype");
        long ladderTypeId = ladderType == null ? 0L : ladderType.getLong(pkValue);
        String targetCalType = kpi.getString("targetcaltype");
        this.updateFormula(rebateType, ladderTypeId, targetCalType);
    }

    private void updateFormula(String rebateType, long ladderTypeId, String targetCalType) {
        QFilter filter = new QFilter("laddertype", "=", (Object)ladderTypeId);
        filter.and(new QFilter("rebatetype", "=", (Object)rebateType));
        filter.and(new QFilter("targetcaltype", "=", (Object)targetCalType));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject formula = ORM.create().queryOne("ocdbd_formula", filter.toArray());
        if (formula != null) {
            this.getModel().setValue("explication", formula.get("explication"));
            this.getModel().setValue("formula", formula.getPkValue());
            this.getView().updateView("formula");
        } else {
            this.getModel().setValue("explication", null);
        }
    }

    private void createNewFormulaEntry(int formulalevel) {
        DynamicObjectCollection formulaList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        formulaList.clear();
        for (int i = 0; i < formulalevel; ++i) {
            DynamicObject formula = formulaList.addNew();
            formula.set("minachive", (Object)BigDecimal.ZERO);
            formula.set("maxachive", (Object)BigDecimal.ZERO);
            formula.set("minamount", (Object)BigDecimal.ZERO);
            formula.set("maxamount", (Object)BigDecimal.ZERO);
            formula.set("minqty", (Object)BigDecimal.ZERO);
            formula.set("maxqty", (Object)BigDecimal.ZERO);
        }
        this.getModel().setValue("entryentity", (Object)formulaList);
        this.getView().updateView("entryentity");
    }

    protected final void setFormulaEntryEnable(DynamicObjectCollection formulaList, boolean targetSetting) {
        String target;
        if (CollectionUtils.isEmpty((Collection)formulaList)) {
            return;
        }
        int lastLevel = formulaList.size() - 1;
        if (targetSetting && "B".equalsIgnoreCase(target = (String)this.getModel().getValue("target"))) {
            for (int i = 0; i <= lastLevel; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"minachive", "minamount", "minqty"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"maxachive", "maxamount", "maxqty"});
            }
            return;
        }
        this.getView().setEnable(Boolean.TRUE, 0, new String[]{"minachive", "minamount", "minqty"});
        this.getView().setEnable(Boolean.TRUE, 0, new String[]{"maxachive", "maxamount", "maxqty"});
        for (int i = 1; i <= lastLevel; ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"minachive", "minamount", "minqty"});
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"maxachive", "maxamount", "maxqty"});
        }
        this.getView().setEnable(Boolean.FALSE, lastLevel, new String[]{"maxachive", "maxamount", "maxqty"});
    }

    protected void setFormulaEntryEnable(DynamicObjectCollection formulaList) {
        this.setFormulaEntryEnable(formulaList, true);
    }

    public void addF7Listeners(String[] f7Keys) {
        for (String key : f7Keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }
}

