/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebate.rebatepolicy;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;
import kd.occ.occpic.business.rebate.RebateHelper;

public class RebatePolicyList
extends OcbaseListPlugin {
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().endsWith("tblupdate")) {
            RebateHelper.rebateUpgrade();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "custompush": {
                Object[] policyIdArray = this.getSelectedRows().getPrimaryKeyValues();
                DynamicObject[] policyArray = QueryUtil.loadArray((Object[])policyIdArray, (String)"occpic_rebatepolicy", (String[])new String[]{"billstatus", "pushtype", "settperiod", "starttime", "endtime"});
                Map<String, List<DynamicObject>> policyMap = Arrays.stream(policyArray).collect(Collectors.groupingBy(r -> String.join((CharSequence)"#", r.getString("billstatus"), r.getString("pushtype"), r.getString("settperiod"))));
                if (policyMap.size() == 1) {
                    for (Map.Entry<String, List<DynamicObject>> policyEntry : policyMap.entrySet()) {
                        String key = policyEntry.getKey();
                        if (!key.startsWith("C#C#")) continue;
                        String settperiod = key.split("#")[2];
                        Date startTime = null;
                        Date endTime = null;
                        for (DynamicObject policy : policyEntry.getValue()) {
                            if (startTime == null) {
                                startTime = policy.getDate("starttime");
                            } else if (startTime.compareTo(policy.getDate("starttime")) > 0) {
                                startTime = policy.getDate("starttime");
                            }
                            if (endTime == null) {
                                endTime = policy.getDate("endtime");
                                continue;
                            }
                            if (endTime.compareTo(policy.getDate("endtime")) >= 0) continue;
                            endTime = policy.getDate("endtime");
                        }
                        RebateHelper.showCustomPushTarget((IFormView)this.getView(), (Object[])policyIdArray, (String)settperiod, startTime, endTime);
                        return;
                    }
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9700\u9009\u62e9\u5df2\u5ba1\u6838\uff0c\u653f\u7b56\u751f\u6210\u76ee\u6807\u63a7\u5236\u4e3a\u624b\u52a8\u6307\u5b9a\u7ed3\u7b97\u5468\u671f\u751f\u6210\uff0c\u76f8\u540c\u7ed3\u7b97\u5468\u671f \u7684 \u8fd4\u5229\u653f\u7b56\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RebatePolicyList_4", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

