/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebate.rebatepolicy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.enums.LadderTypeEnums;
import kd.occ.ocbase.common.enums.TargetCalTypeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.occpic.formplugin.rebate.rebatepolicy.RebatePolicyBaseEdit;

public class RebateTargetEdit
extends RebatePolicyBaseEdit {
    protected static final String[] f7FieldKeys = new String[]{"rptoffice", "areadept", "country"};
    protected static final String[] entryFieldKeys = new String[]{"signchannel"};
    public static final String EF_highestpercent_copy = "highestpercent_copy";

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addF7Listeners(f7FieldKeys);
    }

    @Override
    public void afterBindData(EventObject e) {
        this.hideBusinessOrg();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject kpi = dataEntity.getDynamicObject("kpi");
        long ladderTypePk = DynamicObjectUtils.getPkValue((DynamicObject)kpi, (String)"laddertype");
        if (LadderTypeEnums.MBO.getTypeId() == ladderTypePk) {
            this.getModel().setValue(EF_highestpercent_copy, dataEntity.get("highestpercent"));
            this.getModel().setDataChanged(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"formulaentity"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"highestpercent"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"highestpercent"});
        }
        this.setFormulaEntryEnable(this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("formulaentity"), false);
    }

    private void hideBusinessOrg() {
        boolean isbusinessorg = SysParamsUtil.isBusinessOrg();
        if (!isbusinessorg) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areadept"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"rptoffice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        QFilter qFilter = null;
        switch (key) {
            case "rptoffice": {
                DynamicObject areaDept = (DynamicObject)this.getModel().getValue("areadept");
                if (areaDept == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5730\u533a\u90e8\u3002", (String)"RebateTargetEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                long parentId = Long.parseLong(areaDept.getPkValue().toString());
                qFilter = new QFilter("parent", "=", (Object)parentId);
                break;
            }
            case "country": {
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "customergroup": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"ocdbd_regclient_role", (boolean)true);
                showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5ba2\u6237\uff1a", (String)"RebateTargetEdit_1", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customergroup"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() != null && "customergroup".equalsIgnoreCase(e.getActionId())) {
            DynamicObjectCollection formulaList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("benifitcustentity");
            formulaList.clear();
            ListSelectedRowCollection returnIdList = (ListSelectedRowCollection)e.getReturnData();
            List ids = returnIdList.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)returnIdList)) {
                QFilter filter = new QFilter("id", "in", ids);
                DynamicObjectCollection roleList = ORM.create().query("ocdbd_regclient_role", filter.toArray());
                if (!CollectionUtils.isEmpty((Collection)roleList)) {
                    for (int i = 0; i < roleList.size(); ++i) {
                        DynamicObject formula = formulaList.addNew();
                    }
                    this.getView().updateView("benifitcustentity");
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e, String key) {
        this.triggerChangeEvent = true;
        ArrayList arrayList = new ArrayList(entryFieldKeys.length);
        Collections.addAll(arrayList, entryFieldKeys);
        if (arrayList.contains(key)) {
            this.updateEntryFieldValues(e, key);
        } else if (e.getProperty().getParent().getName().equals("formulaentity") && key.indexOf("max") > -1) {
            this.setNextLevelMinByMax(e, key);
        }
    }

    private void setNextLevelMinByMax(PropertyChangedArgs e, String key) {
        DynamicObjectCollection formulaList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("formulaentity");
        ChangeData[] changeDataSet = e.getChangeSet();
        if (changeDataSet != null && changeDataSet.length > 0) {
            ChangeData changeData = changeDataSet[0];
            int nextRow = changeData.getRowIndex() + 1;
            Object maxValue = changeData.getNewValue();
            String nextMinKey = key.replace("max", "min");
            if (formulaList.size() > nextRow) {
                this.getModel().setValue(nextMinKey, maxValue, nextRow);
            }
        }
    }

    private void updateEntryFieldValues(PropertyChangedArgs e, String key) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        switch (key) {
            case "signchannel": {
                this.updateChannelEntryValues(changeData, "signcustomer", "schannelfirstclass", "schannelsecclass", "signchannel", "signcustentity");
                break;
            }
        }
    }

    private void updateChannelEntryValues(ChangeData[] changeData, String ef_customer, String ef_firstclass, String ef_secclass, String ef_channel, String channelEntry) {
        if (changeData == null || changeData.length == 0) {
            return;
        }
        List<String> entryKeyList = this.getChannelEntryCollectionKeyList(channelEntry, ef_customer, ef_firstclass, ef_secclass, ef_channel);
        for (ChangeData changeItem : changeData) {
            Object secClassPk;
            long secClassId;
            long parentId;
            DynamicObject parentChannel;
            Object pkValue;
            String key;
            int rowIndex = changeItem.getRowIndex();
            DynamicObject value = (DynamicObject)changeItem.getNewValue();
            if (value == null) continue;
            DynamicObjectCollection channelClassEntity = value.getDynamicObjectCollection("channelclassentity");
            DynamicObject secclass = null;
            long classifyId = 0L;
            for (DynamicObject channelClass : channelClassEntity) {
                DynamicObject classify = channelClass.getDynamicObject("classstandard");
                if (classify == null || (classifyId = Long.parseLong(classify.getPkValue().toString())) != 836014120472951808L) continue;
                secclass = channelClass.getDynamicObject("channelclass");
                break;
            }
            if (entryKeyList.contains(key = String.format("%s_%s_%s_%s", pkValue = (parentChannel = value.getDynamicObject("parent")) == null ? null : parentChannel.getPkValue(), parentId = this.getParentChannelClass(secClassId = (secClassPk = secclass == null ? Long.valueOf(0L) : secclass.getPkValue()) == null ? 0L : Long.parseLong(secClassPk.toString())), secClassId, DynamicObjectUtils.getPkValue((DynamicObject)value)))) continue;
            entryKeyList.add(key);
            this.getModel().setValue(ef_customer, pkValue, rowIndex);
            this.getModel().setValue(ef_secclass, (Object)secClassId, rowIndex);
            this.getModel().setValue(ef_firstclass, (Object)parentId, rowIndex);
            this.getView().updateView("formulaentity", rowIndex);
        }
    }

    private List<String> getChannelEntryCollectionKeyList(String channelEntry, String ef_customer, String ef_firstclass, String ef_secclass, String ef_channel) {
        DynamicObjectCollection channelEntryCollection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection(channelEntry);
        ArrayList<String> entryKeyList = new ArrayList<String>(channelEntryCollection.size());
        for (DynamicObject entry : channelEntryCollection) {
            String key = String.format("%s_%s_%s_%s", DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_customer), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_firstclass), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_secclass), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)ef_channel));
            if (entryKeyList.contains(key)) continue;
            entryKeyList.add(key);
        }
        return entryKeyList;
    }

    @Override
    public void addF7Listeners(String[] f7Keys) {
        for (String key : f7Keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection formulaDetail = this.getModel().getEntryEntity("formulaentity");
            if (CollectionUtils.isEmpty((Collection)formulaDetail)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u8be6\u60c5\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8fd4\u5229\u653f\u7b56\u3002", (String)"RebateTargetEdit_2", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject kpi = dataEntity.getDynamicObject("kpi");
            String rebateType = dataEntity.getString("rebatetype");
            BigDecimal highestPercent = dataEntity.getBigDecimal("highestpercent");
            long ladderTypeId = DynamicObjectUtils.getPkValue((DynamicObject)kpi, (String)"laddertype");
            String calcType = kpi.getString("targetcaltype");
            boolean calcByAmount = TargetCalTypeEnum.AMOUNT.getValue().equals(calcType);
            String normalTypeHint = String.format(ResManager.loadKDString((String)"%1$s\u6700\u5c0f\u503c\u3001\u6700\u5927\u503c", (String)"RebateTargetEdit_3", (String)"occ-occpic-formplugin", (Object[])new Object[0]), calcByAmount ? ResManager.loadKDString((String)"\u91d1\u989d", (String)"RebateTargetEdit_4", (String)"occ-occpic-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u91cf", (String)"RebateTargetEdit_5", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
            if (LadderTypeEnums.MBO.getTypeId() == DynamicObjectUtils.getPkValue((DynamicObject)kpi, (String)"laddertype")) {
                BigDecimal originHighestPercent = (BigDecimal)this.getModel().getValue(EF_highestpercent_copy);
                if (highestPercent.compareTo(BigDecimal.ZERO) <= 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u9ad8\u767e\u5206\u6bd4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"RebateTargetEdit_12", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (highestPercent.compareTo(originHighestPercent) > 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6700\u9ad8\u767e\u5206\u6bd4\u4e0d\u80fd\u8d85\u8fc7\u539f\u503c%1$s\u3002", (String)"RebateTargetEdit_13", (String)"occ-occpic-formplugin", (Object[])new Object[0]), originHighestPercent));
                    return;
                }
            }
            int rowIdx = 1;
            int formulaSize = formulaDetail.size();
            for (DynamicObject formulaEntry : formulaDetail) {
                String minMaxLegal;
                if (LadderTypeEnums.MBO.getTypeId() == DynamicObjectUtils.getPkValue((DynamicObject)kpi, (String)"laddertype")) {
                    return;
                }
                if (LadderTypeEnums.NORMAL.getTypeId() == ladderTypeId) {
                    if (calcByAmount && (formulaEntry.getBigDecimal("minamount").compareTo(BigDecimal.ZERO) < 0 || rowIdx < formulaSize && formulaEntry.getBigDecimal("maxamount").compareTo(BigDecimal.ZERO) <= 0) || !calcByAmount && (formulaEntry.getBigDecimal("minqty").compareTo(BigDecimal.ZERO) < 0 || rowIdx < formulaSize && formulaEntry.getBigDecimal("maxqty").compareTo(BigDecimal.ZERO) <= 0)) {
                        e.setCancel(true);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u8be6\u60c5\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199%2$s\u3002", (String)"RebateTargetEdit_8", (String)"occ-occpic-formplugin", (Object[])new Object[0]), rowIdx, normalTypeHint));
                        return;
                    }
                } else if (LadderTypeEnums.ACHIEVEMENT.getTypeId() == ladderTypeId && (formulaEntry.getBigDecimal("minachive").compareTo(BigDecimal.ZERO) < 0 || rowIdx < formulaSize && formulaEntry.getBigDecimal("maxachive").compareTo(BigDecimal.ZERO) <= 0)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u8be6\u60c5\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u8fbe\u6210\u7387\u6700\u5c0f\u503c\u3001\u6700\u5927\u503c\u3002", (String)"RebateTargetEdit_9", (String)"occ-occpic-formplugin", (Object[])new Object[0]), rowIdx));
                    return;
                }
                if (rowIdx != formulaSize && StringUtils.isNotEmpty((String)(minMaxLegal = this.validateFormulaDetail(rebateType, ladderTypeId, calcType, formulaEntry, rowIdx)))) {
                    e.setCancel(true);
                    this.getView().showTipNotification(minMaxLegal);
                    return;
                }
                ++rowIdx;
            }
        }
    }

    private String validateFormulaDetail(String rebateType, long ladderTypeId, String targetCalType, DynamicObject formula, int rowIndex) {
        String min = "minamount";
        String max = "maxamount";
        if (ladderTypeId == LadderTypeEnums.ACHIEVEMENT.getTypeId()) {
            min = "minachive";
            max = "maxachive";
        } else if (TargetCalTypeEnum.QTY.getValue().equals(targetCalType)) {
            min = "minqty";
            max = "maxqty";
        }
        return this.validateDetailValue(formula, min, max, ladderTypeId, targetCalType, rowIndex);
    }

    private String validateDetailValue(DynamicObject formula, String min, String max, long ladderTypeId, String targetCalType, int rowIndex) {
        StringBuilder errorMsg = new StringBuilder();
        String compareName = ResManager.loadKDString((String)"\u91d1\u989d", (String)"RebateTargetEdit_4", (String)"occ-occpic-formplugin", (Object[])new Object[0]);
        if (formula.getBigDecimal(min).compareTo(formula.getBigDecimal(max)) > 0) {
            if (ladderTypeId == LadderTypeEnums.ACHIEVEMENT.getTypeId()) {
                compareName = ResManager.loadKDString((String)"\u8fbe\u6210\u7387", (String)"RebateTargetEdit_10", (String)"occ-occpic-formplugin", (Object[])new Object[0]);
            } else if (TargetCalTypeEnum.QTY.getValue().equals(targetCalType)) {
                compareName = ResManager.loadKDString((String)"\u6570\u91cf", (String)"RebateTargetEdit_5", (String)"occ-occpic-formplugin", (Object[])new Object[0]);
            }
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u6700\u5c0f\u503c\u4e0d\u5141\u8bb8\u8d85\u8fc7%3$s\u6700\u5927\u503c\u3002", (String)"RebateTargetEdit_11", (String)"occ-occpic-formplugin", (Object[])new Object[0]), rowIndex, compareName, compareName);
        }
        return errorMsg.toString();
    }
}

