/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebate.rebatestatement;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.RbStatementUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;

public class RbStatementEdit
extends OcbaseFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"channel", "benefitcustomer", "salechannel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue("billtypedata", this.getF7Value("billtype"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setValue("billtypedata", this.getF7Value("billtype"), false);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(false);
        this.hideBusinessOrg();
    }

    private void hideBusinessOrg() {
        boolean isbusinessorg = SysParamsUtil.isBusinessOrg();
        if (!isbusinessorg) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"areadept"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"office"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        this.triggerChangeEvent = true;
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        ChangeData cd = e.getChangeSet()[0];
        int index = cd.getRowIndex();
        DynamicObjectCollection entity = null;
        switch (key) {
            case "channel": {
                DynamicObject channel = (DynamicObject)cd.getNewValue();
                DynamicObject customer = DynamicObjectUtils.getDynamicObject((DynamicObject)channel, (String)"customer");
                DynamicObject currency = DynamicObjectUtils.getDynamicObject((DynamicObject)channel, (String)"currency");
                this.getModel().beginInit();
                this.getModel().setValue("chncustomer", (Object)customer);
                this.getModel().setValue("stmcurrency", (Object)currency);
                this.getModel().endInit();
                this.updateEntryFieldValue("benefitcustomer", channel);
                this.updateEntryFieldValue("echncustomer", customer);
                this.getView().updateView("chncustomer");
                this.getView().updateView("stmcurrency");
                break;
            }
            case "chncustomer": {
                Object ochannel = this.getModel().getValue("channel");
                DynamicObject customer = (DynamicObject)cd.getNewValue();
                if (ochannel == null) {
                    DynamicObject settlementcy = DynamicObjectUtils.getDynamicObject((DynamicObject)customer, (String)"settlementcyid");
                    this.getModel().setValue("stmcurrency", (Object)settlementcy);
                }
                this.updateEntryFieldValue("echncustomer", customer);
                break;
            }
            case "benefitcustomer": {
                DynamicObject benefitcustomer = (DynamicObject)cd.getNewValue();
                DynamicObject echncustomer = DynamicObjectUtils.getDynamicObject((DynamicObject)benefitcustomer, (String)"customer");
                this.getModel().beginInit();
                this.getModel().setValue("echncustomer", (Object)echncustomer, index);
                Object stmcurrency = this.getModel().getValue("stmcurrency");
                if (stmcurrency == null) {
                    DynamicObject currency = DynamicObjectUtils.getDynamicObject((DynamicObject)benefitcustomer, (String)"currency");
                    this.getModel().setValue("stmcurrency", (Object)currency);
                }
                this.getModel().endInit();
                this.getView().updateView("echncustomer", index);
                this.getView().updateView("stmcurrency");
                break;
            }
            case "iteminfo": {
                DynamicObject iteminfo = (DynamicObject)cd.getNewValue();
                if (iteminfo != null) {
                    DynamicObject material = iteminfo.getDynamicObject("material");
                    DynamicObject orderunit = iteminfo.getDynamicObject("orderunit");
                    this.setValue("material", material, index);
                    this.setValue("unitid", orderunit, index);
                    break;
                }
                this.setValue("material", null, index);
                this.setValue("unitid", null, index);
                break;
            }
            case "material": {
                QFilter filter;
                DynamicObject materialsalinfo;
                DynamicObject material;
                long materialId;
                long salesunitid = 0L;
                Object newiteminfo = this.getModel().getValue("iteminfo", index);
                if (newiteminfo == null && (materialId = DynamicObjectUtils.getPkValue((DynamicObject)(material = (DynamicObject)cd.getNewValue()))) > 0L && (materialsalinfo = QueryServiceHelper.queryOne((String)"bd_materialsalinfo", (String)"salesunit", (QFilter[])(filter = new QFilter("id", "=", (Object)materialId)).toArray())) != null) {
                    salesunitid = materialsalinfo.getLong("salesunit");
                }
                this.setItemValueByID("unitid", salesunitid, index);
                break;
            }
            case "consignqty": {
                BigDecimal consignqty = (BigDecimal)cd.getNewValue();
                BigDecimal adjuststatementqty = (BigDecimal)this.getModel().getValue("adjuststatementqty", index);
                if (consignqty.compareTo(BigDecimal.ZERO) == 0 && adjuststatementqty.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal statementqty = consignqty.add(adjuststatementqty);
                this.setValue("statementqty", statementqty, index);
                this.getView().updateView("statementqty", index);
                break;
            }
            case "adjuststatementqty": {
                BigDecimal adjuststatementqty = (BigDecimal)cd.getNewValue();
                BigDecimal consignqty = (BigDecimal)this.getModel().getValue("consignqty", index);
                if (consignqty.compareTo(BigDecimal.ZERO) == 0 && adjuststatementqty.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal statementqty = consignqty.add(adjuststatementqty);
                this.setValue("statementqty", statementqty, index);
                this.getView().updateView("statementqty", index);
                break;
            }
            case "statementqty": {
                BigDecimal statementqty = (BigDecimal)cd.getNewValue();
                BigDecimal actualunitrebate = (BigDecimal)this.getModel().getValue("actualunitrebate", index);
                int amtprecision = 2;
                DynamicObject currency = (DynamicObject)this.getModel().getValue("stmcurrency");
                if (currency != null) {
                    amtprecision = currency.getInt("amtprecision");
                }
                BigDecimal rebateamount = actualunitrebate.multiply(statementqty).setScale(amtprecision, RoundingMode.HALF_UP);
                this.getModel().beginInit();
                this.setValue("rebateamount", rebateamount, index);
                this.getModel().endInit();
                this.getView().updateView("rebateamount", index);
                entity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                BigDecimal totalstateqty = RbStatementUtil.sumByKey((DynamicObjectCollection)entity, (String)"statementqty");
                this.getModel().setValue("totalstateqty", (Object)totalstateqty);
                BigDecimal totalrebamount = RbStatementUtil.sumByKey((DynamicObjectCollection)entity, (String)"rebateamount");
                this.setValue("totalrebamount", totalrebamount);
                this.getView().updateView("totalstateqty");
                this.getView().updateView("totalrebamount");
                break;
            }
            case "actualunitrebate": {
                BigDecimal statementqty = (BigDecimal)this.getModel().getValue("statementqty", index);
                BigDecimal actualunitrebate = (BigDecimal)cd.getNewValue();
                int amtprecision = 2;
                DynamicObject currency = (DynamicObject)this.getModel().getValue("stmcurrency");
                if (currency != null) {
                    amtprecision = currency.getInt("amtprecision");
                }
                BigDecimal rebateamount = actualunitrebate.multiply(statementqty).setScale(amtprecision, RoundingMode.HALF_UP);
                this.getModel().beginInit();
                this.setValue("rebateamount", rebateamount, index);
                this.getModel().endInit();
                this.getView().updateView("rebateamount", index);
                entity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                BigDecimal totalrebamount = RbStatementUtil.sumByKey((DynamicObjectCollection)entity, (String)"rebateamount");
                this.setValue("totalrebamount", totalrebamount);
                break;
            }
            case "rebateamount": {
                BigDecimal actualunitrebate = BigDecimal.ZERO;
                BigDecimal statementqty = (BigDecimal)this.getModel().getValue("statementqty", index);
                if (statementqty.compareTo(BigDecimal.ZERO) != 0) {
                    int priceprecision = 2;
                    DynamicObject currency = (DynamicObject)this.getModel().getValue("stmcurrency");
                    if (currency != null) {
                        priceprecision = currency.getInt("priceprecision");
                    }
                    BigDecimal rebateamount = (BigDecimal)cd.getNewValue();
                    actualunitrebate = rebateamount.divide(statementqty, priceprecision, RoundingMode.HALF_UP);
                }
                this.getModel().beginInit();
                Object sourceorderid = this.getModel().getValue("sourceorderid", index);
                if (!ObjectUtils.isEmpty((Object)sourceorderid)) {
                    BigDecimal scunitrbamount = (BigDecimal)this.getModel().getValue("scunitrbamount", index);
                    BigDecimal propayunitprice = (BigDecimal)this.getModel().getValue("propayunitprice", index);
                    BigDecimal adjuststunitprice = actualunitrebate.subtract(scunitrbamount).add(propayunitprice);
                    this.setValue("adjuststunitprice", adjuststunitprice, index);
                    this.getView().updateView("adjuststunitprice", index);
                }
                this.setValue("actualunitrebate", actualunitrebate, index);
                this.getModel().endInit();
                this.getView().updateView("actualunitrebate", index);
                entity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                BigDecimal totalrebamount = RbStatementUtil.sumByKey((DynamicObjectCollection)entity, (String)"rebateamount");
                this.setValue("totalrebamount", totalrebamount);
                break;
            }
            case "adjuststunitprice": {
                BigDecimal statementqty = (BigDecimal)this.getModel().getValue("statementqty", index);
                int amtprecision = 2;
                DynamicObject currency = (DynamicObject)this.getModel().getValue("stmcurrency");
                if (currency != null) {
                    amtprecision = currency.getInt("amtprecision");
                }
                BigDecimal scunitrbamount = (BigDecimal)this.getModel().getValue("scunitrbamount", index);
                BigDecimal propayunitprice = (BigDecimal)this.getModel().getValue("propayunitprice", index);
                BigDecimal adjuststunitprice = (BigDecimal)cd.getNewValue();
                BigDecimal actualunitrebate = scunitrbamount.subtract(propayunitprice).add(adjuststunitprice);
                BigDecimal rebateamount = actualunitrebate.multiply(statementqty).setScale(amtprecision, RoundingMode.HALF_UP);
                this.getModel().beginInit();
                this.setValue("actualunitrebate", actualunitrebate, index);
                this.setValue("rebateamount", rebateamount, index);
                this.getModel().endInit();
                this.getView().updateView("actualunitrebate", index);
                this.getView().updateView("rebateamount", index);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "salechannel": {
                F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)CUserHelper.getAuthorizedChannelFilter());
                break;
            }
            case "channel": 
            case "benefitcustomer": {
                DynamicObject saleChannel = (DynamicObject)this.getModel().getValue("salechannel");
                if (saleChannel == null) {
                    return;
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("salechannel", "=", saleChannel.getPkValue()), new QFilter("supplyrelation", "=", (Object)"B"), new QFilter("enable", "=", (Object)"1")};
                DynamicObjectCollection authorizedList = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"orderchannel.balancechannel", (QFilter[])qFilters);
                Set balancechannelids = authorizedList.stream().map(c -> c.getLong("orderchannel.balancechannel")).collect(Collectors.toSet());
                QFilter filter = new QFilter("id", "in", balancechannelids);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            Object chncustomer;
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            Object channel = this.getModel().getValue("channel");
            if (channel != null) {
                this.getModel().setValue("benefitcustomer", channel, rowIndex);
            }
            if ((chncustomer = this.getModel().getValue("chncustomer")) != null) {
                this.getModel().setValue("echncustomer", chncustomer, rowIndex);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "entryentity": {
                this.recalTotalRebateQtyAmount();
                break;
            }
        }
    }

    private void updateEntryFieldValue(String entryField, Object entryValue) {
        int rowIndex = 0;
        DynamicObjectCollection entity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entity) {
            entry.set(entryField, entryValue);
            this.getView().updateView(entryField, rowIndex++);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.recalTotalRebateQtyAmount();
    }

    private void recalTotalRebateQtyAmount() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        BigDecimal totalstateqty = RbStatementUtil.sumByKey((DynamicObjectCollection)entity, (String)"statementqty");
        this.setValue("totalstateqty", totalstateqty);
        BigDecimal totalrebamount = RbStatementUtil.sumByKey((DynamicObjectCollection)entity, (String)"rebateamount");
        this.setValue("totalrebamount", totalrebamount);
    }
}

