/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebatebudgetbill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;

public class RebatePreBudgetEdit
extends OcbaseFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"unitid"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideBusinessOrg();
        if (this.isNewCreate()) {
            this.getModel().setValue("billtype", (Object)this.getDefaultBillTypeId());
        }
    }

    private void hideBusinessOrg() {
        boolean isbusinessorg = SysParamsUtil.isBusinessOrg();
        if (!isbusinessorg) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rpareadep"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"rprepresentoffice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"rparea"});
        }
    }

    public long getDefaultBillTypeId() {
        QFilter qFilter = new QFilter("billformid", "=", (Object)"occpic_rebateprebudget");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection billTypeList = QueryServiceHelper.query((String)"bos_billtype", (String)"id,isdefault", (QFilter[])qFilter.toArray());
        long defaultBillTypeId = 0L;
        if (!CollectionUtils.isEmpty((Collection)billTypeList)) {
            for (DynamicObject billType : billTypeList) {
                boolean isdefault = billType.getBoolean("isdefault");
                if (!isdefault) continue;
                return billType.getLong("id");
            }
            defaultBillTypeId = ((DynamicObject)billTypeList.get(0)).getLong("id");
        }
        return defaultBillTypeId;
    }

    private BigDecimal caluAmount(String key) {
        DynamicObjectCollection entity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject item : entity) {
            total = total.add(item.getBigDecimal(key));
        }
        return total;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "channel": {
                DynamicObject channel = (DynamicObject)cd.getNewValue();
                DynamicObject customer = DynamicObjectUtils.getDynamicObject((DynamicObject)channel, (String)"customer");
                DynamicObject currency = DynamicObjectUtils.getDynamicObject((DynamicObject)channel, (String)"currency");
                this.getModel().beginInit();
                this.getModel().setValue("rebatecustomer", (Object)customer);
                this.getModel().setValue("rpprecurrency", (Object)currency);
                this.getModel().endInit();
                this.getView().updateView("rebatecustomer");
                this.getView().updateView("rpprecurrency");
                break;
            }
            case "rebatecustomer": {
                Object ochannel = this.getModel().getValue("channel");
                if (ochannel != null) break;
                DynamicObject customer = (DynamicObject)cd.getNewValue();
                DynamicObject settlementcy = DynamicObjectUtils.getDynamicObject((DynamicObject)customer, (String)"settlementcyid");
                this.getModel().setValue("rpprecurrency", (Object)settlementcy);
                break;
            }
            case "rebatepolicytarget": {
                if (cd.getNewValue() == null) {
                    this.getModel().setValue("repolicytarget", null);
                    this.getModel().setValue("channel", null);
                    this.getModel().setValue("customer", null);
                    return;
                }
                DynamicObject policytarget = (DynamicObject)cd.getNewValue();
                this.setPropValueFromeTarget(policytarget);
                break;
            }
            case "consignqty": {
                BigDecimal totalproconsignqty = this.caluAmount("consignqty");
                this.getModel().setValue("totalproconsignqty", (Object)totalproconsignqty);
                break;
            }
            case "saleamount": {
                BigDecimal totalsaleamount = this.caluAmount("saleamount");
                this.getModel().setValue("totalsaleamount", (Object)totalsaleamount);
                break;
            }
            case "rebateamount": {
                BigDecimal totalrebateamount = this.caluAmount("rebateamount");
                this.getModel().setValue("totalrebateamount", (Object)totalrebateamount);
                break;
            }
            case "hasbudgetamount": {
                BigDecimal totalhasbudgetamount = this.caluAmount("hasbudgetamount");
                this.getModel().setValue("totalhasbudgetamount", (Object)totalhasbudgetamount);
                break;
            }
            case "material": {
                QFilter filter;
                DynamicObject materialsalinfo;
                DynamicObject material;
                long materialId;
                long salesunitid = 0L;
                Object itemInfo = this.getModel().getValue("iteminfo", rowIndex);
                if (itemInfo == null && (materialId = DynamicObjectUtils.getPkValue((DynamicObject)(material = (DynamicObject)cd.getNewValue()))) > 0L && (materialsalinfo = QueryServiceHelper.queryOne((String)"bd_materialsalinfo", (String)"salesunit", (QFilter[])(filter = new QFilter("id", "=", (Object)materialId)).toArray())) != null) {
                    salesunitid = materialsalinfo.getLong("salesunit");
                }
                this.setItemValueByID("unitid", salesunitid, rowIndex);
                break;
            }
        }
    }

    private void setPropValueFromeTarget(DynamicObject target) {
        DynamicObjectCollection signcustentitys = target.getDynamicObjectCollection("signcustentity");
        if (signcustentitys != null && signcustentitys.size() > 0) {
            DynamicObject signcustentity = (DynamicObject)signcustentitys.get(0);
            this.getModel().setValue("channel", signcustentity.get("signchannel"));
            this.getModel().setValue("customer", signcustentity.get("signcustomer"));
        }
        this.getModel().setValue("rpprecurrency", target.get("currency"));
        this.getModel().setValue("rpbegindate", target.get("starttime"));
        this.getModel().setValue("rpenddate", target.get("endtime"));
        this.getModel().setValue("rpareadep", target.get("areadept"));
        this.getModel().setValue("rprepresentoffice", target.get("rptoffice"));
        this.getModel().setValue("rparea", target.get("country"));
        this.getModel().setValue("rpcontractsubject", target.get("signparty"));
        DynamicObject signparty = BusinessDataServiceHelper.loadSingle((Object)target.getDynamicObject("signparty").getPkValue(), (String)"ocdbd_contparties", (String)"frepresentativeorg,org");
        this.getModel().setValue("org", signparty.get("frepresentativeorg"));
        this.getModel().setValue("rpchannelfirstgroup", target.get("chlfirstclassid"));
        this.getModel().setValue("rpchannelsecondgroup", target.get("chlsecclass"));
        DynamicObject kpiobj = target.getDynamicObject("kpi");
        kpiobj = BusinessDataServiceHelper.loadSingle((Object)kpiobj.getPkValue(), (String)"ocdbd_kpi", (String)"inspiretype,childtype,targetcaltype,laddertype");
        this.getModel().setValue("rpincentivetype", kpiobj.get("inspiretype"));
        this.getModel().setValue("rpincentivesubtyp", kpiobj.get("childtype"));
        this.getModel().setValue("rpdestcaculatetype", kpiobj.get("targetcaltype"));
        this.getModel().setValue("laddertype", kpiobj.get("laddertype"));
        this.getModel().setValue("rpbudgetcycle", target.get("settleperiod"));
        String selectProperties = "id,billno,name,rebatetype,itemclassentity.firstclass,itemclassentity.secondclass,itemclassentity.productmodel,subentryentity.subfirstclass,subentryentity.subsecondclass,subentryentity.subproductmodel";
        DynamicObject policyTarget = BusinessDataServiceHelper.loadSingle((Object)target.getPkValue(), (String)"occpic_rebatetarget", (String)selectProperties);
        DynamicObjectCollection itemclassentitys = policyTarget.getDynamicObjectCollection("itemclassentity");
        this.getModel().setValue("rebatetype", policyTarget.get("rebatetype"));
        String selectProps = "id,rebateformula";
        QFilter qFilter = new QFilter("laddertype", "=", kpiobj.getDynamicObject("laddertype").getPkValue()).and(new QFilter("rebatetype", "=", policyTarget.get("rebatetype"))).and(new QFilter("targetcaltype", "=", this.getModel().getValue("rpdestcaculatetype")));
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] formulas = BusinessDataServiceHelper.load((String)"ocdbd_formula", (String)selectProps, (QFilter[])filters);
        if (formulas != null && formulas.length > 0) {
            this.getModel().setValue("rppdestformula", (Object)formulas[0]);
        }
        Object channelid = this.getF7PKValue("channel");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("repolicytarget", new Object[0]);
        setter.addField("productmodel", new Object[0]);
        setter.addField("benefitcustomer", new Object[0]);
        Long repolicytarget = (Long)target.getPkValue();
        for (DynamicObject entry : itemclassentitys) {
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject detial : subentryentity) {
                Long productmodel = detial.getDynamicObject("subproductmodel") == null ? 0L : DynamicObjectUtils.getPkValue((DynamicObject)detial.getDynamicObject("subproductmodel"));
                Long signchl = 0L;
                if (channelid != null) {
                    signchl = (Long)channelid;
                }
                setter.addRow(new Object[]{repolicytarget, productmodel, signchl});
            }
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "entryentity": {
                BigDecimal totalproconsignqty = this.caluAmount("consignqty");
                this.setValue("totalproconsignqty", totalproconsignqty);
                BigDecimal totalsaleamount = this.caluAmount("saleamount");
                this.setValue("totalsaleamount", totalsaleamount);
                BigDecimal totalrebateamount = this.caluAmount("rebateamount");
                this.setValue("totalrebateamount", totalrebateamount);
                BigDecimal totalhasbudgetamount = this.caluAmount("hasbudgetamount");
                this.setValue("totalhasbudgetamount", totalhasbudgetamount);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "unitid": {
                this.setUnitIdEntryF7Select(e, rowIndex);
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObject importData = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = importData.getDynamicObjectCollection("entryentity");
        BigDecimal totalproconsignqty = BigDecimal.ZERO;
        BigDecimal totalsaleamount = BigDecimal.ZERO;
        BigDecimal totalrebateamount = BigDecimal.ZERO;
        BigDecimal totalhasbudgetamount = BigDecimal.ZERO;
        for (DynamicObject entry : entryEntity) {
            totalproconsignqty = totalproconsignqty.add(entry.getBigDecimal("consignqty"));
            totalsaleamount = totalsaleamount.add(entry.getBigDecimal("saleamount"));
            totalrebateamount = totalrebateamount.add(entry.getBigDecimal("rebateamount"));
            totalhasbudgetamount = totalhasbudgetamount.add(entry.getBigDecimal("hasbudgetamount"));
        }
        this.setValue("totalproconsignqty", totalproconsignqty);
        this.setValue("totalsaleamount", totalsaleamount);
        this.setValue("totalrebateamount", totalrebateamount);
        this.setValue("totalhasbudgetamount", totalhasbudgetamount);
    }

    private void setUnitIdEntryF7Select(BeforeF7SelectEvent e, int rowIndex) {
        if (!this.verifyMaterial(rowIndex)) {
            e.setCancel(true);
            return;
        }
        DynamicObject material = this.getEntryF7Value("entryentity", "material", rowIndex);
        Object materialId = material.getPkValue();
        Long baseUnitId = material.getLong("baseunit_id");
        List fixconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(((Object)baseUnitId).toString())), (String)"1");
        QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)fixconFilter);
    }

    private boolean verifyMaterial(int rowIndex) {
        Object itemId = this.getEntryF7PKValue("entryentity", "material", rowIndex);
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"RebatePreBudgetEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

