/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.occpic.CalculateStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class RebatePreBudget2StatementWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String PANME_OCCPICREBATEPREBUDGET = "occpic_rebateprebudget";

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if (PANME_OCCPICREBATEPREBUDGET.equals(srcSubMainType.getName()) && ("audit".equalsIgnoreCase(opType) || "unaudit".equalsIgnoreCase(opType))) {
            DynamicObject[] rebatePreBudgetArray = this.reloadRebatePreBudgetArray(e);
            this.resetRebatePreBudgetBillStatus(rebatePreBudgetArray);
            this.calTotalHasBudgetAmount(rebatePreBudgetArray);
            SaveServiceHelper.save((DynamicObject[])rebatePreBudgetArray);
        }
    }

    private DynamicObject[] reloadRebatePreBudgetArray(AfterSaveSourceBillEventArgs e) {
        DynamicObject[] rebatePreBudgetArray = e.getSrcDataEntities();
        if (rebatePreBudgetArray != null && rebatePreBudgetArray.length > 0) {
            ArrayList<Object> pkArray = new ArrayList<Object>(rebatePreBudgetArray.length);
            for (DynamicObject rebatePreBudget : rebatePreBudgetArray) {
                pkArray.add(rebatePreBudget.getPkValue());
            }
            rebatePreBudgetArray = BusinessDataServiceHelper.load((Object[])pkArray.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)PANME_OCCPICREBATEPREBUDGET));
        }
        return rebatePreBudgetArray;
    }

    private void calTotalHasBudgetAmount(DynamicObject[] rebatePreBudgetArray) {
        for (DynamicObject rebatePreBudget : rebatePreBudgetArray) {
            BigDecimal totalHasBudgetAmount = BigDecimal.ZERO;
            for (DynamicObject rebatePreBudgetEntry : rebatePreBudget.getDynamicObjectCollection("entryentity")) {
                totalHasBudgetAmount = totalHasBudgetAmount.add(rebatePreBudgetEntry.getBigDecimal("hasbudgetamount"));
            }
            rebatePreBudget.set("totalhasbudgetamount", (Object)totalHasBudgetAmount);
        }
    }

    private void resetRebatePreBudgetBillStatus(DynamicObject[] rebatePreBudgetArray) {
        HashSet<Long> rebateTargetIdSet = new HashSet<Long>(rebatePreBudgetArray.length * 10);
        for (DynamicObject rebatePreBudget : rebatePreBudgetArray) {
            String billStatus = rebatePreBudget.getString("billstatus");
            boolean isAllAudit = true;
            boolean isAllCompleteBudget = true;
            for (DynamicObject rebatePreBudgetEntry : rebatePreBudget.getDynamicObjectCollection("entryentity")) {
                BigDecimal rebateAmonnt = rebatePreBudgetEntry.getBigDecimal("rebateamount");
                switch (rebatePreBudgetEntry.getString("rowstatus")) {
                    case "C": {
                        if (rebateAmonnt == null || BigDecimal.ZERO.compareTo(rebateAmonnt) == 0 || !isAllCompleteBudget) break;
                        isAllCompleteBudget = false;
                        break;
                    }
                    case "E": {
                        if (!isAllAudit) break;
                        isAllAudit = false;
                        break;
                    }
                    case "F": {
                        if (isAllAudit) {
                            isAllAudit = false;
                        }
                        if (!isAllCompleteBudget) break;
                        isAllCompleteBudget = false;
                        break;
                    }
                }
            }
            if (isAllAudit) {
                if ("C".equals(billStatus)) continue;
                rebatePreBudget.set("billstatus", (Object)"C");
                continue;
            }
            if (isAllCompleteBudget) {
                if ("E".equals(billStatus)) continue;
                rebatePreBudget.set("billstatus", (Object)"E");
                for (DynamicObject rebatePreBudgetEntry : rebatePreBudget.getDynamicObjectCollection("entryentity")) {
                    rebateTargetIdSet.add(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rebatePreBudgetEntry, (String)"repolicytarget"));
                }
                continue;
            }
            if ("F".equals(billStatus)) continue;
            rebatePreBudget.set("billstatus", (Object)"F");
        }
        if (!CollectionUtils.isEmpty(rebateTargetIdSet)) {
            QFilter qf = new QFilter("id", "in", rebateTargetIdSet);
            qf.and("calculatestatus", "!=", (Object)CalculateStatus.JISUANJIESHU.toString());
            DynamicObject[] rebateTargetArray = BusinessDataServiceHelper.load((String)"occpic_rebatetarget", (String)"calculatestatus", (QFilter[])qf.toArray());
            if (rebateTargetArray != null && rebateTargetArray.length > 0) {
                for (DynamicObject rebateTarget : rebateTargetArray) {
                    rebateTarget.set("calculatestatus", (Object)CalculateStatus.JISUANJIESHU.toString());
                }
                SaveServiceHelper.save((DynamicObject[])rebateTargetArray);
            }
        }
    }
}

