/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.business.handle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.handler.BalanceHandler;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.occpic.business.model.OrderRebate;

public class RebateACTHandle {
    private static final String DLOCK_KEY_PREFIX = "/drp/drm/updaterebateact";
    private static final long WITH_TIME = 180000L;
    private final Object userId = UserUtil.getUserID();
    private final Object now = new Date();
    private static final String ACCOUNT = "account.id";
    private static final String OWNER = "account.owner.id";
    private static final String CUSTOMER = "account.customer.id";
    private static final String CURRENY = "account.currency.id";
    private static final String ACCOUNT_TYPE = "account.accounttype.id";

    private static String getDLOCK_MSG() {
        return ResManager.loadKDString((String)"\u66f4\u65b0\u6216\u521b\u5efa\u8fd4\u5229\u8d26\u6237", (String)"RebateACTHandle_0", (String)"occ-occpic-business", (Object[])new Object[0]);
    }

    public void rebateBill2AdvanceACT(DynamicObject rebateBill) {
        String tag = RebateACTHandle.class.getName() + ".rebateBill2AdvanceACT";
        try (TXHandle tx = TX.required((String)tag);){
            try {
                this.doRebateBill2AdvanceACT(rebateBill);
            }
            catch (Exception e) {
                tx.markRollback();
                String billNo = rebateBill.getString("billno");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u5229\u5355\u3010%1$s\u3011\u8f6c\u9884\u6536\u6b3e\u5931\u8d25\uff1a%2$s", (String)"RebateACTHandle_1", (String)"occ-occpic-business", (Object[])new Object[0]), billNo, e.getMessage()));
            }
        }
    }

    private void doRebateBill2AdvanceACT(DynamicObject rebateBill) {
        DynamicObjectCollection details = rebateBill.getDynamicObjectCollection("detail");
        if (details.size() == 0) {
            return;
        }
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObject[] advanceDetailArr = new DynamicObject[details.size()];
        DynamicObject advanceDetail = null;
        int len = details.size();
        for (int i = 0; i < len; ++i) {
            advanceDetail = this.newAdvanceDetail(rebateBill, (DynamicObject)details.get(i));
            amount = amount.add(((DynamicObject)details.get(i)).getBigDecimal("amount"));
            advanceDetailArr[i] = advanceDetail;
        }
        Object ownerId = rebateBill.getDynamicObject("owner").get("id");
        Object customerId = rebateBill.getDynamicObject("customer").get("id");
        rebateBill.set("billstatus", (Object)"E");
        rebateBill.set("settmenttype", (Object)"3");
        BalanceHandler.updateBalance((Object)ownerId, (Object)customerId, (BigDecimal)amount, null);
        SaveServiceHelper.save((DynamicObject[])advanceDetailArr);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateBill});
    }

    private DynamicObject newAdvanceDetail(DynamicObject rebateBill, DynamicObject detail) {
        DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"ocbsoc_money_receive");
        BigDecimal amount = detail.getBigDecimal("amount");
        info.set("amount", (Object)amount);
        info.set("currency", (Object)rebateBill.getDynamicObject("currency"));
        info.set("receivingtype", (Object)(amount.compareTo(BigDecimal.ZERO) < 0 ? "1" : "0"));
        info.set("paymenttype", (Object)"0");
        info.set("paymentchannel", (Object)"0");
        info.set("isaddnew", (Object)"0");
        info.set("isrefund", (Object)"0");
        info.set("approverid", this.userId);
        info.set("creatorid", this.userId);
        info.set("approvetime", this.now);
        info.set("createtime", this.now);
        info.set("paymenttime", this.now);
        info.set("status", (Object)"C");
        info.set("remark", (Object)ResManager.loadKDString((String)"\u8fd4\u5229\u5355\u8f6c\u9884\u6536\u6b3e", (String)"RebateACTHandle_2", (String)"occ-occpic-business", (Object[])new Object[0]));
        info.set("owner", (Object)rebateBill.getDynamicObject("owner"));
        info.set("contactscustomer", (Object)rebateBill.getDynamicObject("customer"));
        info.set("orderid", (Object)rebateBill.get("id").toString());
        info.set("ordertype", (Object)"rebate");
        Object no = this.getAdvanceDetailNO(info);
        if (no == null) {
            no = rebateBill.getString("billno") + "-" + detail.get("seq");
        }
        info.set("number", no);
        return info;
    }

    private Object getAdvanceDetailNO(DynamicObject detail) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)detail.getDataEntityType().getName(), (DynamicObject)detail, null);
        if (codeRuleInfo != null) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)detail);
        }
        return null;
    }

    public void rebateBill2RebateACT(DynamicObject rebateBill) {
        String tag = RebateACTHandle.class.getName() + ".rebateBill2RebateACT";
        try (TXHandle tx = TX.required((String)tag);){
            try {
                this.doRebateBill2RebateACT(rebateBill);
            }
            catch (Exception e) {
                tx.markRollback();
                String billNo = rebateBill.getString("billno");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u5229\u5355\u3010%1$s\u3011\u8f6c\u8fd4\u5229\u8d26\u6237\u5931\u8d25\uff1a%2$s", (String)"RebateACTHandle_3", (String)"occ-occpic-business", (Object[])new Object[0]), billNo, e.getMessage()));
            }
        }
    }

    private DLock getDlockByRebateBill(DynamicObject rebateBill) {
        DynamicObject ownerId = rebateBill.getDynamicObject("owner");
        DynamicObject customerId = rebateBill.getDynamicObject("customer");
        DynamicObject accounttypeId = rebateBill.getDynamicObject("accounttype");
        DynamicObject currencyId = rebateBill.getDynamicObject("currency");
        DLock lock = DLock.createReentrant((String)this.getDLockKey(ownerId, customerId, accounttypeId, currencyId), (String)RebateACTHandle.getDLOCK_MSG());
        return lock;
    }

    private String getDLockKey(Object ownerId, Object customerId, Object accounttypeId, Object currencyId) {
        return new StringBuffer(DLOCK_KEY_PREFIX).append(ownerId).append(customerId).append(accounttypeId).append(currencyId).toString();
    }

    private void doRebateBill2RebateACT(DynamicObject rebateBill) {
        DLock lock = this.getDlockByRebateBill(rebateBill);
        if (lock.tryLock(180000L)) {
            try {
                this.afterDLock4RebateACT(rebateBill);
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u5229\u5355\u3010%1$s\u3011\u8f6c\u8fd4\u5229\u8d26\u6237\u4efb\u52a1\u5931\u8d25\uff0c\u5efa\u8bae\u7a0d\u540e\u91cd\u8bd5", (String)"RebateACTHandle_4", (String)"occ-occpic-business", (Object[])new Object[0]), rebateBill.get("billno")));
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u5229\u5355\u3010%1$s\u3011\u8f6c\u8fd4\u5229\u8d26\u6237\u4efb\u52a1\u7b49\u5f85\u8d85\u65f6\u3010%2$s ms\u3011\uff0c\u5efa\u8bae\u7a0d\u540e\u91cd\u8bd5", (String)"RebateACTHandle_5", (String)"occ-occpic-business", (Object[])new Object[0]), rebateBill.get("billno"), 180000L));
        }
    }

    private void afterDLock4RebateACT(DynamicObject rebateBill) {
        QFilter hFs = this.handFt(rebateBill);
        HashMap<String, DynamicObject> accounts = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> accountSaveList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> accountUpdateList = new ArrayList<DynamicObject>();
        DynamicObject account = null;
        DynamicObject detail = null;
        DynamicObjectCollection entrys = rebateBill.getDynamicObjectCollection("detail");
        QFilter fs = null;
        for (DynamicObject entry : entrys) {
            String key = "" + entry.getDate("fromdate").getTime() + entry.getDate("todate").getTime();
            account = (DynamicObject)accounts.get(key);
            if (account == null) {
                fs = new QFilter("fromdate", "=", entry.get("fromdate")).and("todate", "=", entry.get("todate")).and(hFs);
                String cols = F7Utils.getSelectCols((String[])new String[]{"id", "number", "balance", "unusedamount", "modifier", "updatedatetime"});
                account = BusinessDataServiceHelper.loadSingle((String)"ocdbd_rebateaccount", (String)cols, (QFilter[])fs.toArray());
                if (account == null) {
                    account = this.newAccount(rebateBill, entry);
                    accountSaveList.add(account);
                } else {
                    this.setModifyInfo4Account(account);
                    accountUpdateList.add(account);
                }
                accounts.put(key, account);
            }
            accountList.add(account);
            detail = this.newAccountDetail(rebateBill, account, entry);
            detailList.add(detail);
        }
        this.handleAmount(detailList, accountList);
        DynamicObject[] accountSaveArr = accountSaveList.toArray(new DynamicObject[accountSaveList.size()]);
        DynamicObject[] accountUpdateArr = accountUpdateList.toArray(new DynamicObject[accountUpdateList.size()]);
        DynamicObject[] detailArr = detailList.toArray(new DynamicObject[detailList.size()]);
        rebateBill.set("billstatus", (Object)"E");
        rebateBill.set("settmenttype", (Object)"2");
        this.saveRebate2RebateACTInfo(rebateBill, accountSaveArr, accountUpdateArr, detailArr);
    }

    private void saveRebate2RebateACTInfo(DynamicObject rebateBill, DynamicObject[] accountSaveArr, DynamicObject[] accountUpdateArr, DynamicObject[] detailArr) {
        if (accountSaveArr.length > 0) {
            SaveServiceHelper.save((DynamicObject[])accountSaveArr);
        }
        if (accountUpdateArr.length > 0) {
            SaveServiceHelper.save((DynamicObject[])accountUpdateArr);
        }
        SaveServiceHelper.save((DynamicObject[])detailArr);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateBill});
    }

    private void handleAmount(List<DynamicObject> detailList, List<DynamicObject> accountList) {
        DynamicObject detail = null;
        DynamicObject account = null;
        BigDecimal balance = null;
        BigDecimal unUsedAmount = null;
        int len = detailList.size();
        for (int i = 0; i < len; ++i) {
            account = accountList.get(i);
            detail = detailList.get(i);
            balance = account.getBigDecimal("balance");
            unUsedAmount = account.getBigDecimal("unusedamount");
            balance = balance.add(detail.getBigDecimal("rebateamount"));
            unUsedAmount = unUsedAmount.add(detail.getBigDecimal("rebateamount"));
            account.set("balance", (Object)balance);
            account.set("unusedamount", (Object)unUsedAmount);
        }
    }

    private DynamicObject newDetail4Occupy(BigDecimal amount, OrderRebate orderRebate, DynamicObject account) {
        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_account_detail");
        detail.set("account", (Object)account);
        detail.set("currency", (Object)orderRebate.getCurrencyId());
        detail.set("rebateamount", (Object)amount.negate());
        detail.set("sourcebillid", (Object)orderRebate.getSourceBillId());
        detail.set("sourcebillno", (Object)orderRebate.getSourceBillNo());
        detail.set("sourcebilltype", (Object)"2");
        detail.set("amounttype", (Object)"2");
        this.setCreateInfo4NewDetail(detail);
        return detail;
    }

    private void setCreateInfo4NewDetail(DynamicObject detail) {
        detail.set("creater", this.userId);
        detail.set("createdate", this.now);
        detail.set("number", (Object)this.createDetailNumber(detail));
    }

    private DynamicObject newAccountDetail(DynamicObject rebateBill, DynamicObject account, DynamicObject entry) {
        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_account_detail");
        detail.set("account", (Object)account);
        detail.set("currency", (Object)rebateBill.getDynamicObject("currency"));
        detail.set("rebateamount", (Object)entry.getBigDecimal("amount"));
        detail.set("sourcebillid", (Object)rebateBill.get("id").toString());
        detail.set("sourcebillno", (Object)rebateBill.getString("billno"));
        detail.set("sourcebilltype", (Object)"1");
        detail.set("amounttype", (Object)"3");
        this.setCreateInfo4NewDetail(detail);
        return detail;
    }

    private DynamicObject newAccount(DynamicObject rebateBill, DynamicObject entry) {
        DynamicObject account = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
        account.set("owner", (Object)rebateBill.getDynamicObject("owner"));
        account.set("customer", (Object)rebateBill.getDynamicObject("customer"));
        account.set("accounttype", (Object)rebateBill.getDynamicObject("accounttype"));
        account.set("currency", (Object)rebateBill.getDynamicObject("currency"));
        account.set("fromdate", (Object)entry.getDate("fromdate"));
        account.set("todate", (Object)entry.getDate("todate"));
        this.setCreateInfo4NewAccount(account);
        return account;
    }

    private void setCreateInfo4NewAccount(DynamicObject account) {
        account.set("creater", this.userId);
        account.set("createdate", this.now);
        account.set("number", (Object)this.createAccountNumber(account));
    }

    private void setModifyInfo4Account(DynamicObject account) {
        account.set("modifier", this.userId);
        account.set("updatedatetime", this.now);
    }

    private QFilter handFt(DynamicObject rebateBill) {
        QFilter fs = new QFilter("owner", "=", rebateBill.getDynamicObject("owner").get("id"));
        fs.and("customer", "=", rebateBill.getDynamicObject("customer").get("id"));
        Object accountTypeId = 0L;
        DynamicObject accountType = rebateBill.getDynamicObject("accounttype");
        if (accountType != null) {
            accountTypeId = accountType.get("id");
        }
        fs.and("accounttype", "=", accountTypeId);
        fs.and("currency", "=", rebateBill.getDynamicObject("currency").get("id"));
        return fs;
    }

    private String createAccountNumber(DynamicObject account) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)account.getDataEntityType().getName(), (DynamicObject)account, null);
        if (codeRuleInfo != null) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)account);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u3010\u8fd4\u5229\u8d26\u6237\u3011\u7f16\u7801\u89c4\u5219", (String)"RebateACTHandle_6", (String)"occ-occpic-business", (Object[])new Object[0]));
    }

    public void occupyDetail(List<OrderRebate> orderRebates) {
        String tag = RebateACTHandle.class.getName() + ".occupyDetail";
        try (TXHandle tx = TX.required((String)tag);){
            try {
                this.doOccupyDetail(orderRebates);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void doOccupyDetail(List<OrderRebate> orderRebates) {
        Map<String, List<OrderRebate>> orderRebateMap = this.groupByDLockKey(orderRebates);
        for (Map.Entry<String, List<OrderRebate>> orderRebateList : orderRebateMap.entrySet()) {
            this.doOccupyDetailAfterGroup(orderRebateList.getKey(), orderRebateList.getValue());
        }
    }

    private void doOccupyDetailAfterGroup(String key, List<OrderRebate> orderRebates) {
        DLock lock = DLock.createReentrant((String)key, (String)RebateACTHandle.getDLOCK_MSG());
        if (lock.tryLock(180000L)) {
            try {
                this.afterDLock4OccupyDetail(orderRebates);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u6263\u51cf\u9884\u5360\u8fd4\u5229\u91d1\u989d\u4efb\u52a1\u5931\u8d25\uff0c\u5efa\u8bae\u7a0d\u540e\u518d\u8bd5", (String)"RebateACTHandle_7", (String)"occ-occpic-business", (Object[])new Object[0]));
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u6263\u51cf\u9884\u5360\u8fd4\u5229\u91d1\u989d\u4efb\u52a1\u7b49\u5f85\u8d85\u65f6\u3010%1$s ms\u3011\uff0c\u5efa\u8bae\u7a0d\u540e\u518d\u8bd5", (String)"RebateACTHandle_8", (String)"occ-occpic-business", (Object[])new Object[0]), 180000L));
        }
    }

    private void afterDLock4OccupyDetail(List<OrderRebate> orderRebates) {
        OrderRebate orderRebate = null;
        DynamicObject[] accounts = null;
        ArrayList details = null;
        int index = 0;
        int len = orderRebates.size();
        for (int i = 0; i < len; ++i) {
            orderRebate = orderRebates.get(i);
            if (i == 0) {
                accounts = this.loadAccount4OccupyDetail(orderRebate);
                if (accounts == null || accounts.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5360\u7528\u8fd4\u5229\uff1a\u6ca1\u6709\u53ef\u6263\u51cf\u7684\u8d26\u6237\uff0c\u8bf7\u5728\u5355\u636e\u7f16\u8f91\u754c\u9762\u91cd\u65b0\u7f16\u8f91\u4f7f\u7528\u8fd4\u5229\uff0c\u8c03\u6574\u672c\u6b21\u62b5\u7528\u91d1\u989d\u540e\u91cd\u8bd5", (String)"RebateACTHandle_9", (String)"occ-occpic-business", (Object[])new Object[0]));
                }
                details = new ArrayList(orderRebates.size());
            }
            index = this.createDetail4Occupy(accounts, orderRebate, details, index);
        }
        DynamicObject[] accountToUpdate = new DynamicObject[index + 1];
        int i = 0;
        if (accounts != null && accounts.length > 0) {
            DynamicObject[] dynamicObjectArray = accounts;
            int n = dynamicObjectArray.length;
            for (int j = 0; j < n; ++j) {
                DynamicObject account;
                accountToUpdate[i] = account = dynamicObjectArray[j];
                this.setModifyInfo4Account(accountToUpdate[i]);
                ++i;
            }
        }
        SaveServiceHelper.save((DynamicObject[])accountToUpdate);
        if (details != null) {
            SaveServiceHelper.save((DynamicObject[])details.toArray(new DynamicObject[details.size()]));
        }
    }

    private int createDetail4Occupy(DynamicObject[] accounts, OrderRebate orderRebate, List<DynamicObject> details, int index) {
        BigDecimal unUsedAmount = null;
        BigDecimal orderUsedAmount = null;
        BigDecimal nextSubAmount = orderRebate.getUsedRebate();
        int len = accounts.length;
        for (int i = index; i < len; ++i) {
            unUsedAmount = accounts[i].getBigDecimal("unusedamount");
            if (unUsedAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (nextSubAmount.compareTo(BigDecimal.ZERO) == 0) {
                return i;
            }
            orderUsedAmount = accounts[i].getBigDecimal("orderusedamount");
            if (unUsedAmount.compareTo(nextSubAmount) < 0) {
                if (i == len - 1) break;
                accounts[i].set("unusedamount", (Object)BigDecimal.ZERO);
                accounts[i].set("orderusedamount", (Object)orderUsedAmount.add(unUsedAmount));
                details.add(this.newDetail4Occupy(unUsedAmount, orderRebate, accounts[i]));
                nextSubAmount = nextSubAmount.subtract(unUsedAmount);
                continue;
            }
            BigDecimal balance = unUsedAmount.subtract(nextSubAmount);
            accounts[i].set("unusedamount", (Object)balance);
            accounts[i].set("orderusedamount", (Object)orderUsedAmount.add(nextSubAmount));
            details.add(this.newDetail4Occupy(nextSubAmount, orderRebate, accounts[i]));
            if (balance.compareTo(BigDecimal.ZERO) >= 0) {
                return i;
            }
            return i + 1;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5360\u7528\u8fd4\u5229\u4f59\u989d\u5931\u8d25\uff1a\u8d26\u6237\u5f85\u8fd4\u91d1\u989d\u4e0d\u8db3\u4e86\uff0c\u8bf7\u5c1d\u8bd5\u5355\u6761\u6570\u636e\u64cd\u4f5c\u6216\u8005\u6253\u5f00\u5355\u636e\u91cd\u65b0\u7f16\u8f91\u4f7f\u7528\u8fd4\u5229\uff0c\u8c03\u6574\u672c\u6b21\u62b5\u7528\u91d1\u989d\u540e\u91cd\u8bd5", (String)"RebateACTHandle_10", (String)"occ-occpic-business", (Object[])new Object[0]));
    }

    private DynamicObject[] loadAccount4OccupyDetail(OrderRebate orderRebate) {
        String cols = F7Utils.getSelectCols((String[])new String[]{"id", "orderusedamount", "unusedamount", "modifier", "updatedatetime"});
        QFilter fs = new QFilter("owner", "=", (Object)orderRebate.getOwnerId());
        fs.and("customer", "=", (Object)orderRebate.getCustomerId());
        fs.and("accounttype", "=", (Object)orderRebate.getAccountTypeId());
        fs.and("currency", "=", (Object)orderRebate.getCurrencyId());
        Date nowDate = DateUtil.getNowDate();
        fs.and("fromdate", "<=", (Object)nowDate);
        fs.and("todate", ">=", (Object)nowDate);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"ocdbd_rebateaccount", (String)cols, (QFilter[])fs.toArray(), (String)"todate ASC");
        return accounts;
    }

    private Map<String, List<OrderRebate>> groupByDLockKey(List<OrderRebate> orderRebates) {
        HashMap<String, List<OrderRebate>> infoMap = new HashMap<String, List<OrderRebate>>();
        String key = null;
        ArrayList<OrderRebate> tempList = null;
        for (OrderRebate orderRebate : orderRebates) {
            key = this.getDLockKey(orderRebate.getOwnerId(), orderRebate.getCustomerId(), orderRebate.getAccountTypeId(), orderRebate.getCurrencyId());
            tempList = (ArrayList<OrderRebate>)infoMap.get(key);
            if (tempList == null) {
                tempList = new ArrayList<OrderRebate>();
                infoMap.put(key, tempList);
            }
            tempList.add(orderRebate);
        }
        return infoMap;
    }

    public void occupy2PayDetail(List<String> sourceBillIds) {
        this.handelDetails(sourceBillIds, DetailOP.OCCUPY_2PAY);
    }

    public void delOccupyDetailBySourceBillIds(List<String> sourceBillIds) {
        this.handelDetails(sourceBillIds, DetailOP.DEL_OCCUPY);
    }

    public void delPayDetailBySourceBillIds(List<String> sourceBillIds) {
        this.handelDetails(sourceBillIds, DetailOP.DEL_PAY);
    }

    private void handelDetails(List<String> idList, DetailOP type) {
        String tag = RebateACTHandle.class.getName() + ".handelDetails." + type.name();
        try (TXHandle tx = TX.required((String)tag);){
            try {
                this.doHandleDetail(idList, type);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("DRM-USE-REBATE", ResManager.loadKDString((String)"\u8fd4\u5229\u6d41\u6c34\u53cd\u5411\u5904\u7406\u5f02\u5e38", (String)"RebateACTHandle_11", (String)"occ-occpic-business", (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    private void doHandleDetail(List<String> idList, DetailOP opType) {
        DataSet datas = this.queryDetailDataSet(idList, opType);
        if (datas == null) {
            return;
        }
        HashMap<Object, BigDecimal> accountAmountMap = new HashMap<Object, BigDecimal>();
        HashMap<String, List<Object>> dLockAccountsMap = new HashMap<String, List<Object>>();
        ArrayList<Object> details4Del = new ArrayList<Object>(16);
        ArrayList<DynamicObject> newDetails = null;
        Row row = null;
        while (datas.hasNext()) {
            row = datas.next();
            details4Del.add(row.get("id"));
            if (DetailOP.OCCUPY_2PAY == opType) {
                if (newDetails == null) {
                    newDetails = new ArrayList<DynamicObject>();
                }
                newDetails.add(this.newPayDetailByRow(row));
            }
            this.sumAmountByRow(accountAmountMap, row);
            this.groupByDlockKey(dLockAccountsMap, row);
        }
        this.handleAccount4Details(accountAmountMap, dLockAccountsMap, opType);
        if (details4Del.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_account_detail").getDataEntityType(), (Object[])details4Del.toArray());
        }
        if (DetailOP.OCCUPY_2PAY == opType && newDetails != null && newDetails.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newDetails.toArray(new DynamicObject[newDetails.size()]));
        }
    }

    protected void groupByDlockKey(Map<String, List<Object>> dLockAccountsMap, Row row) {
        String lockKey = this.getDLockKey(row.get(OWNER), row.get(CUSTOMER), row.get(CUSTOMER), row.get(CURRENY));
        List<Object> theSameDLockAccountIds = dLockAccountsMap.get(lockKey);
        if (theSameDLockAccountIds == null) {
            theSameDLockAccountIds = new ArrayList<Object>();
            dLockAccountsMap.put(lockKey, theSameDLockAccountIds);
        }
        theSameDLockAccountIds.add(row.get(ACCOUNT));
    }

    private DynamicObject newPayDetailByRow(Row row) {
        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_account_detail");
        detail.set("account", row.get(ACCOUNT));
        detail.set("currency", row.get(CURRENY));
        detail.set("rebateamount", row.get("rebateamount"));
        detail.set("sourcebillid", row.get("sourcebillid"));
        detail.set("sourcebillno", row.get("sourcebillno"));
        detail.set("sourcebilltype", (Object)"2");
        detail.set("amounttype", (Object)"1");
        this.setCreateInfo4NewDetail(detail);
        return detail;
    }

    private void sumAmountByRow(Map<Object, BigDecimal> accountAmountMap, Row row) {
        Object accountId = row.get(ACCOUNT);
        BigDecimal accountSumAmount = accountAmountMap.get(accountId);
        BigDecimal detailAmount = row.getBigDecimal("rebateamount");
        if (accountSumAmount == null) {
            accountAmountMap.put(accountId, detailAmount);
        } else {
            accountAmountMap.put(accountId, accountSumAmount.add(detailAmount));
        }
    }

    protected DataSet queryDetailDataSet(List<String> idList, DetailOP opType) {
        QFilter fs = new QFilter("sourcebillid", "in", idList);
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("id");
        colList.add(ACCOUNT);
        colList.add(OWNER);
        colList.add(CUSTOMER);
        colList.add(CURRENY);
        colList.add(ACCOUNT_TYPE);
        colList.add("rebateamount");
        if (DetailOP.OCCUPY_2PAY == opType) {
            colList.add("sourcebillid");
            colList.add("sourcebillno");
        }
        String cols = F7Utils.getSelectCols(colList);
        DataSet datas = QueryServiceHelper.queryDataSet((String)RebateACTHandle.class.getName(), (String)"ocdbd_account_detail", (String)cols, (QFilter[])fs.toArray(), null);
        return datas;
    }

    private void handleAccount4Details(Map<Object, BigDecimal> rebateAmounts, Map<String, List<Object>> accountDlockKeys, DetailOP opType) {
        String lockKey = null;
        for (Map.Entry<String, List<Object>> accountDlockKey : accountDlockKeys.entrySet()) {
            lockKey = DLOCK_KEY_PREFIX + accountDlockKey.getKey();
            this.batchHandleAmount(lockKey, accountDlockKey.getValue(), rebateAmounts, opType);
        }
    }

    private void batchHandleAmount(String lockKey, List<Object> accountIds, Map<Object, BigDecimal> rebateAmounts, DetailOP opType) {
        DLock lock = DLock.createReentrant((String)lockKey, (String)RebateACTHandle.getDLOCK_MSG());
        if (lock.tryLock(180000L)) {
            try {
                this.afterDLock4batchHandleAmount(accountIds, rebateAmounts, opType);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5904\u7406\u8fd4\u5229\u91d1\u989d\u4efb\u52a1\u5931\u8d25\uff0c\u5efa\u8bae\u7a0d\u540e\u518d\u8bd5", (String)"RebateACTHandle_12", (String)"occ-occpic-business", (Object[])new Object[0]));
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u5904\u7406\u8fd4\u5229\u91d1\u989d\u4efb\u52a1\u7b49\u5f85\u8d85\u65f6\u3010%1$s ms\u3011\uff0c\u5efa\u8bae\u7a0d\u540e\u518d\u8bd5", (String)"RebateACTHandle_13", (String)"occ-occpic-business", (Object[])new Object[0]), 180000L));
        }
    }

    private void afterDLock4batchHandleAmount(List<Object> accountIds, Map<Object, BigDecimal> rebateAmounts, DetailOP opType) {
        QFilter fs;
        String cols = F7Utils.getSelectCols((String[])new String[]{"id", "usedamount", "orderusedamount", "unusedamount", "modifier", "updatedatetime"});
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"ocdbd_rebateaccount", (String)cols, (QFilter[])(fs = new QFilter("id", "in", accountIds)).toArray());
        if (accounts == null) {
            return;
        }
        switch (opType) {
            case DEL_OCCUPY: {
                this.delOccupyDetails(rebateAmounts, accounts);
                break;
            }
            case DEL_PAY: {
                this.delPayDetails(rebateAmounts, accounts);
                break;
            }
            case OCCUPY_2PAY: {
                this.occupy2Pay(rebateAmounts, accounts);
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"RebateACTHandle.batchUnDoAmount:DetailOP\u3010%1$s\u3011 \u975e\u6cd5\u7c7b\u578b", (String)"RebateACTHandle_14", (String)"occ-occpic-business", (Object[])new Object[0]), opType.name()));
            }
        }
        SaveServiceHelper.save((DynamicObject[])accounts);
    }

    private void delOccupyDetails(Map<Object, BigDecimal> rebateAmounts, DynamicObject[] accounts) {
        this.reCalAmount("orderusedamount", "unusedamount", rebateAmounts, accounts);
    }

    private void delPayDetails(Map<Object, BigDecimal> rebateAmounts, DynamicObject[] accounts) {
        this.reCalAmount("usedamount", "unusedamount", rebateAmounts, accounts);
    }

    private void occupy2Pay(Map<Object, BigDecimal> rebateAmounts, DynamicObject[] accounts) {
        this.reCalAmount("orderusedamount", "usedamount", rebateAmounts, accounts);
    }

    private void reCalAmount(String addAmountCol, String subAmountCol, Map<Object, BigDecimal> rebateAmounts, DynamicObject[] accounts) {
        Object accountId = null;
        BigDecimal amount = null;
        for (DynamicObject account : accounts) {
            accountId = account.get("id");
            amount = rebateAmounts.get(accountId);
            account.set(addAmountCol, (Object)account.getBigDecimal(addAmountCol).add(amount));
            account.set(subAmountCol, (Object)account.getBigDecimal(subAmountCol).subtract(amount));
            this.setModifyInfo4Account(account);
        }
    }

    private String createDetailNumber(DynamicObject detail) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)detail.getDataEntityType().getName(), (DynamicObject)detail, null);
        if (codeRuleInfo != null) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)detail);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u3010\u8fd4\u5229\u8d26\u6237\u6d41\u6c34\u3011\u7f16\u7801\u89c4\u5219", (String)"RebateACTHandle_15", (String)"occ-occpic-business", (Object[])new Object[0]));
    }

    public static Map<String, Map<String, BigDecimal>> getAccountBalance(QFilter fs, String[] groupByColName, String[] sumColNames) {
        HashMap<String, Map<String, BigDecimal>> groupSumMap = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, BigDecimal> sumMap = null;
        String cols = F7Utils.getSelectCols((String[])sumColNames);
        cols = cols + "," + F7Utils.getSelectCols((String[])groupByColName);
        try (DataSet datas = null;){
            datas = QueryServiceHelper.queryDataSet((String)RebateACTHandle.class.getName(), (String)"ocdbd_rebateaccount", (String)cols, (QFilter[])fs.toArray(), null);
            GroupbyDataSet grouped = datas.groupBy(groupByColName);
            for (String sumColName : sumColNames) {
                grouped = grouped.sum(sumColName);
            }
            BigDecimal tempSumAmount = null;
            BigDecimal tempAmount = null;
            datas = grouped.finish();
            String groupkey = null;
            while (datas.hasNext()) {
                Row t = datas.next();
                groupkey = RebateACTHandle.getGroupKey(t, groupByColName);
                sumMap = (Map<String, BigDecimal>)groupSumMap.get(groupkey);
                if (sumMap == null) {
                    sumMap = RebateACTHandle.initSumMap(sumColNames);
                    groupSumMap.put(groupkey, sumMap);
                }
                for (String sumColName : sumColNames) {
                    tempAmount = t.getBigDecimal(sumColName);
                    tempSumAmount = sumMap.get(sumColName);
                    sumMap.put(sumColName, tempSumAmount.add(tempAmount));
                }
            }
        }
        return groupSumMap;
    }

    private static Map<String, BigDecimal> initSumMap(String[] sumColNames) {
        HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>(sumColNames.length);
        for (String sumColName : sumColNames) {
            sumMap.put(sumColName, BigDecimal.ZERO);
        }
        return sumMap;
    }

    private static String getGroupKey(Row t, String[] groupByColName) {
        StringBuilder sb = new StringBuilder();
        for (String col : groupByColName) {
            sb.append(t.get(col));
        }
        return sb.toString();
    }

    public static Map<String, BigDecimal> getAccountAmounts(Object ownerId, Object customerId, String[] sumColNames) {
        Date date = DateUtil.getNowDate();
        QFilter fs = new QFilter("fromdate", "<=", (Object)date);
        fs.and("todate", ">=", (Object)date);
        fs.and("owner", "=", ownerId);
        fs.and("customer", "=", customerId);
        Map<String, Map<String, BigDecimal>> groupAccounts = RebateACTHandle.getAccountBalance(fs, new String[]{"owner"}, sumColNames);
        Map<String, BigDecimal> amounts = groupAccounts.get(ownerId.toString());
        if (amounts == null) {
            amounts = new HashMap<String, BigDecimal>(sumColNames.length);
            for (String col : sumColNames) {
                amounts.put(col, BigDecimal.ZERO);
            }
        }
        return amounts;
    }

    public static Map<String, BigDecimal> getAccountBalance4MyAccount(Object ownerId, Object customerId) {
        return RebateACTHandle.getAccountAmounts(ownerId, customerId, new String[]{"unusedamount", "balance", "orderusedamount"});
    }

    public static Map<String, BigDecimal> getAllAccountBalance4Order(Object ownerId, Object customerId, Object currencyId) {
        Date date = DateUtil.getNowDate();
        QFilter fs = new QFilter("fromdate", "<=", (Object)date);
        fs.and("todate", ">=", (Object)date);
        fs.and("owner", "=", ownerId);
        fs.and("customer", "=", customerId);
        fs.and("currency", "=", currencyId);
        Map<String, Map<String, BigDecimal>> amounts = RebateACTHandle.getAccountBalance(fs, new String[]{"accounttype"}, new String[]{"unusedamount"});
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>(amounts.size());
        for (Map.Entry<String, Map<String, BigDecimal>> amountMap : amounts.entrySet()) {
            balanceMap.put(amountMap.getKey(), amountMap.getValue().get("unusedamount"));
        }
        return balanceMap;
    }

    private static enum DetailOP {
        DEL_OCCUPY,
        DEL_PAY,
        OCCUPY_2PAY;

    }
}

