/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.business.helper;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;

public class RebateMonthlyHelper {
    private Log log = LogFactory.getLog(RebateMonthlyHelper.class);

    public void saveRebateMonthly() {
        this.log.info("\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u6708\u7ed3\u8868\u5f00\u59cb...");
        ArrayList<DynamicObject> saveEntry = new ArrayList<DynamicObject>();
        DynamicObject[] rebatePrebudgetList = this.findRebatePreData();
        DynamicObject rebatePreData = BusinessDataServiceHelper.newDynamicObject((String)"occpic_rebatemonthly");
        QFilter[] rabatefilter = new QFilter[]{};
        Map rebateMap = BusinessDataServiceHelper.loadFromCache((String)"occpic_rebatestatement", (String)"paytype", (QFilter[])rabatefilter);
        HashMap<Object, DynamicObject> ratioMap = new HashMap<Object, DynamicObject>();
        Map<Long, Long> fidMap = RebateMonthlyHelper.getRebatestatementMap();
        for (Map.Entry<Long, Long> entry : fidMap.entrySet()) {
            Long fid = entry.getKey();
            Long settleId = entry.getValue();
            for (Map.Entry entryRebate : rebateMap.entrySet()) {
                Object rebateid = entryRebate.getKey();
                if (!settleId.equals((Long)rebateid)) continue;
                DynamicObject entity = (DynamicObject)entryRebate.getValue();
                if (ratioMap.containsKey(fid)) continue;
                ratioMap.put(fid, entity);
            }
        }
        this.setEntry(rebatePreData);
        if (rebatePrebudgetList != null) {
            for (DynamicObject rebatePrebudget : rebatePrebudgetList) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)rebatePrebudget.get("id"), (String)"occpic_rebateprebudget");
                this.setEntryBody(rebatePreData, dynamicObject, ratioMap);
            }
        }
        saveEntry.add(rebatePreData);
        SaveServiceHelper.save((DynamicObject[])saveEntry.toArray(new DynamicObject[saveEntry.size()]));
        this.log.info("\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u6708\u7ed3\u8868\u7ed3\u675f...");
    }

    private DynamicObject[] findRebatePreData() {
        QFilter qf = new QFilter("1", "=", (Object)"1");
        DynamicObject[] rebatepreList = BusinessDataServiceHelper.load((String)"occpic_rebateprebudget", (String)"id", (QFilter[])qf.toArray());
        return rebatepreList;
    }

    private void setEntry(DynamicObject rebatePreData) {
        rebatePreData.set("number", (Object)DateUtil.getDateFormat((Date)DateUtil.getlastFirstDayOfMonth()));
        rebatePreData.set("status", (Object)"C");
        rebatePreData.set("enable", (Object)1);
        String name = DateUtil.getDateFormat((Date)DateUtil.getlastFirstDayOfMonth()).substring(0, 7);
        rebatePreData.set("name", (Object)name);
        rebatePreData.set("monthlydate", (Object)name);
        QFilter qf = new QFilter("enable", "=", (Object)"1");
        qf.and("name", "=", (Object)name);
        DynamicObject[] rebatepreList = BusinessDataServiceHelper.load((String)"occpic_rebatemonthly", (String)"id,enable", (QFilter[])qf.toArray());
        if (rebatepreList.length > 0) {
            for (DynamicObject dynamicObject : rebatepreList) {
                dynamicObject.set("enable", (Object)"0");
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
    }

    private void setEntryBody(DynamicObject rebatePreData, DynamicObject rebatePrebudget, Map<Object, DynamicObject> ratioMap) {
        DynamicObjectCollection rebatePrebudgetEntrys = rebatePrebudget.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entryEntitys = rebatePreData.getDynamicObjectCollection("entryentity");
        for (DynamicObject rebatePrebudgetEntry : rebatePrebudgetEntrys) {
            try {
                DynamicObject monthlyEntryEntitys = entryEntitys.addNew();
                DynamicObject rebatestatement = ratioMap.get(rebatePrebudget.getPkValue());
                if (rebatestatement != null) {
                    monthlyEntryEntitys.set("paytype", (Object)rebatestatement.getString("paytype"));
                }
                this.addEntryEntity(monthlyEntryEntitys, rebatePrebudgetEntry, rebatePrebudget);
            }
            catch (Exception e) {
                this.log.info("\u751f\u6210\u6708\u7ed3\u8868\u5931\u8d25,\u9884\u7ed3\u7b97\u5355\u53f7\u4e3a:" + rebatePrebudget.getString("billno"));
                this.log.info("\u751f\u6210\u6708\u7ed3\u8868\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a:", (Object)e);
            }
        }
    }

    public void addEntryEntity(DynamicObject monthlyEntryEntitys, DynamicObject pretRelationEntry, DynamicObject rebatePrebudget) {
        monthlyEntryEntitys.set("billno", rebatePrebudget.get("billno"));
        monthlyEntryEntitys.set("billname", rebatePrebudget.get("name"));
        monthlyEntryEntitys.set("rpareadep", rebatePrebudget.get("rpareadep"));
        monthlyEntryEntitys.set("rprepresentoffice", rebatePrebudget.get("rprepresentoffice"));
        monthlyEntryEntitys.set("rparea", rebatePrebudget.get("rparea"));
        monthlyEntryEntitys.set("businessorg", rebatePrebudget.get("businessorg"));
        monthlyEntryEntitys.set("repolicytarget", rebatePrebudget.get("rebatepolicy"));
        monthlyEntryEntitys.set("channel", rebatePrebudget.get("channel"));
        monthlyEntryEntitys.set("customer", rebatePrebudget.get("customer"));
        monthlyEntryEntitys.set("channelsecondgroup", rebatePrebudget.get("rpchannelsecondgroup"));
        monthlyEntryEntitys.set("rpcontractsubject", rebatePrebudget.get("rpcontractsubject"));
        monthlyEntryEntitys.set("rppdestformula", rebatePrebudget.get("rppdestformula.rebateformula"));
        monthlyEntryEntitys.set("rpincentivetype", rebatePrebudget.get("rpincentivetype"));
        monthlyEntryEntitys.set("rpincentivesubtyp", rebatePrebudget.get("rpincentivesubtyp"));
        monthlyEntryEntitys.set("rpbudgetcycle", rebatePrebudget.get("rpbudgetcycle"));
        monthlyEntryEntitys.set("rpdestcaculatetype", rebatePrebudget.get("rpdestcaculatetype"));
        monthlyEntryEntitys.set("rpbegindate", rebatePrebudget.get("rpbegindate"));
        monthlyEntryEntitys.set("rpenddate", rebatePrebudget.get("rpenddate"));
        monthlyEntryEntitys.set("laddertype", rebatePrebudget.get("laddertype"));
        monthlyEntryEntitys.set("saleorderqty", pretRelationEntry.get("framecontractnumber"));
        monthlyEntryEntitys.set("brand", (Object)"Honor");
        monthlyEntryEntitys.set("productmodel", pretRelationEntry.get("product"));
        DynamicObject product = (DynamicObject)pretRelationEntry.get("product");
        monthlyEntryEntitys.set("productcode", pretRelationEntry.get("product.product_code"));
        monthlyEntryEntitys.set("rpprecurrency", rebatePrebudget.get("rpprecurrency"));
        monthlyEntryEntitys.set("profitrate", pretRelationEntry.get("profitrate"));
        BigDecimal adjustendamount = pretRelationEntry.getBigDecimal("rebateamount");
        BigDecimal proconsignqty = pretRelationEntry.getBigDecimal("proconsignqty");
        if (proconsignqty.compareTo(new BigDecimal(0)) > 0) {
            BigDecimal perunamount = adjustendamount.divide(proconsignqty, 2, 0);
            monthlyEntryEntitys.set("perunitrebateamount", (Object)perunamount);
        }
        monthlyEntryEntitys.set("consignqtynumer", pretRelationEntry.get("proconsignqty"));
        monthlyEntryEntitys.set("rebateamount", (Object)pretRelationEntry.getBigDecimal("rebateamount"));
        monthlyEntryEntitys.set("settleamount", (Object)pretRelationEntry.getBigDecimal("actualunitrebate"));
        monthlyEntryEntitys.set("hassettlenumber", pretRelationEntry.get("hasbudgetqty"));
        monthlyEntryEntitys.set("hasbudgetamount", (Object)pretRelationEntry.getBigDecimal("hasbudgetamount"));
        monthlyEntryEntitys.set("unitid", pretRelationEntry.get("unitid"));
        BigDecimal prosaleamount = pretRelationEntry.getBigDecimal("rebateamount").subtract(pretRelationEntry.getBigDecimal("hasbudgetamount"));
        monthlyEntryEntitys.set("prosaleamount", (Object)prosaleamount);
        int rate = 0;
        String rparea = (String)rebatePrebudget.get("rparea.number");
        if ("CN".equals(rparea)) {
            rate = 13;
        }
        BigDecimal taxrate = new BigDecimal(rate).divide(new BigDecimal(100));
        monthlyEntryEntitys.set("taxrate", (Object)rate);
        monthlyEntryEntitys.set("isbudgetfinish", rebatePrebudget.get("isbudgetfinish"));
        monthlyEntryEntitys.set("istax", pretRelationEntry.get("istax"));
        monthlyEntryEntitys.set("prosaleamountistax", (Object)prosaleamount.divide(new BigDecimal(1).add(taxrate), 2, 0));
        BigDecimal rebateamount = pretRelationEntry.getBigDecimal("rebateamount");
        monthlyEntryEntitys.set("adjustendamount", (Object)rebateamount);
        BigDecimal hasbudgetamount = pretRelationEntry.getBigDecimal("hasbudgetamount");
        monthlyEntryEntitys.set("adjustendsettleamount", (Object)hasbudgetamount);
        BigDecimal adjustrebateamount = rebateamount.subtract(hasbudgetamount);
        monthlyEntryEntitys.set("adjustrebateamount", (Object)adjustrebateamount);
        monthlyEntryEntitys.set("adjustrrnotaxamount", (Object)adjustrebateamount.divide(new BigDecimal(1).add(taxrate), 2, 0));
        DynamicObject group = (DynamicObject)product.get("group");
        if (group != null) {
            Long groupId = (Long)group.getPkValue();
            DynamicObject groupDynamic = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"bd_productgroup", (String)"parent.id,parent");
            monthlyEntryEntitys.set("fourproductclass", groupDynamic.get("parent"));
            Long groupid4 = (Long)groupDynamic.get("parent.id");
            DynamicObject groupDynamic4 = BusinessDataServiceHelper.loadSingle((Object)groupid4, (String)"bd_productgroup", (String)"parent.id,parent");
            monthlyEntryEntitys.set("thirdproductclass", groupDynamic4.get("parent"));
            Long groupid3 = (Long)groupDynamic4.get("parent.id");
            DynamicObject groupDynamic3 = BusinessDataServiceHelper.loadSingle((Object)groupid3, (String)"bd_productgroup", (String)"parent.id,parent");
            monthlyEntryEntitys.set("secondproductclass", groupDynamic3.get("parent"));
            Long groupid2 = (Long)groupDynamic3.get("parent.id");
            DynamicObject groupDynamic2 = BusinessDataServiceHelper.loadSingle((Object)groupid2, (String)"bd_productgroup", (String)"parent.id,parent");
            monthlyEntryEntitys.set("firstproductclass", groupDynamic2.get("parent"));
        }
    }

    private static Map<Long, Long> getRebatestatementMap() {
        StringBuilder sql = new StringBuilder();
        sql.append("select FTBILLID,FSBILLID from t_occpic_rebatestatement_tc");
        return (Map)DB.query((DBRoute)DBRoute.of((String)"drp"), (String)sql.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Map<Long, Long>>(){

            public Map<Long, Long> handle(ResultSet rs) throws Exception {
                HashMap<Long, Long> resultMap = new HashMap<Long, Long>(rs.getFetchSize());
                while (rs.next()) {
                    resultMap.put(rs.getLong("FSBILLID"), rs.getLong("FTBILLID"));
                }
                return resultMap;
            }
        });
    }
}

