/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class RebatePreHelper {
    public static final void setRate(DynamicObject rowData) {
        DynamicObject taxRate;
        BigDecimal rebateAmount = rowData.getBigDecimal("rebateamount");
        boolean isTax = rowData.getBoolean("istax");
        long materialId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)rowData, (String)"material");
        if (materialId > 0L && rebateAmount != null && (taxRate = RebatePreHelper.getTaxRateByMaterial(materialId)) != null) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)rowData, (String)"taxrateid", (long)((Long)taxRate.getPkValue()));
            BigDecimal taxRateValue = taxRate.getBigDecimal("taxrate");
            rowData.set("taxrate", (Object)taxRateValue);
            BigDecimal taxRateValuePercent = taxRateValue.divide(new BigDecimal("100"));
            if (isTax) {
                if (BigDecimal.ZERO.compareTo(BigDecimal.ONE.add(taxRateValuePercent)) != 0) {
                    rowData.set("tax", (Object)rebateAmount.divide(BigDecimal.ONE.add(taxRateValuePercent), 10, RoundingMode.HALF_UP).multiply(taxRateValuePercent));
                }
            } else {
                rowData.set("tax", (Object)rebateAmount.multiply(taxRateValuePercent));
            }
        }
    }

    private static final DynamicObject getTaxRateByMaterial(long materialId) {
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"taxrate");
        return material != null ? material.getDynamicObject("taxrate") : null;
    }
}

