/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.business.rebate;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.occpic.business.rebate.RebateProcessor;
import kd.occ.occpic.common.pojo.SettlePeriod;

public class RebateHelper {
    private static final RebateProcessor processor = new RebateProcessor();
    private static final int SETTLEPERIOD_CALTYPE_FIRSTDAY = 1;
    private static final int SETTLEPERIOD_CALTYPE_LASTDAY = 2;
    private static final int SETTLEPERIOD_CALTYPE_ADDDAY = 3;
    private static final int SETTLEPERIOD_CALTYPE_LASTPERIODENDDAY = 4;
    private static final String SETTLEPERIOD_BY_YEAR = "A";
    private static final String SETTLEPERIOD_BY_QUARTER = "E";
    private static final String SETTLEPERIOD_BY_MONTH = "B";
    private static final String SETTLEPERIOD_BY_WEEK = "C";
    private static final String SETTLEPERIOD_WHOLE_LIFE = "D";
    private static final String DATEFORMAT_PATTERN_YYYYMMDD = "yyyyMMdd";

    public static BigDecimal getAccountBalance4Order(long ownerId, long customerId, long accountTypeId, long currencyId) {
        return processor.getAccountBalance4Order(ownerId, customerId, accountTypeId, currencyId);
    }

    public static DynamicObject getRebateAccount(long orgId, long customerId, long channelId, long accountTypeId, long currencyId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("customer", "=", (Object)customerId));
        filter.and(new QFilter("channel", "=", (Object)channelId));
        filter.and(new QFilter("accounttype", "=", (Object)accountTypeId));
        filter.and(new QFilter("setcurrency", "=", (Object)currencyId));
        return ORM.create().queryOne("ocdbd_rebateaccount", filter.toArray());
    }

    public static void checkAdjustAccountExist(long pkValue, long orgId, long customerId, long accountTypeId, long currencyId, long channelId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("entryentity.customer", "=", (Object)customerId));
        filter.and(new QFilter("entryentity.channel", "=", (Object)channelId));
        filter.and(new QFilter("entryentity.accounttype", "=", (Object)accountTypeId));
        filter.and(new QFilter("entryentity.currency", "=", (Object)currencyId));
        filter.and(new QFilter("billstatus", "=", (Object)SETTLEPERIOD_BY_MONTH));
        filter.and(new QFilter("id", "!=", (Object)pkValue));
        DynamicObject adjustBill = ORM.create().queryOne("occba_balanceadjust", filter.toArray());
        if (adjustBill != null) {
            DynamicObjectCollection adjustAccounts = adjustBill.getDynamicObjectCollection("entryentity");
            DynamicObject adjustInfo = (DynamicObject)adjustAccounts.get(0);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u3010%1$s\u3011\uff0c\u5ba2\u6237\u4e3a\u3010%2$s\u3011\uff0c\u6e20\u9053\u4e3a\u3010%3$s\u3011\uff0c\u8d26\u6237\u7c7b\u578b\u4e3a\u3010%4$s\u3011\uff0c\u5e01\u522b\u4e3a\u3010%5$s\u3011\u7684\u6fc0\u52b1\u8d26\u6237\u5df2\u5b58\u5728\u4e8e\u63d0\u4ea4\u72b6\u6001\u7684\u8c03\u6574\u5355\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8c03\u6574\u3002", (String)"RebateHelper_0", (String)"occ-occpic-business", (Object[])new Object[0]), adjustBill.getString("org.name"), adjustInfo.getString("customer.name"), adjustInfo.getString("channel.name"), adjustInfo.getString("accounttype.name"), adjustInfo.getString("currency.name"));
            throw new KDBizException(errorMsg);
        }
    }

    public static final void rebateUpgrade() {
        RebateHelper.rebateUpgrade1();
        RebateHelper.rebateUpgrade2();
    }

    private static void rebateUpgrade1() {
        RebateHelper.updateKPI1();
        RebateHelper.updatePolicy1();
        RebateHelper.updateTarget1();
        RebateHelper.updateRebatePrebudget1();
        RebateHelper.updateRebateStatement1();
    }

    private static void rebateUpgrade2() {
        RebateHelper.updateKPI2();
        RebateHelper.updatePolicy2();
        RebateHelper.updateTarget2();
        RebateHelper.updateRebatePrebudget2();
    }

    private static void updateKPI1() {
        if (RebateHelper.exsit("SELECT FID FROM T_OCDBD_KPI WHERE FREBATECLASSID = 0 ")) {
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FCALSCOPETYPE = 'A' WHERE FCALSCOPETYPE = ' '");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FREBATECLASSID = 1560989956279842816 WHERE FREBATECLASSID = 0");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FTARGETCALTYPE = 'totalamount' WHERE FTARGETCALTYPE = 'A'");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FTARGETCALTYPE = 'totalqty' WHERE FTARGETCALTYPE = 'B'");
        }
    }

    private static void updatePolicy1() {
        Map<Long, Map<String, Object>> policyMap = RebateHelper.queryPolicyForUpgrade();
        if (!CollectionUtils.isEmpty(policyMap)) {
            Set<Long> contPartyIdSet = policyMap.values().stream().map(r -> (Long)r.get("fsignpartyid")).filter(r -> r > 0L).collect(Collectors.toSet());
            Map<Long, Map<String, Object>> contPartyMap = RebateHelper.queryContParties(contPartyIdSet);
            Set<Long> kpiIdSet = policyMap.values().stream().map(r -> (Long)r.get("fkpiid")).filter(r -> r > 0L).collect(Collectors.toSet());
            Map<Long, Map<String, Object>> kpiMap = RebateHelper.queryKpi(kpiIdSet);
            ArrayList<Object[]> policyPL1 = new ArrayList<Object[]>(policyMap.size());
            ArrayList<Object[]> policyPL2 = new ArrayList<Object[]>(policyMap.size());
            ArrayList<Object[]> policyPL3 = new ArrayList<Object[]>(policyMap.size());
            ArrayList<Object[]> policyEntryEntityPL = new ArrayList<Object[]>(policyMap.size());
            ArrayList<Object[]> incomecusEntityPL = new ArrayList<Object[]>(policyMap.size());
            ArrayList<Object[]> itemClassEntityPL = new ArrayList<Object[]>(policyMap.size());
            for (Map.Entry<Long, Map<String, Object>> policyEntry : policyMap.entrySet()) {
                long policyId = policyEntry.getKey();
                Map<String, Object> policy = policyEntry.getValue();
                Map<String, Object> contParty = contPartyMap.get(policy.get("fsignpartyid"));
                Map<String, Object> kpi = kpiMap.get(policy.get("fkpiid"));
                if (contParty != null && kpi != null) {
                    policyPL1.add(new Object[]{contParty.get("forgid"), contParty.get("frepresentativeorgid"), kpi.get("fcalscopetype"), kpi.get("frebateclassid"), kpi.get("fladdertypeid"), kpi.get("ftargetcaltype"), kpi.get("fcalbilltypeid"), policyId});
                } else if (kpi != null) {
                    policyPL2.add(new Object[]{kpi.get("fcalscopetype"), kpi.get("frebateclassid"), kpi.get("fladdertypeid"), kpi.get("ftargetcaltype"), kpi.get("fcalbilltypeid"), policyId});
                } else if (contParty != null) {
                    policyPL3.add(new Object[]{contParty.get("forgid"), contParty.get("frepresentativeorgid"), policyId});
                }
                if (policy.get("fhighestrebate") != null && BigDecimal.ZERO.compareTo((BigDecimal)policy.get("fhighestrebate")) < 0) {
                    Object[] policyEntryEntityP = new Object[3];
                    policyEntryEntityP[1] = policyId;
                    policyEntryEntityP[2] = policy.get("fhighestrebate");
                    policyEntryEntityPL.add(policyEntryEntityP);
                }
                incomecusEntityPL.add(new Object[]{policy.get("fbaselineamount"), policy.get("fbaselineqty"), policyId});
            }
            if (!CollectionUtils.isEmpty(policyPL1)) {
                RebateHelper.executeBatch("UPDATE T_OCCPIC_REBATEPOLICY SET FBIZORGID = ?,FBALANCEORGID = ?,FCALSCOPETYPE = ?,FREBATECLASSID = ?,FLADDERTYPEID = ?,FTARGETCALTYPE = ?,FCALBILLTYPEID = ? WHERE FID = ?", policyPL1);
            }
            if (!CollectionUtils.isEmpty(policyPL2)) {
                RebateHelper.executeBatch("UPDATE T_OCCPIC_REBATEPOLICY SET FCALSCOPETYPE = ?,FREBATECLASSID = ?,FLADDERTYPEID = ?,FTARGETCALTYPE = ?,FCALBILLTYPEID = ? WHERE FID = ?", policyPL2);
            }
            if (!CollectionUtils.isEmpty(policyPL3)) {
                RebateHelper.executeBatch("UPDATE T_OCCPIC_REBATEPOLICY SET FBIZORGID = ?,FBALANCEORGID = ? WHERE FID = ?", policyPL3);
            }
            if (!CollectionUtils.isEmpty(policyEntryEntityPL)) {
                long[] entryIdArray = DB.genLongIds((String)"T_OCCPIC_RP_FORMULA", (int)policyEntryEntityPL.size());
                int size = policyEntryEntityPL.size();
                for (int i = 0; i < size; ++i) {
                    Object[] formulaEntityP = (Object[])policyEntryEntityPL.get(i);
                    formulaEntityP[0] = entryIdArray[i];
                }
                RebateHelper.executeBatch("INSERT INTO T_OCCPIC_RP_FORMULA (FENTRYID,FID,FICTPERCENT) VALUES (?,?,?)", policyEntryEntityPL);
            }
            if (!CollectionUtils.isEmpty(incomecusEntityPL)) {
                RebateHelper.executeBatch("UPDATE T_OCCPIC_RP_BNFCUST SET FBLAMOUNT = ? ,FBLQTY = ?,FCHANNELID = FBCHANNELID WHERE FID = ?", incomecusEntityPL);
            }
            Map<Long, List<Map<String, Object>>> classItemMap = RebateHelper.queryPolicyClassItem(policyMap.keySet());
            for (List<Map<String, Object>> classItemList : classItemMap.values()) {
                for (Map<String, Object> classItem : classItemList) {
                    if ((Long)classItem.get("fproductmodelid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("fproductmodelid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("ffourthclassid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("ffourthclassid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("fthirdclassid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("fthirdclassid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("fsecclassid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("fsecclassid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("ffirstclassid") <= 0L) continue;
                    itemClassEntityPL.add(new Object[]{classItem.get("ffirstclassid"), classItem.get("fentryid")});
                }
            }
            if (!CollectionUtils.isEmpty(itemClassEntityPL)) {
                RebateHelper.executeBatch("UPDATE T_OCCPIC_RP_ITEMCLASS SET FITEMCLASSID = ? WHERE FENTRYID = ?", itemClassEntityPL);
            }
        }
    }

    private static void updateTarget1() {
        Map<Long, Map<String, Object>> targetMap = RebateHelper.queryTargetForUpgrade();
        if (!CollectionUtils.isEmpty(targetMap)) {
            Set<Long> contPartyIdSet = targetMap.values().stream().map(r -> (Long)r.get("fsignpartyid")).filter(r -> r > 0L).collect(Collectors.toSet());
            Map<Long, Map<String, Object>> contPartyMap = RebateHelper.queryContParties(contPartyIdSet);
            Set<Long> kpiIdSet = targetMap.values().stream().map(r -> (Long)r.get("fkpiid")).filter(r -> r > 0L).collect(Collectors.toSet());
            Map<Long, Map<String, Object>> kpiMap = RebateHelper.queryKpi(kpiIdSet);
            ArrayList<Object[]> targetPL = new ArrayList<Object[]>(targetMap.size());
            ArrayList<Object[]> formulaEntityPL = new ArrayList<Object[]>(targetMap.size());
            ArrayList<Object[]> itemClassEntityPL = new ArrayList<Object[]>(targetMap.size());
            for (Map.Entry<Long, Map<String, Object>> targetMapEntry : targetMap.entrySet()) {
                long targetId = targetMapEntry.getKey();
                Map<String, Object> target = targetMapEntry.getValue();
                Map<String, Object> contParty = contPartyMap.get(target.get("fsignpartyid"));
                Map<String, Object> kpi = kpiMap.get(target.get("fkpiid"));
                Object[] targetP = new Object[9];
                targetP[0] = targetMapEntry.getValue() == null || targetMapEntry.getValue().get("fcustomerid") == null ? Long.valueOf(0L) : targetMapEntry.getValue().get("fcustomerid");
                if (contParty == null) {
                    targetP[1] = 0L;
                    targetP[2] = 0L;
                } else {
                    targetP[1] = contParty.get("forgid");
                    targetP[2] = contParty.get("frepresentativeorgid");
                }
                if (kpi == null) {
                    targetP[3] = " ";
                    targetP[4] = 0L;
                    targetP[5] = 0L;
                    targetP[6] = " ";
                    targetP[7] = 0L;
                } else {
                    targetP[3] = kpi.get("fcalscopetype");
                    targetP[4] = kpi.get("frebateclassid");
                    targetP[5] = kpi.get("fladdertypeid");
                    targetP[6] = kpi.get("ftargetcaltype");
                    targetP[7] = kpi.get("fcalbilltypeid");
                }
                targetP[8] = targetId;
                targetPL.add(targetP);
                if (target.get("fhighestrebate") == null || BigDecimal.ZERO.compareTo((BigDecimal)target.get("fhighestrebate")) >= 0) continue;
                Object[] formulaEntityP = new Object[3];
                formulaEntityP[1] = targetId;
                formulaEntityP[2] = target.get("fhighestrebate");
                formulaEntityPL.add(formulaEntityP);
            }
            if (!CollectionUtils.isEmpty(targetPL)) {
                RebateHelper.executeBatch("UPDATE T_OCCPIC_REBATETARGET SET FBNFCUSTOMERID = ?,FBIZORGID = ?,FBALANCEORGID = ?,FCALSCOPETYPE = ?,FREBATECLASSID = ?,FLADDERTYPEID = ?,FTARGETCALTYPE = ?,FCALBILLTYPEID = ? WHERE FID = ?", targetPL);
            }
            if (!CollectionUtils.isEmpty(formulaEntityPL)) {
                long[] entryIdArray = DB.genLongIds((String)"T_OCCPIC_RBTGT_FORM_DT", (int)formulaEntityPL.size());
                int size = formulaEntityPL.size();
                for (int i = 0; i < size; ++i) {
                    Object[] formulaEntityP = (Object[])formulaEntityPL.get(i);
                    formulaEntityP[0] = entryIdArray[i];
                }
                RebateHelper.executeBatch("INSERT INTO T_OCCPIC_RBTGT_FORM_DT (FENTRYID,FID,FICTPERCENT) VALUES (?,?,?)", formulaEntityPL);
            }
            Map<Long, List<Map<String, Object>>> classItemMap = RebateHelper.queryTargetClassItem(targetMap.keySet());
            for (List<Map<String, Object>> classItemList : classItemMap.values()) {
                for (Map<String, Object> classItem : classItemList) {
                    if ((Long)classItem.get("fproductmodelid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("fproductmodelid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("ffourthlevelid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("ffourthlevelid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("fthirdlevelid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("fthirdlevelid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("fseclevelid") > 0L) {
                        itemClassEntityPL.add(new Object[]{classItem.get("fseclevelid"), classItem.get("fentryid")});
                        continue;
                    }
                    if ((Long)classItem.get("ffirstlevelid") <= 0L) continue;
                    itemClassEntityPL.add(new Object[]{classItem.get("ffirstlevelid"), classItem.get("fentryid")});
                }
            }
            if (!CollectionUtils.isEmpty(itemClassEntityPL)) {
                RebateHelper.executeBatch("UPDATE T_OCCPIC_RBTGT_ITEMCLASS SET FITEMCLASSID = ? WHERE FENTRYID = ?", itemClassEntityPL);
            }
        }
    }

    private static void updateRebateStatement1() {
        RebateHelper.execute("UPDATE T_OCCPIC_REBATESTATEMENT SET FDESTCACULATETYPE = 'totalamount' WHERE FDESTCACULATETYPE = 'A'");
        RebateHelper.execute("UPDATE T_OCCPIC_REBATESTATEMENT SET FDESTCACULATETYPE = 'totalqty' WHERE FDESTCACULATETYPE = 'B'");
    }

    private static void updateKPI2() {
        if (RebateHelper.exsit("SELECT FID FROM T_OCDBD_KPI WHERE FNREBATECLASSID = 0 ")) {
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNREBATECLASSID = 1695535217797783552 WHERE FREBATECLASSID = 1560989956279842816");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNREBATECLASSID = 1695535399184650240 WHERE FREBATECLASSID = 1560991314798131200");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNREBATETYPEID = 1685577941872112640 WHERE FREBATETYPE = 'A'");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNREBATETYPEID = 1685578233493681152 WHERE FREBATETYPE = 'B'");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNREBATETYPEID = 1685578435222926336 WHERE FREBATETYPE = 'C'");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNLADDERTYPEID = 1685577627081208832 WHERE FLADDERTYPEID = 1033307953928798208");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNLADDERTYPEID = 1685577457002181632 WHERE FLADDERTYPEID = 1031932621782945792");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNLADDERTYPEID = 1685577291184567296 WHERE FLADDERTYPEID = 1031933043016896512 AND FTARGETCALTYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNLADDERTYPEID = 1685577107457274880 WHERE FLADDERTYPEID = 1031933043016896512 AND FTARGETCALTYPE = 'totalamount'");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNLADDERTYPEID = 1685576410909209600 WHERE FLADDERTYPEID = 1031934446783336448 AND FTARGETCALTYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCDBD_KPI SET FNLADDERTYPEID = 1685560276713451520 WHERE FLADDERTYPEID = 1031934446783336448 AND FTARGETCALTYPE = 'totalamount'");
        }
    }

    private static void updatePolicy2() {
        if (RebateHelper.exsit("SELECT FID FROM T_OCCPIC_REBATEPOLICY WHERE FNREBATECLASSID = 0 ")) {
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNREBATECLASSID = 1695535217797783552 WHERE FREBATECLASSID = 1560989956279842816");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNREBATECLASSID = 1695535399184650240 WHERE FREBATECLASSID = 1560991314798131200");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNREBATETYPEID = 1685577941872112640 WHERE FREBATETYPE = 'A'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNREBATETYPEID = 1685578233493681152 WHERE FREBATETYPE = 'B'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNREBATETYPEID = 1685578435222926336 WHERE FREBATETYPE = 'C'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNLADDERTYPEID = 1685577627081208832 WHERE FLADDERTYPEID = 1033307953928798208");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNLADDERTYPEID = 1685577457002181632 WHERE FLADDERTYPEID = 1031932621782945792");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNLADDERTYPEID = 1685577291184567296 WHERE FLADDERTYPEID = 1031933043016896512 AND FTARGETCALTYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNLADDERTYPEID = 1685577107457274880 WHERE FLADDERTYPEID = 1031933043016896512 AND FTARGETCALTYPE = 'totalamount'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNLADDERTYPEID = 1685576410909209600 WHERE FLADDERTYPEID = 1031934446783336448 AND FTARGETCALTYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPOLICY SET FNLADDERTYPEID = 1685560276713451520 WHERE FLADDERTYPEID = 1031934446783336448 AND FTARGETCALTYPE = 'totalamount'");
        }
    }

    private static void updateTarget2() {
        if (RebateHelper.exsit("SELECT FID FROM T_OCCPIC_REBATETARGET WHERE FNREBATECLASSID = 0 ")) {
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNREBATECLASSID = 1695535217797783552 WHERE FREBATECLASSID = 1560989956279842816");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNREBATECLASSID = 1695535399184650240 WHERE FREBATECLASSID = 1560991314798131200");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNREBATETYPEID = 1685577941872112640 WHERE FREBATETYPE = 'A'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNREBATETYPEID = 1685578233493681152 WHERE FREBATETYPE = 'B'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNREBATETYPEID = 1685578435222926336 WHERE FREBATETYPE = 'C'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNLADDERTYPEID = 1685577627081208832 WHERE FLADDERTYPEID = 1033307953928798208");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNLADDERTYPEID = 1685577457002181632 WHERE FLADDERTYPEID = 1031932621782945792");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNLADDERTYPEID = 1685577291184567296 WHERE FLADDERTYPEID = 1031933043016896512 AND FTARGETCALTYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNLADDERTYPEID = 1685577107457274880 WHERE FLADDERTYPEID = 1031933043016896512 AND FTARGETCALTYPE = 'totalamount'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNLADDERTYPEID = 1685576410909209600 WHERE FLADDERTYPEID = 1031934446783336448 AND FTARGETCALTYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATETARGET SET FNLADDERTYPEID = 1685560276713451520 WHERE FLADDERTYPEID = 1031934446783336448 AND FTARGETCALTYPE = 'totalamount'");
        }
    }

    private static void updateRebatePrebudget1() {
        StringBuilder sql = new StringBuilder(100);
        sql.append("SELECT T1.FID,T2.FREBATEPOLICYTARGETID,T3.FCUSTOMERID ");
        sql.append("FROM T_OCCPIC_REBATEPREBUDGET T1 ");
        sql.append("LEFT JOIN T_OCCPIC_REBATEPBDGENTRY T2 ON T1.FID =  T2.FID ");
        sql.append("LEFT JOIN T_OCDBD_CHANNEL T3 ON T3.FID = T1.FCHANNELID ");
        sql.append("WHERE T1.FREBATECUSTOMERID = 0 OR T1.FREBATEPOLICYTARGETID = 0 ");
        Map result = (Map)DB.query((DBRoute)RebateHelper.getDRPDBRoute(), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<Long, Object[]>>(){

            public Map<Long, Object[]> handle(ResultSet rs) throws Exception {
                HashMap<Long, Object[]> result = new HashMap<Long, Object[]>(500);
                while (rs.next()) {
                    long fid = rs.getLong("FREBATEPOLICYTARGETID");
                    if (result.containsKey(fid)) continue;
                    Object[] data = new Object[]{rs.getLong("FCUSTOMERID"), rs.getLong("FREBATEPOLICYTARGETID"), rs.getLong("FID")};
                    result.put(fid, data);
                }
                return result;
            }
        });
        if (!CollectionUtils.isEmpty((Map)result)) {
            RebateHelper.executeBatch("UPDATE T_OCCPIC_REBATEPREBUDGET SET FREBATECUSTOMERID = ?,FREBATEPOLICYTARGETID = ? WHERE FID = ?", result.values().stream().collect(Collectors.toList()));
        }
    }

    private static void updateRebatePrebudget2() {
        if (RebateHelper.exsit("SELECT FID FROM T_OCCPIC_REBATEPREBUDGET WHERE FNREBATETYPEID = 0 ")) {
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNREBATETYPEID = 1685577941872112640 WHERE FREBATETYPE = 'A'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNREBATETYPEID = 1685578233493681152 WHERE FREBATETYPE = 'B'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNREBATETYPEID = 1685578435222926336 WHERE FREBATETYPE = 'C'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNLADDERTYPEID = 1685577627081208832 WHERE FLADDERTYPEID = 1033307953928798208");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNLADDERTYPEID = 1685577457002181632 WHERE FLADDERTYPEID = 1031932621782945792");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNLADDERTYPEID = 1685577291184567296 WHERE FLADDERTYPEID = 1031933043016896512 AND FRPDESTCACULATETYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNLADDERTYPEID = 1685577107457274880 WHERE FLADDERTYPEID = 1031933043016896512 AND FRPDESTCACULATETYPE = 'totalamount'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNLADDERTYPEID = 1685576410909209600 WHERE FLADDERTYPEID = 1031934446783336448 AND FRPDESTCACULATETYPE = 'totalqty'");
            RebateHelper.execute("UPDATE T_OCCPIC_REBATEPREBUDGET SET FNLADDERTYPEID = 1685560276713451520 WHERE FLADDERTYPEID = 1031934446783336448 AND FRPDESTCACULATETYPE = 'totalamount'");
        }
    }

    private static void executeBatch(String sql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)RebateHelper.getDRPDBRoute(), (String)sql, paramsList);
    }

    private static void execute(String sql) {
        DB.execute((DBRoute)RebateHelper.getDRPDBRoute(), (String)sql);
    }

    private static DBRoute getDRPDBRoute() {
        return DBRoute.of((String)"drp");
    }

    private static boolean exsit(String sql) {
        SqlBuilder sb = new SqlBuilder();
        sb.append(sql, new Object[0]);
        return RebateHelper.exsit(sb);
    }

    private static boolean exsit(SqlBuilder sql) {
        try (DataSet result = null;){
            result = DB.queryDataSet((String)"RebateHelper_exsit", (DBRoute)RebateHelper.getDRPDBRoute(), (SqlBuilder)sql);
            boolean bl = result != null && result.hasNext();
            return bl;
        }
    }

    private static Map<Long, List<Map<String, Object>>> queryPolicyClassItem(Set<Long> policyIdSet) {
        if (CollectionUtils.isEmpty(policyIdSet)) {
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT FID,FENTRYID,FPRODUCTMODELID,FFOURTHCLASSID,FTHIRDCLASSID,FSECCLASSID,FFIRSTCLASSID ", new Object[0]);
        sb.append("FROM T_OCCPIC_RP_ITEMCLASS ", new Object[0]);
        sb.append("WHERE ", new Object[0]);
        sb.appendIn("FID", policyIdSet.toArray());
        return (Map)DB.query((DBRoute)RebateHelper.getDRPDBRoute(), (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<Map<Long, List<Map<String, Object>>>>(){

            public Map<Long, List<Map<String, Object>>> handle(ResultSet rs) throws Exception {
                HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(500);
                while (rs.next()) {
                    HashMap<String, Long> data = new HashMap<String, Long>(7);
                    data.put("fid", rs.getLong("FID"));
                    data.put("fentryid", rs.getLong("FENTRYID"));
                    data.put("fproductmodelid", rs.getLong("FPRODUCTMODELID"));
                    data.put("ffourthclassid", rs.getLong("FFOURTHCLASSID"));
                    data.put("fthirdclassid", rs.getLong("FTHIRDCLASSID"));
                    data.put("fsecclassid", rs.getLong("FSECCLASSID"));
                    data.put("ffirstclassid", rs.getLong("FFIRSTCLASSID"));
                    ArrayList rList = (ArrayList)result.get(rs.getLong("FID"));
                    if (rList == null) {
                        rList = new ArrayList(100);
                        rList.add(data);
                        result.put(rs.getLong("FID"), rList);
                        continue;
                    }
                    rList.add(data);
                }
                return result;
            }
        });
    }

    private static Map<Long, List<Map<String, Object>>> queryTargetClassItem(Set<Long> targetIdSet) {
        if (CollectionUtils.isEmpty(targetIdSet)) {
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT FID,FENTRYID,FPRODUCTMODELID,FFOURTHLEVELID,FTHIRDLEVELID,FSECLEVELID,FFIRSTLEVELID ", new Object[0]);
        sb.append("FROM T_OCCPIC_RBTGT_ITEMCLASS ", new Object[0]);
        sb.append("WHERE ", new Object[0]);
        sb.appendIn("FID", targetIdSet.toArray());
        return (Map)DB.query((DBRoute)RebateHelper.getDRPDBRoute(), (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<Map<Long, List<Map<String, Object>>>>(){

            public Map<Long, List<Map<String, Object>>> handle(ResultSet rs) throws Exception {
                HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(500);
                while (rs.next()) {
                    HashMap<String, Long> data = new HashMap<String, Long>(7);
                    data.put("fid", rs.getLong("FID"));
                    data.put("fentryid", rs.getLong("FENTRYID"));
                    data.put("fproductmodelid", rs.getLong("FPRODUCTMODELID"));
                    data.put("ffourthlevelid", rs.getLong("FFOURTHLEVELID"));
                    data.put("fthirdlevelid", rs.getLong("FTHIRDLEVELID"));
                    data.put("fseclevelid", rs.getLong("FSECLEVELID"));
                    data.put("ffirstlevelid", rs.getLong("FFIRSTLEVELID"));
                    ArrayList rList = (ArrayList)result.get(rs.getLong("FID"));
                    if (rList == null) {
                        rList = new ArrayList(100);
                        rList.add(data);
                        result.put(rs.getLong("FID"), rList);
                        continue;
                    }
                    rList.add(data);
                }
                return result;
            }
        });
    }

    private static Map<Long, Map<String, Object>> queryKpi(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT FID,FCALSCOPETYPE,FCALBILLTYPEID,FLADDERTYPEID,FREBATECLASSID,FTARGETCALTYPE ", new Object[0]);
        sb.append("FROM T_OCDBD_KPI ", new Object[0]);
        sb.append("WHERE ", new Object[0]);
        sb.appendIn("FID", ids.toArray());
        return (Map)DB.query((DBRoute)RebateHelper.getDRPDBRoute(), (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(100);
                while (rs.next()) {
                    HashMap<String, Object> data = new HashMap<String, Object>(6);
                    data.put("fid", rs.getLong("FID"));
                    data.put("fcalscopetype", rs.getString("FCALSCOPETYPE"));
                    data.put("fcalbilltypeid", rs.getLong("FCALBILLTYPEID"));
                    data.put("fladdertypeid", rs.getLong("FLADDERTYPEID"));
                    data.put("frebateclassid", rs.getLong("FREBATECLASSID"));
                    data.put("ftargetcaltype", rs.getString("FTARGETCALTYPE"));
                    result.put(rs.getLong("FID"), data);
                }
                return result;
            }
        });
    }

    private static Map<Long, Map<String, Object>> queryContParties(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT FID,FORGID,FREPRESENTATIVEORGID ", new Object[0]);
        sb.append("FROM T_OCDBD_CONTPARTIES ", new Object[0]);
        sb.append("WHERE ", new Object[0]);
        sb.appendIn("FID", ids.toArray());
        return (Map)DB.query((DBRoute)RebateHelper.getDRPDBRoute(), (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(50);
                while (rs.next()) {
                    HashMap<String, Long> data = new HashMap<String, Long>(3);
                    data.put("fid", rs.getLong("FID"));
                    data.put("forgid", rs.getLong("FORGID"));
                    data.put("frepresentativeorgid", rs.getLong("FREPRESENTATIVEORGID"));
                    result.put(rs.getLong("FID"), data);
                }
                return result;
            }
        });
    }

    private static Map<Long, Map<String, Object>> queryTargetForUpgrade() {
        StringBuilder sql = new StringBuilder(100);
        sql.append("SELECT T1.FID,T1.FSIGNPARTYID,T1.FKPIID,T1.FLADDERTYPEID,T1.FHIGHESTREBATE,T1.FBASELINEAMOUNT,T1.FBASELINEQTY,T2.FCUSTOMERID ");
        sql.append("FROM T_OCCPIC_REBATETARGET T1 ");
        sql.append("LEFT JOIN T_OCDBD_CHANNEL T2 ON T1.FBNFCHANNELID = T2.FID ");
        sql.append(" WHERE T1.FBIZORGID = 0 ");
        return (Map)DB.query((DBRoute)RebateHelper.getDRPDBRoute(), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(500);
                while (rs.next()) {
                    HashMap<String, Number> data = new HashMap<String, Number>(8);
                    data.put("fid", rs.getLong("FID"));
                    data.put("fsignpartyid", rs.getLong("FSIGNPARTYID"));
                    data.put("fkpiid", rs.getLong("FKPIID"));
                    data.put("fladdertypeid", rs.getLong("FLADDERTYPEID"));
                    data.put("fhighestrebate", rs.getBigDecimal("FHIGHESTREBATE"));
                    data.put("fbaselineamount", rs.getBigDecimal("FBASELINEAMOUNT"));
                    data.put("fbaselineqty", rs.getBigDecimal("FBASELINEQTY"));
                    data.put("fcustomerid", rs.getLong("FCUSTOMERID"));
                    result.put(rs.getLong("FID"), data);
                }
                return result;
            }
        });
    }

    private static Map<Long, Map<String, Object>> queryPolicyForUpgrade() {
        StringBuilder sql = new StringBuilder(100);
        sql.append("SELECT FID,FSIGNPARTYID,FKPIID,FLADDERTYPEID,FHIGHESTREBATE,FBASELINEAMOUNT,FBASELINEQTY ");
        sql.append("FROM T_OCCPIC_REBATEPOLICY ");
        sql.append(" WHERE FBIZORGID = 0 ");
        return (Map)DB.query((DBRoute)RebateHelper.getDRPDBRoute(), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(500);
                while (rs.next()) {
                    HashMap<String, Number> data = new HashMap<String, Number>(7);
                    data.put("fid", rs.getLong("FID"));
                    data.put("fsignpartyid", rs.getLong("FSIGNPARTYID"));
                    data.put("fkpiid", rs.getLong("FKPIID"));
                    data.put("fladdertypeid", rs.getLong("FLADDERTYPEID"));
                    data.put("fhighestrebate", rs.getBigDecimal("FHIGHESTREBATE"));
                    data.put("fbaselineamount", rs.getBigDecimal("FBASELINEAMOUNT"));
                    data.put("fbaselineqty", rs.getBigDecimal("FBASELINEQTY"));
                    result.put(rs.getLong("FID"), data);
                }
                return result;
            }
        });
    }

    public static final void showCustomPushTarget(IFormView formView, Object[] policyIdArray, String settperiod, Date startTime, Date endTime) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("occpic_custompushtarget");
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("policyidsformatestring", (Object)RebateHelper.formatePolicyIdArray(policyIdArray));
        parameter.setCustomParam("settperiod", (Object)settperiod);
        parameter.setCustomParam("starttime", (Object)DateUtil.getDateFormat((Date)startTime));
        parameter.setCustomParam("endtime", (Object)DateUtil.getDateFormat((Date)endTime));
        formView.showForm(parameter);
    }

    private static final String formatePolicyIdArray(Object[] policyIdArray) {
        return StringUtils.join((CharSequence)"#", (Object[])policyIdArray);
    }

    public static final Object[] parsePolicyIdArray(String policyIdsFormateString) {
        return Arrays.stream(policyIdsFormateString.split("#")).map(Long::valueOf).toArray();
    }

    public static final String formateCusomDateRange(String[] splitEffDateArray) {
        return String.join((CharSequence)"@", splitEffDateArray);
    }

    private static final String[] parseCusomDateRange(String cusomDateRange) {
        return cusomDateRange.split("@");
    }

    public static final String buildSettlePeriodCacheKey(String settlePeriod, Date startTime, Date endTime) {
        return String.join((CharSequence)"#", settlePeriod, RebateHelper.formatDate(startTime), RebateHelper.formatDate(endTime));
    }

    public static final Map<String, SettlePeriod> getSettlePeriodMap(DynamicObject target, Map<String, Map<String, SettlePeriod>> settlePeriodCache) {
        if (target != null) {
            String settlePeriod = target.getString("settleperiod");
            Date startDate = target.getDate("starttime");
            Date endDate = target.getDate("endtime");
            return RebateHelper.getSettlePeriodMap(settlePeriod, startDate, endDate, settlePeriodCache);
        }
        return new HashMap<String, SettlePeriod>(0);
    }

    public static final Map<String, SettlePeriod> getSettlePeriodMap(String settlePeriod, Date startTime, Date endTime, Map<String, Map<String, SettlePeriod>> settlePeriodCache) {
        Map<String, Object> settlePeriodMap = new HashMap<String, SettlePeriod>(0);
        if (StringUtils.isNotEmpty((String)settlePeriod) && startTime != null && endTime != null) {
            String settlePeriodCacheKey = RebateHelper.buildSettlePeriodCacheKey(settlePeriod, startTime, endTime);
            settlePeriodMap = settlePeriodCache != null ? settlePeriodCache.computeIfAbsent(settlePeriodCacheKey, r -> RebateHelper.calSettlePeriodMap(settlePeriod, startTime, endTime)) : RebateHelper.calSettlePeriodMap(settlePeriod, startTime, endTime);
        }
        return settlePeriodMap;
    }

    private static Map<String, SettlePeriod> calSettlePeriodMap(String settlePeriod, Date startTime, Date endTime) {
        LinkedHashMap<String, Object> settlePeriodMap = new LinkedHashMap<String, SettlePeriod>(0);
        if (StringUtils.isNotEmpty((String)settlePeriod) && startTime != null && endTime != null) {
            if (SETTLEPERIOD_WHOLE_LIFE.equals(settlePeriod)) {
                settlePeriodMap = new LinkedHashMap(1);
                RebateHelper.addSettlePeriodMap(settlePeriodMap, startTime, endTime, RebateHelper.buildSettlePeriodName(settlePeriod, startTime), 1);
            } else {
                int splitSize = RebateHelper.calSettlePeriodCount(settlePeriod, startTime, endTime);
                if (splitSize >= 0) {
                    settlePeriodMap = new LinkedHashMap(splitSize + 1);
                    for (int i = 0; i <= splitSize; ++i) {
                        Date splitTime = RebateHelper.calAddDateForSettlePeriod(settlePeriod, startTime, i);
                        Date splitStartTime = i == 0 ? startTime : RebateHelper.calFistDayForSettlePeriod(settlePeriod, splitTime);
                        Date splitEndTime = i == splitSize ? endTime : RebateHelper.calLastDayForSettlePeriod(settlePeriod, splitTime);
                        RebateHelper.addSettlePeriodMap(settlePeriodMap, splitStartTime, splitEndTime, RebateHelper.buildSettlePeriodName(settlePeriod, splitTime), i + 1);
                    }
                }
            }
        }
        return settlePeriodMap;
    }

    private static void addSettlePeriodMap(Map<String, SettlePeriod> settlePeriodMap, Date startTime, Date endTime, String name, int seq) {
        if (settlePeriodMap != null && startTime != null && endTime != null) {
            SettlePeriod settlePeriod = new SettlePeriod(DateUtil.getDayFirst((Date)startTime), DateUtil.getDayLast2((Date)endTime), name, seq);
            settlePeriodMap.put(settlePeriod.getFormatString(), settlePeriod);
        }
    }

    public static final Date calAddDateForSettlePeriod(String settlePeriod, Date date, int offset) {
        return RebateHelper.calDateForSettlePeriod(settlePeriod, date, 3, offset);
    }

    public static final Date calLastDayForSettlePeriod(String settlePeriod, Date date) {
        return RebateHelper.calDateForSettlePeriod(settlePeriod, date, 2, 0);
    }

    public static final Date calFistDayForSettlePeriod(String settlePeriod, Date date) {
        return RebateHelper.calDateForSettlePeriod(settlePeriod, date, 1, 0);
    }

    public static final Date calEndDayOfLastPeriod(String settlePeriod, Date date) {
        return RebateHelper.calDateForSettlePeriod(settlePeriod, date, 4, 0);
    }

    private static Date calDateForSettlePeriod(String settlePeriod, Date date, int settlePeriodCalType, int offset) {
        Date calDate = date;
        switch (settlePeriod) {
            case "A": {
                calDate = RebateHelper.calDateForYear(date, settlePeriodCalType, offset);
                break;
            }
            case "E": {
                calDate = RebateHelper.calDateForQuarter(date, settlePeriodCalType, offset);
                break;
            }
            case "B": {
                calDate = RebateHelper.calDateForMonth(date, settlePeriodCalType, offset);
                break;
            }
            case "C": {
                calDate = RebateHelper.calDateForWeek(date, settlePeriodCalType, offset);
            }
        }
        return calDate;
    }

    private static Date calDateForYear(Date date, int settlePeriodCalType, int offset) {
        Date calDate = date;
        switch (settlePeriodCalType) {
            case 1: {
                calDate = DateUtil.getFirstDayOfYear((Date)date);
                break;
            }
            case 2: {
                calDate = DateUtil.getLastDayOfYear((Date)date);
                break;
            }
            case 3: {
                calDate = DateUtil.yearAdd((Date)date, (int)offset);
                break;
            }
            case 4: {
                calDate = DateUtil.getLastDayOfLastYear((Date)date);
            }
        }
        return calDate;
    }

    private static Date calDateForQuarter(Date date, int settlePeriodCalType, int offset) {
        Date calDate = date;
        switch (settlePeriodCalType) {
            case 1: {
                calDate = DateUtil.getFirstDayOfQuarter((Date)date);
                break;
            }
            case 2: {
                calDate = DateUtil.getLastDayOfQuarter((Date)date);
                break;
            }
            case 3: {
                calDate = DateUtil.monthAdd((Date)date, (int)(offset * 3));
                break;
            }
            case 4: {
                calDate = DateUtil.getLastDayOfLastQuarter((Date)date);
            }
        }
        return calDate;
    }

    private static Date calDateForMonth(Date date, int settlePeriodCalType, int offset) {
        Date calDate = date;
        switch (settlePeriodCalType) {
            case 1: {
                calDate = DateUtil.getFirstDayOfMonth((Date)date);
                break;
            }
            case 2: {
                calDate = DateUtil.getLastDayOfMonth((Date)date);
                break;
            }
            case 3: {
                calDate = DateUtil.monthAdd((Date)date, (int)offset);
                break;
            }
            case 4: {
                calDate = DateUtil.getLastDayOfLastMonth((Date)date);
            }
        }
        return calDate;
    }

    private static Date calDateForWeek(Date date, int settlePeriodCalType, int offset) {
        Date calDate = date;
        switch (settlePeriodCalType) {
            case 1: {
                calDate = DateUtil.getFirstDayOfWeek((Date)date);
                break;
            }
            case 2: {
                calDate = DateUtil.getLastDayOfWeek((Date)date);
                break;
            }
            case 3: {
                calDate = DateUtil.dayAdd((Date)date, (int)(offset * 7));
                break;
            }
            case 4: {
                calDate = DateUtil.getLastDayOfLastWeek((Date)date);
            }
        }
        return calDate;
    }

    private static int calSettlePeriodCount(String settlePeriod, Date startTime, Date endTime) {
        int periodCount = -1;
        if (StringUtils.isNotEmpty((String)settlePeriod) && startTime != null && endTime != null && DateUtil.dayDiff((Date)startTime, (Date)endTime) <= 0) {
            switch (settlePeriod) {
                case "A": {
                    periodCount = DateUtil.yearDiff((Date)endTime, (Date)startTime);
                    break;
                }
                case "E": {
                    periodCount = DateUtil.quarterDiff((Date)endTime, (Date)startTime);
                    break;
                }
                case "B": {
                    periodCount = DateUtil.monthDiff((Date)endTime, (Date)startTime);
                    break;
                }
                case "C": {
                    periodCount = DateUtil.weekDiff((Date)endTime, (Date)startTime);
                    break;
                }
            }
        }
        return periodCount;
    }

    private static String buildSettlePeriodName(String settlePeriod, Date date) {
        String settlePeriodName = "";
        if (StringUtils.isNotEmpty((String)settlePeriod) && date != null) {
            switch (settlePeriod) {
                case "A": {
                    settlePeriodName = DateUtil.getDateFormat((Date)date, (String)ResManager.loadKDString((String)"yyyy\u5e74", (String)"RebateHelper_1", (String)"occ-occpic-business", (Object[])new Object[0]));
                    break;
                }
                case "E": {
                    settlePeriodName = DateUtil.getQuarterString((Date)date);
                    break;
                }
                case "B": {
                    settlePeriodName = DateUtil.getDateFormat((Date)date, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"RebateHelper_2", (String)"occ-occpic-business", (Object[])new Object[0]));
                    break;
                }
                case "C": {
                    settlePeriodName = DateUtil.getWeekString((Date)date);
                    break;
                }
                case "D": {
                    settlePeriodName = ResManager.loadKDString((String)"\u5168\u751f\u547d\u5468\u671f", (String)"RebateHelper_3", (String)"occ-occpic-business", (Object[])new Object[0]);
                }
            }
        }
        return settlePeriodName;
    }

    private static final Date getSplitStartTime(String splitEffDate) {
        return RebateHelper.getDayFirst(splitEffDate.split("#")[0]);
    }

    private static final Date getSplitEndTime(String splitEffDate) {
        return RebateHelper.getDayLast(splitEffDate.split("#")[1]);
    }

    private static final String formatSplitEffDateString(Date startTime, Date endTime) {
        return String.join((CharSequence)"#", RebateHelper.formatDate(startTime), RebateHelper.formatDate(endTime));
    }

    private static final String formatDate(Date date) {
        return DateUtil.getDateFormat((Date)date, (String)DATEFORMAT_PATTERN_YYYYMMDD);
    }

    private static final Date getDayFirst(String formatDateString) {
        Date date = DateUtil.formatDate((String)formatDateString, (String)DATEFORMAT_PATTERN_YYYYMMDD);
        return DateUtil.getDayFirst((Date)date);
    }

    private static final Date getDayLast(String formatDateString) {
        Date date = DateUtil.formatDate((String)formatDateString, (String)DATEFORMAT_PATTERN_YYYYMMDD);
        return DateUtil.getDayLast2((Date)date);
    }

    public static final void updateRebatePolicy(Object[] policyIdArray, String customDateRange) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("UPDATE T_OCCPIC_REBATEPOLICY SET FCUSTOMDATERANGE = ? WHERE ", new Object[]{customDateRange});
        sb.appendIn("FID", policyIdArray);
        DB.execute((DBRoute)RebateHelper.getDRPDBRoute(), (SqlBuilder)sb);
    }

    public static final List<SettlePeriod> getSplitSettlePeriodList(DynamicObject target, Date now, Map<String, Map<String, SettlePeriod>> settlePeriodCache) {
        List<Object> splitSettlePeriodList = new ArrayList<SettlePeriod>(0);
        if (target != null) {
            Date endDate;
            Date startDate;
            Map<String, SettlePeriod> settlePeriodMap;
            String settlePeriod = target.getString("settleperiod");
            String pushType = target.getString("pushtype");
            if (StringUtils.isNotEmpty((String)settlePeriod) && StringUtils.isNotEmpty((String)pushType) && !CollectionUtils.isEmpty(settlePeriodMap = RebateHelper.getSettlePeriodMap(settlePeriod, startDate = target.getDate("starttime"), endDate = target.getDate("endtime"), settlePeriodCache))) {
                switch (pushType) {
                    case "A": {
                        splitSettlePeriodList = settlePeriodMap.values().stream().collect(Collectors.toList());
                        break;
                    }
                    case "B": {
                        splitSettlePeriodList = RebateHelper.getSplitSettlePeriodList2AutoPush(target, now, settlePeriodMap);
                        break;
                    }
                    case "C": {
                        splitSettlePeriodList = RebateHelper.getSplitSettlePeriodList2CustomPush(target, settlePeriodMap);
                    }
                }
            }
        }
        return splitSettlePeriodList;
    }

    private static List<SettlePeriod> getSplitSettlePeriodList2AutoPush(DynamicObject target, Date now, Map<String, SettlePeriod> settlePeriodMap) {
        Date endDate;
        ArrayList<Object> splitSettlePeriodList = new ArrayList<SettlePeriod>(0);
        String settlePeriod = target.getString("settleperiod");
        Date startDate = target.getDate("starttime");
        String key = RebateHelper.formatSplitEffDateString(startDate, endDate = target.getDate("endtime"), now, settlePeriod);
        if (settlePeriodMap.containsKey(key)) {
            splitSettlePeriodList = new ArrayList(settlePeriodMap.size());
            for (Map.Entry<String, SettlePeriod> settlePeriodEntry : settlePeriodMap.entrySet()) {
                splitSettlePeriodList.add(settlePeriodEntry.getValue());
                if (!key.equals(settlePeriodEntry.getKey())) continue;
                break;
            }
        }
        return splitSettlePeriodList;
    }

    private static List<SettlePeriod> getSplitSettlePeriodList2CustomPush(DynamicObject target, Map<String, SettlePeriod> settlePeriodMap) {
        String[] splitEffDateArray;
        List<Object> splitSettlePeriodList = new ArrayList<SettlePeriod>(0);
        Date startDate = target.getDate("starttime");
        Date endDate = target.getDate("endtime");
        String cusomDateRange = target.getString("customdaterange");
        if (StringUtils.isNotEmpty((String)cusomDateRange) && (splitEffDateArray = RebateHelper.parseCusomDateRange(cusomDateRange)) != null && splitEffDateArray.length > 0) {
            splitSettlePeriodList = new ArrayList(splitEffDateArray.length);
            for (String splitEffDate : splitEffDateArray) {
                Date splitEndDate;
                Date splitStartDate = RebateHelper.getSplitStartTime(splitEffDate);
                SettlePeriod settlePeriod = settlePeriodMap.get(RebateHelper.formatSplitEffDateString(startDate, endDate, splitStartDate, splitEndDate = RebateHelper.getSplitEndTime(splitEffDate)));
                if (settlePeriod == null) continue;
                splitSettlePeriodList.add(settlePeriod);
            }
            if (!CollectionUtils.isEmpty(splitSettlePeriodList)) {
                splitSettlePeriodList = splitSettlePeriodList.stream().sorted(Comparator.comparing(SettlePeriod::getIndex)).collect(Collectors.toList());
            }
        }
        return splitSettlePeriodList;
    }

    private static String formatSplitEffDateString(Date startDate, Date endDate, Date now, String settlePeriod) {
        if (SETTLEPERIOD_WHOLE_LIFE.equals(settlePeriod)) {
            return RebateHelper.formatSplitEffDateString(startDate, endDate);
        }
        Date lastSettlePeriod = RebateHelper.calAddDateForSettlePeriod(settlePeriod, now, -1);
        Date splitStartDate = RebateHelper.calFistDayForSettlePeriod(settlePeriod, lastSettlePeriod);
        Date splitEndDate = RebateHelper.calLastDayForSettlePeriod(settlePeriod, lastSettlePeriod);
        return RebateHelper.formatSplitEffDateString(startDate, endDate, splitStartDate, splitEndDate);
    }

    private static String formatSplitEffDateString(Date startDate, Date endDate, Date splitStartDate, Date splitEndDate) {
        if (DateUtil.dayDiff((Date)splitStartDate, (Date)startDate) < 0) {
            splitStartDate = startDate;
        }
        if (DateUtil.dayDiff((Date)splitEndDate, (Date)endDate) > 0) {
            splitEndDate = endDate;
        }
        return RebateHelper.formatSplitEffDateString(splitStartDate, splitEndDate);
    }
}

