/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.business.task;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.helper.datafetchrule.DataFetchRuleHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.Convert;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;

public class RebateBaseTabTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        QFilter filter = new QFilter("datatype", "=", (Object)"B");
        filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        filter.and(new QFilter("convertruleid", "!=", (Object)" "));
        filter.and(new QFilter("createtype", "!=", (Object)"1"));
        DynamicObject[] ruleDynObjs = BusinessDataServiceHelper.load((String)"ocdbd_datafetchrule", (String)String.join((CharSequence)",", "createtype", "convertruleid", "id"), (QFilter[])filter.toArray());
        if (!CommonUtils.isNull((Object)ruleDynObjs)) {
            List<String> extRuleIdList = this.getExtRuleIdList();
            List<String> sysRuleIdList = Arrays.asList("1378232960813412352", "1388261372889974784");
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(ruleDynObjs.length);
            ArrayList<Long> dataFetchRuleIdList = new ArrayList<Long>(ruleDynObjs.length);
            for (DynamicObject ruleDynObj : ruleDynObjs) {
                String createType = ruleDynObj.getString("createtype");
                if (StringUtils.isNull((String)createType)) {
                    String ruleId = DynamicObjectUtils.getStrPkValue((DynamicObject)ruleDynObj, (String)"convertruleid");
                    if (sysRuleIdList.contains(ruleId)) {
                        if (extRuleIdList.contains(ruleId)) {
                            ruleDynObj.set("createtype", (Object)"2");
                        } else {
                            ruleDynObj.set("createtype", (Object)"1");
                        }
                    } else {
                        ruleDynObj.set("createtype", (Object)"2");
                    }
                    saveList.add(ruleDynObj);
                }
                dataFetchRuleIdList.add(ruleDynObj.getLong("id"));
            }
            if (!saveList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
            }
            this.batchSaveRebateBaseTabBill(dataFetchRuleIdList);
        }
        String msg = DataFetchRuleHelper.batchSaveRebateBaseTabBill();
        String deleteMsg = DataFetchRuleHelper.batchDeleteRebateBaseTabBill();
        if (StringUtils.isNotEmpty((String)(msg = msg + deleteMsg))) {
            throw new KDBizException(msg);
        }
    }

    private List<String> getExtRuleIdList() {
        String sql = "SELECT FMASTERID FROM T_BOTP_CONVERTRULE WHERE FMASTERID IN ('1378232960813412352','1388261372889974784') AND FPARENTID IN ('1378232960813412352','1388261372889974784')";
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> paths = new ArrayList<String>(16);
                while (rs.next()) {
                    paths.add(rs.getString("FMASTERID"));
                }
                return paths;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action);
    }

    private void batchSaveRebateBaseTabBill(List<Long> dataFetchRuleIdList) {
        if (CommonUtils.isNull(dataFetchRuleIdList)) {
            return;
        }
        StringBuilder sbStr = new StringBuilder();
        String msg = "\u8fd4\u5229\u6570\u636e\u5e95\u8868\u4fdd\u5b58\u5931\u8d25\uff1a{0}";
        for (Long dataFetchRuleId : dataFetchRuleIdList) {
            List targetBillObjs = DataFetchRuleHelper.getTargetBillDynObjColl((long)Convert.toLong((Object)dataFetchRuleId));
            if (CommonUtils.isNull((Object)targetBillObjs)) continue;
            ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(100000);
            OperateOption saveOption = CommonUtils.getOperateOption((boolean)false);
            for (DynamicObject billDynObj : targetBillObjs) {
                billList.add(billDynObj);
                if (billList.size() % 100000 != 0) continue;
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"occpibc_rebatebasetab", (DynamicObject[])billList.toArray(new DynamicObject[billList.size()]), (OperateOption)saveOption);
                if (!saveResult.isSuccess() && CommonUtils.isNull((Object)saveResult.getSuccessPkIds())) {
                    sbStr.append(MessageFormat.format(msg, CommonUtils.getErrDetail((OperationResult)saveResult)));
                }
                billList.clear();
            }
            if (CommonUtils.isNull(billList)) continue;
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"occpibc_rebatebasetab", (DynamicObject[])billList.toArray(new DynamicObject[billList.size()]), (OperateOption)saveOption);
            if (!saveResult.isSuccess() && CommonUtils.isNull((Object)saveResult.getSuccessPkIds())) {
                sbStr.append(MessageFormat.format(msg, CommonUtils.getErrDetail((OperationResult)saveResult)));
            }
            billList.clear();
        }
        if (!CommonUtils.isNull((Object)sbStr.toString())) {
            throw new KDBizException(sbStr.toString());
        }
    }
}

