/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;

public class RebatePreReportPlugin
extends OcbaseBasePlugin {
    private static final String BD_CURRENCY = "bd_currency";
    private static final String BD_MEASUREUNITS = "bd_measureunits";
    private Log logger = LogFactory.getLog(RebatePreReportPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        this.getView().showLoading(new LocaleString());
        String key = e.getOperateKey();
        if ("query".equals(key)) {
            QFilter rebatefilter = new QFilter("1", "=", (Object)"1");
            QFilter monthlyfilter = new QFilter("1", "=", (Object)"1");
            Object search_rpareadep = this.getF7PKValue("search_rpareadep");
            Object search_rprepresent = this.getF7PKValue("search_rprepresent");
            Object search_country = this.getF7PKValue("search_country");
            Object search_rebate = this.getF7PKValue("search_rebate");
            Object search_customer = this.getF7PKValue("search_customer");
            String billno = (String)this.getModel().getValue("search_billno");
            Date monthlydate = (Date)this.getModel().getValue("monthlydate");
            if (search_rpareadep != null) {
                if (monthlydate == null) {
                    rebatefilter.and("rpareadep", "=", search_rpareadep);
                    monthlyfilter.and("entryentity.rpareadep", "=", search_rpareadep);
                } else {
                    monthlyfilter.and("entryentity.rpareadep", "=", search_rpareadep);
                }
            }
            if (search_rprepresent != null) {
                if (monthlydate == null) {
                    rebatefilter.and("rprepresentoffice", "=", search_rprepresent);
                    monthlyfilter.and("entryentity.rprepresentoffice", "=", search_rprepresent);
                } else {
                    monthlyfilter.and("entryentity.rprepresentoffice", "=", search_rprepresent);
                }
            }
            if (search_country != null) {
                if (monthlydate == null) {
                    rebatefilter.and("rparea", "=", search_country);
                    monthlyfilter.and("entryentity.rparea", "=", search_country);
                } else {
                    monthlyfilter.and("entryentity.rparea", "=", search_country);
                }
            }
            if (search_rebate != null) {
                if (monthlydate == null) {
                    rebatefilter.and("rebatepolicy", "=", search_rebate);
                    monthlyfilter.and("entryentity.repolicytarget", "=", search_rebate);
                } else {
                    monthlyfilter.and("entryentity.repolicytarget", "=", search_rebate);
                }
            }
            if (search_customer != null) {
                if (monthlydate == null) {
                    rebatefilter.and("customer", "=", search_customer);
                    monthlyfilter.and("entryentity.customer", "=", search_customer);
                } else {
                    monthlyfilter.and("entryentity.customer", "=", search_customer);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)billno)) {
                rebatefilter.and("billno", "=", (Object)billno);
                monthlyfilter.and("entryentity.billno", "=", (Object)billno);
            }
            DynamicObject entry = null;
            Row row = null;
            QFilter[] currfilter = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
            Map currMap = BusinessDataServiceHelper.loadFromCache((String)BD_CURRENCY, (QFilter[])currfilter);
            QFilter[] unitfilter = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
            Map unitMap = BusinessDataServiceHelper.loadFromCache((String)BD_MEASUREUNITS, (QFilter[])unitfilter);
            Map<Long, Long> fidMap = RebatePreReportPlugin.getRebatestatementMap();
            QFilter[] rabatefilter = new QFilter[]{};
            Map rebateMap = BusinessDataServiceHelper.loadFromCache((String)"occpic_rebatestatement", (String)"paytype", (QFilter[])rabatefilter);
            QFilter[] beforerabatefilter = new QFilter[]{};
            Map beforerebateMap = BusinessDataServiceHelper.loadFromCache((String)"occpic_rebateprebudget", (String)"hihn_usdexrate", (QFilter[])beforerabatefilter);
            HashMap<Long, DynamicObject> ratioMap = new HashMap<Long, DynamicObject>();
            for (Map.Entry<Long, Long> entryMap : fidMap.entrySet()) {
                Long fid = entryMap.getKey();
                Long settleId = entryMap.getValue();
                for (Map.Entry entryRebate : rebateMap.entrySet()) {
                    Object rebateid = entryRebate.getKey();
                    if (!settleId.equals((Long)rebateid)) continue;
                    DynamicObject entity = (DynamicObject)entryRebate.getValue();
                    if (ratioMap.containsKey(fid)) continue;
                    ratioMap.put(fid, entity);
                }
            }
            Map<String, Set<Object>> regionIds = this.getRegionIdsByUser();
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryEntity.clear();
            String sign = "monthly";
            Map<String, Object> monthlyMap = this.getMonthlyDataSet(monthlydate, monthlyfilter);
            DataSet dataSet = (DataSet)monthlyMap.get("dataSet");
            DynamicObject monthlyentity = (DynamicObject)monthlyMap.get("monthlyentity");
            while (dataSet != null && dataSet.hasNext()) {
                row = dataSet.next();
                entry = entryEntity.addNew();
                entry.set("monthlyperiod", row.get("monthlydate"));
                entry.set("paytype", row.get("paytype"));
                this.setAdjustData(entry, row);
                this.setEntryProperty(entryEntity, entry, row, currMap, unitMap, beforerebateMap, regionIds, sign, monthlyentity);
            }
            if (monthlydate == null) {
                DataSet rebateSet = this.getDataSet(rebatefilter);
                while (rebateSet != null && rebateSet.hasNext()) {
                    row = rebateSet.next();
                    entry = entryEntity.addNew();
                    DynamicObject rebatestatement = (DynamicObject)ratioMap.get(row.get("id"));
                    if (rebatestatement != null) {
                        entry.set("paytype", (Object)rebatestatement.getString("paytype"));
                    }
                    sign = "rebate";
                    this.setEntryProperty(entryEntity, entry, row, currMap, unitMap, beforerebateMap, regionIds, sign, monthlyentity);
                }
            }
            this.getView().updateView("entryentity");
        }
        this.getView().hideLoading();
        super.afterDoOperation(e);
    }

    protected Map<String, Set<Object>> getRegionIdsByUser() {
        return new HashMap<String, Set<Object>>(0);
    }

    public void setEntryProperty(DynamicObjectCollection entryEntity, DynamicObject entry, Row row, Map<Object, DynamicObject> currMap, Map<Object, DynamicObject> unitMap, Map<Object, DynamicObject> beforerebateMap, Map<String, Set<Object>> regionIds, String sign, DynamicObject monthlyentity) {
        try {
            entry.set("billno", (Object)row.getString("billno"));
            entry.set("billname", (Object)row.getString("billname"));
            entry.set("rpaname", (Object)row.getString("rpaname"));
            entry.set("rpanamecode", (Object)row.getString("rpanamecode"));
            entry.set("offname", (Object)row.getString("offname"));
            entry.set("offnamecode", (Object)row.getString("offnamecode"));
            entry.set("arename", (Object)row.getString("arename"));
            entry.set("arenamecode", (Object)row.getString("arenamecode"));
            entry.set("businessorg", (Object)row.getString("businessorg"));
            entry.set("policynumber", (Object)row.getString("policynumber"));
            entry.set("policy", (Object)row.getString("policy"));
            entry.set("dircustomername", (Object)row.getString("dircustomername"));
            entry.set("dircustomerid", (Object)row.getString("dircustomerid"));
            entry.set("channelid", (Object)row.getString("channelid"));
            entry.set("secondgroupname", (Object)row.getString("secondgroupname"));
            entry.set("rpconname", (Object)row.getString("rpconname"));
            entry.set("rpconnumber", (Object)row.getString("rpconnumber"));
            entry.set("formulaname", (Object)row.getString("formulaname"));
            entry.set("rpincentivetype", (Object)row.getString("rpincentivetype"));
            entry.set("rpincentivesubtyp", (Object)row.getString("rpincentivesubtyp"));
            entry.set("rpbudgetcycle", (Object)row.getString("rpbudgetcycle"));
            entry.set("rpdestcaculatetype", (Object)row.getString("rpdestcaculatetype"));
            entry.set("rpbegindate", (Object)row.getDate("rpbegindate"));
            entry.set("rpenddate", (Object)row.getDate("rpenddate"));
            entry.set("laddertype", (Object)row.getString("laddertype"));
            entry.set("saleorderqty", (Object)row.getString("saleorderqty"));
            entry.set("brand", (Object)"Honor");
            entry.set("productclass4", (Object)row.getString("productclass4"));
            entry.set("productclass3", (Object)row.getString("productclass3"));
            entry.set("productclass2", (Object)row.getString("productclass2"));
            entry.set("productclass1", (Object)row.getString("productclass1"));
            entry.set("productcode", (Object)row.getString("productcode"));
            entry.set("entproductmodel", (Object)row.getString("entproductmodel"));
            entry.set("rpprecurrency", (Object)currMap.get(row.get("rpprecurrency")));
            entry.set("entconsignqty", (Object)row.getBigDecimal("entconsignqty"));
            entry.set("effectamount", (Object)row.getBigDecimal("effectamount"));
            entry.set("actualunitrebate", (Object)row.getBigDecimal("actualunitrebate"));
            entry.set("hasbudgetqty", (Object)row.getString("hasbudgetqty"));
            entry.set("hasbudgetamount", (Object)row.getBigDecimal("hasbudgetamount"));
            entry.set("isbudgetfinishend", (Object)row.getString("isbudgetfinishend"));
            entry.set("unitid", (Object)unitMap.get(row.get("unitid")));
            if (((Boolean)row.get("istax")).booleanValue()) {
                entry.set("istax", (Object)"Y");
            } else {
                entry.set("istax", (Object)"N");
            }
            if (((Boolean)row.get("isbudgetfinishend")).booleanValue()) {
                entry.set("isbudgetfinishend", (Object)"Y");
            } else {
                entry.set("isbudgetfinishend", (Object)"N");
            }
            BigDecimal profitrate = row.getBigDecimal("profitrate").setScale(2, 0);
            entry.set("profitrate", (Object)(profitrate.toString() + "%"));
            BigDecimal adjustendamount = row.getBigDecimal("effectamount");
            BigDecimal entconsignqty = row.getBigDecimal("entconsignqty");
            if (entconsignqty.compareTo(new BigDecimal(0)) > 0) {
                BigDecimal perunamount = adjustendamount.divide(entconsignqty, 2, 0);
                entry.set("perunamount", (Object)perunamount);
            }
            BigDecimal entrebateamount = adjustendamount.subtract(row.getBigDecimal("hasbudgetamount"));
            entry.set("entrebateamount", (Object)entrebateamount);
            String rate = "0";
            String rparea = row.getString("arenamecode");
            if ("CN".equals(rparea)) {
                rate = "0.13";
                entry.set("taxrate", (Object)"13%");
            } else {
                entry.set("taxrate", (Object)"0%");
            }
            BigDecimal rateall = new BigDecimal(rate).add(new BigDecimal(1));
            entry.set("prosaleamountistax", (Object)entrebateamount.divide(rateall, 2, 0));
            if ("rebate".equals(sign)) {
                entry.set("adjustendamount", (Object)adjustendamount);
                BigDecimal hasbudgetamount = row.getBigDecimal("hasbudgetamount");
                entry.set("adjustendsettleamount", (Object)hasbudgetamount);
                BigDecimal adjustrebateamount = adjustendamount.subtract(hasbudgetamount);
                entry.set("adjustrebateamount", (Object)adjustrebateamount);
                entry.set("adjustrebateamountnotax", (Object)adjustrebateamount.divide(rateall, 2, 0));
            } else {
                entry.set("adjustendamount", (Object)row.getBigDecimal("adjustendamount"));
                entry.set("adjustendsettleamount", (Object)row.getBigDecimal("adjustendsettleamount"));
                entry.set("adjustrebateamount", (Object)row.getBigDecimal("adjustrebateamount"));
                entry.set("adjustrebateamountnotax", (Object)row.getBigDecimal("adjustrebateamountnotax"));
            }
        }
        catch (Exception e) {
            this.logger.info("\u8fd4\u5229\u9884\u63d0\u62a5\u8868\u5355\u636e\u4f53\u8d4b\u503c\u62a5\u9519:", (Object)e);
        }
    }

    private static Map<Long, Long> getRebatestatementMap() {
        StringBuilder sql = new StringBuilder();
        sql.append("select FTBILLID,FSBILLID from t_occpic_rebatestatement_tc");
        return (Map)DB.query((DBRoute)DBRoute.of((String)"drp"), (String)sql.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Map<Long, Long>>(){

            public Map<Long, Long> handle(ResultSet rs) throws Exception {
                HashMap<Long, Long> resultMap = new HashMap<Long, Long>(rs.getFetchSize());
                while (rs.next()) {
                    resultMap.put(rs.getLong("FSBILLID"), rs.getLong("FTBILLID"));
                }
                return resultMap;
            }
        });
    }

    private DataSet getDataSet(QFilter filter) {
        ORM orm = ORM.create();
        DataSet standardset = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "occpic_rebateprebudget", "rpareadep rpareadepid,rprepresentoffice officeid,id,billno,name billname,rpareadep.name rpaname,rpareadep.number rpanamecode,rprepresentoffice.name offname,rprepresentoffice.number offnamecode,rparea.name arename,rparea.number arenamecode,businessorg.number businessorg,rebatepolicy.number policynumber,rebatepolicy.name policy,channel.number channelid,customer.name dircustomername,customer.number dircustomerid,rpcontractsubject.number rpconnumber,rpcontractsubject.name rpconname,rpchannelsecondgroup.name secondgroupname,rppdestformula.rebateformula formulaname,rpincentivetype,rpbudgetcycle,rpincentivesubtyp,rpdestcaculatetype,rpbegindate,rpenddate,laddertype.name laddertype,entryentity.framecontractnumber saleorderqty,entryentity.product.group.parent.name productclass4,entryentity.product.group.parent.parent.name productclass3,entryentity.product.group.parent.parent.parent.name productclass2,entryentity.product.group.parent.parent.parent.parent.name productclass1,entryentity.product.product_code productcode,entryentity.product.name entproductmodel,rpprecurrency rpprecurrency,entryentity.profitrate profitrate,entryentity.proconsignqty entconsignqty,entryentity.hasbudgetqty enthasbudgetqty,entryentity.rebateamount effectamount,entryentity.actualunitrebate actualunitrebate,entryentity.hasbudgetqty hasbudgetqty,entryentity.hasbudgetamount hasbudgetamount,isbudgetfinish isbudgetfinishend,entryentity.istax istax,entryentity.id entryentityid,entryentity.unitid unitid", new QFilter[]{filter}, "createtime desc");
        return standardset;
    }

    private Map<String, Object> getMonthlyDataSet(Date monthlydate, QFilter filter) {
        HashMap<String, Object> monthlyMap = new HashMap<String, Object>();
        if (monthlydate != null) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(monthlydate);
            int year = ca.get(1);
            int month = ca.get(2);
            Date debateDate = DateUtil.getDateFormat((String)DateUtil.getFirstDayOfMonth1((int)year, (int)month));
            String name = DateUtil.getDateFormat((Date)debateDate, (String)"yyyy-MM");
            filter.and("monthlydate", "=", (Object)name);
        }
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObject[] rebatepreList = BusinessDataServiceHelper.load((String)"occpic_rebatemonthly", (String)"id", (QFilter[])filter.toArray());
        if (rebatepreList.length > 0) {
            DynamicObject monthlyentity = BusinessDataServiceHelper.loadSingle((Object)rebatepreList[0].getPkValue(), (String)"occpic_rebatemonthly");
            monthlyMap.put("monthlyentity", monthlyentity);
        }
        ORM orm = ORM.create();
        DataSet standardset = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "occpic_rebatemonthly", "entryentity.rpareadep.id rpareadepid,entryentity.rprepresentoffice.id officeid,monthlydate,entryentity.billno billno,entryentity.billname billname,entryentity.rpareadep.name rpaname,entryentity.rpareadep.number rpanamecode,entryentity.rprepresentoffice.name offname,entryentity.rprepresentoffice.number offnamecode,entryentity.rparea.name arename,entryentity.rparea.number arenamecode,entryentity.businessorg.number businessorg,entryentity.repolicytarget.number policynumber,entryentity.repolicytarget.name policy,entryentity.channel.number channelid,entryentity.customer.name dircustomername,entryentity.customer.number dircustomerid,entryentity.channelsecondgroup.name secondgroupname,entryentity.rpcontractsubject.name rpconname,entryentity.rpcontractsubject.number rpconnumber,entryentity.rppdestformula formulaname,entryentity.rpincentivetype rpincentivetype,entryentity.rpbudgetcycle rpbudgetcycle,entryentity.rpincentivesubtyp rpincentivesubtyp,entryentity.rpdestcaculatetype rpdestcaculatetype,entryentity.rpbegindate rpbegindate,entryentity.rpenddate rpenddate,entryentity.laddertype.name laddertype,entryentity.saleorderqty saleorderqty,entryentity.rpprecurrency rpprecurrency,entryentity.firstproductclass.name productclass1,entryentity.secondproductclass.name productclass2,entryentity.thirdproductclass.name productclass3,entryentity.fourproductclass.name productclass4,entryentity.productcode productcode,entryentity.productmodel.name entproductmodel,entryentity.profitrate profitrate,entryentity.perunitrebateamount perunamount,entryentity.consignqtynumer entconsignqty,entryentity.rebateamount effectamount,entryentity.settleamount actualunitrebate,entryentity.hassettlenumber hasbudgetqty,entryentity.hasbudgetamount hasbudgetamount,entryentity.unitid unitid,entryentity.prosaleamount entrebateamount,entryentity.prosaleamountistax prosaleamountistax,entryentity.effectadjustamount effectadjustamount,entryentity.settleadjustamount settleadjustamount,entryentity.adjustendamount adjustendamount,entryentity.adjustendsettleamount adjustendsettleamount,entryentity.adjustrebateamount adjustrebateamount,entryentity.adjustrrnotaxamount adjustrebateamountnotax,entryentity.isbudgetfinish isbudgetfinishend,entryentity.istax istax,entryentity.taxrate taxrate,entryentity.paytype paytype,entryentity.id monthlyentityid", new QFilter[]{filter}, "createtime desc");
        monthlyMap.put("dataSet", standardset);
        return monthlyMap;
    }

    public void setAdjustData(DynamicObject entry, Row row) {
        entry.set("effectadjustamount", (Object)row.getBigDecimal("effectadjustamount"));
        entry.set("settleadjustamount", (Object)row.getBigDecimal("settleadjustamount"));
        entry.set("adjustendamount", (Object)row.getBigDecimal("adjustendamount"));
        entry.set("adjustendsettleamount", (Object)row.getBigDecimal("adjustendsettleamount"));
        entry.set("adjustrebateamount", (Object)row.getBigDecimal("adjustrebateamount"));
        entry.set("adjustrebateamountnotax", (Object)row.getBigDecimal("adjustrebateamountnotax"));
    }
}

