/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.mservice;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.occpic.common.enums.RecordUpdateTypeEnum;
import kd.occ.occpic.mservice.api.RebateFlowRecord;

public class RebateFlowRecordImpl
implements RebateFlowRecord {
    private static Log logger = LogFactory.getLog(RebateFlowRecordImpl.class);

    public void updateRebateFlowRecord(AccountRecord accountRecord, long accountId, RecordUpdateTypeEnum updateType) {
        if (accountRecord == null) {
            logger.info("\u8fd4\u5229\u6d41\u6c34\u4fe1\u606f\u6709\u8bef\u3002");
            return;
        }
        DynamicObject rebateRecord = BusinessDataServiceHelper.newDynamicObject((String)"occpic_flowrecord");
        rebateRecord.set("billtype", (Object)updateType.getValue());
        rebateRecord.set("customer_id", (Object)accountRecord.getCustomerId());
        rebateRecord.set("country_id", (Object)accountRecord.getCountryId());
        rebateRecord.set("areadept_id", (Object)accountRecord.getAreaDeptId());
        rebateRecord.set("office_id", (Object)accountRecord.getOfficeId());
        rebateRecord.set("channel_id", (Object)accountRecord.getChannelId());
        rebateRecord.set("sourcebillid", (Object)accountRecord.getSourceBillNo());
        rebateRecord.set("sourcebillid", (Object)accountRecord.getSourceBillId());
        rebateRecord.set("org_id", (Object)accountRecord.getOrgId());
        rebateRecord.set("stmcurrency_id", (Object)accountRecord.getCurrencyId());
        rebateRecord.set("accout_id", (Object)accountRecord.getAccountType());
        rebateRecord.set("transaction", (Object)updateType.getValue());
        BigDecimal accountAmount = this.getAccountAmountById(accountId);
    }

    public BigDecimal getAccountAmountById(long accountId) {
        DynamicObject account = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"ocdbd_rebateaccount");
        if (account != null) {
            return account.getBigDecimal("balance");
        }
        return BigDecimal.ZERO;
    }
}

