/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.business.algorithm;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.occ.ocbase.business.algorithm.AbstractBillAlgorithm;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.constants.BigDecimalConstants;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.item.ConversionDirection;

public abstract class SaleOrderAlgorithm
extends AbstractBillAlgorithm {
    private int amountPrecision = 2;
    private int curAmountPrecision = 2;
    private int pricePrecision = 10;

    public void initPrecision() {
        DynamicObject curCurrency;
        DynamicObject currency = (DynamicObject)this.getValue("settlecurrencyid");
        if (currency != null) {
            this.amountPrecision = currency.getInt("amtprecision");
            this.pricePrecision = currency.getInt("priceprecision");
        }
        if ((curCurrency = (DynamicObject)this.getValue("basecurrencyid")) != null) {
            this.curAmountPrecision = curCurrency.getInt("amtprecision");
        }
    }

    public boolean calByChange(String key) {
        boolean hasCal = true;
        switch (key) {
            case "basecurrencyid": {
                this.calByExchangeRate();
                break;
            }
            case "exchangerate": {
                this.calByExchangeRate();
                break;
            }
            case "settlecurrencyid": {
                this.calBySettleCurrency();
                break;
            }
            default: {
                hasCal = false;
            }
        }
        return hasCal;
    }

    public void calByExchangeRate() {
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            this.calEntryCurFileds(i);
        }
    }

    public void calBySettleCurrency() {
        int size = this.getEntrySize();
        if (this.hasTax()) {
            for (int i = 0; i < size; ++i) {
                this.calAmountAndTaxByCur(i);
                this.calTaxAmount(i);
                this.calCurTaxAmount(i);
                this.calAmount(i);
                this.calCurAmount(i);
                this.calTaxPriceByAmountAndTax(i);
                this.calPrice(i);
                this.calDiscountAmount(i);
                this.calActualPrice(i);
                this.calActualTaxPrice(i);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.calAmountByCur(i);
                this.calTaxAmount(i);
                this.calCurTaxAmount(i);
                this.calAmountAndTax(i);
                this.calCurAmountAndTax(i);
                this.calPriceByAmount(i);
                this.calPriceAndTax(i);
                this.calDiscountAmount(i);
                this.calActualPrice(i);
                this.calActualTaxPrice(i);
            }
        }
    }

    public boolean calByEntryChange(String key, int i) {
        boolean hasCal = true;
        switch (key) {
            case "qty": {
                this.calByQty(i);
                break;
            }
            case "unit": {
                this.calByQty(i);
                break;
            }
            case "price": {
                this.calByPrice(i);
                break;
            }
            case "taxrate": {
                this.calByTaxRate(i);
                break;
            }
            case "taxprice": {
                this.calByPriceAndTax(i);
                break;
            }
            case "pricediscount": 
            case "recdiscount": 
            case "promotiondiscount": {
                this.calByPriceDiscount(i);
                break;
            }
            default: {
                hasCal = false;
            }
        }
        return hasCal;
    }

    public void calByQty(int i) {
        if (this.hasTax()) {
            this.calPrice(i);
        } else {
            this.calPriceAndTax(i);
        }
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calTotalFields();
    }

    public void calByPrice(int i) {
        this.calPriceAndTax(i);
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calTotalFields();
    }

    public void calByTaxRate(int i) {
        if (this.hasTax()) {
            this.calByPriceAndTax(i);
        } else {
            this.calByPrice(i);
        }
    }

    public void calByPriceAndTax(int i) {
        this.calPrice(i);
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calTotalFields();
    }

    public void calByPriceDiscount(int i) {
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calTotalFields();
    }

    public void calTotalFields() {
        this.calTotalItemAmount();
        this.setValue("sumdiscountamount", this.sumEntryPriceDiscount().add(this.sumEntryFiled("promotiondiscount")));
        this.setValue("sumreceivableamount", this.getNullToZero("sumitemamount").subtract(this.getNullToZero("sumdiscountamount")));
        this.setValue("sumrecamount", this.sumRecEntryUsedAmount());
        this.setValue("sumunrecamount", this.getNullToZero("sumreceivableamount").subtract(this.getNullToZero("sumrecamount")));
    }

    public void calEntryCurFileds(int i) {
        if (this.hasTax()) {
            this.calCurAmountAndTax(i);
            this.calCurTaxAmount(i);
            this.calCurAmount(i);
        } else {
            this.calCurAmount(i);
            this.calCurTaxAmount(i);
            this.calCurAmountAndTax(i);
        }
    }

    public void calEntryAmountFileds(int i) {
        if (this.hasTax()) {
            this.calAmountAndTax(i);
            this.calTaxAmount(i);
            this.calAmount(i);
        } else {
            this.calAmount(i);
            this.calTaxAmount(i);
            this.calAmountAndTax(i);
        }
    }

    private void calTotalItemAmount() {
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal itemAmount = BigDecimal.ZERO;
        DynamicObjectCollection entrys = this.getEntryDynColl();
        BigDecimal totalValue = BigDecimal.ZERO;
        int rowIndex = 0;
        for (DynamicObject entryDynObj : entrys) {
            if (this.isEntryAavailable(entryDynObj) && !this.isCombEntry(entryDynObj)) {
                qty = this.getNullToZero("qty", rowIndex);
                taxPrice = this.getNullToZero("taxprice", rowIndex);
                itemAmount = qty.multiply(taxPrice).setScale(this.amountPrecision, 4);
                totalValue = totalValue.add(itemAmount);
            }
            ++rowIndex;
        }
        this.setValue("sumitemamount", totalValue);
    }

    private boolean isCombEntry(DynamicObject entryDynObj) {
        DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
        return itemDynObj != null && GoodsTypeEnum.COMBINEGOODS.getValue().equals(itemDynObj.getString(String.join((CharSequence)"_", "itemtypeid", "id")));
    }

    private boolean isEntryAavailable(DynamicObject entry) {
        return entry.get("itemid") != null && entry.get("unit") != null;
    }

    private BigDecimal sumEntryFiled(String key) {
        DynamicObjectCollection entrys = this.getEntryDynColl();
        BigDecimal totleValue = BigDecimal.ZERO;
        int rowIndex = 0;
        for (DynamicObject entryDynObj : entrys) {
            if (this.isEntryAavailable(entryDynObj) && !this.isCombEntry(entryDynObj)) {
                BigDecimal value = this.getNullToZero(key, rowIndex);
                totleValue = totleValue.add(value);
            }
            ++rowIndex;
        }
        return totleValue;
    }

    private BigDecimal sumEntryPriceDiscount() {
        DynamicObjectCollection entrys = this.getEntryDynColl();
        BigDecimal totleValue = BigDecimal.ZERO;
        int rowIndex = 0;
        BigDecimal priceDiscount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal sumPriceDiscount = BigDecimal.ZERO;
        for (DynamicObject entryDynObj : entrys) {
            if (this.isEntryAavailable(entryDynObj) && !this.isCombEntry(entryDynObj)) {
                priceDiscount = this.getNullToZero("pricediscount", rowIndex);
                qty = this.getNullToZero("qty", rowIndex);
                sumPriceDiscount = priceDiscount.multiply(qty).setScale(this.amountPrecision, 4);
                totleValue = totleValue.add(sumPriceDiscount);
            }
            ++rowIndex;
        }
        return totleValue;
    }

    public BigDecimal sumRecEntryUsedAmount() {
        DynamicObjectCollection recEntryColl = this.getRecEntryDynColl();
        BigDecimal sumUsedAmount = BigDecimal.valueOf(recEntryColl.stream().filter(obj -> obj.getDynamicObject("receiptoffset") != null && !"3".equals(obj.getDynamicObject("receiptoffset").getString("type"))).mapToDouble(obj -> Double.parseDouble(obj.getBigDecimal("usedamount").toString())).sum());
        BigDecimal manualUsedAmount = BigDecimal.valueOf(recEntryColl.stream().filter(obj -> obj.getDynamicObject("receiptoffset") != null && "3".equals(obj.getDynamicObject("receiptoffset").getString("type"))).mapToDouble(obj -> Double.parseDouble(obj.getBigDecimal("usedamount").toString())).sum()).negate();
        sumUsedAmount = sumUsedAmount.add(manualUsedAmount);
        return sumUsedAmount;
    }

    private void calPrice(int i) {
        BigDecimal taxPrice = this.getNullToZero("taxprice", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal price = BigDecimalConstants.ZERO;
        if (taxPrice != null) {
            BigDecimal zero = BigDecimalConstants.ZERO;
            BigDecimal one = BigDecimalConstants.ONE;
            BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
            taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
            price = taxPrice.divide(one.add(taxRate), this.pricePrecision, 4);
        }
        this.setValue("price", price, i);
    }

    private void calPriceAndTax(int i) {
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal taxPrice = BigDecimalConstants.ZERO;
        BigDecimal one = BigDecimalConstants.ONE;
        BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
        taxRate = taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
        taxPrice = price.multiply(one.add(taxRate));
        taxPrice = taxPrice.setScale(this.pricePrecision, 4);
        this.setValue("taxprice", taxPrice, i);
    }

    private void calDiscountAmount(int i) {
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal discountRate = this.getNullToZero("pricediscount", i);
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (this.hasTax()) {
            discountAmount = qty.multiply(discountRate).setScale(this.amountPrecision, 4);
        } else {
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
            discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate)).setScale(this.amountPrecision, 4);
        }
        BigDecimal sumDiscount = this.getNullToZero("promotiondiscount", i).add(this.getNullToZero("recdiscount", i));
        discountAmount = discountAmount.add(sumDiscount);
        this.setValue("discountamount", discountAmount, i);
        this.setValue("unitdiscount", discountRate.add(qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumDiscount.divide(qty, this.amountPrecision, 4)), i);
    }

    private void calActualPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal price = this.getNullToZero("price", i);
            this.setValue("actualprice", price, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amount) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue("actualprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal price = amount.divide(qty, this.pricePrecision, 4);
                this.setValue("actualprice", price, i);
            }
        }
    }

    private void calActualTaxPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = this.getNullToZero("taxprice", i);
            this.setValue("actualtaxprice", taxPrice, i);
        } else {
            BigDecimal amountAndTax = this.getNullToZero("taxamount", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amountAndTax) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue("actualtaxprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal taxPrice = amountAndTax.divide(qty, this.pricePrecision, 4);
                this.setValue("actualtaxprice", taxPrice, i);
            }
        }
    }

    private void calPriceByAmount(int i) {
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal qty = this.getNullToZero("qty", i);
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal amount = this.getNullToZero("amount", i);
        BigDecimal discount = this.getNullToZero("pricediscount", i);
        if (amount.compareTo(BigDecimal.ZERO) != 0) {
            price = amount.divide(qty, this.pricePrecision, 4).add(discount);
        }
        this.setValue("price", price, i);
    }

    private void calTaxPriceByAmountAndTax(int i) {
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal qty = this.getNullToZero("qty", i);
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal itemAmount = this.getNullToZero("taxamount", i);
        BigDecimal discount = this.getNullToZero("pricediscount", i);
        if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
            taxPrice = itemAmount.divide(qty, this.pricePrecision, 4).add(discount);
        }
        this.setValue("taxprice", taxPrice, i);
    }

    private void calAmountAndTax(int i) {
        if (this.hasTax()) {
            BigDecimal priceAndTax = this.getNullToZero("taxprice", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal discountAmount = this.getNullToZero("discountamount", i);
            BigDecimal taxAmount = qty.multiply(priceAndTax).setScale(this.amountPrecision, 4);
            BigDecimal discountTaxAmount = taxAmount.subtract(discountAmount);
            this.setTaxAmountErrorTip(taxAmount);
            this.setValue("taxamount", discountTaxAmount, i);
            this.setValue("beforetaxamount", taxAmount, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal tax = this.getNullToZero("tax", i);
            BigDecimal taxAmount = amount.add(tax);
            this.setTaxAmountErrorTip(taxAmount);
            this.setValue("taxamount", taxAmount, i);
            BigDecimal price = this.getNullToZero("price", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
            BigDecimal taxPrice = price.multiply(BigDecimalConstants.ONE.add(taxRate));
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal beforeTaxAmount = qty.multiply(taxPrice).setScale(this.amountPrecision, 4);
            this.setTaxAmountErrorTip(beforeTaxAmount);
            this.setValue("beforetaxamount", beforeTaxAmount, i);
        }
    }

    private void setTaxAmountErrorTip(BigDecimal taxAmount) {
        if (taxAmount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            String code = "occ.ocbsoc.ERROR_MAX_TAX_AMOUNT";
            throw new KDBizException(new ErrorCode(code, ResManager.loadKDString((String)"\u91d1\u989d\u8d85\u8fc7\u7cfb\u7edf\u9884\u5236\u6700\u5927\u503c[9999999999999]\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u76f8\u5173\u6570\u636e\u3002", (String)"SaleOrderAlgorithm_0", (String)"occ-ocbsoc-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void calAmountAndTaxByCur(int i) {
        BigDecimal exchangeRate = this.getNullToZero("exchangerate");
        BigDecimal curAmountAndTax = this.getNullToZero("localtaxamount", i);
        BigDecimal amountAndTax = BigDecimal.ZERO;
        if (exchangeRate.compareTo(BigDecimal.ZERO) != 0 && curAmountAndTax.compareTo(BigDecimal.ZERO) != 0) {
            amountAndTax = curAmountAndTax.divide(exchangeRate, this.amountPrecision, 4);
        }
        this.setValue("taxamount", amountAndTax, i);
    }

    private void calCurAmountAndTax(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("taxamount", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            BigDecimal localTaxAmount = taxAmount.multiply(exchangerate).setScale(this.curAmountPrecision, 4);
            this.setValue("localtaxamount", localTaxAmount, i);
        } else {
            BigDecimal localAmount = this.getNullToZero("localamount", i);
            BigDecimal localTax = this.getNullToZero("localtax", i);
            this.setValue("localtaxamount", localAmount.add(localTax), i);
        }
    }

    private void calTaxAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("taxamount", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = taxAmount.multiply(taxRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
            }
            this.setValue("tax", tax, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = amount.multiply(taxRate).setScale(this.amountPrecision, 4);
            }
            this.setValue("tax", tax, i);
        }
    }

    private void calCurTaxAmount(int i) {
        BigDecimal tax = this.getNullToZero("tax", i);
        BigDecimal exchangerate = this.getNullToZero("exchangerate");
        BigDecimal localTax = tax.multiply(exchangerate).setScale(this.curAmountPrecision, 4);
        this.setValue("localtax", localTax, i);
    }

    private void calAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("taxamount", i);
            BigDecimal tax = this.getNullToZero("tax", i);
            BigDecimal amount = taxAmount.subtract(tax);
            this.setValue("amount", amount, i);
        } else {
            BigDecimal price = this.getNullToZero("price", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal discountRate = this.getNullToZero("pricediscount", i);
            amount = qty.multiply(price.subtract(discountRate)).setScale(this.amountPrecision, 4);
            amount = amount.subtract(this.getNullToZero("promotiondiscount", i).add(this.getNullToZero("recdiscount", i)));
            this.setValue("amount", amount, i);
        }
    }

    private void calAmountByCur(int i) {
        BigDecimal exchangeRate = this.getNullToZero("exchangerate");
        BigDecimal curAmount = this.getNullToZero("localamount", i);
        BigDecimal amount = BigDecimal.ZERO;
        if (exchangeRate.compareTo(BigDecimal.ZERO) != 0 && curAmount.compareTo(BigDecimal.ZERO) != 0) {
            amount = curAmount.divide(exchangeRate, this.amountPrecision, 4);
        }
        this.setValue("amount", amount, i);
    }

    private void calCurAmount(int i) {
        if (this.hasTax()) {
            BigDecimal localTaxAmount = this.getNullToZero("localtaxamount", i);
            BigDecimal localTax = this.getNullToZero("localtax", i);
            this.setValue("localamount", localTaxAmount.subtract(localTax), i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            BigDecimal localTaxAmount = amount.multiply(exchangerate).setScale(this.curAmountPrecision, 4);
            this.setValue("localamount", localTaxAmount, i);
        }
    }

    public boolean hasTax() {
        boolean isTax = (Boolean)this.getValue("istax");
        return isTax;
    }

    public void calQtysByApproveQty(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(rowIndex);
        DynamicObject item = orderEntry.getDynamicObject("itemid");
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        DynamicObject unitDynObj = orderEntry.getDynamicObject("unit");
        BigDecimal baseQty = BigDecimal.ZERO;
        BigDecimal assistQty = orderEntry.getBigDecimal("approveassistqty");
        long materialId = orderEntry.getLong(String.join((CharSequence)"_", "materialid", "id"));
        long baseUnitId = orderEntry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
        baseQty = unitDynObj != null ? UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitDynObj.getLong("id"), (Long)baseUnitId) : qty;
        String conversionfor = ConversionDirection.FOR_ASSISTUNIT.getConversionFor();
        if (item != null) {
            conversionfor = item.getString("conversionfor");
        }
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) {
            long assisUnitId = orderEntry.getLong(String.join((CharSequence)"_", "assistunitid", "id"));
            assistQty = assisUnitId > 0L ? UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assisUnitId) : BigDecimal.ZERO;
        }
        this.setValue("approvebaseqty", baseQty, rowIndex);
        this.setValue("approveassistqty", assistQty, rowIndex);
    }

    public void calQtysBySubQty(DynamicObject planEntryDynObj) {
        DynamicObject orderEntry = (DynamicObject)planEntryDynObj.getParent();
        DynamicObject item = orderEntry.getDynamicObject("itemid");
        if (item != null) {
            BigDecimal qty = planEntryDynObj.getBigDecimal("sub_qty");
            DynamicObject unitDynObj = planEntryDynObj.getDynamicObject("sub_unitid");
            BigDecimal baseQty = BigDecimal.ZERO;
            BigDecimal assistQty = planEntryDynObj.getBigDecimal("sub_assistqty");
            long materialId = orderEntry.getLong(String.join((CharSequence)"_", "materialid", "id"));
            long baseUnitId = orderEntry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
            if (unitDynObj != null) {
                baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitDynObj.getLong("id"), (Long)baseUnitId);
            }
            String conversionfor = null;
            if (item != null) {
                conversionfor = item.getString("conversionfor");
            }
            if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) {
                DynamicObject assisUnit = planEntryDynObj.getDynamicObject("sub_assistunitid");
                assistQty = assisUnit != null ? UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)assisUnit.getLong("id")) : BigDecimal.ZERO;
            }
            planEntryDynObj.set("sub_baseqty", (Object)baseQty);
            planEntryDynObj.set("sub_assistqty", (Object)assistQty);
        }
    }

    public void calQtysByReqQty(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(rowIndex);
        DynamicObject item = orderEntry.getDynamicObject("itemid");
        if (item == null) {
            return;
        }
        BigDecimal alterQty = orderEntry.getBigDecimal("qty");
        DynamicObject unitDynObj = orderEntry.getDynamicObject("unit");
        BigDecimal alterBaseQty = BigDecimal.ZERO;
        BigDecimal alterAssistQty = orderEntry.getBigDecimal("assistreqqty");
        long materialId = orderEntry.getLong(String.join((CharSequence)"_", "materialid", "id"));
        long baseUnitId = orderEntry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
        alterBaseQty = unitDynObj != null ? UnitConvertHelper.calculateDestQty((BigDecimal)alterQty, (Long)materialId, (Long)unitDynObj.getLong("id"), (Long)baseUnitId) : alterQty;
        String conversionfor = null;
        if (item != null) {
            conversionfor = item.getString("conversionfor");
        }
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) {
            DynamicObject assisUnit = orderEntry.getDynamicObject("assistunitid");
            alterAssistQty = assisUnit != null ? UnitConvertHelper.calculateDestQty((BigDecimal)alterBaseQty, (Long)materialId, (Long)baseUnitId, (Long)assisUnit.getLong("id")) : BigDecimal.ZERO;
        }
        this.setValue("reqbaseqty", alterBaseQty, rowIndex);
        this.setValue("assistreqqty", alterAssistQty, rowIndex);
    }

    public void calQtysByAssistApproveQty(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(rowIndex);
        DynamicObject item = orderEntry.getDynamicObject("itemid");
        String conversionfor = null;
        if (item != null) {
            conversionfor = item.getString("conversionfor");
        }
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        BigDecimal baseQty = orderEntry.getBigDecimal("approvebaseqty");
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) {
            DynamicObject unit = orderEntry.getDynamicObject("unit");
            if (unit != null) {
                BigDecimal assistQty = orderEntry.getBigDecimal("approveassistqty");
                DynamicObject assisUnit = orderEntry.getDynamicObject("assistunitid");
                if (assisUnit != null) {
                    long materialId = orderEntry.getLong(String.join((CharSequence)"_", "materialid", "id"));
                    long baseUnitId = orderEntry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
                    qty = UnitConvertHelper.calculateDestQty((BigDecimal)assistQty, (Long)materialId, (Long)assisUnit.getLong("id"), (Long)unit.getLong("id"));
                    baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unit.getLong("id"), (Long)baseUnitId);
                } else {
                    qty = BigDecimal.ZERO;
                    baseQty = BigDecimal.ZERO;
                }
            } else {
                qty = BigDecimal.ZERO;
                baseQty = BigDecimal.ZERO;
            }
        }
        this.setValue("qty", qty, rowIndex);
        this.setValue("approvebaseqty", baseQty, rowIndex);
    }

    public void calQtysByAssistReqQty(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo(rowIndex);
        BigDecimal assistReqQty = orderEntry.getBigDecimal("assistreqqty");
        DynamicObject item = orderEntry.getDynamicObject("itemid");
        String conversionfor = null;
        if (item != null) {
            conversionfor = item.getString("conversionfor");
        }
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        BigDecimal baseQty = orderEntry.getBigDecimal("reqbaseqty");
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) {
            DynamicObject unit = orderEntry.getDynamicObject("unit");
            if (unit != null) {
                DynamicObject assisUnit = orderEntry.getDynamicObject("assistunitid");
                if (assisUnit != null) {
                    long materialId = orderEntry.getLong(String.join((CharSequence)"_", "materialid", "id"));
                    long baseUnitId = orderEntry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
                    qty = UnitConvertHelper.calculateDestQty((BigDecimal)assistReqQty, (Long)materialId, (Long)assisUnit.getLong("id"), (Long)unit.getLong("id"));
                    baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unit.getLong("id"), (Long)baseUnitId);
                } else {
                    qty = BigDecimal.ZERO;
                    baseQty = BigDecimal.ZERO;
                }
            } else {
                qty = BigDecimal.ZERO;
                baseQty = BigDecimal.ZERO;
            }
        }
        this.setValue("qty", qty, rowIndex);
        this.setValue("reqbaseqty", baseQty, rowIndex);
    }
}

