/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.business.channel;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.Checked;

public class ChannelAuthProcessor {
    public static final String customerAuthorizeSelectField = String.join((CharSequence)",", "id", "number", "name", "saleorg", "saleorg.name", "supplyrelation", "salechannel", "salechannel.name");
    private static final String orgInfoSelectField = String.join((CharSequence)",", "id", "fisbankroll", "parent");

    public DynamicObjectCollection getChannelAuthOrgByOrderChannel(long orderChannelId) {
        QFilter filter = new QFilter("orderchannel", "=", (Object)orderChannelId);
        filter.and(new QFilter("enable", "=", (Object)Checked.YES.toString()));
        filter.and(new QFilter("salechannel", "=", (Object)0L));
        return QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)customerAuthorizeSelectField, (QFilter[])filter.toArray());
    }

    public long getBankRollOrg(Set<Long> orgIds) {
        QFilter filter = new QFilter("id", "in", orgIds);
        filter.and(new QFilter("enable", "=", (Object)Checked.YES.toString()));
        DynamicObjectCollection orgList = QueryServiceHelper.query((String)"bos_org", (String)orgInfoSelectField, (QFilter[])filter.toArray());
        if (orgList != null && orgList.size() > 0) {
            DynamicObject bankRollOrg = orgList.stream().filter(r -> r.getBoolean("fisbankroll")).findFirst().orElse(null);
            if (bankRollOrg != null) {
                return bankRollOrg.getLong("id");
            }
            Set<Long> parentOrg = orgList.stream().filter(r -> r.getLong("parent") > 0L).map(r -> r.getLong("parent")).collect(Collectors.toSet());
            if (parentOrg != null && parentOrg.size() > 0) {
                return this.getBankRollOrg(parentOrg);
            }
        }
        return 0L;
    }
}

