/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.business.order;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.UserUtil;

public class SaleOrderHelper {
    protected static Log logger = LogFactory.getLog(SaleOrderHelper.class);

    public static <T> T invokeOrderService(String methodName, Object ... paras) {
        return (T)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbsoc", (String)"MobSaleOrderService", (String)methodName, (Object[])paras);
    }

    public static List<QFilter> getItemFilter(long saleOrgId, long saleChannelId, long orderChannelId) {
        List<QFilter> filters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)saleChannelId, (long)orderChannelId);
        if (filters == null) {
            filters = Arrays.asList(new QFilter("id", "=", (Object)0L).toArray());
        }
        return filters;
    }

    public static BigDecimal unitConvert(BigDecimal qty, long baseUnitId, long unitId, long materialId) {
        BigDecimal convertQty = BigDecimal.ZERO;
        try {
            convertQty = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)baseUnitId, (Long)unitId, (Long)materialId, null);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return convertQty;
    }

    public static DynamicObjectCollection getCartData(QFilter filter) {
        DynamicObjectCollection cartList = QueryServiceHelper.query((String)"ocepfp_cart", (String)String.join((CharSequence)",", "id", "item", String.join((CharSequence)".", "item", "number"), String.join((CharSequence)".", "item", "name"), "auxpty", "qty", "auxqty", "auxunit"), (QFilter[])filter.toArray());
        return cartList;
    }

    public static DynamicObjectCollection getCartData(List<String> items, long orderChannelId, long saleOrgId, long saleChannelId, String supplyRelation) {
        QFilter filter = new QFilter("user", "=", UserUtil.getUserID());
        filter.and(new QFilter("saleorg", "=", (Object)saleOrgId));
        filter.and(new QFilter("orderchannel", "=", (Object)orderChannelId));
        filter.and(new QFilter("salechannel", "=", (Object)saleChannelId));
        filter.and(new QFilter("supplyrelation", "=", (Object)supplyRelation));
        filter.and(new QFilter("item", "in", items));
        DynamicObjectCollection cartList = QueryServiceHelper.query((String)"ocepfp_cart", (String)String.join((CharSequence)",", "id", "item", "auxpty", "qty"), (QFilter[])filter.toArray());
        return cartList;
    }

    public static int deleteCartByIds(List<Long> deleteIds, List<Long> itemIds) {
        if (deleteIds != null && !deleteIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", deleteIds);
            if (itemIds != null) {
                filter.and("item", "in", itemIds);
            }
            return DeleteServiceHelper.delete((String)"ocepfp_cart", (QFilter[])filter.toArray());
        }
        return 0;
    }

    public static QFilter getOrderChannelFilter() {
        return OrderHelper.getOrderChannelFilter();
    }
}

