/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.cart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.occ.ocbase.business.b2b.AuxptyHelper;
import kd.occ.ocbase.business.b2b.ItemBusinessHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.constants.PriceFetchResult;
import kd.occ.ocbase.common.entity.OrderQuantityResult;
import kd.occ.ocbase.common.entity.b2b.Auxpty;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.pojo.PromotionItemVo;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.OrderQuantityUtil;
import kd.occ.ocbase.common.util.PictureUtil;
import kd.occ.ocbase.common.util.PriceServiceUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocdma.business.item.ItemHelper;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class MobCartEdit
extends OcdmaFormMobPlugin
implements RowClickEventListener,
ListRowClickListener,
EntryGridBindDataListener,
SelectRowsEventListener {
    private static final Log LOGGER = LogFactory.getLog(MobCartEdit.class);
    private static final String ORDER_FAILURE_CALLBACK = "orderFailureCallback";
    private static final String DELETE_ITEM_CART_CALLBACK = "deleteItemCartCallBack";
    private static final String CHANGE_AUXPTY_CONFIRM_CALLBACK = "changeAuxptyConfirmCallBack";
    private static final String OCDMA_SELECT_AUXPTY = "ocdma_select_auxpty";
    public static final String ITEM_LIST = "itemlist";
    public static final String ORDER_AMOUNT = "orderamount";
    public static final String ORDER_QTY = "orderqty";
    public static final String ORDER_AUXQTY = "orderauxqty";
    public static final String ORDEREXT = "orderext";
    public static final String ADD = "add";
    public static final String REDUCE = "reduce";
    public static final String DELETE = "delete";
    private static final int amtPrecision = 2;
    private static final String PRICECURRENCY = "pricecurrency";
    private static final String UNIT_NAME = "unit_name";
    private static final String OCBMALL_GOODS_DETAIL = "ocdma_goods_detail";
    private static final String OCBMALL_SALEORDER_ADD = "ocdma_saleorder_add";
    private static final String BTN_CREATEORDER = "createorder";
    private static final String BTN_BATCH_DELETE = "batch_delete";
    private static final String SPLITKEY = "&";
    private static final String PROMOTION_LABEL = "promotion_label";
    private static final String SELECT_ALL = "selectall";
    private static final String AUXPTY_VALUE = "auxpty_value";
    private static final String BTN_SELECTGROUPALL = "selectgroupall";
    private static final String BTN_UNSELECTGROUPALL = "unselectgroupall";
    private static final String IsGroupChild = "groupchild";
    private static final String DELETE_BTN = "delete_btn";
    private static final String cartseletfield = String.join((CharSequence)",", "id", "user", "orderchannel", "saleorg", "salechannel", "supplyrelation", "currency", "item", "unit", "auxunit", "qty", "auxqty", "auxpty", String.join((CharSequence)".", "item", "name"), String.join((CharSequence)".", "item", "number"), String.join((CharSequence)".", "item", "material"), String.join((CharSequence)".", "item", "material", "taxrate", "taxrate"), String.join((CharSequence)".", "item", "modelnum"), String.join((CharSequence)".", "item", "thumbnail"), String.join((CharSequence)".", "unit", "name"), String.join((CharSequence)".", "unit", "precisionaccount"), String.join((CharSequence)".", "orderchannel", "name"), String.join((CharSequence)".", "saleorg", "name"), String.join((CharSequence)".", "salechannel", "name"));

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        super.selectRowsChange(evt);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ITEM_LIST);
        int[] seleRows = cardEntry.getSelectRows();
        DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
        DynamicObjectCollection tempList = new DynamicObjectCollection();
        if (seleRows != null && seleRows.length > 0) {
            for (int i = 0; i < seleRows.length; ++i) {
                tempList.add(itemList.get(seleRows[i]));
            }
            this.countTotalAmount(tempList);
        } else {
            this.countTotalAmount(null);
        }
        int entryRowCount = this.getModel().getEntryRowCount(ITEM_LIST);
        int selectRowCount = cardEntry.getSelectRows().length;
        if (entryRowCount == selectRowCount) {
            this.triggerChangeEvent = false;
            this.setValue(SELECT_ALL, true);
            this.triggerChangeEvent = true;
        } else {
            this.triggerChangeEvent = false;
            this.setValue(SELECT_ALL, false);
            this.triggerChangeEvent = true;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DELETE, ADD, REDUCE, BTN_CREATEORDER, BTN_BATCH_DELETE, AUXPTY_VALUE, BTN_SELECTGROUPALL, BTN_UNSELECTGROUPALL, DELETE_BTN});
        CardEntry cardEntry = (CardEntry)this.getControl(ITEM_LIST);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initShoppingCart();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAuxptyValue();
        this.getView().executeClientCommand("loadThirdPartyJS", new Object[]{"./kingdee/drp/ocdma/qtyfocus.js"});
    }

    private void setAuxptyValue() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ITEM_LIST);
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        for (int i = 0; i < entryEntity.size(); ++i) {
            boolean isOpenSelectAuxpty;
            this.setAuxptyValue(i);
            DynamicObject itemEntry = (DynamicObject)entryEntity.get(i);
            DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)itemEntry, (String)"materialid");
            boolean isUseAuxpty = DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"isuseauxpty");
            boolean bl = isOpenSelectAuxpty = isUseAuxpty && StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A") || !StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A");
            if (!isOpenSelectAuxpty) continue;
            itemEntry.set("isuseauxpty", (Object)true);
        }
        this.getView().updateView(ITEM_LIST);
    }

    private void setAuxptyValue(int index) {
        Auxpty auxpty;
        CardEntry cardEntry = (CardEntry)this.getControl(ITEM_LIST);
        long auxptyId = this.getAuxptyId(index);
        if (auxptyId != 0L && (auxpty = AuxptyHelper.getAuxptyName((long)auxptyId)) != null) {
            HashMap mapTextfield = new HashMap(1);
            HashMap<String, String> labelField = new HashMap<String, String>(1);
            labelField.put("text", auxpty.getAuxptyName());
            mapTextfield.put(AUXPTY_VALUE, labelField);
            cardEntry.setCustomProperties(cardEntry.getKey(), index, mapTextfield);
        }
    }

    private void initShoppingCart() {
        this.initItemList();
        int entryRowCount = this.getModel().getEntryRowCount(ITEM_LIST);
        if (entryRowCount > 0) {
            CardEntry cardEntry = (CardEntry)this.getControl(ITEM_LIST);
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject temp = this.getModel().getEntryRowEntity(ITEM_LIST, i);
                if (temp.get(IsGroupChild) != null && temp.getBoolean(IsGroupChild)) {
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{ORDEREXT});
                }
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{BTN_UNSELECTGROUPALL});
                if (EnableStatusEnum.DISABLE.getValue().equals(temp.getString("status"))) {
                    this.setUnEnable(i, new String[]{ADD});
                    this.setUnEnable(i, new String[]{REDUCE});
                }
                this.setValue("metering", this.getValue("unit", i), i);
                this.setValue("assistunit", this.getValue("auxunit", i), i);
            }
        }
    }

    private void initItemList() {
        QFilter filter;
        DynamicObjectCollection shoppingCartInfos;
        IDataModel model = this.getModel();
        DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
        CardEntry itemListControl = (CardEntry)this.getView().getControl(ITEM_LIST);
        if (itemList != null && itemList.size() > 0) {
            model.deleteEntryData(ITEM_LIST);
        }
        if ((shoppingCartInfos = QueryServiceHelper.query((String)"ocepfp_cart", (String)cartseletfield, (QFilter[])(filter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())).toArray())) != null && !shoppingCartInfos.isEmpty()) {
            ArrayList<PriceFetchParam> priceFetchParamList = new ArrayList<PriceFetchParam>(shoppingCartInfos.size());
            Map shoppingCartGroupMap = shoppingCartInfos.stream().collect(Collectors.groupingBy(k -> k.getLong("orderchannel") + "_" + k.getLong("saleorg") + "_" + k.getLong("salechannel") + "_" + k.getString("supplyrelation"), Collectors.toList()));
            int index_count = 0;
            HashMap<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>();
            for (Map.Entry shoppingCartGroup : shoppingCartGroupMap.entrySet()) {
                long currencyId;
                List sameGroupItems = shoppingCartGroup.getValue();
                String[] supplyRelationInfo = shoppingCartGroup.getKey().split("_");
                long orderChannelId = Long.parseLong(supplyRelationInfo[0]);
                DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel", (String)"pricechannel,currency");
                long priceChannelId = orderChannel != null ? orderChannel.getLong("pricechannel_id") : 0L;
                long saleOrgId = Long.parseLong(supplyRelationInfo[1]);
                long saleChannelId = Long.parseLong(supplyRelationInfo[2]);
                String supplyRelation = supplyRelationInfo[3];
                long l = currencyId = orderChannel != null ? orderChannel.getLong("currency_id") : 0L;
                if (currencyId != 0L && !currencyMap.containsKey(currencyId)) {
                    DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bd_currency");
                    currencyMap.put(currencyId, currency);
                }
                List sameGroupItemIdList = sameGroupItems.stream().map(r -> r.getLong("item")).collect(Collectors.toList());
                filter = new QFilter("id", "in", sameGroupItemIdList);
                this.getItemStatusQFilter(filter, saleOrgId, saleChannelId, orderChannelId);
                List<Long> marketItemIdList = this.getMarketableGoodsIds(saleOrgId, saleChannelId, orderChannelId, filter);
                List itemInfo = sameGroupItems.stream().map(r -> r.getLong("item") + "_" + r.getLong("auxpty") + "_" + r.getLong("unit")).collect(Collectors.toCollection(ArrayList::new));
                Map<String, List<PromotionItemVo>> promotionPolicyMap = this.getPromotionPolicy(orderChannelId, saleOrgId, saleChannelId, supplyRelation, itemInfo);
                DynamicObject channelAuthorize = QueryServiceHelper.queryOne((String)"ocdbd_channel_authorize", (String)String.join((CharSequence)",", "id"), (QFilter[])new QFilter[]{new QFilter("orderchannel", "=", (Object)orderChannelId), new QFilter("saleorg", "=", (Object)saleOrgId), new QFilter("salechannel", "=", (Object)saleChannelId), new QFilter("supplyrelation", "=", (Object)supplyRelation)});
                int[] indexes = model.batchCreateNewEntryRow(ITEM_LIST, sameGroupItems.size());
                for (int i = 0; i < sameGroupItems.size(); ++i) {
                    int rowIndex = indexes[i];
                    DynamicObject cartInfo = (DynamicObject)sameGroupItems.get(i);
                    DynamicObject dataObject = this.getRowInfo(ITEM_LIST, rowIndex);
                    dataObject.set("id", (Object)cartInfo.getLong("id"));
                    dataObject.set(PRICECURRENCY, currencyMap.get(currencyId));
                    dataObject.set("itemname", (Object)cartInfo.getString(String.join((CharSequence)".", "item", "name")));
                    dataObject.set("itemnumber", (Object)cartInfo.getString(String.join((CharSequence)".", "item", "number")));
                    long itemId = cartInfo.getLong("item");
                    dataObject.set("itemid", (Object)itemId);
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"item", (long)itemId);
                    dataObject.set("thumbnail", (Object)PictureUtil.getServerPictureUrl((String)cartInfo.getString(String.join((CharSequence)".", "item", "thumbnail"))));
                    dataObject.set("qty", (Object)cartInfo.getBigDecimal("qty"));
                    dataObject.set("auxqty", (Object)cartInfo.getBigDecimal("auxqty"));
                    long unitId = cartInfo.getLong("unit");
                    long auxUnitId = DynamicObjectUtils.getLong((DynamicObject)cartInfo, (String)"auxunit");
                    dataObject.set("unit", (Object)unitId);
                    dataObject.set("auxunit", (Object)auxUnitId);
                    dataObject.set(UNIT_NAME, (Object)cartInfo.getString(String.join((CharSequence)".", "unit", "name")));
                    long auxpty = cartInfo.getLong("auxpty");
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"auxptyid", (long)auxpty);
                    String key = itemId + "_" + auxpty + "_" + unitId;
                    dataObject.set("haspromotion", (Object)CollectionUtil.isNotNull(promotionPolicyMap.get(key)));
                    itemListControl.setChildVisible(CollectionUtil.isNotNull(promotionPolicyMap.get(key)), index_count, new String[]{PROMOTION_LABEL});
                    long materialId = cartInfo.getLong(String.join((CharSequence)".", "item", "material"));
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"materialid", (long)materialId);
                    BigDecimal taxRate = BigDecimal.ZERO;
                    model.setValue("taxrate", (Object)cartInfo.getBigDecimal(String.join((CharSequence)".", "item", "material", "taxrate", "taxrate")), rowIndex);
                    BigDecimal qty = cartInfo.getBigDecimal("qty");
                    PriceFetchParam priceFetchParam = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)priceChannelId, (long)itemId, (long)auxpty, (long)unitId, (long)currencyId, (BigDecimal)qty);
                    priceFetchParam.setOwnerId(saleChannelId);
                    priceFetchParam.setChannelSupplyRelation(ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation) ? ChannelSupplyRelation.SUPPLY_CHANNEL : ChannelSupplyRelation.SUPPLY_ORG);
                    priceFetchParamList.add(priceFetchParam);
                    dataObject.set("priceuq", (Object)priceFetchParam.getParamUniKey());
                    BigDecimal price = BigDecimal.ZERO;
                    dataObject.set("price", (Object)price);
                    dataObject.set("qty", (Object)qty);
                    dataObject.set("orderchannelid", (Object)orderChannelId);
                    dataObject.set("saleorgid", (Object)saleOrgId);
                    dataObject.set("salechannelid", (Object)saleChannelId);
                    dataObject.set("supplyrelation", (Object)supplyRelation);
                    if (i != 0) {
                        dataObject.set(IsGroupChild, (Object)"1");
                    }
                    if (ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation)) {
                        dataObject.set("supplier", (Object)(cartInfo.getString(String.join((CharSequence)".", "salechannel", "name")) + "\uff0c" + cartInfo.getString(String.join((CharSequence)".", "orderchannel", "name"))));
                    } else {
                        dataObject.set("supplier", (Object)(cartInfo.getString(String.join((CharSequence)".", "saleorg", "name")) + "\uff0c" + cartInfo.getString(String.join((CharSequence)".", "orderchannel", "name"))));
                    }
                    if (channelAuthorize != null) {
                        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"supplyrelationid", (long)channelAuthorize.getLong("id"));
                    }
                    if (marketItemIdList.contains(cartInfo.getLong("item"))) {
                        dataObject.set("status", (Object)EnableStatusEnum.ENABLE.getValue());
                    } else {
                        dataObject.set("statusname", (Object)"\u5df2\u4e0b\u67b6");
                        dataObject.set("status", (Object)EnableStatusEnum.DISABLE.getValue());
                    }
                    ++index_count;
                }
                Map priceMap = PriceServiceUtil.batchGetItemPrice(priceFetchParamList);
                for (int i = 0; i < sameGroupItems.size(); ++i) {
                    int rowIndex = indexes[i];
                    DynamicObject entryObj = this.getRowInfo(ITEM_LIST, rowIndex);
                    PriceFetchResult priceFetchResult = (PriceFetchResult)priceMap.get(entryObj.getString("priceuq"));
                    DynamicObject settleCurrency = entryObj.getDynamicObject(PRICECURRENCY);
                    BigDecimal taxRate = entryObj.getBigDecimal("taxrate");
                    BigDecimal qty = entryObj.getBigDecimal("qty");
                    BigDecimal price = BigDecimal.ZERO;
                    if (priceFetchResult != null) {
                        HashMap priceDetailMap = OrderHelper.getPriceMap((PriceFetchResult)priceFetchResult, (DynamicObject)settleCurrency, (BigDecimal)qty, (BigDecimal)taxRate, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
                        price = priceDetailMap != null ? (BigDecimal)priceDetailMap.get("actualtaxprice") : BigDecimal.ZERO;
                    }
                    entryObj.set("price", (Object)price);
                    entryObj.set("amount", (Object)price.multiply(qty));
                }
                DynamicObjectCollection entryList = this.getModel().getEntryEntity(ITEM_LIST);
                BusinessDataServiceHelper.loadRefence((Object[])entryList.toArray(), (IDataEntityType)entryList.getDynamicObjectType());
            }
        }
    }

    private List<Long> getMarketableGoodsIds(long saleOrgId, long saleChannelId, long orderChannelId, QFilter filter) {
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoodsId", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
    }

    private Map<String, List<PromotionItemVo>> getPromotionPolicy(long orderChannelId, long saleOrgId, long saleChannelId, String supplyRelation, List<String> itemInfo) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"PromotionService", (String)"getPromotionPolicy", (Object[])new Object[]{orderChannelId, saleOrgId, saleChannelId, supplyRelation, itemInfo});
    }

    private QFilter getItemStatusQFilter(QFilter filter, long saleOrgId, long saleChannelId, long orderChannelId) {
        boolean isFromOcsaa = this.getIsFromOCSAA();
        filter = isFromOcsaa ? ItemBusinessHelper.getItemStatusSysControlQFilter((long)saleOrgId, (long)saleChannelId, (long)orderChannelId, (QFilter)filter, (String)"3") : ItemBusinessHelper.getItemStatusSysControlQFilter((long)saleOrgId, (long)saleChannelId, (long)orderChannelId, (QFilter)filter, (String)"1");
        return filter;
    }

    private boolean getIsFromOCSAA() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return false;
        }
        FormShowParameter formShowParameter = parentView.getFormShowParameter();
        if (formShowParameter == null) {
            return false;
        }
        return formShowParameter.getCustomParam("supplierid") != null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = true;
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        DynamicObject rowInfo = this.getRowInfo(ITEM_LIST, rowIndex);
        switch (key) {
            case "qty": {
                String unitName = rowInfo.getString(UNIT_NAME);
                BigDecimal itemQty = (BigDecimal)e.getChangeSet()[0].getNewValue();
                BigDecimal oldValue = (BigDecimal)e.getChangeSet()[0].getOldValue();
                BigDecimal auxQty = (BigDecimal)this.getValue("auxqty", rowIndex);
                oldValue = oldValue == null ? BigDecimal.ZERO : oldValue;
                boolean isAdd = itemQty.compareTo(oldValue) >= 0;
                DynamicObjectCollection itemEntry = this.getModel().getEntryEntity(ITEM_LIST);
                DynamicObject item = (DynamicObject)itemEntry.get(rowIndex);
                long saleOrgId = item.getLong("saleorgid");
                long orderChannelId = item.getLong("orderchannelid");
                long unitId = item.getLong("unit");
                long itemId = item.getLong("item_id");
                long auxptyId = this.getAuxptyId(rowIndex);
                OrderQuantityResult orderQuantityResult = OrderQuantityUtil.calOrderQuantity((long)saleOrgId, (long)orderChannelId, (long)itemId, (long)unitId, (long)auxptyId, (BigDecimal)itemQty, (IPageCache)this.getView().getPageCache());
                if (orderQuantityResult.isQuantity()) {
                    itemQty = orderQuantityResult.getSuggestQty();
                    this.triggerChangeEvent = false;
                    this.getModel().setValue("qty", (Object)itemQty, rowIndex);
                    this.triggerChangeEvent = true;
                    this.getView().showTipNotification(orderQuantityResult.getErrorMsg());
                }
                DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"updateCartQtyById", (Object[])new Object[]{rowInfo.getLong("id"), itemQty, auxQty});
                BigDecimal price = rowInfo.getBigDecimal("price");
                BigDecimal amount = price.multiply(itemQty);
                this.getModel().setValue("amount", (Object)amount, rowIndex);
                DynamicObjectCollection tempList = this.getModel().getEntryEntity(ITEM_LIST);
                DynamicObjectCollection itemList = new DynamicObjectCollection();
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
                int[] seleRows = entryGrid.getSelectRows();
                boolean isSelect = false;
                for (int i = 0; i < seleRows.length; ++i) {
                    itemList.add(tempList.get(seleRows[i]));
                    if (seleRows[i] != rowIndex) continue;
                    isSelect = true;
                }
                if (!isSelect) {
                    int[] newSelectRows = Arrays.copyOf(seleRows, seleRows.length + 1);
                    newSelectRows[seleRows.length] = rowIndex;
                    entryGrid.selectRows(newSelectRows, rowIndex);
                    itemList.add(tempList.get(rowIndex));
                }
                this.countTotalAmount(itemList);
                break;
            }
            case "selectall": {
                Boolean selectAll = (Boolean)this.getModel().getValue(SELECT_ALL);
                if (selectAll.booleanValue()) {
                    this.selectAllEntry(ITEM_LIST);
                    DynamicObjectCollection selectList = this.getModel().getDataEntity(true).getDynamicObjectCollection(ITEM_LIST);
                    this.countTotalAmount(selectList);
                    break;
                }
                this.countTotalAmount(null);
                this.unSelectAllEntry(ITEM_LIST);
                DynamicObjectCollection tempList = this.getModel().getEntryEntity(ITEM_LIST);
                for (int i = 0; i < tempList.size(); ++i) {
                    rowInfo = (DynamicObject)tempList.get(i);
                    BigDecimal price = rowInfo.getBigDecimal("price");
                    BigDecimal qty = rowInfo.getBigDecimal("qty");
                    BigDecimal amount = price.multiply(qty);
                    this.getModel().setValue("amount", (Object)amount, i);
                }
                break;
            }
            case "auxptyid": {
                long itemId = this.getItemId(rowIndex);
                long auxptyId = this.getAuxptyId(rowIndex);
                this.setAuxptyValue(rowIndex);
                DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"updateCartAuxptyById", (Object[])new Object[]{rowInfo.getLong("id"), auxptyId});
                break;
            }
        }
    }

    protected void fetchTaxPrice(int rowIndex) {
        DynamicObject taxrate;
        DynamicObject material;
        BigDecimal taxRate;
        IDataModel model = this.getModel();
        DynamicObjectCollection itemList = model.getEntryEntity(ITEM_LIST);
        DynamicObject item = (DynamicObject)itemList.get(rowIndex);
        long currencyId = this.getCurrencyId(rowIndex);
        long saleOrgId = item.getLong("saleorgid");
        long orderChannelId = item.getLong("orderchannelid");
        long saleChannelId = item.getLong("salechannelid");
        DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel");
        long priceChannelId = orderChannel != null ? orderChannel.getLong("pricechannel_id") : 0L;
        long unitId = item.getLong("unit");
        long itemId = item.getDynamicObject("item").getLong("id");
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            qty = BigDecimal.ONE;
        }
        if (((taxRate = item.getBigDecimal("taxrate")) == null || BigDecimal.ZERO.compareTo(taxRate) == 0) && (material = item.getDynamicObject("materialid")) != null && (taxrate = material.getDynamicObject("taxrate")) != null) {
            model.setValue("taxrateid", (Object)taxrate, rowIndex);
            DynamicObject modelTaxrate = (DynamicObject)model.getValue("taxrateid", rowIndex);
            taxRate = modelTaxrate.getBigDecimal("taxrate");
            model.setValue("taxrate", (Object)taxRate, rowIndex);
        }
        String supplyrelation = item.getString("supplyrelation");
        PriceFetchParam params = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)priceChannelId, (long)itemId, (long)this.getAuxptyId(rowIndex), (long)unitId, (long)currencyId, (BigDecimal)qty);
        params.setOwnerId(saleChannelId);
        params.setChannelSupplyRelation(ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyrelation) ? ChannelSupplyRelation.SUPPLY_CHANNEL : ChannelSupplyRelation.SUPPLY_ORG);
        HashMap priceMap = OrderHelper.getPriceMap((PriceFetchParam)params, null, (BigDecimal)qty, (BigDecimal)taxRate);
        this.setPrice(priceMap, rowIndex, model);
    }

    private void setPrice(HashMap<String, Object> priceMap, int rowIndex, IDataModel model) {
        DynamicObject customerEntity;
        model.setValue("price", priceMap.get("actualtaxprice"), rowIndex);
        Long currency = this.getCurrencyId(rowIndex);
        if (currency > 0L && (customerEntity = BusinessDataServiceHelper.loadSingle((Object)currency, (String)"bd_currency")) != null) {
            String currencySign = customerEntity.getString("sign");
            model.setValue("price_show", (Object)(currencySign + BigDecimalUtil.setScale((BigDecimal)((BigDecimal)priceMap.get("actualtaxprice")), (int)2)));
        }
    }

    private boolean isOrderQuantityStrongControl() {
        return SysParamsUtil.isOrderQuantityStrongControl();
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex(ITEM_LIST);
        switch (key) {
            case "add": {
                this.add(index);
                break;
            }
            case "reduce": {
                this.reduce(index);
                break;
            }
            case "delete": {
                Long id = (Long)this.getModel().getValue("id", index);
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(id);
                QFilter filter = new QFilter("id", "in", ids);
                DeleteServiceHelper.delete((String)"ocepfp_cart", (QFilter[])filter.toArray());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5546\u54c1\u6210\u529f\u3002", (String)"MobCartEdit_1", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
                this.initShoppingCart();
                this.setCartBadgeInfo();
                this.getView().updateView();
                break;
            }
            case "batch_delete": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
                int[] seleRows = entryGrid.getSelectRows();
                if (seleRows == null || seleRows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"MobCartEdit_2", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DELETE_ITEM_CART_CALLBACK, (IFormPlugin)this);
                String message = ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"MobCartEdit_3", (String)"occ-ocdma-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.YesNo, ConfirmTypes.Wait, confirmCallBacks);
                break;
            }
            case "createorder": {
                this.gotoOrder();
                break;
            }
            case "auxpty_value": {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
                BigDecimal auxQty = (BigDecimal)this.getModel().getValue("auxqty", index);
                MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)false, (long)this.getItemId(index), (long)this.getAuxptyId(index), (long)this.getSupplyRelationId(index), (BigDecimal)qty, (BigDecimal)auxQty);
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
            case "selectgroupall": {
                DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
                DynamicObject groupItem = (DynamicObject)itemList.get(index);
                CardEntry cardEntry = (CardEntry)this.getView().getControl(ITEM_LIST);
                ArrayList<Integer> newSelections = new ArrayList<Integer>(cardEntry.getSelectRows().length);
                for (int a : cardEntry.getSelectRows()) {
                    newSelections.add(a);
                }
                long supplierId = groupItem.getLong("supplyrelationid_id");
                Integer i = 0;
                for (DynamicObject itemRow : itemList) {
                    if (itemRow.getLong("supplyrelationid_id") == supplierId && !newSelections.contains(i)) {
                        newSelections.add(i);
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                cardEntry.selectRows(newSelections.stream().mapToInt(Integer::valueOf).toArray(), index);
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), index, new String[]{BTN_UNSELECTGROUPALL});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), index, new String[]{BTN_SELECTGROUPALL});
                this.countSelectRowTotalAmount(newSelections);
                break;
            }
            case "unselectgroupall": {
                CardEntry cardEntry = (CardEntry)this.getView().getControl(ITEM_LIST);
                DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
                DynamicObject groupItem = (DynamicObject)itemList.get(index);
                ArrayList<Integer> newSelections = new ArrayList<Integer>(cardEntry.getSelectRows().length);
                for (int a : cardEntry.getSelectRows()) {
                    newSelections.add(a);
                }
                long supplierId = groupItem.getLong("supplyrelationid_id");
                Integer i = 0;
                Object a = itemList.iterator();
                while (a.hasNext()) {
                    DynamicObject itemRow = (DynamicObject)a.next();
                    if (itemRow.getLong("supplyrelationid_id") == supplierId) {
                        newSelections.remove(i);
                    }
                    Integer n = i;
                    Integer n3 = i = Integer.valueOf(i + 1);
                }
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), index, new String[]{BTN_SELECTGROUPALL});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), index, new String[]{BTN_UNSELECTGROUPALL});
                cardEntry.selectRows(newSelections.stream().mapToInt(Integer::valueOf).toArray(), index);
                this.countSelectRowTotalAmount(newSelections);
                break;
            }
            case "delete_btn": {
                ConfirmCallBackListener deleteConfirm = new ConfirmCallBackListener(DELETE_BTN, (IFormPlugin)this);
                String deleteCheckMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"MobCartEdit_3", (String)"occ-ocdma-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(deleteCheckMsg, "", MessageBoxOptions.YesNo, ConfirmTypes.Wait, deleteConfirm, null, index + "");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        boolean isYes = messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes);
        if (isYes) {
            switch (callBackId) {
                case "deleteItemCartCallBack": {
                    this.batchDeleteItem();
                    this.getView().showTipNotification("\u5220\u9664\u5546\u54c1\u6210\u529f\u3002");
                    this.setCartBadgeInfo();
                    break;
                }
                case "orderFailureCallback": {
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
                    int[] selectRows = entryGrid.getSelectRows();
                    if (selectRows.length == 0) break;
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ITEM_LIST, selectRows[0]);
                    long orderChannelId = entryRowEntity.getLong("orderchannelid");
                    long saleOrgId = entryRowEntity.getLong("saleorgid");
                    long saleChannelId = entryRowEntity.getLong("salechannelid");
                    String supplyRelation = entryRowEntity.getString("supplyrelation");
                    DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"deleteCartBySupplyRelation", (Object[])new Object[]{orderChannelId, saleOrgId, saleChannelId, supplyRelation});
                    this.refreshPage();
                    break;
                }
                case "delete_btn": {
                    String customVaule = messageBoxClosedEvent.getCustomVaule();
                    long cartId = (Long)this.getModel().getValue("id", Integer.parseInt(customVaule));
                    QFilter filter = new QFilter("id", "=", (Object)cartId);
                    DeleteServiceHelper.delete((String)"ocepfp_cart", (QFilter[])filter.toArray());
                    this.getView().showTipNotification("\u5220\u9664\u5546\u54c1\u6210\u529f\u3002");
                    this.refreshPage();
                    this.setCartBadgeInfo();
                    break;
                }
            }
        }
    }

    private void batchDeleteItem() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
        int[] seleRows = entryGrid.getSelectRows();
        ArrayList<Long> delIds = new ArrayList<Long>(seleRows.length);
        DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
        for (int i = 0; i < seleRows.length; ++i) {
            DynamicObject temp = (DynamicObject)itemList.get(seleRows[i]);
            delIds.add(temp.getLong("id"));
        }
        QFilter delFilter = new QFilter("id", "in", delIds);
        DeleteServiceHelper.delete((String)"ocepfp_cart", (QFilter[])delFilter.toArray());
        this.refreshPage();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        switch (key = closedCallBackEvent.getActionId()) {
            case "ocdma_goods_detail": 
            case "ocdma_saleorder_add": {
                this.setValue(SELECT_ALL, false, false);
                this.refreshPage();
                break;
            }
            case "ocdma_select_auxpty": {
                if (closedCallBackEvent.getReturnData() == null) break;
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                int index = (Integer)returnData.get("index");
                long itemId = (Long)returnData.get("item");
                long auxptyId = (Long)returnData.get("auxpty");
                BigDecimal qty = (BigDecimal)returnData.get("qty");
                BigDecimal auxQty = (BigDecimal)returnData.get("auxqty");
                this.setValue("auxptyid", auxptyId, index);
                List sameItemEntry = this.getModel().getEntryEntity(ITEM_LIST).stream().filter(k -> k.getLong("item.id") == itemId && k.getLong("auxptyid.id") == auxptyId && k.getLong("supplyrelationid.id") == this.getSupplyRelationId(index)).collect(Collectors.toList());
                if (sameItemEntry.size() == 0 || auxptyId == 0L) {
                    this.setValue("auxqty", auxQty, index);
                    this.setValue("qty", qty, index);
                    break;
                }
                DynamicObject rowInfo = this.getRowInfo(ITEM_LIST, index);
                long cartId = rowInfo.getLong("id");
                if (sameItemEntry.size() > 1) {
                    QFilter delFilter = new QFilter("id", "=", (Object)cartId);
                    DeleteServiceHelper.delete((String)"ocepfp_cart", (QFilter[])delFilter.toArray());
                    this.refreshPage();
                    break;
                }
                this.setValue("auxqty", auxQty, index);
                this.setValue("qty", qty, index);
                break;
            }
        }
    }

    private void gotoOrder() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"MobCartEdit_2", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ITEM_LIST);
        DynamicObjectCollection itemList = new DynamicObjectCollection();
        for (int selectRow : selectRows) {
            itemList.add(entryEntity.get(selectRow));
        }
        Map<String, List<DynamicObject>> mapGroup = itemList.stream().collect(Collectors.groupingBy(k -> k.getString("orderchannelid") + "_" + k.getString("saleorgid") + "_" + k.getString("salechannelid")));
        if (mapGroup.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u8ba2\u8d27\u6e20\u9053\u548c\u4f9b\u8d27\u65b9\u7684\u5546\u54c1\u8fdb\u884c\u8ba2\u8d27\u3002", (String)"MobCartEdit_4", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String> cartIds = itemList.stream().map(r -> r.getString("id")).collect(Collectors.toList());
        List itemIdList = itemList.stream().map(r -> r.getLong("item.id")).collect(Collectors.toList());
        int index = ((DynamicObject)itemList.get(0)).getInt("seq") - 1;
        long supplyRelationId = this.getSupplyRelationId(index);
        long orderChannelId = ((DynamicObject)itemList.get(0)).getLong("orderchannelid");
        long saleOrgId = ((DynamicObject)itemList.get(0)).getLong("saleorgid");
        long saleChannelId = ((DynamicObject)itemList.get(0)).getLong("salechannelid");
        String supplyRelation = ((DynamicObject)itemList.get(0)).getString("supplyrelation");
        List channelIds = CUserHelper.getAuthorizedChannelIdList();
        if (!channelIds.contains(orderChannelId)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ORDER_FAILURE_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm("\u60a8\u5df2\u6ca1\u6709\u6b64\u6e20\u9053\u8ba2\u8d27\u6743\u9650\uff0c\u662f\u5426\u9700\u8981\u5220\u9664\u76f8\u5173\u5546\u54c1\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        if (!this.isSupplyRelationExist(supplyRelationId)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ORDER_FAILURE_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm("\u60a8\u7684\u5f53\u524d\u6e20\u9053\u4e0e\u4f9b\u8d27\u5546\u5df2\u4e0d\u5b58\u5728\u4f9b\u8d27\u5173\u7cfb\uff0c\u662f\u5426\u9700\u8981\u5220\u9664\u76f8\u5173\u5546\u54c1\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        QFilter filter = this.getItemStatusQFilter(null, saleOrgId, saleChannelId, orderChannelId);
        List marketItemIdList = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoodsId", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
        boolean invalid = itemIdList.stream().anyMatch(r -> !marketItemIdList.contains(r));
        if (invalid) {
            this.getView().showTipNotification("\u5b58\u5728\u4e0b\u67b6\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
            this.refreshPage();
            return;
        }
        MobileFormShowParameter openParam = new MobileFormShowParameter();
        openParam.getOpenStyle().setShowType(ShowType.Floating);
        openParam.setFormId(OCBMALL_SALEORDER_ADD);
        openParam.setStatus(OperationStatus.ADDNEW);
        openParam.setCustomParam("supplyrelationid", (Object)String.valueOf(supplyRelationId));
        openParam.setCustomParam("cartids", (Object)kd.occ.ocbase.common.util.StringUtils.join((Object[])cartIds.toArray(new String[0]), (String)","));
        openParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCBMALL_SALEORDER_ADD));
        this.getView().showForm((FormShowParameter)openParam);
    }

    private void resetSelectEntry(int index) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ITEM_LIST);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        ((MobileFormView)this.getView()).getClientProxy().invokeControlMethod(ITEM_LIST, "clearSelRows", new Object[0]);
        int[] rowIndexes = null;
        if (selectRows.length >= 1) {
            int i;
            rowIndexes = new int[selectRows.length];
            ArrayList<Integer> retSetRows = new ArrayList<Integer>(selectRows.length - 1);
            for (i = 0; i < selectRows.length; ++i) {
                if (selectRows[i] == index) continue;
                retSetRows.add(selectRows[i]);
            }
            rowIndexes[1] = (Integer)retSetRows.get(0);
            if (retSetRows.size() > 1) {
                for (i = 1; i < retSetRows.size(); ++i) {
                    rowIndexes[i] = (Integer)retSetRows.get(i);
                }
            }
        } else {
            rowIndexes = new int[1];
            if (selectRows.length == 1 && selectRows[0] != index) {
                rowIndexes = new int[2];
                rowIndexes[1] = selectRows[0];
            }
        }
        rowIndexes[0] = index;
        cardEntry.selectRows(rowIndexes, 0);
    }

    protected Map<String, BigDecimal> getOrderQuantity(int index) {
        return OrderQuantityUtil.getOrderQuantityRlue((long)this.getSaleOrgId(index), (long)this.getOrderChannelId(index), (long)this.getItemId(index), (long)this.getUnitId(index), (long)this.getAuxptyId(index), (IPageCache)this.getPageCache());
    }

    private long getSupplyRelationId(int index) {
        Object supplyRelationId = this.getEntryF7PKValue(ITEM_LIST, "supplyrelationid", index);
        return supplyRelationId == null ? 0L : (Long)supplyRelationId;
    }

    private long getOrderChannelId(int index) {
        return (Long)this.getModel().getValue("orderchannelid", index);
    }

    private long getSaleOrgId(int index) {
        return (Long)this.getModel().getValue("saleorgid", index);
    }

    private long getSaleChannelId(int index) {
        return (Long)this.getModel().getValue("salechannelid", index);
    }

    private String getSupplyRelation(int index) {
        return (String)this.getModel().getValue("supplyrelation", index);
    }

    private long getItemId(int index) {
        return (Long)this.getEntryF7PKValue(ITEM_LIST, "item", index);
    }

    private long getMaterialId(int index) {
        return (Long)this.getEntryF7PKValue(ITEM_LIST, "material", index);
    }

    private String getThumbnail(int index) {
        return (String)this.getModel().getValue("thumbnail", index);
    }

    private long getUnitId(int index) {
        return (Long)this.getModel().getValue("unit", index);
    }

    private long getCurrencyId(int index) {
        return (Long)this.getEntryF7PKValue(ITEM_LIST, PRICECURRENCY, index);
    }

    private BigDecimal getPrice(int index) {
        return (BigDecimal)this.getModel().getValue("price", index);
    }

    private long getAuxptyId(int index) {
        Object auxpty = this.getEntryF7PKValue(ITEM_LIST, "auxptyid", index);
        return auxpty == null ? 0L : (Long)auxpty;
    }

    private void add(int index) {
        DynamicObject item = this.getRowInfo(ITEM_LIST, index);
        if (EnableStatusEnum.DISABLE.getValue().equals(item.getString("status"))) {
            return;
        }
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        boolean isUseAuxpty = this.isUseAuxpty(index);
        boolean isOpenSelectAuxpty = isUseAuxpty && StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A") || !StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A");
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
        BigDecimal auxQty = (BigDecimal)this.getModel().getValue("auxqty", index);
        if (isOpenSelectAuxpty) {
            MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)true, (long)this.getItemId(index), (long)this.getAuxptyId(index), (long)this.getSupplyRelationId(index), (BigDecimal)qty, (BigDecimal)auxQty);
            mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            return;
        }
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal bigDecimal = orderMinQty = orderMinQty.compareTo(BigDecimal.ZERO) == 0 ? orderQty : orderMinQty;
        if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            this.setValue("qty", orderMinQty, index, true);
        } else {
            this.setValue("qty", qty.add(orderQty), index, true);
        }
    }

    private BigDecimal getShoppingCartQty(int index) {
        long orderChannelId = this.getOrderChannelId(index);
        long saleOrgId = this.getSaleOrgId(index);
        long saleChannelId = this.getSaleChannelId(index);
        String supplyRelation = this.getSupplyRelation(index);
        long itemId = this.getItemId(index);
        long auxpty = this.getAuxptyId(index);
        DynamicObject shoppingCartInfo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{itemId, auxpty, orderChannelId, saleOrgId, saleChannelId, supplyRelation});
        if (shoppingCartInfo == null) {
            return BigDecimal.ZERO;
        }
        return shoppingCartInfo.getBigDecimal("qty");
    }

    private void reduce(int index) {
        DynamicObject item = this.getRowInfo(ITEM_LIST, index);
        if (EnableStatusEnum.DISABLE.getValue().equals(item.getString("status"))) {
            return;
        }
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        boolean isUseAuxpty = this.isUseAuxpty(index);
        boolean isOpenSelectAuxpty = isUseAuxpty && StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A") || !StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A");
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
        BigDecimal auxQty = (BigDecimal)this.getModel().getValue("auxqty", index);
        if (isOpenSelectAuxpty) {
            MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)true, (long)this.getItemId(index), (long)this.getAuxptyId(index), (long)this.getSupplyRelationId(index), (BigDecimal)qty, (BigDecimal)auxQty);
            mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            return;
        }
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal newQty = qty.subtract(orderQty);
        if (newQty.compareTo(orderMinQty) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.setValue("qty", newQty, index, true);
    }

    private BigDecimal getStepValue(int index) {
        int precision = 0;
        DynamicObject unitfield = (DynamicObject)this.getModel().getValue("metering", index);
        if (unitfield != null && unitfield.get("precision") != null) {
            precision = unitfield.getInt("precision");
        }
        return BigDecimal.ONE.movePointLeft(precision);
    }

    private void countTotalAmount(DynamicObjectCollection itemList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAuxQty = BigDecimal.ZERO;
        if (itemList != null && itemList.size() > 0) {
            for (DynamicObject data : itemList) {
                totalAmount = totalAmount.add(data.getBigDecimal("amount"));
                totalQty = totalQty.add(data.getBigDecimal("qty"));
                totalAuxQty = totalAuxQty.add(data.getBigDecimal("auxqty"));
            }
        }
        this.setValue(ORDER_AMOUNT, totalAmount);
        MobCartEdit.LabelSetValue((Label)this.getControl(ORDER_QTY), totalQty.stripTrailingZeros().toPlainString());
        MobCartEdit.LabelSetValue((Label)this.getControl(ORDER_AUXQTY), totalAuxQty.stripTrailingZeros().toPlainString());
    }

    private void countSelectRowTotalAmount(List<Integer> selectRows) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAuxQty = BigDecimal.ZERO;
        if (selectRows != null && selectRows.size() > 0) {
            DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
            for (Integer row : selectRows) {
                totalAmount = totalAmount.add(((DynamicObject)itemList.get(row.intValue())).getBigDecimal("amount"));
                totalQty = totalQty.add(((DynamicObject)itemList.get(row.intValue())).getBigDecimal("qty"));
                totalAuxQty = totalAuxQty.add(((DynamicObject)itemList.get(row.intValue())).getBigDecimal("auxqty"));
            }
        }
        this.setValue(ORDER_AMOUNT, totalAmount);
        MobCartEdit.LabelSetValue((Label)this.getControl(ORDER_QTY), totalQty.stripTrailingZeros().toPlainString());
        MobCartEdit.LabelSetValue((Label)this.getControl(ORDER_AUXQTY), totalAuxQty.stripTrailingZeros().toPlainString());
    }

    private static void LabelSetValue(Label control, Object value) {
        String text = "";
        text = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toPlainString() : value.toString();
        control.setText(text);
    }

    private boolean isUseAuxpty(int index) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ITEM_LIST, index);
        DynamicObject material = entryRowEntity.getDynamicObject("materialid");
        if (material == null) {
            return false;
        }
        return material.getBoolean("isuseauxpty");
    }

    private void refreshPage() {
        this.countTotalAmount(null);
        this.initShoppingCart();
        this.getView().updateView();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        if (e.getRows() != null && !e.getRows().isEmpty()) {
            CardEntry cardEntry = (CardEntry)this.getControl(ITEM_LIST);
            for (RowDataEntity row : e.getRows()) {
                DynamicObject temp = row.getDataEntity();
                if (temp.get(IsGroupChild) != null && temp.getBoolean(IsGroupChild)) {
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), row.getRowIndex(), new String[]{ORDEREXT});
                }
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), row.getRowIndex(), new String[]{BTN_UNSELECTGROUPALL});
                cardEntry.setChildVisible(temp.getBoolean("haspromotion"), row.getRowIndex(), new String[]{PROMOTION_LABEL});
                if (EnableStatusEnum.DISABLE.getValue().equals(temp.getString("status"))) {
                    this.setUnEnable(row.getRowIndex(), new String[]{ADD});
                    this.setUnEnable(row.getRowIndex(), new String[]{REDUCE});
                }
                this.setValue("metering", this.getValue("unit", row.getRowIndex()), row.getRowIndex());
                this.setValue("assistunit", this.getValue("auxunit", row.getRowIndex()), row.getRowIndex());
            }
        }
    }
}

