/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.flex.FlexService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.helper.returnorder.ReturnOrderBusinessHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelInBillEditPlugin
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(ChannelInBillEditPlugin.class);
    private static final Set<Long> BILLTYPE_ORG = new HashSet<Long>(Arrays.asList(1028239231052488704L, 1052867209870858240L, 1052867451555168256L));
    private static final String btnselectitem = "btnselectitem";
    private static final String btnselectsn = "btnselectsn";
    private static final String op_scanqrcode = "scanqrcode";
    private static final String op_add = "add";
    private static final String op_reduce = "reduce";
    private static final String op_save = "save";
    private static final String op_instock = "instock";
    private static final String btnmore = "btnmore";
    private static final String ISWX = "iswx";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!this.isView()) {
            this.addClickListeners(new String[]{btnselectitem, btnselectsn, op_add, op_reduce, op_save, op_instock, btnmore});
        }
        this.addRowClickListener(this, new String[]{"billentry"});
        this.addF7Listener(this, new String[]{"inchannelid", "warehouse", "supplychannelid", "saleorg", "itemid", "supplierid"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("operationStatus", this.getView().getFormShowParameter().getStatus().toString());
        if (this.isView() || this.isEdit()) {
            this.viewOrder();
        } else if (this.isAddNew()) {
            this.initNewBillHead();
        }
        boolean isWx = CommonUtils.isFromWeixin((String)RequestContext.get().getUserAgent());
        if (isWx) {
            this.setValue(ISWX, true);
        }
    }

    private void viewOrder() {
        Object billid = this.getParameter("billid");
        this.getModel().setValue("id", billid);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"ococic_channelinbill");
        this.setValue("billno", bill.get("billno"));
        this.setValue("billtypeid", bill.get("billtypeid"));
        this.setValue("inchannelid", bill.get("inchannelid"));
        this.setValue("supplychannelid", bill.get("supplychannelid"));
        this.setValue("supplierid", bill.get("supplierid"));
        this.setValue("org", bill.get("org"));
        this.setValue("saleorg", bill.get("saleorg"));
        this.setValue("settlecurrencyid", bill.get("settlecurrencyid"));
        this.setValue("billstatus", bill.get("billstatus"));
        MobExtendHelper.loadMobExtend((IDataModel)this.getModel(), (String)this.getView().getEntityId(), (DynamicObject)bill, (String)"ococic_channelinbill");
        Map extColsMap = MobExtendHelper.getExtColsMap((String)this.getView().getEntityId(), (String)"ococic_channelinbill");
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)billEntry)) {
            return;
        }
        int[] rowIndexes = this.getModel().batchCreateNewEntryRow("billentry", billEntry.size());
        DynamicObjectCollection pageItemData = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntry.get(i);
            int rowIndex = rowIndexes[i];
            this.setValue("itemid", entry.get("itemid"), rowIndex);
            this.setValue("materialid", entry.get("materialid"), rowIndex);
            this.setValue("qty", entry.getBigDecimal("qty"), rowIndex);
            this.setValue("unitid", entry.get("unitid"), rowIndex);
            this.setValue("baseqty", entry.getBigDecimal("baseqty"), rowIndex);
            this.setValue("baseunitid", entry.get("baseunitid"), rowIndex);
            this.setValue("serialqty", entry.getBigDecimal("serialqty"), rowIndex);
            this.setValue("serialunit", entry.get("serialunit"), rowIndex);
            this.setValue("auxptyid", entry.get("auxptyid"), rowIndex);
            this.setValue("assistunitid", entry.get("assistunitid"), rowIndex);
            this.setValue("warehouse", entry.get("warehouse"), rowIndex);
            this.setValue("locationid", entry.get("locationid"), rowIndex);
            this.setValue("stockstatus", entry.get("stockstatus"), rowIndex);
            this.setValue("stocktype", entry.get("stocktype"), rowIndex);
            this.setValue("ownerid", entry.get("ownerid"), rowIndex);
            this.setValue("ownertype", entry.get("ownertype"), rowIndex);
            this.setValue("keeperid", entry.get("keeperid"), rowIndex);
            this.setValue("keepertype", entry.get("keepertype"), rowIndex);
            this.setValue("lotnumber", entry.get("lotnumber"), rowIndex);
            this.setValue("lotnumberid", entry.get("lotnumberid"), rowIndex);
            this.setValue("producedate", entry.get("producedate"), rowIndex);
            this.setValue("expirydate", entry.get("expirydate"), rowIndex);
            this.setValue("projectid", entry.get("projectid"), rowIndex);
            DynamicObject itemDynObj = this.getEntryF7Value("billentry", "itemid", rowIndex);
            if (itemDynObj != null) {
                this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex);
            }
            for (Map.Entry extCols : extColsMap.entrySet()) {
                if (!((DynamicObject)pageItemData.get(0)).containsProperty((String)extCols.getKey()) || !entry.containsProperty((String)extCols.getValue())) continue;
                this.setValue((String)extCols.getKey(), entry.get((String)extCols.getValue()), rowIndex);
            }
            DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)subEntryEntity)) continue;
            JSONObject snJson = new JSONObject();
            boolean isFirstRow = true;
            for (DynamicObject subEntry : subEntryEntity) {
                String serialnumber = subEntry.getString("serialnumber");
                Object serialid = subEntry.getPkValue();
                snJson.put(serialnumber, serialid);
                if (!isFirstRow) continue;
                this.setValue("serialnumber", serialnumber, rowIndex);
                this.setValue("serialid", serialid, rowIndex);
                isFirstRow = false;
            }
            this.setValue("mulserialnumber", snJson, rowIndex);
            this.viewIndexSerialNumber(rowIndex);
        }
    }

    private long getChannelAuthorizeSaleOrgIdSet(Long channelId) {
        long channelSaleOrgId = 0L;
        QFilter channelFilter = new QFilter("orderchannel", "=", (Object)channelId);
        channelFilter.and("enable", "=", (Object)"1");
        DynamicObject channelSaleOrg = QueryServiceHelper.queryOne((String)"ocdbd_channel_authorize", (String)"name,saleorg", (QFilter[])channelFilter.toArray());
        if (channelSaleOrg != null) {
            channelSaleOrgId = channelSaleOrg.getLong("saleorg");
        }
        return channelSaleOrgId;
    }

    public void entryRowClick(RowClickEvent e) {
        int rowIndex = e.getRow();
        this.viewIndexSerialNumber(rowIndex);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "billentry": {
                int rowIndex = this.getCurrentRowIndex("billentry");
                this.viewIndexSerialNumber(rowIndex);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "add": {
                this.addQty(index);
                break;
            }
            case "reduce": {
                this.reduceQty(index);
                break;
            }
            case "btnselectitem": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdbd_itemmobf7");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>(2);
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("billentry");
                List list = entryentity.stream().map(r -> r.getLong("itemid_id")).collect(Collectors.toList());
                hashMap.put("selected", list);
                List<Object> marketItemIds = this.getMarketItemIds();
                hashMap.put("ids", marketItemIds);
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnselectitem);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btnselectsn": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdma_channelinbill_sn");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
                DynamicObject rowEntry = this.getRowInfo("billentry", this.getCurrentRowIndex("billentry"));
                hashMap.put("itemid", rowEntry.getLong("itemid_id"));
                hashMap.put("unitid", rowEntry.getLong("unitid_id"));
                hashMap.put("qty", rowEntry.getBigDecimal("qty"));
                hashMap.put("mulserialnumber", rowEntry.get("mulserialnumber"));
                hashMap.put("thumbnail", rowEntry.get("thumbnail"));
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnselectsn);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btnmore": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdma_channelinbill_more");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(21);
                DynamicObject rowEntry = this.getRowInfo("billentry", this.getCurrentRowIndex("billentry"));
                DynamicObject inchannel = (DynamicObject)this.getValue("inchannelid");
                hashMap.put("inchannelid", DynamicObjectUtils.getPkValue((DynamicObject)inchannel));
                hashMap.put("itemid", rowEntry.getLong("itemid_id"));
                hashMap.put("materialid", rowEntry.getLong("materialid_id"));
                hashMap.put("unitid", rowEntry.getLong("unitid_id"));
                hashMap.put("qty", rowEntry.getBigDecimal("qty"));
                hashMap.put("thumbnail", rowEntry.get("thumbnail"));
                hashMap.put("auxptyid", rowEntry.get("auxptyid_id"));
                hashMap.put("warehouse", rowEntry.get("warehouse_id"));
                hashMap.put("locationid", rowEntry.get("locationid_id"));
                hashMap.put("lotnumber", rowEntry.get("lotnumber"));
                hashMap.put("lotnumberid", rowEntry.get("lotnumberid_id"));
                hashMap.put("producedate", rowEntry.get("producedate"));
                hashMap.put("expirydate", rowEntry.get("expirydate"));
                hashMap.put("stocktype", rowEntry.get("stocktype_id"));
                hashMap.put("stockstatus", rowEntry.get("stockstatus_id"));
                hashMap.put("ownertype", rowEntry.get("ownertype"));
                hashMap.put("ownerid", rowEntry.get("ownerid_id"));
                hashMap.put("keepertype", rowEntry.get("keepertype"));
                hashMap.put("keeperid", rowEntry.get("keeperid_id"));
                hashMap.put("projectid", rowEntry.get("projectid_id"));
                hashMap.put("id", rowEntry.get("id"));
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnmore);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "inchannelid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getinChannelFilter());
                break;
            }
            case "warehouse": {
                List<Long> warehouseIds = this.getIdsFromOcocicWareHouse();
                QFilter filter = new QFilter("id", "in", warehouseIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "supplychannelid": {
                if (null == this.getInChannelObject()) {
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053");
                    e.setCancel(true);
                    break;
                }
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                filter.and("id", "in", this.getSaleChannelsFromOcdbdChannelAuthorize());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "saleorg": {
                if (null == this.getInChannelObject()) {
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053");
                    e.setCancel(true);
                    break;
                }
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                filter.and("id", "in", this.getSaleOrgsFromOcdbdChannelAuthorize());
                break;
            }
            case "supplierid": {
                QFilter filter = new QFilter("enable", "=", (Object)Checked.YES.toString());
                filter.and("orderchannel", "=", (Object)this.getInChannelId());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "itemid": {
                this.itemidValueChanged(rowIndex);
                break;
            }
            case "qty": {
                this.qtyValueChanged(rowIndex);
                break;
            }
            case "serialid": {
                this.serialidValueChanged(rowIndex);
                break;
            }
            default: {
                if (!key.startsWith("$$") || !key.split("__")[0].equals("$$auxptyid")) break;
                this.getAuxptyId();
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String customKey = e.getKey();
        if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"callappmethod")) {
            Map result;
            String scanQRCode;
            boolean isAddSuccess;
            if (StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)op_scanqrcode) && (isAddSuccess = this.scanFillItemEntry(scanQRCode = CommonUtils.convertObjectToString((result = (Map)SerializationUtils.fromJsonString((String)value, Map.class)).get("qrcode_str"))))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(op_scanqrcode, (IFormPlugin)this);
                this.getView().showConfirm("\u626b\u7801\u6210\u529f\uff0c\u7ee7\u7eed\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"wxscanqrcode") && StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)"scancode")) {
            JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
            String qrCode = CommonUtils.convertObjectToString((Object)result.get((Object)"value"));
            this.scanFillItemEntry(qrCode);
        }
    }

    private boolean scanFillItemEntry(String scanQRCode) {
        DynamicObject inchannel = (DynamicObject)this.getValue("inchannelid");
        long channelWarehouseId = ReturnOrderBusinessHelper.getDefaultReturnWarehouse((long)DynamicObjectUtils.getPkValue((DynamicObject)inchannel));
        long outchannelid = DynamicObjectUtils.getPkValue((DynamicObject)inchannel);
        JSONObject result = this.scanQRCode(scanQRCode, outchannelid);
        if (result == null) {
            return false;
        }
        JSONArray data = result.getJSONArray("data");
        if (data.isEmpty()) {
            this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", scanQRCode));
            return false;
        }
        JSONObject itemJson = (JSONObject)data.get(0);
        String snstatus = itemJson.getString("snstatus");
        if (StringUtils.equals((CharSequence)snstatus, (CharSequence)SnStatusEnum.INSTOCK.getValue())) {
            this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u4e0d\u80fd\u5165\u5e93\uff0c\u539f\u56e0\uff1a\u5e8f\u5217\u53f7\u7684\u72b6\u6001=\u5728\u5e93\u3002", scanQRCode));
            return false;
        }
        boolean enableSerial = itemJson.getBoolean("enableserial");
        String serialNo = itemJson.getString("serialno");
        long serialId = itemJson.getLong("serialid");
        long itemid = itemJson.getLong("itemid");
        StringBuilder scanBuilder = new StringBuilder();
        scanBuilder.append(itemJson.getLong("itemid"));
        scanBuilder.append(itemJson.getLong("auxptyid"));
        scanBuilder.append(itemJson.getString("lotnum"));
        scanBuilder.append(itemJson.getLong("channelstockid"));
        scanBuilder.append(itemJson.getLong("channellocationid"));
        scanBuilder.append(itemJson.getLong("retailunit"));
        scanBuilder.append(itemJson.getLong("channelstockstatusid"));
        scanBuilder.append(itemJson.getLong("channelstocktypeid"));
        scanBuilder.append(itemJson.getString("keepertype"));
        scanBuilder.append(itemJson.getLong("keeperid"));
        scanBuilder.append(itemJson.getString("ownertype"));
        scanBuilder.append(itemJson.getLong("ownerid"));
        scanBuilder.append(itemJson.getDate("productdate"));
        scanBuilder.append(itemJson.getDate("effectivedate"));
        scanBuilder.append(itemJson.getLong("projectid"));
        String scanKey = scanBuilder.toString();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("billentry");
        int rowIndex = 0;
        for (DynamicObject entry : entryColl) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getLong("itemid_id"));
            sb.append(entry.getLong("auxptyid_id"));
            sb.append(entry.getString("lotnumber"));
            sb.append(entry.getLong("warehouse_id"));
            sb.append(entry.getLong("locationid_id"));
            sb.append(entry.getLong("unitid_id"));
            sb.append(entry.getLong("stockstatus_id"));
            sb.append(entry.getLong("stocktype_id"));
            sb.append(entry.getString("keepertype"));
            sb.append(entry.getLong("keeperid_id"));
            sb.append(entry.getString("ownertype"));
            sb.append(entry.getLong("ownerid_id"));
            sb.append(entry.getDate("producedate"));
            sb.append(entry.getDate("expirydate"));
            sb.append(entry.getLong("projectid_id"));
            if (StringUtils.equals((CharSequence)scanKey, (CharSequence)sb.toString())) {
                if (enableSerial) {
                    JSONObject snJson = JSONObject.parseObject((String)entry.getString("mulserialnumber"));
                    if (snJson != null && snJson.containsKey((Object)serialNo)) {
                        this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u5728\u7b2c%d\u884c\u5df2\u5b58\u5728\u3002", serialNo, rowIndex + 1));
                        return false;
                    }
                    this.updateSerialNumberFields(serialNo, serialId, rowIndex);
                    return true;
                }
                this.getView().showTipNotification(String.format("\u5546\u54c1\u5728\u7b2c%d\u884c\u5df2\u5b58\u5728\u3002", rowIndex + 1));
                return false;
            }
            ++rowIndex;
        }
        rowIndex = this.getModel().createNewEntryRow("billentry");
        this.setValue("itemid", itemid, rowIndex);
        this.setValue("qty", BigDecimal.ONE, rowIndex);
        this.setValue("warehouse", channelWarehouseId, rowIndex);
        this.setValue("ownerid", inchannel, rowIndex);
        this.setValue("keeperid", inchannel, rowIndex);
        if (enableSerial) {
            JSONObject snJson = new JSONObject();
            snJson.put(serialNo, (Object)serialId);
            this.setValue("serialid", serialId, rowIndex);
            this.setValue("serialnumber", serialNo, rowIndex);
            this.setValue("mulserialnumber", snJson, rowIndex);
            this.viewIndexSerialNumber(rowIndex);
        }
        return true;
    }

    private void updateSerialNumberFields(String serialNo, Object serialId, int rowIndex) {
        Object serialnumber;
        JSONObject snJson = JSONObject.parseObject((String)String.valueOf(this.getValue("mulserialnumber", rowIndex)));
        if (snJson == null) {
            snJson = new JSONObject();
        }
        if (ObjectUtils.isEmpty((Object)(serialnumber = this.getValue("serialnumber")))) {
            this.setValue("serialid", serialId, rowIndex);
            this.setValue("serialnumber", serialNo, rowIndex);
        }
        snJson.put(serialNo, serialId);
        this.setValue("qty", snJson.size(), rowIndex);
        this.setValue("mulserialnumber", snJson, rowIndex);
        this.viewIndexSerialNumber(rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "save": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                this.saveBill();
                break;
            }
            case "instock": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                this.submitBill();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (key) {
            case "btnselectitem": {
                Object[] selectIds = (Object[])returnData;
                if (selectIds == null || selectIds.length == 0) {
                    return;
                }
                DynamicObject inchannel = (DynamicObject)this.getValue("inchannelid");
                long channelWarehouseId = ReturnOrderBusinessHelper.getDefaultWarehouse((long)DynamicObjectUtils.getPkValue((DynamicObject)inchannel), (String)"isdelivery");
                long channelLocationId = this.getDefaultLocationId(channelWarehouseId);
                for (Object itemId : selectIds) {
                    int rowIndex = this.getModel().createNewEntryRow("billentry");
                    this.setValue("itemid", itemId, rowIndex);
                    this.setValue("qty", BigDecimal.ONE, rowIndex);
                    this.setValue("warehouse", channelWarehouseId, rowIndex);
                    this.setValue("locationid", channelLocationId, rowIndex);
                    this.setValue("ownerid", inchannel, rowIndex);
                    this.setValue("keeperid", inchannel, rowIndex);
                }
                break;
            }
            case "btnselectsn": {
                JSONObject snJson = JSONObject.parseObject((String)String.valueOf(returnData));
                int rowIndex = this.getCurrentRowIndex("billentry");
                long serialid = 0L;
                String serialnumber = "";
                if (snJson != null) {
                    Set snNumbers = snJson.entrySet();
                    for (Map.Entry entry : snNumbers) {
                        serialid = Long.parseLong(String.valueOf(entry.getValue()));
                        serialnumber = (String)entry.getKey();
                        if (serialid <= 0L) continue;
                        break;
                    }
                    this.setValue("qty", snNumbers.size(), rowIndex);
                }
                this.setValue("serialid", serialid, rowIndex);
                this.setValue("serialnumber", serialnumber, rowIndex);
                this.setValue("mulserialnumber", snJson, rowIndex);
                this.viewIndexSerialNumber(rowIndex);
                break;
            }
            case "btnmore": {
                JSONObject resultJson = JSONObject.parseObject((String)String.valueOf(returnData));
                int rowIndex = this.getCurrentRowIndex("billentry");
                this.setValue("auxptyid", resultJson.get((Object)"auxptyid"), rowIndex);
                this.setValue("warehouse", resultJson.get((Object)"warehouse"), rowIndex);
                this.setValue("locationid", resultJson.get((Object)"locationid"), rowIndex);
                this.setValue("lotnumber", resultJson.get((Object)"lotnumber"), rowIndex);
                this.setValue("lotnumberid", resultJson.get((Object)"lotnumberid"), rowIndex);
                this.setValue("producedate", resultJson.get((Object)"producedate"), rowIndex);
                this.setValue("expirydate", resultJson.get((Object)"expirydate"), rowIndex);
                this.setValue("stocktype", resultJson.get((Object)"stocktype"), rowIndex);
                this.setValue("stockstatus", resultJson.get((Object)"stockstatus"), rowIndex);
                this.setValue("ownertype", resultJson.get((Object)"ownertype"), rowIndex);
                this.setValue("ownerid", resultJson.get((Object)"ownerid"), rowIndex);
                this.setValue("keepertype", resultJson.get((Object)"keepertype"), rowIndex);
                this.setValue("keeperid", resultJson.get((Object)"keeperid"), rowIndex);
                this.setValue("projectid", resultJson.get((Object)"projectid"), rowIndex);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "scanqrcode": {
                this.getView().invokeOperation(op_scanqrcode);
                break;
            }
        }
    }

    private JSONObject scanQRCode(String scanQRCode, long channelId) {
        if (StringUtils.isNotEmpty((CharSequence)scanQRCode) && channelId > 0L) {
            return CSerialHelper.getSerialDataByNumber(Collections.singletonList(scanQRCode), (Long)channelId);
        }
        return null;
    }

    private void submitBill() {
        this.saveBill();
        long billid = Long.parseLong(String.valueOf(this.getValue("id")));
        if (billid > 0L) {
            String billstatus;
            Object[] objectIds = new Object[]{billid};
            OperateOption option = CommonUtils.getOperateOption();
            switch (billstatus = String.valueOf(this.getValue("billstatus"))) {
                case "A": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_channelinbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.showMessage(result, false);
                        break;
                    }
                    this.setValue("billstatus", "B");
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_channelinbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.showMessage(result, false);
                        break;
                    }
                    this.setValue("billstatus", "C");
                    break;
                }
                case "B": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_channelinbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.showMessage(result, false);
                        break;
                    }
                    this.setValue("billstatus", "C");
                    break;
                }
            }
        }
        this.getPageCache().put("nextsubmittime", "0");
    }

    private void saveBill() {
        long billid = Long.parseLong(String.valueOf(this.getValue("id")));
        DynamicObject bill = null;
        BigDecimal sumqty = BigDecimal.ZERO;
        if (billid == 0L) {
            bill = BusinessDataServiceHelper.newDynamicObject((String)"ococic_channelinbill");
            bill.set("creator", (Object)UserUtil.getUserInfo());
            bill.set("billstatus", (Object)"A");
        } else {
            bill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"ococic_channelinbill");
            this.setValue("billstatus", bill.getString("billstatus"));
        }
        long inChannelId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)this.getValue("inchannelid")));
        bill.set("billno", this.getValue("billno"));
        bill.set("billtypeid", this.getValue("billtypeid"));
        bill.set("inway", this.getValue("inway"));
        bill.set("inchannelid", this.getValue("inchannelid"));
        bill.set("org", this.getValue("org"));
        bill.set("saleorg", this.getValue("saleorg"));
        bill.set("supplychannelid", this.getValue("supplychannelid"));
        bill.set("supplierid", this.getValue("supplierid"));
        bill.set("intype", this.getValue("intype"));
        bill.set("instocktime", this.getValue("instocktime"));
        bill.set("settlecurrencyid", this.getValue("settlecurrencyid"));
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)bill, (String)this.getView().getEntityId(), (String)"ococic_channelinbill");
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("billentry");
        entryEntity.clear();
        DynamicObjectCollection mobEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)mobEntryEntity)) {
            this.getView().showTipNotification("\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return;
        }
        int seq = 0;
        for (DynamicObject mobEntry : mobEntryEntity) {
            ++seq;
            DynamicObject item = mobEntry.getDynamicObject("itemid");
            if (item == null) {
                this.getView().showTipNotification("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return;
            }
            BigDecimal serialqty = mobEntry.getBigDecimal("serialqty");
            BigDecimal qty = mobEntry.getBigDecimal("qty");
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", seq));
                return;
            }
            sumqty = sumqty.add(qty);
            DynamicObject entry = entryEntity.addNew();
            entry.set("materialid", mobEntry.get("materialid"));
            entry.set("itemid", (Object)item);
            entry.set("unitid", mobEntry.get("unitid"));
            entry.set("auxptyid", mobEntry.get("auxptyid"));
            entry.set("assistunitid", mobEntry.get("assistunitid"));
            entry.set("warehouse", mobEntry.get("warehouse"));
            entry.set("locationid", mobEntry.get("locationid"));
            entry.set("qty", (Object)qty);
            entry.set("baseunitid", mobEntry.get("baseunitid"));
            entry.set("baseqty", mobEntry.get("baseqty"));
            entry.set("serialqty", (Object)serialqty);
            entry.set("serialunit", mobEntry.get("serialunit"));
            entry.set("stockstatus", mobEntry.get("stockstatus"));
            entry.set("stocktype", mobEntry.get("stocktype"));
            entry.set("ownerid", mobEntry.get("ownerid"));
            entry.set("ownertype", mobEntry.get("ownertype"));
            entry.set("keeperid", mobEntry.get("keeperid"));
            entry.set("keepertype", mobEntry.get("keepertype"));
            entry.set("lotnumber", mobEntry.get("lotnumber"));
            entry.set("lotnumberid", mobEntry.get("lotnumberid"));
            entry.set("producedate", mobEntry.get("producedate"));
            entry.set("expirydate", mobEntry.get("expirydate"));
            entry.set("projectid", mobEntry.get("projectid"));
            MobExtendHelper.setMobExtToOrmExt((DynamicObject)mobEntry, (DynamicObject)entry, (String)this.getView().getEntityId(), (String)"ococic_channelinbill");
            boolean enableserial = item.getBoolean("enableserial");
            boolean isNotControlSN = ChannelUtil.queryChannelIsNotControlSN((long)inChannelId);
            if (!enableserial || isNotControlSN) continue;
            String serialnumber = mobEntry.getString("serialnumber");
            if (StringUtils.isEmpty((CharSequence)serialnumber)) {
                this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u5df2\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u5e8f\u5217\u53f7\u5fc5\u5f55\u3002", seq));
                return;
            }
            if (serialqty.compareTo(BigDecimal.ONE) == 0) {
                DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
                DynamicObject subEntry = subentryentity.addNew();
                subEntry.set("serialid", mobEntry.get("serialid"));
                subEntry.set("serialnumber", (Object)serialnumber);
                continue;
            }
            if (serialqty.compareTo(BigDecimal.ONE) > 0) {
                JSONObject snJson = JSONObject.parseObject((String)mobEntry.getString("mulserialnumber"));
                if (snJson == null || serialqty.intValue() != snJson.size()) {
                    this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u5e8f\u5217\u53f7\u6570\u91cf\u548c\u5e8f\u5217\u53f7\u6761\u6570\u4e0d\u4e00\u81f4\u3002", seq));
                    return;
                }
                DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
                if (snJson == null) continue;
                Set snNumbers = snJson.entrySet();
                for (Map.Entry snEntry : snNumbers) {
                    DynamicObject subEntry = subentryentity.addNew();
                    subEntry.set("serialid_id", snEntry.getValue());
                    subEntry.set("serialnumber", snEntry.getKey());
                }
                continue;
            }
            this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u5e8f\u5217\u53f7\u6570\u91cf\u5fc5\u5f55\u3002", seq));
            return;
        }
        bill.set("sumqty", (Object)sumqty);
        OperateOption saveOption = CommonUtils.getOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)op_save, (String)"ococic_channelinbill", (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)saveOption);
        if (!result.isSuccess()) {
            this.showMessage(result, false);
        }
        this.setValue("id", bill.getPkValue());
        this.setValue("billno", bill.getString("billno"));
    }

    private void viewIndexSerialNumber(int rowIndex) {
        JSONObject snJson;
        StringBuilder sb = new StringBuilder();
        if (rowIndex >= 0 && (snJson = JSONObject.parseObject((String)String.valueOf(this.getValue("mulserialnumber", rowIndex)))) != null) {
            Set snNumbers = snJson.keySet();
            for (String snNumber : snNumbers) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(snNumber);
            }
        }
        this.setValue("viewserialnumber", sb.toString());
    }

    private void initNewBillHead() {
        long channelId = this.getChannelId();
        this.setValue("inchannelid", channelId);
        long saleOrgId = this.getChannelAuthorizeSaleOrgIdSet(channelId);
        this.setValue("saleorg", saleOrgId);
        DynamicObject inchannel = (DynamicObject)this.getValue("inchannelid");
        this.setValue("org", DynamicObjectUtils.getPkValue((DynamicObject)inchannel, (String)"saleorg"));
        this.setValue("settlecurrencyid", DynamicObjectUtils.getPkValue((DynamicObject)inchannel, (String)"currency"));
        this.setValue("billstatus", "A");
    }

    private long getAuxptyId() {
        FlexEdit flexEdit = (FlexEdit)this.getControl("auxptyid");
        IDataModel flexModel = flexEdit.getFlexModel();
        DynamicObject dataEntity = flexModel.getDataEntity();
        MainEntityType dataEntityType = flexModel.getDataEntityType();
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData(dataEntityType, dataEntity);
        long id = FlexService.saveFlexData((MainEntityType)dataEntityType, (FlexEntireData)flexEntireData);
        this.setValue("auxptyid", id, this.getCurrentRowIndex("billentry"));
        return id;
    }

    private long getChannelId() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String cacheChannelId = parentPageCache.get("channelId");
        long channelId = cacheChannelId != null ? Long.parseLong(cacheChannelId) : B2BUserHelper.getLoginChannelId();
        return channelId;
    }

    protected void addQty(int index) {
        Object qtyObj = this.getModel().getValue("qty", index);
        BigDecimal qty = qtyObj == null ? BigDecimal.ZERO : (BigDecimal)qtyObj;
        BigDecimal newQty = qty.add(BigDecimal.ONE);
        this.getModel().setValue("qty", (Object)newQty, index);
    }

    protected void reduceQty(int index) {
        Object qtyObj = this.getModel().getValue("qty", index);
        BigDecimal qty = qtyObj == null ? BigDecimal.ZERO : (BigDecimal)qtyObj;
        BigDecimal newQty = qty.subtract(BigDecimal.ONE);
        if (newQty.compareTo(BigDecimal.ZERO) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue("qty", (Object)newQty, index);
    }

    private void itemidValueChanged(int rowIndex) {
        DynamicObject itemDynObj = this.getEntryF7Value("billentry", "itemid", rowIndex);
        DynamicObject material = null;
        DynamicObject orderunit = null;
        DynamicObject baseunit = null;
        DynamicObject serialunit = null;
        DynamicObject assistunit = null;
        Object thumbnail = null;
        if (itemDynObj != null) {
            material = itemDynObj.getDynamicObject("material");
            orderunit = itemDynObj.getDynamicObject("orderunit");
            baseunit = itemDynObj.getDynamicObject("baseunit");
            serialunit = itemDynObj.getDynamicObject("serialunit");
            assistunit = itemDynObj.getDynamicObject("assistunit");
            thumbnail = itemDynObj.get("thumbnail");
        }
        this.setValue("materialid", material, rowIndex);
        this.setValue("unitid", orderunit, rowIndex);
        this.setValue("baseunitid", baseunit, rowIndex);
        this.setValue("serialunit", serialunit, rowIndex);
        this.setValue("assistunitid", assistunit, rowIndex);
        this.setValue("thumbnail", thumbnail, rowIndex);
        this.triggerChangeEvent = true;
    }

    private void qtyValueChanged(int rowIndex) {
        DynamicObject rowEntry = this.getRowInfo("billentry", rowIndex);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"materialid");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"unitid");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"baseunitid");
        long serialunitId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"serialunit");
        BigDecimal qty = (BigDecimal)this.getValue("qty", rowIndex);
        BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
        BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)serialunitId);
        this.setValue("baseqty", baseQty, rowIndex);
        this.setValue("serialqty", serialQty, rowIndex);
        this.triggerChangeEvent = true;
    }

    private void serialidValueChanged(int rowIndex) {
        DynamicObject serialDynObj = this.getEntryF7Value("billentry", "serialid", rowIndex);
        DynamicObject lotid = null;
        String lotnum = "";
        Date productdate = null;
        Date effectivedate = null;
        DynamicObject projectid = null;
        String ownertype = "";
        DynamicObject ownerid = null;
        String keepertype = "";
        DynamicObject keeperid = null;
        DynamicObject auxptyid = null;
        DynamicObject channelstocktypeid = null;
        DynamicObject channelstockstatusid = null;
        DynamicObject channelstockid = null;
        DynamicObject channellocationid = null;
        if (serialDynObj != null) {
            lotid = serialDynObj.getDynamicObject("lotid");
            lotnum = serialDynObj.getString("lotnum");
            productdate = serialDynObj.getDate("productdate");
            effectivedate = serialDynObj.getDate("effectivedate");
            projectid = serialDynObj.getDynamicObject("projectid");
            ownertype = serialDynObj.getString("ownertype");
            ownerid = serialDynObj.getDynamicObject("ownerid");
            keepertype = serialDynObj.getString("keepertype");
            keeperid = serialDynObj.getDynamicObject("keeperid");
            auxptyid = serialDynObj.getDynamicObject("auxptyid");
            channelstocktypeid = serialDynObj.getDynamicObject("channelstocktypeid");
            channelstockstatusid = serialDynObj.getDynamicObject("channelstockstatusid");
            channelstockid = serialDynObj.getDynamicObject("channelstockid");
            channellocationid = serialDynObj.getDynamicObject("channellocationid");
        }
        this.setValue("lotnumberid", lotid, rowIndex);
        this.setValue("lotnumber", lotnum, rowIndex);
        this.setValue("producedate", productdate, rowIndex);
        this.setValue("expirydate", effectivedate, rowIndex);
        this.setValue("projectid", projectid, rowIndex);
        this.setValue("ownertype", ownertype, rowIndex);
        this.setValue("ownerid", ownerid, rowIndex);
        this.setValue("keepertype", keepertype, rowIndex);
        this.setValue("keeperid", keeperid, rowIndex);
        this.setValue("auxptyid", auxptyid, rowIndex);
        this.setValue("stocktype", channelstocktypeid, rowIndex);
        this.setValue("stockstatus", channelstockstatusid, rowIndex);
        this.setValue("warehouse", channelstockid, rowIndex);
        this.setValue("locationid", channellocationid, rowIndex);
        this.triggerChangeEvent = true;
    }

    private List<Object> getMarketItemIds() {
        long orgid = (Long)this.getModel().getValue(String.join((CharSequence)"_", "org", "id"));
        long inchannelid = (Long)this.getModel().getValue(String.join((CharSequence)"_", "inchannelid", "id"));
        long supplychannelid = (Long)this.getModel().getValue(String.join((CharSequence)"_", "supplychannelid", "id"));
        List<QFilter> filters = this.getItemFilter(orgid, inchannelid, supplychannelid);
        return QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_iteminfo", (QFilter[])filters.toArray(new QFilter[filters.size()]), null, (int)99999);
    }

    private List<QFilter> getItemFilter(long saleOrgId, long saleChannelId, long orderChannelId) {
        List<QFilter> filters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)saleChannelId, (long)orderChannelId);
        if (filters == null) {
            filters = Arrays.asList(new QFilter("id", "=", (Object)0L).toArray());
        } else {
            filters.add(new QFilter("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue())));
        }
        return filters;
    }

    private QFilter getinChannelFilter() {
        QFilter qFilter = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("channelfunctions.fbasedataid.number", "=", (Object)"003");
        qFilter.and(CUserHelper.getAuthorizedChannelFilter());
        qFilter.and("invcontrolmode", "=", (Object)"A");
        return qFilter;
    }

    private List<Long> getIdsFromOcocicWareHouse() {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject inchannel = (DynamicObject)this.getValue("inchannelid");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)inchannel);
        if (channelId == 0L) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("ownerchannelid", "=", (Object)channelId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)"id", (QFilter[])filter.toArray());
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("id"));
            }
        }
        return ids;
    }

    private List<Long> getSaleChannelsFromOcdbdChannelAuthorize() {
        QFilter filter = new QFilter("enable", "=", (Object)Checked.YES.toString());
        filter.and("orderchannel", "=", (Object)this.getInChannelId());
        long billTypeId = (Long)this.getModel().getValue("billtypeid_id");
        if (billTypeId == 0L) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002");
            return new ArrayList<Long>(0);
        }
        if (BILLTYPE_ORG.contains(billTypeId)) {
            filter.and(new QFilter("supplyrelation", "=", (Object)ChannelSupplyRelation.SUPPLY_ORG.getValue()));
        } else {
            filter.and(new QFilter("supplyrelation", "=", (Object)ChannelSupplyRelation.SUPPLY_CHANNEL.getValue()));
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)"salechannel", (QFilter[])new QFilter[]{filter});
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("salechannel.id"));
            }
        }
        return ids;
    }

    private List<Long> getSaleOrgsFromOcdbdChannelAuthorize() {
        ArrayList<Long> ids = new ArrayList<Long>();
        long channelId = this.getInChannelId();
        if (channelId <= 0L) {
            throw new KDBizException("\u5165\u5e93\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        QFilter customerFilter = new QFilter("orderchannel", "=", (Object)channelId);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)"saleorg", (QFilter[])new QFilter[]{customerFilter});
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("saleorg.id"));
            }
        }
        return ids;
    }

    private DynamicObject getInChannelObject() {
        Object obj = this.getModel().getValue("inchannelid");
        return obj == null ? null : (DynamicObject)obj;
    }

    private long getInChannelId() {
        Object obj = this.getF7PKValue("inchannelid");
        return obj == null ? 0L : (Long)obj;
    }

    private long getDefaultLocationId(long channelWarehouseId) {
        if (channelWarehouseId <= 0L) {
            return 0L;
        }
        long channelLocationId = 0L;
        QFilter qFilter = new QFilter("id", "=", (Object)channelWarehouseId);
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"ococic_warehouse", (String)"enablelocation", (QFilter[])qFilter.toArray());
        boolean enableLocation = DynamicObjectUtils.getBoolean((DynamicObject)warehouse, (String)"enablelocation");
        if (enableLocation) {
            QFilter filter = new QFilter("warehouseid", "=", (Object)channelWarehouseId);
            filter.and("isdefault", "=", (Object)Boolean.TRUE);
            filter.and("enable", "=", (Object)"1");
            DynamicObject location = QueryServiceHelper.queryOne((String)"ococic_location", (String)"id", (QFilter[])filter.toArray());
            channelLocationId = DynamicObjectUtils.getLong((DynamicObject)location, (String)"id");
        }
        return channelLocationId;
    }

    private void showMessage(OperationResult result, boolean isSubmit) {
        if (result.isSuccess()) {
            return;
        }
        List allError = result.getAllErrorInfo();
        if (!allError.isEmpty()) {
            ArrayList<String> allErrorMessageList = new ArrayList<String>(1);
            for (OperateErrorInfo error : allError) {
                allErrorMessageList.add(error.getMessage());
            }
            this.getView().showErrorNotification(String.join((CharSequence)",", allErrorMessageList));
            return;
        }
        List validResultList = result.getValidateResult().getValidateErrors();
        ArrayList<String> fatalErrorMessageList = new ArrayList<String>(1);
        ArrayList<String> errorMessageList = new ArrayList<String>(1);
        ArrayList<String> warningMessageList = new ArrayList<String>(1);
        for (ValidateResult validation : validResultList) {
            List allErrorInfo = validation.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                ErrorLevel errorLevel = errorInfo.getLevel();
                switch (errorLevel) {
                    case FatalError: {
                        fatalErrorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Error: {
                        errorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Warning: {
                        warningMessageList.add(errorInfo.getMessage());
                        break;
                    }
                }
            }
        }
        if (!fatalErrorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", fatalErrorMessageList));
        } else if (!errorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", errorMessageList));
        } else if (!warningMessageList.isEmpty() && isSubmit) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitConfirmCallBack", (IFormPlugin)this);
            String message = MessageFormat.format("{0} - {1}", result.getMessage(), String.join((CharSequence)",", warningMessageList));
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
        }
    }
}

